/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.integration.rei;

import com.google.common.collect.ImmutableList;

import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.crafting.PureDaisyRecipe;

import java.util.Collections;

public class PureDaisyREIDisplay extends BotaniaRecipeDisplay<PureDaisyRecipe> {

	public PureDaisyREIDisplay(PureDaisyRecipe recipe) {
		super(recipe);
		ImmutableList.Builder<EntryStack<?>> inputs = ImmutableList.builder();
		for (class_2680 state : recipe.getInput().getDisplayed()) {
			if (!state.method_26227().method_15769()) {
				inputs.add(EntryStacks.of(state.method_26227().method_15772()));
			} else {
				inputs.add(EntryStacks.of(state.method_26204()));
			}
		}
		this.inputs = Collections.singletonList(EntryIngredient.of(inputs.build()));
		this.outputs = EntryIngredients.of(recipe.getOutputState().method_26204());
	}

	/*todo implement time-based hints?
	public int getProcessingTime() {
		return recipe.getTime();
	}
	*/

	@Override
	public int getManaCost() {
		return 0;
	}

	@Override
	public @NotNull CategoryIdentifier<?> getCategoryIdentifier() {
		return BotaniaREICategoryIdentifiers.PURE_DAISY;
	}
}
