/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.integration.rei;

import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.client.integration.shared.OrechidUIHelper;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

import java.util.List;
import java.util.stream.Stream;

import static vazkii.botania.fabric.integration.rei.PureDaisyREICategory.setupPureDaisyDisplay;

import it.unimi.dsi.fastutil.ints.IntIntPair;

public class OrechidREICategory implements DisplayCategory<OrechidBaseREIDisplay<?>> {
	private final EntryStack<class_1799> orechid;
	private final CategoryIdentifier<? extends OrechidBaseREIDisplay<?>> categoryId;
	private final String langKey;

	public OrechidREICategory(CategoryIdentifier<? extends OrechidBaseREIDisplay<?>> categoryId, class_2248 orechid) {
		this.categoryId = categoryId;
		this.orechid = EntryStacks.of(orechid);
		this.langKey = "botania.nei." + (orechid == BotaniaFlowerBlocks.orechidIgnem ? "orechidIgnem" : "orechid");
	}

	@Override
	public @NotNull CategoryIdentifier<? extends OrechidBaseREIDisplay<?>> getCategoryIdentifier() {
		return categoryId;
	}

	@Override
	public @NotNull Renderer getIcon() {
		return orechid;
	}

	@Override
	public @NotNull class_2561 getTitle() {
		return class_2561.method_43471(langKey);
	}

	@Override
	public @NotNull List<Widget> setupDisplay(OrechidBaseREIDisplay<?> display, Rectangle bounds) {
		List<Widget> widgets = setupPureDaisyDisplay(display, bounds, orechid);

		final Double chance = getChance(display.getRecipe());
		if (chance != null) {
			final class_2561 chanceComponent = OrechidUIHelper.getPercentageComponent(chance);
			final Point center = new Point(bounds.getCenterX() - 8, bounds.getCenterY() - 9);
			final Label chanceLabel = Widgets.createLabel(new Point(center.x + 51, center.y - 11), chanceComponent)
					.rightAligned().color(0x555555, 0xAAAAAA).noShadow();
			chanceLabel.tooltip(getChanceTooltipComponents(chance, display.getRecipe()).toArray(class_2561[]::new));
			widgets.add(chanceLabel);
		}

		return widgets;
	}

	@NotNull
	protected Stream<class_2561> getChanceTooltipComponents(double chance, OrechidRecipe recipe) {
		final var ratio = OrechidUIHelper.getRatioForChance(chance);
		return Stream.of(OrechidUIHelper.getRatioTooltipComponent(ratio));
	}

	@Nullable
	protected Double getChance(@NotNull OrechidRecipe recipe) {
		return OrechidUIHelper.getChance(recipe, null);
	}

	@Override
	public int getDisplayHeight() {
		return 54;
	}

	@Override
	public int getDisplayWidth(OrechidBaseREIDisplay<?> display) {
		return 112;
	}
}
