/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.impl.corporea;

import com.google.common.collect.ImmutableList;
import vazkii.botania.api.corporea.CorporeaRequest;
import vazkii.botania.api.corporea.CorporeaSpark;

import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class VanillaCorporeaNode extends AbstractCorporeaNode {

	protected final class_1263 inv;

	public VanillaCorporeaNode(class_1937 world, class_2338 pos, class_1263 inv, CorporeaSpark spark) {
		super(world, pos, spark);
		this.inv = inv;
	}

	@Override
	public List<class_1799> countItems(CorporeaRequest request) {
		return iterateOverSlots(request, false);
	}

	@Override
	public List<class_1799> extractItems(CorporeaRequest request) {
		return iterateOverSlots(request, true);
	}

	protected List<class_1799> iterateOverSlots(CorporeaRequest request, boolean doit) {
		ImmutableList.Builder<class_1799> builder = ImmutableList.builder();

		for (int i = inv.method_5439() - 1; i >= 0; i--) {
			class_1799 stackAt = inv.method_5438(i);
			if (request.getMatcher().test(stackAt)) {
				request.trackFound(stackAt.method_7947());

				int rem = Math.min(stackAt.method_7947(), request.getStillNeeded() == -1 ? stackAt.method_7947() : request.getStillNeeded());
				if (rem > 0) {
					request.trackSatisfied(rem);

					if (doit) {
						class_1799 copy = stackAt.method_46651(rem);
						if (getSpark().isCreative()) {
							builder.add(copy);
						} else {
							builder.addAll(breakDownBigStack(inv.method_5434(i, rem)));
							inv.method_5431();
						}
						getSpark().onItemExtracted(copy);
						request.trackExtracted(rem);
					} else {
						class_1799 copy = stackAt.method_46651(rem);
						builder.add(copy);
					}
				}
			}
		}

		return builder.build();
	}

}
