/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.fx.SparkleParticleData;

public class PixieEntity extends class_1307 {
	private static final class_2940<Integer> PIXIE_TYPE = class_2945.method_12791(PixieEntity.class, class_2943.field_13327);

	private class_1309 summoner = null;
	private float damage = 0;
	private class_1293 effect = null;

	public PixieEntity(class_1299<PixieEntity> type, class_1937 world) {
		super(type, world);
	}

	public PixieEntity(class_1937 world) {
		this(BotaniaEntities.PIXIE, world);
	}

	@Override
	protected void method_5693() {
		super.method_5693();
		field_6011.method_12784(PIXIE_TYPE, 0);
	}

	public void setPixieType(int type) {
		field_6011.method_12778(PIXIE_TYPE, type);
	}

	public int getPixieType() {
		return field_6011.method_12789(PIXIE_TYPE);
	}

	public void setProps(class_1309 target, class_1309 summoner, int type, float damage) {
		method_5980(target);
		this.summoner = summoner;
		this.damage = damage;
		setPixieType(type);
	}

	public void setApplyPotionEffect(class_1293 effect) {
		this.effect = effect;
	}

	@Override
	protected void method_5958() {
		class_1309 target = method_5968();
		if (target != null) {
			double d0 = target.method_23317() + target.method_17681() / 2 - method_23317();
			double d1 = target.method_23318() + target.method_17682() / 2 - method_23318();
			double d2 = target.method_23321() + target.method_17681() / 2 - method_23321();
			double d3 = d0 * d0 + d1 * d1 + d2 * d2;

			float mod = 0.45F;
			if (getPixieType() == 1) {
				mod = 0.1F;
			}

			method_18800(d0 / d3 * mod, d1 / d3 * mod, d2 / d3 * mod);

			if (Math.sqrt(d3) < 1F) {
				if (summoner != null) {
					if (summoner instanceof class_1657 player) {
						target.method_5643(method_48923().method_48802(player), damage);
					} else {
						target.method_5643(method_48923().method_48812(summoner), damage);
					}
				} else {
					target.method_5643(method_48923().method_48812(this), damage);
				}
				if (effect != null && !(target instanceof class_1657)) {
					target.method_6092(effect);
				}
				method_31472();
			}
		}

		field_6283 = -((float) Math.atan2(method_18798().method_10216(), method_18798().method_10215()))
				* 180.0F / (float) Math.PI;
		method_36456(field_6283);
	}

	@Override
	public boolean method_5679(@NotNull class_1282 source) {
		if (getPixieType() == 0 && source.method_5529() == summoner) {
			return true;
		}

		if (getPixieType() == 1 && !(source.method_5529() instanceof class_1657)) {
			return true;
		}

		return super.method_5679(source);
	}

	@Override
	public void method_5670() {
		super.method_5670();

		if (!method_37908().field_9236
				&& (method_5968() == null || field_6012 > 200)) {
			method_31472();
		}

		boolean dark = getPixieType() == 1;
		if (method_37908().field_9236) {
			for (int i = 0; i < 4; i++) {
				float r = dark ? 0.1F : 1F;
				float g = dark ? 0.025F : 0.25F;
				float b = dark ? 0.09F : 0.9F;
				SparkleParticleData data = SparkleParticleData.sparkle(0.1F + (float) Math.random() * 0.25F, r, g, b, 12);
				method_37908().method_8406(data, method_23317() + (Math.random() - 0.5) * 0.25, method_23318() + 0.5 + (Math.random() - 0.5) * 0.25, method_23321() + (Math.random() - 0.5) * 0.25, 0, 0, 0);
			}
		}
	}

	@Override
	public void method_5650(class_5529 reason) {
		if (method_37908() != null && method_37908().field_9236 && getPixieType() == 0) {
			for (int i = 0; i < 12; i++) {
				SparkleParticleData data = SparkleParticleData.sparkle(1F + (float) Math.random() * 0.25F, 1F, 0.25F, 0.9F, 5);
				method_37908().method_8406(data, method_23317() + (Math.random() - 0.5) * 0.25, method_23318() + 0.5 + (Math.random() - 0.5) * 0.25, method_23321() + (Math.random() - 0.5) * 0.25, 0, 0, 0);
			}
		}
		super.method_5650(reason);
	}

	@Override
	public boolean method_5863() {
		return method_5805();
	}

	@Override
	public boolean method_5931(class_1657 player) {
		return false;
	}
}
