/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.red_string;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.red_string.RedStringBlockEntity;
import vazkii.botania.common.block.block_entity.red_string.RedStringInterceptorBlockEntity;

public class RedStringInterceptorBlock extends RedStringBlock {

	public RedStringInterceptorBlock(class_4970.class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12525, class_2350.field_11033).method_11657(class_2741.field_12484, false));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		super.method_9515(builder);
		builder.method_11667(class_2741.field_12484);
	}

	public static class_1269 onInteract(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
		return RedStringInterceptorBlockEntity.onInteract(player, world, hit.method_17777(), hand);
	}

	@Override
	public boolean method_9506(class_2680 state) {
		return true;
	}

	@Override
	public int method_9524(class_2680 state, class_1922 world, class_2338 pos, class_2350 side) {
		return state.method_11654(class_2741.field_12484) ? 15 : 0;
	}

	@Override
	public void method_9588(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
		world.method_8501(pos, state.method_11657(class_2741.field_12484, false));
	}

	@NotNull
	@Override
	public RedStringBlockEntity method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new RedStringInterceptorBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.RED_STRING_INTERCEPTOR, RedStringInterceptorBlockEntity::commonTick);
	}
}
