/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.annotations.SoftImplement;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.PylonBlockEntity;

public class PylonBlock extends BotaniaWaterloggedBlock implements class_2343 {
	private static final class_265 SHAPE = method_9541(2, 0, 2, 14, 21, 14);

	public enum Variant {
		// Note: The enchantment power values are duplicated in the following file. Make sure to keep them in sync:
		// Fabric/src/main/resources/data/quilt/attachments/minecraft/block/enchanting_boosters.json
		MANA(8f, 0.5f, 0.5f, 1f),
		NATURA(15f, 0.5f, 1f, 0.5f),
		GAIA(15f, 1f, 0.5f, 1f);

		public final float enchantPowerBonus;
		public final float r, g, b;

		Variant(float epb, float r, float g, float b) {
			enchantPowerBonus = epb;
			this.r = r;
			this.g = g;
			this.b = b;
		}

		public class_2248 getTargetBlock() {
			return this == MANA ? BotaniaBlocks.enchanter : BotaniaBlocks.alfPortal;
		}
	}

	public final Variant variant;

	public PylonBlock(@NotNull Variant v, class_2251 builder) {
		super(builder);
		this.variant = v;
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@NotNull
	@Override
	public class_2464 method_9604(class_2680 state) {
		return class_2464.field_11456;
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new PylonBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		return createTickerHelper(type, BotaniaBlockEntities.PYLON, PylonBlockEntity::commonTick);
	}

	@SoftImplement("IForgeBlock")
	public float getEnchantPowerBonus(class_2680 state, class_4538 world, class_2338 pos) {
		return variant.enchantPowerBonus;
	}
}
