/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.render.block_entity;

import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.block_entity.mana.ManaPrismBlockEntity;
import vazkii.botania.common.helper.VecHelper;

public class ManaPrismBlockEntityRenderer implements class_827<ManaPrismBlockEntity> {

	public ManaPrismBlockEntityRenderer(class_5614.class_5615 ctx) {}

	@Override
	public void render(@NotNull ManaPrismBlockEntity prism, float partTicks, class_4587 ms, class_4597 buffers, int light, int overlay) {
		float pos = (float) Math.sin((ClientTickHandler.ticksInGame + partTicks) * 0.05F) * 0.5F * (1F - 1F / 16F) * 0.997F - 0.5F;

		class_1799 stack = prism.getItemHandler().method_5438(0);

		if (!stack.method_7960()) {
			if (stack.method_7909() instanceof BasicLensItem) {
				ms.method_22903();
				ms.method_22907(VecHelper.rotateX(90));
				ms.method_46416(0.5F, 0.5F, pos);
				ms.method_22905(1.003F, 1.003F, 1F);
				class_310.method_1551().method_1480().method_23178(stack, class_811.field_4315,
						light, overlay, ms, buffers, prism.method_10997(), 0);
				ms.method_22909();
			}
		}
	}

}
