/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.item;

import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

/**
 * An item that has this capability counts as a Relic item. This is purely for interaction
 * and other mod items should not reuse this capability.
 */
public interface Relic {

	/**
	 * Binds to the UUID passed in.
	 */
	void bindToUUID(UUID uuid);

	/**
	 * Gets the UUID of the person this relic is bound to, or null if a well-formed UUID could not be found
	 */
	@Nullable
	UUID getSoulbindUUID();

	/**
	 * Attempts to bind to a player, or damage them if it's not theirs
	 */
	void tickBinding(class_1657 player);

	/**
	 * Get the advancement granted when this relic binds
	 */
	@Nullable
	default class_2960 getAdvancement() {
		return null;
	}

	default boolean shouldDamageWrongPlayer() {
		return true;
	}

	boolean isRightPlayer(class_1657 player);

}
