/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric.integration.rei;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.List;
import java.util.stream.Stream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Label;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.client.integration.shared.OrechidUIHelper;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.fabric.integration.rei.OrechidBaseREIDisplay;
import vazkii.botania.fabric.integration.rei.PureDaisyREICategory;

public class OrechidREICategory
implements DisplayCategory<OrechidBaseREIDisplay<?>> {
    private final EntryStack<class_1799> orechid;
    private final CategoryIdentifier<? extends OrechidBaseREIDisplay<?>> categoryId;
    private final String langKey;

    public OrechidREICategory(CategoryIdentifier<? extends OrechidBaseREIDisplay<?>> categoryId, class_2248 orechid) {
        this.categoryId = categoryId;
        this.orechid = EntryStacks.of((class_1935)orechid);
        this.langKey = "botania.nei." + (orechid == BotaniaFlowerBlocks.orechidIgnem ? "orechidIgnem" : "orechid");
    }

    @NotNull
    public CategoryIdentifier<? extends OrechidBaseREIDisplay<?>> getCategoryIdentifier() {
        return this.categoryId;
    }

    @NotNull
    public Renderer getIcon() {
        return this.orechid;
    }

    @NotNull
    public class_2561 getTitle() {
        return class_2561.method_43471((String)this.langKey);
    }

    @NotNull
    public List<Widget> setupDisplay(OrechidBaseREIDisplay<?> display, Rectangle bounds) {
        List<Widget> widgets = PureDaisyREICategory.setupPureDaisyDisplay(display, bounds, this.orechid);
        Double chance = this.getChance((OrechidRecipe)display.getRecipe());
        if (chance != null) {
            class_2561 chanceComponent = OrechidUIHelper.getPercentageComponent(chance);
            Point center = new Point(bounds.getCenterX() - 8, bounds.getCenterY() - 9);
            Label chanceLabel = Widgets.createLabel((Point)new Point(center.x + 51, center.y - 11), (class_2561)chanceComponent).rightAligned().color(0x555555, 0xAAAAAA).noShadow();
            chanceLabel.tooltip((class_2561[])this.getChanceTooltipComponents(chance, (OrechidRecipe)display.getRecipe()).toArray(class_2561[]::new));
            widgets.add((Widget)chanceLabel);
        }
        return widgets;
    }

    @NotNull
    protected Stream<class_2561> getChanceTooltipComponents(double chance, OrechidRecipe recipe) {
        IntIntPair ratio = OrechidUIHelper.getRatioForChance(chance);
        return Stream.of(OrechidUIHelper.getRatioTooltipComponent(ratio));
    }

    @Nullable
    protected Double getChance(@NotNull OrechidRecipe recipe) {
        return OrechidUIHelper.getChance(recipe, null);
    }

    public int getDisplayHeight() {
        return 54;
    }

    public int getDisplayWidth(OrechidBaseREIDisplay<?> display) {
        return 112;
    }
}

