/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity.mana;

import com.google.common.base.Predicates;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5712;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.ManaDissolvable;
import vazkii.botania.api.mana.KeyLocked;
import vazkii.botania.api.mana.ManaBlockType;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaNetworkAction;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.spark.ManaSpark;
import vazkii.botania.api.mana.spark.SparkAttachable;
import vazkii.botania.api.recipe.ManaInfusionRecipe;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ThrottledPacket;
import vazkii.botania.common.block.mana.ManaPoolBlock;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaPoolBlockEntity
extends BotaniaBlockEntity
implements ManaPool,
KeyLocked,
SparkAttachable,
ThrottledPacket,
Wandable {
    public static final int PARTICLE_COLOR = 50943;
    public static final float PARTICLE_COLOR_BLUE = 1.0f;
    public static final float PARTICLE_COLOR_GREEN = 0.7764706f;
    public static final float PARTICLE_COLOR_RED = 0.0f;
    public static final int MAX_MANA = 1000000;
    private static final int MAX_MANA_DILLUTED = 10000;
    private static final String TAG_MANA = "mana";
    private static final String TAG_OUTPUTTING = "outputting";
    private static final String TAG_MANA_CAP = "manaCap";
    private static final String TAG_CAN_ACCEPT = "canAccept";
    private static final String TAG_CAN_SPARE = "canSpare";
    private static final String TAG_INPUT_KEY = "inputKey";
    private static final String TAG_OUTPUT_KEY = "outputKey";
    private static final int CRAFT_EFFECT_EVENT = 0;
    private static final int CHARGE_EFFECT_EVENT = 1;
    private static final int DRAIN_EFFECT_EVENT = 2;
    private static final float CHARGING_GRAVITY = 0.003f;
    private boolean outputting = false;
    private Optional<class_1767> legacyColor = Optional.empty();
    private int mana;
    private int manaCap = -1;
    private int soundTicks = 0;
    private boolean canAccept = true;
    private boolean canSpare = true;
    boolean isDoingTransfer = false;
    int ticksDoingTransfer = 0;
    private String inputKey = "";
    private final String outputKey = "";
    private int ticks = 0;
    private boolean sendPacket = false;
    private final Int2ObjectMap<MutableInt> chargingParticles = new Int2ObjectOpenHashMap();
    private final Int2ObjectMap<MutableInt> drainingParticles = new Int2ObjectOpenHashMap();

    public ManaPoolBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.POOL, pos, state);
    }

    @Override
    public boolean isFull() {
        class_2680 stateBelow = this.field_11863.method_8320(this.field_11867.method_10074());
        return !stateBelow.method_27852(BotaniaBlocks.manaVoid) && this.getCurrentMana() >= this.getMaxMana();
    }

    @Override
    public void receiveMana(int mana) {
        int old = this.mana;
        this.mana = Math.max(0, Math.min(this.getCurrentMana() + mana, this.getMaxMana()));
        if (old != this.mana) {
            this.method_5431();
            this.markDispatchable();
        }
    }

    public void method_11012() {
        super.method_11012();
        BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.REMOVE);
    }

    public static int calculateComparatorLevel(int mana, int max) {
        int val = (int)((double)mana / (double)max * 15.0);
        if (mana > 0) {
            val = Math.max(val, 1);
        }
        return val;
    }

    public ManaInfusionRecipe getMatchingRecipe(@NotNull class_1799 stack, @NotNull class_2680 state) {
        ArrayList<ManaInfusionRecipe> matchingNonCatRecipes = new ArrayList<ManaInfusionRecipe>();
        ArrayList<ManaInfusionRecipe> matchingCatRecipes = new ArrayList<ManaInfusionRecipe>();
        for (ManaInfusionRecipe recipe : BotaniaRecipeTypes.getRecipes(this.field_11863, BotaniaRecipeTypes.MANA_INFUSION_TYPE).values()) {
            if (!recipe.matches(stack)) continue;
            if (recipe.getRecipeCatalyst() == null) {
                matchingNonCatRecipes.add(recipe);
                continue;
            }
            if (!recipe.getRecipeCatalyst().test(state)) continue;
            matchingCatRecipes.add(recipe);
        }
        return !matchingCatRecipes.isEmpty() ? (ManaInfusionRecipe)matchingCatRecipes.get(0) : (!matchingNonCatRecipes.isEmpty() ? (ManaInfusionRecipe)matchingNonCatRecipes.get(0) : null);
    }

    public boolean collideEntityItem(class_1542 item) {
        if (this.field_11863.field_9236 || !item.method_5805() || item.method_6983().method_7960()) {
            return false;
        }
        class_1799 stack = item.method_6983();
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof ManaDissolvable) {
            ManaDissolvable dissolvable = (ManaDissolvable)class_17922;
            dissolvable.onDissolveTick(this, item);
        }
        if (XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)item).manaInfusionSpawned) {
            return false;
        }
        ManaInfusionRecipe recipe = this.getMatchingRecipe(stack, this.field_11863.method_8320(this.field_11867.method_10074()));
        if (recipe != null) {
            int mana = recipe.getManaToConsume();
            if (this.getCurrentMana() >= mana) {
                this.receiveMana(-mana);
                class_1799 output = recipe.getRecipeOutput(this.field_11863.method_30349(), stack);
                EntityHelper.shrinkItem(item);
                item.method_24830(false);
                class_1542 outputItem = new class_1542(this.field_11863, (double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 1.5, (double)this.field_11867.method_10260() + 0.5, output);
                XplatAbstractions.INSTANCE.itemFlagsComponent((class_1542)outputItem).manaInfusionSpawned = true;
                class_1297 class_12972 = item.method_24921();
                if (class_12972 instanceof class_1657) {
                    class_1657 player = (class_1657)class_12972;
                    player.method_51283((class_1860)recipe, List.of(output));
                    output.method_7982(this.field_11863, player, output.method_7947());
                }
                this.field_11863.method_8649((class_1297)outputItem);
                this.craftingEffect(true);
                return true;
            }
        }
        return false;
    }

    public void craftingEffect(boolean playSound) {
        if (playSound && this.soundTicks == 0) {
            this.field_11863.method_8396(null, this.field_11867, BotaniaSounds.manaPoolCraft, class_3419.field_15245, 1.0f, 1.0f);
            this.soundTicks = 6;
        }
        this.field_11863.method_33596(null, class_5712.field_28174, this.method_11016());
        this.field_11863.method_8427(this.method_11016(), this.method_11010().method_26204(), 0, 0);
    }

    public boolean method_11004(int event, int param) {
        switch (event) {
            case 0: {
                if (this.field_11863.field_9236) {
                    for (int i2 = 0; i2 < 25; ++i2) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.field_11863.method_8406((class_2394)data, (double)this.field_11867.method_10263() + 0.5 + Math.random() * 0.4 - 0.2, (double)this.field_11867.method_10264() + 0.75, (double)this.field_11867.method_10260() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
            case 1: {
                if (this.field_11863.field_9236 && BotaniaConfig.common().chargingAnimationEnabled()) {
                    ((MutableInt)this.chargingParticles.computeIfAbsent(param, i -> new MutableInt(15))).setValue(15);
                }
                return true;
            }
            case 2: {
                if (this.field_11863.field_9236 && BotaniaConfig.common().chargingAnimationEnabled()) {
                    ((MutableInt)this.drainingParticles.computeIfAbsent(param, i -> new MutableInt(15))).setValue(15);
                }
                return true;
            }
        }
        return super.method_11004(event, param);
    }

    private void initManaCapAndNetwork() {
        if (this.getMaxMana() == -1) {
            int n = this.manaCap = ((ManaPoolBlock)this.method_11010().method_26204()).variant == ManaPoolBlock.Variant.DILUTED ? 10000 : 1000000;
        }
        if (!ManaNetworkHandler.instance.isPoolIn(this.field_11863, this) && !this.method_11015()) {
            BotaniaAPI.instance().getManaNetworkInstance().fireManaNetworkEvent(this, ManaBlockType.POOL, ManaNetworkAction.ADD);
        }
    }

    public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, ManaPoolBlockEntity self) {
        self.initManaCapAndNetwork();
        double particleChance = 1.0 - (double)self.getCurrentMana() / (double)self.getMaxMana() * 0.1;
        if (Math.random() > particleChance) {
            WispParticleData data = WispParticleData.wisp((float)Math.random() / 3.0f, 0.0f, 0.7764706f, 1.0f, 2.0f);
            level.method_8406((class_2394)data, (double)worldPosition.method_10263() + 0.3 + Math.random() * 0.5, (double)worldPosition.method_10264() + 0.6 + Math.random() * 0.25, (double)worldPosition.method_10260() + Math.random(), 0.0, (double)((float)Math.random() / 25.0f), 0.0);
        }
        if (self.getCurrentMana() == 0) {
            self.chargingParticles.clear();
        } else {
            ManaPoolBlockEntity.displayChargingParticles(level, worldPosition, self, self.chargingParticles, true);
        }
        ManaPoolBlockEntity.displayChargingParticles(level, worldPosition, self, self.drainingParticles, false);
    }

    private static void displayChargingParticles(class_1937 level, class_2338 worldPosition, ManaPoolBlockEntity self, Int2ObjectMap<MutableInt> particles, boolean charging) {
        int bellowCount = charging ? ManaPoolBlockEntity.getBellowCount(level, worldPosition, self) : 0;
        float relativeMana = (float)self.getCurrentMana() / (float)self.getMaxMana();
        ObjectIterator particlesIterator = particles.int2ObjectEntrySet().iterator();
        while (particlesIterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)particlesIterator.next();
            int ticksRemaining = ((MutableInt)entry.getValue()).decrementAndGet();
            if (ticksRemaining % 2 == 0) {
                int encodedPos = entry.getIntKey();
                class_243 itemPosRelBase = ManaPoolBlockEntity.decodeRelativeItemPosition(encodedPos, relativeMana);
                if (charging) {
                    for (int i = 0; i <= bellowCount; ++i) {
                        class_243 itemPosRel = ManaPoolBlockEntity.randomizeItemPos(itemPosRelBase);
                        class_243 poolPosRel = new class_243(0.1 + 0.8 * Math.random(), 0.1 + 0.4 * (double)relativeMana, 0.1 + 0.8 * Math.random());
                        ManaPoolBlockEntity.addManaFlowParticle(level, worldPosition, poolPosRel, itemPosRel);
                    }
                } else {
                    class_243 itemPosRel = ManaPoolBlockEntity.randomizeItemPos(itemPosRelBase);
                    class_243 poolPosRel = new class_243(0.05 + 0.9 * Math.random(), 0.35 * (double)relativeMana, 0.05 + 0.9 * Math.random());
                    ManaPoolBlockEntity.addManaFlowParticle(level, worldPosition, itemPosRel, poolPosRel);
                }
            }
            if (ticksRemaining > 0) continue;
            particlesIterator.remove();
        }
    }

    @NotNull
    private static class_243 randomizeItemPos(class_243 itemPosRelBase) {
        return itemPosRelBase.method_1031(0.1 * Math.random() - 0.05, 0.1 * Math.random() + 0.25, 0.1 * Math.random() - 0.05);
    }

    private static int getBellowCount(class_1937 level, class_2338 worldPosition, ManaPoolBlockEntity self) {
        int bellowCount = 0;
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            BellowsBlockEntity bellows;
            class_2586 tile = level.method_8321(worldPosition.method_10093(dir));
            if (!(tile instanceof BellowsBlockEntity) || (bellows = (BellowsBlockEntity)tile).getLinkedTile() != self) continue;
            ++bellowCount;
        }
        return bellowCount;
    }

    private static void addManaFlowParticle(class_1937 level, class_2338 worldPosition, class_243 startPos, class_243 endPos) {
        double maxHeight = Math.max(startPos.field_1351, endPos.field_1351) - endPos.field_1351 + 0.05 * Math.random();
        class_243 horizontalDiff = new class_243(endPos.field_1352 - startPos.field_1352, 0.0, endPos.field_1350 - startPos.field_1350);
        double horizontalDistance = horizontalDiff.method_37267();
        class_243 horizontalDir = horizontalDiff.method_1021(1.0 / horizontalDistance);
        double startHeight = startPos.field_1351 - endPos.field_1351;
        double vY0Squared = (double)0.006f * (maxHeight - startHeight);
        double vY0 = Math.sqrt(vY0Squared);
        double lifetime = (vY0 + Math.sqrt(vY0Squared + (double)0.006f * startHeight)) / (double)0.003f;
        double vX0 = horizontalDistance / lifetime;
        class_243 v0 = horizontalDir.method_1021(vX0).method_38499(class_2350.class_2351.field_11052, vY0);
        WispParticleData data = WispParticleData.wisp(0.1f, 0.0f, 0.7764706f, 1.0f, (float)(0.025 * lifetime), 0.003f).withNoClip(true);
        level.method_8406((class_2394)data, (double)worldPosition.method_10263() + startPos.field_1352, (double)worldPosition.method_10264() + startPos.field_1351, (double)worldPosition.method_10260() + startPos.field_1350, v0.field_1352, v0.field_1351, v0.field_1350);
    }

    public static void serverTick(class_1937 level, class_2338 worldPosition, class_2680 state, ManaPoolBlockEntity self) {
        if (self.legacyColor.isPresent()) {
            self.setColor(self.legacyColor);
            self.legacyColor = Optional.empty();
        }
        self.initManaCapAndNetwork();
        boolean wasDoingTransfer = self.isDoingTransfer;
        self.isDoingTransfer = false;
        if (self.soundTicks > 0) {
            --self.soundTicks;
        }
        if (self.sendPacket && self.ticks % 10 == 0) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            self.sendPacket = false;
        }
        List items = level.method_18467(class_1542.class, new class_238(worldPosition, worldPosition.method_10069(1, 1, 1)));
        for (class_1542 item : items) {
            if (!item.method_5805()) continue;
            class_1799 stack = item.method_6983();
            ManaItem mana = XplatAbstractions.INSTANCE.findManaItem(stack);
            if (stack.method_7960() || mana == null || (!self.outputting || !mana.canReceiveManaFromPool(self)) && (self.outputting || !mana.canExportManaToPool(self))) continue;
            boolean didSomething = false;
            int bellowCount = self.outputting ? ManaPoolBlockEntity.getBellowCount(level, worldPosition, self) : 0;
            int transfRate = 1000 * (bellowCount + 1);
            if (self.outputting) {
                if (self.canSpare) {
                    if (self.getCurrentMana() > 0 && mana.getMana() < mana.getMaxMana()) {
                        didSomething = true;
                    }
                    manaVal = Math.min(transfRate, Math.min(self.getCurrentMana(), mana.getMaxMana() - mana.getMana()));
                    mana.addMana(manaVal);
                    self.receiveMana(-manaVal);
                }
            } else if (self.canAccept) {
                if (mana.getMana() > 0 && !self.isFull()) {
                    didSomething = true;
                }
                if ((manaVal = Math.min(transfRate, Math.min(self.getMaxMana() - self.getCurrentMana(), mana.getMana()))) == 0 && self.field_11863.method_8320(worldPosition.method_10074()).method_27852(BotaniaBlocks.manaVoid)) {
                    manaVal = Math.min(transfRate, mana.getMana());
                }
                mana.addMana(-manaVal);
                self.receiveMana(manaVal);
            }
            if (!didSomething) continue;
            if (BotaniaConfig.common().chargingAnimationEnabled() && self.ticks % 10 == 0) {
                level.method_8427(worldPosition, state.method_26204(), self.outputting ? 1 : 2, ManaPoolBlockEntity.encodeRelativeItemPosition(worldPosition, item));
            }
            EntityHelper.syncItem(item);
            self.isDoingTransfer = self.outputting;
        }
        if (self.isDoingTransfer) {
            ++self.ticksDoingTransfer;
        } else {
            self.ticksDoingTransfer = 0;
            if (wasDoingTransfer) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            }
        }
        ++self.ticks;
    }

    private static int encodeRelativeItemPosition(class_2338 worldPosition, class_1542 item) {
        double relX = class_3532.method_15350((double)(item.method_19538().method_10216() - (double)worldPosition.method_10263()), (double)0.0, (double)1.0);
        double relY = class_3532.method_15350((double)(0.125 + 0.875 * (item.method_19538().method_10214() - (double)worldPosition.method_10264())), (double)0.125, (double)0.9);
        double relZ = class_3532.method_15350((double)(item.method_19538().method_10215() - (double)worldPosition.method_10260()), (double)0.0, (double)1.0);
        int compressedX = (int)Math.round(7.0 * relX);
        int compressedY = 4 - class_3532.method_15342((int)(14 - (int)(14.0 * relY)));
        int compressedZ = (int)Math.round(7.0 * relZ);
        return compressedX | compressedY << 3 | compressedZ << 5;
    }

    private static class_243 decodeRelativeItemPosition(int param, float relativeMana) {
        int compressedX = param & 7;
        int compressedY = param >> 3 & 3;
        int compressedZ = param >> 5 & 7;
        double relX = (double)compressedX / 7.0;
        double relY = 1.0 - 0.875 / (double)(1 << compressedY);
        double relZ = (double)compressedZ / 7.0;
        return new class_243(relX, Math.max(relY, 0.5 * (double)relativeMana), relZ);
    }

    @Override
    public void writePacketNBT(class_2487 cmp) {
        cmp.method_10569(TAG_MANA, this.getCurrentMana());
        cmp.method_10556(TAG_OUTPUTTING, this.outputting);
        cmp.method_10569(TAG_MANA_CAP, this.getMaxMana());
        cmp.method_10556(TAG_CAN_ACCEPT, this.canAccept);
        cmp.method_10556(TAG_CAN_SPARE, this.canSpare);
        cmp.method_10582(TAG_INPUT_KEY, this.inputKey);
        cmp.method_10582(TAG_OUTPUT_KEY, "");
    }

    @Override
    public void readPacketNBT(class_2487 cmp) {
        this.mana = cmp.method_10550(TAG_MANA);
        this.outputting = cmp.method_10577(TAG_OUTPUTTING);
        if (cmp.method_10545("color")) {
            class_1767 color = class_1767.method_7791((int)cmp.method_10550("color"));
            this.legacyColor = color != class_1767.field_7952 ? Optional.of(color) : Optional.empty();
        }
        if (cmp.method_10545(TAG_MANA_CAP)) {
            this.manaCap = cmp.method_10550(TAG_MANA_CAP);
        }
        if (cmp.method_10545(TAG_CAN_ACCEPT)) {
            this.canAccept = cmp.method_10577(TAG_CAN_ACCEPT);
        }
        if (cmp.method_10545(TAG_CAN_SPARE)) {
            this.canSpare = cmp.method_10577(TAG_CAN_SPARE);
        }
        if (cmp.method_10545(TAG_INPUT_KEY)) {
            this.inputKey = cmp.method_10558(TAG_INPUT_KEY);
        }
        if (cmp.method_10545(TAG_OUTPUT_KEY)) {
            this.inputKey = cmp.method_10558(TAG_OUTPUT_KEY);
        }
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        if (player == null || player.method_5715()) {
            this.outputting = !this.outputting;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return true;
    }

    @Override
    public boolean isOutputtingPower() {
        return this.outputting;
    }

    @Override
    public class_1937 getManaReceiverLevel() {
        return this.method_10997();
    }

    @Override
    public class_2338 getManaReceiverPos() {
        return this.method_11016();
    }

    @Override
    public int getCurrentMana() {
        class_2248 class_22482 = this.method_11010().method_26204();
        if (class_22482 instanceof ManaPoolBlock) {
            ManaPoolBlock pool = (ManaPoolBlock)class_22482;
            return pool.variant == ManaPoolBlock.Variant.CREATIVE ? 1000000 : this.mana;
        }
        return 0;
    }

    @Override
    public int getMaxMana() {
        return this.manaCap;
    }

    @Override
    public String getInputKey() {
        return this.inputKey;
    }

    @Override
    public String getOutputKey() {
        return "";
    }

    @Override
    public boolean canAttachSpark(class_1799 stack) {
        return true;
    }

    @Override
    public ManaSpark getAttachedSpark() {
        List sparks = this.field_11863.method_8390(class_1297.class, new class_238(this.field_11867.method_10084(), this.field_11867.method_10084().method_10069(1, 1, 1)), (Predicate)Predicates.instanceOf(ManaSpark.class));
        if (sparks.size() == 1) {
            class_1297 e = (class_1297)sparks.get(0);
            return (ManaSpark)e;
        }
        return null;
    }

    @Override
    public boolean areIncomingTranfersDone() {
        return false;
    }

    @Override
    public int getAvailableSpaceForMana() {
        int space = Math.max(0, this.getMaxMana() - this.getCurrentMana());
        if (space > 0) {
            return space;
        }
        if (this.field_11863.method_8320(this.field_11867.method_10074()).method_27852(BotaniaBlocks.manaVoid)) {
            return this.getMaxMana();
        }
        return 0;
    }

    @Override
    public Optional<class_1767> getColor() {
        return ((BotaniaStateProperties.OptionalDyeColor)((Object)this.method_11010().method_11654(BotaniaStateProperties.OPTIONAL_DYE_COLOR))).toDyeColor();
    }

    @Override
    public void setColor(Optional<class_1767> color) {
        this.field_11863.method_8501(this.field_11867, (class_2680)this.method_11010().method_11657(BotaniaStateProperties.OPTIONAL_DYE_COLOR, (Comparable)((Object)BotaniaStateProperties.OptionalDyeColor.fromOptionalDyeColor(color))));
    }

    @Override
    public void markDispatchable() {
        this.sendPacket = true;
    }

    public static class WandHud
    implements WandHUD {
        private final ManaPoolBlockEntity pool;

        public WandHud(ManaPoolBlockEntity pool) {
            this.pool = pool;
        }

        @Override
        public void renderHUD(class_332 gui, class_310 mc) {
            class_1799 poolStack = new class_1799((class_1935)this.pool.method_11010().method_26204());
            String name = poolStack.method_7964().getString();
            int centerX = mc.method_22683().method_4486() / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            int width = Math.max(102, mc.field_1772.method_1727(name)) + 4;
            RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 48);
            BotaniaAPIClient.instance().drawSimpleManaHUD(gui, 38399, this.pool.getCurrentMana(), this.pool.getMaxMana(), name);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            int arrowU = this.pool.outputting ? 22 : 0;
            int arrowV = 38;
            RenderHelper.drawTexturedModalRect(gui, HUDHandler.manaBar, centerX - 11, centerY + 30, arrowU, arrowV, 22, 15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_1799 tablet = new class_1799((class_1935)BotaniaItems.manaTablet);
            ManaTabletItem.setStackCreative(tablet);
            gui.method_51427(tablet, centerX - 31, centerY + 30);
            gui.method_51427(poolStack, centerX + 15, centerY + 30);
            RenderSystem.disableBlend();
        }
    }
}

