/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import vazkii.botania.fabric.xplat.FabricXplatImpl;

import java.util.Optional;
import net.minecraft.class_1743;
import net.minecraft.class_2248;
import net.minecraft.class_2680;

@Mixin(class_1743.class)
public class AxeItemFabricMixin {
	/** Stripping blocks without an axis property is not doable through FAPI, so we do this. */
	@Inject(method = "getStripped", at = @At("RETURN"), cancellable = true)
	private void stripBlocksWithoutAxis(class_2680 state, CallbackInfoReturnable<Optional<class_2680>> cir) {
		if (cir.getReturnValue().isEmpty()) {
			class_2248 block = FabricXplatImpl.CUSTOM_STRIPPING.get(state.method_26204());
			if (block != null) {
				cir.setReturnValue(Optional.of(block.method_34725(state)));
			}
		}
	}
}
