/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.helper.VecHelper;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1937;
import net.minecraft.class_2261;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class MagicMissileEntity extends class_1682 {
	private static final String TAG_TIME = "time";
	private static final class_2940<Boolean> EVIL = class_2945.method_12791(MagicMissileEntity.class, class_2943.field_13323);
	private static final class_2940<Integer> TARGET = class_2945.method_12791(MagicMissileEntity.class, class_2943.field_13327);

	double lockX, lockY = Integer.MIN_VALUE, lockZ;
	int time = 0;

	public MagicMissileEntity(class_1299<MagicMissileEntity> type, class_1937 world) {
		super(type, world);
	}

	public MagicMissileEntity(class_1309 owner, boolean evil) {
		super(BotaniaEntities.MAGIC_MISSILE, owner, owner.method_37908());
		setEvil(evil);
	}

	@Override
	protected void method_5693() {
		field_6011.method_12784(EVIL, false);
		field_6011.method_12784(TARGET, 0);
	}

	public void setEvil(boolean evil) {
		field_6011.method_12778(EVIL, evil);
	}

	public boolean isEvil() {
		return field_6011.method_12789(EVIL);
	}

	public void setTarget(class_1309 e) {
		field_6011.method_12778(TARGET, e == null ? -1 : e.method_5628());
	}

	public class_1309 getTargetEntity() {
		int id = field_6011.method_12789(TARGET);
		class_1297 e = method_37908().method_8469(id);
		if (e instanceof class_1309 le) {
			return le;
		}

		return null;
	}

	@Override
	public void method_5773() {
		double lastTickPosX = this.field_6038;
		double lastTickPosY = this.field_5971;
		double lastTickPosZ = this.field_5989;

		super.method_5773();

		if (!method_37908().field_9236 && (!findTarget() || time > 40)) {
			method_31472();
			return;
		}

		boolean evil = isEvil();
		class_243 thisVec = VecHelper.fromEntityCenter(this);
		class_243 oldPos = new class_243(lastTickPosX, lastTickPosY, lastTickPosZ);
		class_243 diff = thisVec.method_1020(oldPos);
		class_243 step = diff.method_1029().method_1021(0.05);
		int steps = (int) (diff.method_1033() / step.method_1033());
		class_243 particlePos = oldPos;

		SparkleParticleData data = evil ? SparkleParticleData.corrupt(0.8F, 1F, 0.0F, 1F, 2)
				: SparkleParticleData.sparkle(0.8F, 1F, 0.4F, 1F, 2);
		for (int i = 0; i < steps; i++) {
			method_37908().method_8406(data, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0, 0, 0);

			if (method_37908().field_9229.method_43048(steps) <= 1) {
				method_37908().method_8406(data, particlePos.field_1352 + (Math.random() - 0.5) * 0.4, particlePos.field_1351 + (Math.random() - 0.5) * 0.4, particlePos.field_1350 + (Math.random() - 0.5) * 0.4, 0, 0, 0);
			}

			particlePos = particlePos.method_1019(step);
		}

		class_1309 target = getTargetEntity();
		if (target != null) {
			if (lockY == Integer.MIN_VALUE) {
				lockX = target.method_23317();
				lockY = target.method_23318();
				lockZ = target.method_23321();
			}

			class_243 targetVec = evil ? new class_243(lockX, lockY, lockZ) : VecHelper.fromEntityCenter(target);
			class_243 diffVec = targetVec.method_1020(thisVec);
			class_243 motionVec = diffVec.method_1029().method_1021(evil ? 0.5 : 0.6);
			method_18799(motionVec);
			if (time < 10) {
				method_18800(method_18798().method_10216(), Math.abs(method_18798().method_10214()), method_18798().method_10215());
			}

			List<class_1309> targetList = method_37908().method_18467(class_1309.class, new class_238(method_23317() - 0.5, method_23318() - 0.5, method_23321() - 0.5, method_23317() + 0.5, method_23318() + 0.5, method_23321() + 0.5));
			if (targetList.contains(target)) {
				target.method_5643(this.getDamageSource(), evil ? 12 : 7);
				method_31472();
			}

			if (evil && diffVec.method_1033() < 1) {
				method_31472();
			}
		}

		time++;
	}

	private class_1282 getDamageSource() {
		class_1297 owner = this.method_24921();
		if (owner instanceof class_1309 livingOwner) {
			return owner instanceof class_1657 playerOwner
					? method_48923().method_48802(playerOwner)
					: method_48923().method_48812(livingOwner);
		} else {
			return method_48923().method_48830();
		}
	}

	@Override
	public void method_5652(class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10569(TAG_TIME, time);
	}

	@Override
	public void method_5749(class_2487 cmp) {
		super.method_5749(cmp);
		time = cmp.method_10550(TAG_TIME);
	}

	public boolean findTarget() {
		class_1309 target = getTargetEntity();
		if (target != null) {
			if (target.method_5805()) {
				return true;
			} else {
				target = null;
				setTarget(null);
			}
		}

		double range = 12;
		class_238 bounds = new class_238(method_23317() - range, method_23318() - range, method_23321() - range, method_23317() + range, method_23318() + range, method_23321() + range);
		class_1282 source = this.getDamageSource();
		Predicate<class_1297> vulnerableTo = e -> !e.method_5679(source);
		List<? extends class_1309> entities;
		if (isEvil()) {
			entities = method_37908().method_8390(class_1657.class, bounds,
					class_1301.field_6157.and(vulnerableTo));
		} else {
			class_1297 owner = method_24921();
			Predicate<class_1297> pred = class_1301.field_6157
					.and(targetPredicate(owner)).and(vulnerableTo);
			entities = method_37908().method_8390(class_1309.class, bounds, pred);
		}

		if (!entities.isEmpty()) {
			target = entities.get(method_37908().field_9229.method_43048(entities.size()));
			setTarget(target);
		}

		return target != null;
	}

	public static Predicate<class_1297> targetPredicate(class_1297 owner) {
		return target -> target instanceof class_1309 living && shouldTarget(owner, living);
	}

	public static boolean shouldTarget(class_1297 owner, class_1309 e) {
		// always defend yourself
		if (e instanceof class_1308 mob && isHostile(owner, mob.method_5968())) {
			return true;
		}
		// don't target tamed creatures...
		if (e instanceof class_1321 animal && animal.method_6181() || e instanceof class_1496 horse && horse.method_6727()) {
			return false;
		}

		// ...but other mobs die
		return e instanceof class_1569;
	}

	public static boolean isHostile(class_1297 owner, class_1297 attackTarget) {
		// if the owner can attack the target thru PvP...
		if (owner instanceof class_1657 ownerPlayer && attackTarget instanceof class_1657 targetedPlayer && ownerPlayer.method_7256(targetedPlayer)) {
			// ... then only defend self
			return owner == attackTarget;
		}
		// otherwise, kill any player-hostiles
		return attackTarget instanceof class_1657;
	}

	@Override
	protected void method_24920(@NotNull class_3965 hit) {
		super.method_24920(hit);
		class_2680 state = method_37908().method_8320(hit.method_17777());
		if (!method_37908().field_9236
				&& !(state.method_26204() instanceof class_2261)
				&& !state.method_26164(class_3481.field_15503)) {
			method_31472();
		}
	}

	@Override
	protected void method_7454(@NotNull class_3966 hit) {
		super.method_7454(hit);
		if (!method_37908().field_9236 && hit.method_17782() == getTargetEntity()) {
			method_31472();
		}
	}

}
