package vazkii.botania.common.helper;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class ForcePushHelper implements AutoCloseable {
	/**
	 * Keeps track of push origins for nested force relay moves.
	 */
	private static final ThreadLocal<Deque<class_2338>> forcePushOriginStack = ThreadLocal.withInitial(ArrayDeque::new);

	/**
	 * Keeps track of nested block push movement types (extending=true or retracting=false) and directions.
	 * While the direction could be inferred when pushed by another block (e.g. extending or retracting piston or
	 * other moving blocks), a directly applied push (e.g. via a force relay or force lens mana burst) does not carry
	 * that information on its own.
	 */
	private static final ThreadLocal<Deque<Map.Entry<Boolean, class_2350>>> movementTypeContextStack = ThreadLocal.withInitial(ArrayDeque::new);

	public static boolean isForcePush() {
		return !forcePushOriginStack.get().isEmpty();
	}

	public static class_2338 getForcePushOrigin() {
		if (!isForcePush()) {
			throw new IllegalStateException("Not currently performing a Force Relay or Force Lens push");
		}
		return forcePushOriginStack.get().peek();
	}

	public static void pushMovementTypeContext(boolean extending, class_2350 pushDir) {
		movementTypeContextStack.get().push(Map.entry(extending, pushDir));
	}

	public static void popMovementTypeContext() {
		movementTypeContextStack.get().pop();
	}

	public static boolean isExtendingMovementContext() {
		Map.Entry<Boolean, class_2350> entry = movementTypeContextStack.get().peek();
		return entry == null || entry.getKey();
	}

	public static class_2350 getMovementContextDirection() {
		Map.Entry<Boolean, class_2350> entry = movementTypeContextStack.get().peek();
		return entry != null ? entry.getValue() : null;
	}

	public ForcePushHelper(class_2338 pushLocation) {
		forcePushOriginStack.get().push(pushLocation.method_10062());
	}

	@Override
	public void close() {
		forcePushOriginStack.get().pop();
	}
}
