/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.common.block.BotaniaBlocks;

import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;

public class ManaInfusionRecipe implements vazkii.botania.api.recipe.ManaInfusionRecipe {
	private final class_2960 id;
	private final class_1799 output;
	private final class_1856 input;
	private final int mana;
	@Nullable
	private final StateIngredient catalyst;
	private final String group;

	public ManaInfusionRecipe(class_2960 id, class_1799 output, class_1856 input, int mana,
			@Nullable String group, @Nullable StateIngredient catalyst) {
		Preconditions.checkArgument(mana > 0, "Mana cost must be positive");
		Preconditions.checkArgument(mana <= 1_000_001, "Mana cost must be at most a pool"); // Leaving wiggle room for a certain modpack having creative-pool-only recipes
		this.id = id;
		this.output = output;
		this.input = input;
		this.mana = mana;
		this.group = group == null ? "" : group;
		this.catalyst = catalyst;
	}

	@NotNull
	@Override
	public final class_2960 method_8114() {
		return id;
	}

	@NotNull
	@Override
	public class_1865<ManaInfusionRecipe> method_8119() {
		return BotaniaRecipeTypes.MANA_INFUSION_SERIALIZER;
	}

	@Override
	public boolean matches(class_1799 stack) {
		return input.method_8093(stack);
	}

	@Override
	public StateIngredient getRecipeCatalyst() {
		return catalyst;
	}

	@Override
	public int getManaToConsume() {
		return mana;
	}

	@NotNull
	@Override
	public class_1799 method_8110(@NotNull class_5455 registries) {
		return output;
	}

	@NotNull
	@Override
	public class_2371<class_1856> method_8117() {
		return class_2371.method_10212(class_1856.field_9017, input);
	}

	@NotNull
	@Override
	public String method_8112() {
		return group;
	}

	@NotNull
	@Override
	public class_1799 method_17447() {
		return new class_1799(BotaniaBlocks.manaPool);
	}

	public static class Serializer implements class_1865<ManaInfusionRecipe> {

		@NotNull
		@Override
		public ManaInfusionRecipe method_8121(@NotNull class_2960 id, @NotNull JsonObject json) {
			JsonElement input = Objects.requireNonNull(json.get("input"));
			class_1856 ing = class_1856.method_52177(input);
			class_1799 output = class_1869.method_35228(class_3518.method_15296(json, "output"));
			int mana = class_3518.method_15260(json, "mana");
			String group = class_3518.method_15253(json, "group", "");
			StateIngredient catalyst = null;
			if (json.has("catalyst")) {
				JsonElement element = json.get("catalyst");
				if (!element.isJsonObject() || !element.getAsJsonObject().has("type")) {
					throw new JsonParseException("Legacy mana infusion catalyst syntax used");
				}
				catalyst = StateIngredientHelper.deserialize(element.getAsJsonObject());
			}

			return new ManaInfusionRecipe(id, output, ing, mana, group, catalyst);
		}

		@Nullable
		@Override
		public ManaInfusionRecipe method_8122(@NotNull class_2960 id, @NotNull class_2540 buf) {
			class_1856 input = class_1856.method_8086(buf);
			class_1799 output = buf.method_10819();
			int mana = buf.method_10816();
			StateIngredient catalyst = null;
			if (buf.readBoolean()) {
				catalyst = StateIngredientHelper.read(buf);
			}
			String group = buf.method_19772();
			return new ManaInfusionRecipe(id, output, input, mana, group, catalyst);
		}

		@Override
		public void toNetwork(@NotNull class_2540 buf, @NotNull ManaInfusionRecipe recipe) {
			recipe.method_8117().get(0).method_8088(buf);
			buf.method_10793(recipe.output);
			buf.method_10804(recipe.getManaToConsume());
			boolean hasCatalyst = recipe.getRecipeCatalyst() != null;
			buf.writeBoolean(hasCatalyst);
			if (hasCatalyst) {
				recipe.getRecipeCatalyst().write(buf);
			}
			buf.method_10814(recipe.method_8112());
		}
	}
}
