/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.mana;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.xplat.XplatAbstractions;

public class PowerGeneratorBlockEntity extends BotaniaBlockEntity implements ManaReceiver {
	private static final int MANA_TO_FE = XplatAbstractions.INSTANCE.isForge() ? 10 : 3;
	public static final int MAX_ENERGY = 1280 * MANA_TO_FE;

	private static final String TAG_MANA = "mana";
	private int energy = 0;

	public PowerGeneratorBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaBlockEntities.FLUXFIELD, pos, state);
	}

	public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, PowerGeneratorBlockEntity self) {
		int toTransfer = Math.min(self.energy, 160 * MANA_TO_FE);
		int unconsumed = XplatAbstractions.INSTANCE.transferEnergyToNeighbors(level, pos, toTransfer);
		if (unconsumed != toTransfer) {
			self.energy -= (toTransfer - unconsumed);
			self.method_5431();
		}
	}

	@Override
	public class_1937 getManaReceiverLevel() {
		return method_10997();
	}

	@Override
	public class_2338 getManaReceiverPos() {
		return method_11016();
	}

	@Override
	public int getCurrentMana() {
		return energy / MANA_TO_FE;
	}

	@Override
	public boolean isFull() {
		return energy >= MAX_ENERGY;
	}

	@Override
	public void receiveMana(int mana) {
		this.energy = Math.min(MAX_ENERGY, this.energy + mana * MANA_TO_FE);
	}

	@Override
	public boolean canReceiveManaFromBursts() {
		return true;
	}

	@Override
	public void writePacketNBT(class_2487 cmp) {
		cmp.method_10569(TAG_MANA, energy);
	}

	@Override
	public void readPacketNBT(class_2487 cmp) {
		energy = cmp.method_10550(TAG_MANA);
	}

	public int getEnergy() {
		return energy;
	}

}
