/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.entity.GaiaGuardianEntity;

import java.util.*;
import net.minecraft.class_1259;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import org.joml.Matrix4f;

public final class BossBarHandler {

	private BossBarHandler() {}

	// Only access on the client thread!
	public static final Set<GaiaGuardianEntity> bosses = Collections.newSetFromMap(new WeakHashMap<>());
	private static final class_2960 BAR_TEXTURE = new class_2960(ResourcesLib.GUI_BOSS_BAR);

	public static OptionalInt onBarRender(class_332 gui, int x, int y, class_1259 bossEvent, boolean drawName) {
		for (GaiaGuardianEntity currentBoss : bosses) {
			if (currentBoss.getBossInfoUuid().equals(bossEvent.method_5407())) {
				class_310 mc = class_310.method_1551();
				// todo boss_bar.png has textures for different colors, respect bossEvent's getColor()?
				int frameU = 0, frameV = 0;
				int frameWidth = 185, frameHeight = 15;
				int healthU = 0, healthV = frameV + frameHeight;
				int healthWidth = 181, healthHeight = 7;
				int healthX = x + (frameWidth - healthWidth) / 2;
				int healthY = y + (frameHeight - healthHeight) / 2;

				RenderSystem.setShaderColor(1F, 1F, 1F, 1F);
				int playerCountHeight = drawPlayerCount(currentBoss.getPlayerCount(), gui, x, y);
				RenderHelper.drawTexturedModalRect(gui, BAR_TEXTURE, x, y, frameU, frameV,
						frameWidth, frameHeight);
				drawHealthBar(gui, currentBoss, healthX, healthY, healthU, healthV,
						(int) (healthWidth * bossEvent.method_5412()), healthHeight, false);

				if (drawName) {
					class_2561 name = bossEvent.method_5414();
					int centerX = mc.method_22683().method_4486() / 2;
					gui.method_27534(mc.field_1772, name, centerX, y - 10, 0xA2018C);
				}

				return OptionalInt.of(frameHeight + playerCountHeight + (drawName ? mc.field_1772.field_2000 : 0));
			}
		}

		return OptionalInt.empty();
	}

	private static int drawPlayerCount(int playerCount, class_332 gui, int x, int y) {
		class_4587 ps = gui.method_51448();
		ps.method_22903();
		int px = x + 160;
		int py = y + 12;

		class_310 mc = class_310.method_1551();
		class_1799 stack = new class_1799(class_1802.field_8575);
		gui.method_51427(stack, px, py);

		gui.method_25303(mc.field_1772, Integer.toString(playerCount), px + 15, py + 4, 0xFFFFFF);
		ps.method_22909();

		return 5;
	}

	private static void drawHealthBar(class_332 gui, GaiaGuardianEntity currentBoss, int x, int y, int u, int v, int w, int h, boolean bg) {
		var shader = CoreShaders.dopplegangerBar();
		if (shader != null) {
			float time = currentBoss.getInvulTime();
			float grainIntensity = time > 20 ? 1F : Math.max(currentBoss.isHardMode() ? 0.5F : 0F, time / 20F);
			shader.method_35785("BotaniaGrainIntensity").method_1251(grainIntensity);
			shader.method_35785("BotaniaHpFract").method_1251(currentBoss.method_6032() / currentBoss.method_6063());
		}

		float minU = u / 256.0F;
		float maxU = (u + w) / 256.0F;
		float minV = v / 256.0F;
		float maxV = (v + h) / 256.0F;

		var matrix = gui.method_51448().method_23760().method_23761();
		RenderSystem.setShader(CoreShaders::dopplegangerBar);
		class_287 builder = class_289.method_1348().method_1349();
		builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
		builder.method_22918(matrix, x, y + h, 0).method_22913(minU, maxV).method_1344();
		builder.method_22918(matrix, x + w, y + h, 0).method_22913(maxU, maxV).method_1344();
		builder.method_22918(matrix, x + w, y, 0).method_22913(maxU, minV).method_1344();
		builder.method_22918(matrix, x, y, 0).method_22913(minU, minV).method_1344();
		class_289.method_1348().method_1350();
	}

}
