package vazkii.botania.common.helper;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.mixin.BundleItemAccessor;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1533;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_5915;
import net.minecraft.class_6007;
import net.minecraft.class_6008;

public class FilterHelper {

	public static final String ITEMS_TAG = "Items";

	public static List<class_1799> getFilterItems(class_1533 filterFrame) {
		class_1799 filterStack = filterFrame.method_6940();
		if (filterStack.method_7960()) {
			return List.of();
		}
		return filterFrame instanceof class_5915 ? getFilterStacks(filterStack) : List.of(filterStack);
	}

	/**
	 * Expands the given filter item into the list of filter items it represents. This is NOT recursive.
	 * Non-empty container items stand for their contents, not for themselves.
	 */
	public static List<class_1799> getFilterStacks(class_1799 filterStack) {
		if (filterStack.method_31574(class_1802.field_27023)) {
			// get bundle content
			List<class_1799> bundledItems = BundleItemAccessor.call_getContents(filterStack).toList();
			if (!bundledItems.isEmpty()) {
				return bundledItems;
			}
		} else {
			// BlockItems (especially shulker boxes) can contain BlockEntity data, which may include an inventory.
			// Otherwise, items may represent an inventory themselves (e.g. Flower Pouch or Bauble Box)
			class_2487 tag = filterStack.method_7909() instanceof class_1747
					? class_1747.method_38072(filterStack)
					: filterStack.method_7969();
			if (tag != null && tag.method_10573(ITEMS_TAG, class_2520.field_33259)) {
				// item might contain an inventory
				List<class_1799> items = getItemStacks(tag);
				if (items != null) {
					return items;
				}
			}
		}
		return List.of(filterStack);
	}

	@Nullable
	private static List<class_1799> getItemStacks(class_2487 tag) {
		try {
			class_2499 contents = tag.method_10554(ITEMS_TAG, class_2487.field_33260);
			List<class_1799> items = new ArrayList<>(contents.size());
			for (int i = 0; i < contents.size(); i++) {
				class_2487 entry = contents.method_10602(i);
				class_1799 stack = class_1799.method_7915(entry);
				if (!stack.method_7960()) {
					items.add(stack);
				}
			}
			if (!items.isEmpty()) {
				return items;
			}
		} catch (ClassCastException ce) {
			// apparently not a typical container inventory
		}
		return null;
	}

	public record WeightedItemStack(class_1799 stack, class_6007 weight) implements class_6008 {
		public static WeightedItemStack of(class_1799 stack, int weight) {
			return new WeightedItemStack(stack, class_6007.method_34977(weight));
		}

		@NotNull
		@Override
		public class_6007 method_34979() {
			return weight;
		}
	}
}
