package vazkii.botania.xplat;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.ServiceUtil;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.network.BotaniaPacket;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1044;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public interface ClientXplatAbstractions {
	class_2960 FLOATING_FLOWER_MODEL_LOADER_ID = prefix("floating_flower");
	class_2960 MANA_GUN_MODEL_LOADER_ID = prefix("mana_gun");

	// Event firing
	void fireRenderTinyPotato(class_2586 potato, class_2561 name, float tickDelta, class_4587 ms, class_4597 buffers, int light, int overlay);

	// Networking
	void sendToServer(BotaniaPacket packet);

	// Capability access
	@Nullable
	WandHUD findWandHud(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_2586 be);

	@Nullable
	WandHUD findWandHud(class_1297 entity);

	// Rendering stuff
	class_1087 wrapPlatformModel(class_1087 original);
	void setFilterSave(class_1044 texture, boolean filter, boolean mipmap);
	void restoreLastFilter(class_1044 texture);
	void tessellateBlock(class_1937 level, class_2680 state, class_2338 pos, class_4587 ps, class_4597 buffers, int overlay);
	/** Marks an animated sprite as "active" for Sodium, if present. */
	void markSpriteActive(class_1058 sprite);

	ClientXplatAbstractions INSTANCE = ServiceUtil.findService(ClientXplatAbstractions.class, null);

	static ClientXplatAbstractions instance() {
		return INSTANCE;
	}
}
