/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonObject;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.crafting.recipe.NbtOutputRecipe;

import java.util.function.Consumer;
import net.minecraft.class_1865;
import net.minecraft.class_2444;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public class NbtOutputResult implements class_2444 {
	private final class_2444 innerRecipe;
	private final class_2487 tag;

	public NbtOutputResult(class_2444 innerRecipe, class_2487 tag) {
		this.innerRecipe = innerRecipe;
		this.tag = tag;
	}

	public static Consumer<class_2444> with(Consumer<class_2444> parent, Consumer<class_2487> tagSetup) {
		class_2487 tag = new class_2487();
		tagSetup.accept(tag);
		return recipe -> parent.accept(new NbtOutputResult(recipe, tag));
	}

	@Override
	public void method_10416(JsonObject json) {
		json.add("recipe", innerRecipe.method_17799());
		json.addProperty("nbt", tag.toString());
	}

	@Override
	public class_2960 method_10417() {
		return innerRecipe.method_10417();
	}

	@Override
	public class_1865<?> method_17800() {
		return NbtOutputRecipe.SERIALIZER;
	}

	@Nullable
	@Override
	public JsonObject method_10415() {
		return innerRecipe.method_10415();
	}

	@Nullable
	@Override
	public class_2960 method_10418() {
		return innerRecipe.method_10418();
	}
}
