/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.rod;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;

public class HighlandsRodItem extends LandsRodItem {

	public HighlandsRodItem(class_1793 props) {
		super(props);
	}

	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (ManaItemHandler.instance().requestManaExactForTool(stack, player, COST * 2, false)) {
			class_243 playerVec = VecHelper.fromEntityCenter(player);
			class_243 lookVec = player.method_5720().method_1021(3);
			class_243 placeVec = playerVec.method_1019(lookVec);

			int x = class_3532.method_15357(placeVec.field_1352);
			int y = class_3532.method_15357(placeVec.field_1351) + 1;
			int z = class_3532.method_15357(placeVec.field_1350);

			int entities = world.method_18467(class_1309.class, new class_238(x, y, z, x + 1, y + 1, z + 1)).size();

			if (entities == 0) {
				class_3965 hit = new class_3965(class_243.field_1353, class_2350.field_11033, new class_2338(x, y, z), false);
				class_1269 result = PlayerHelper.substituteUse(new class_1838(player, hand, hit), new class_1799(class_2246.field_10566));

				if (result.method_23665()) {
					if (!world.field_9236) {
						ManaItemHandler.instance().requestManaExactForTool(stack, player, COST * 2, true);
					}
					SparkleParticleData data = SparkleParticleData.sparkle(1F, 0.35F, 0.2F, 0.05F, 5);
					for (int i = 0; i < 6; i++) {
						world.method_8406(data, x + Math.random(), y + Math.random(), z + Math.random(), 0, 0, 0);
					}
				}
			}
		}

		return class_1271.method_29237(stack, world.field_9236);
	}

}
