/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool.manasteel;

import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.SortableTool;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.gui.ItemsRemainingRenderHandler;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2680;

public class ManasteelAxeItem extends class_1743 implements CustomDamageItem, SortableTool {

	private static final Pattern SAPLING_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)sapling)|(?:(?:[a-z-_.:]|^)Sapling))(?:[A-Z-_.:]|$)");

	private static final int MANA_PER_DAMAGE = 60;

	public ManasteelAxeItem(class_1793 props) {
		this(BotaniaAPI.instance().getManasteelItemTier(), 6F, -3.1F, props);
	}

	public ManasteelAxeItem(class_1832 mat, float attackDamage, float attackSpeed, class_1793 props) {
		super(mat, attackDamage, attackSpeed, props);
	}

	@Override
	public <T extends class_1309> int damageItem(class_1799 stack, int amount, T entity, Consumer<T> onBroken) {
		int manaPerDamage = ((ManasteelAxeItem) stack.method_7909()).getManaPerDamage();
		return ToolCommons.damageItemIfPossible(stack, amount, entity, manaPerDamage);
	}

	public int getManaPerDamage() {
		return MANA_PER_DAMAGE;
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1657 player = ctx.method_8036();
		if (player != null) {
			if (ctx.method_20287() == class_1268.field_5808 && player.method_6079().method_7909() instanceof class_1747) {
				return class_1269.field_5811;
			}

			for (int i = 0; i < player.method_31548().method_5439(); i++) {
				class_1799 stackAt = player.method_31548().method_5438(i);
				if (!stackAt.method_7960() && SAPLING_PATTERN.matcher(stackAt.method_7909().method_7876()).find()) {
					class_1799 displayStack = stackAt.method_7972();
					var result = PlayerHelper.substituteUse(ctx, stackAt);
					if (result.method_23665()) {
						if (!ctx.method_8045().field_9236) {
							ItemsRemainingRenderHandler.send(player, displayStack, SAPLING_PATTERN);
						}
						return result;
					}
				}
			}
		}

		return super.method_7884(ctx);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		if (!world.field_9236 && entity instanceof class_1657 player && stack.method_7919() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, getManaPerDamage() * 2, true)) {
			stack.method_7974(stack.method_7919() - 1);
		}
	}

	@Override
	public int getSortingPriority(class_1799 stack, class_2680 state) {
		return ToolCommons.getToolPriority(stack);
	}
}
