/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5632;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.mana.ManaBarTooltip;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.Optional;

public class ManaMirrorItem extends class_1792 {

	private static final String TAG_MANA = "mana";
	private static final String TAG_MAX_MANA = "maxMana";
	private static final String TAG_MANA_BACKLOG = "manaBacklog";
	private static final String TAG_POS = "pos";

	private static final DummyPool fallbackPool = new DummyPool();

	public ManaMirrorItem(class_1793 props) {
		super(props);
	}

	@Override
	public boolean method_31567(class_1799 stack) {
		return true;
	}

	@Override
	public int method_31569(class_1799 stack) {
		var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
		return Math.round(13 * ManaBarTooltip.getFractionForDisplay(manaItem));
	}

	@Override
	public int method_31571(class_1799 stack) {
		var manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
		return class_3532.method_15369(ManaBarTooltip.getFractionForDisplay(manaItem) / 3.0F, 1.0F, 1.0F);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		if (world.field_9236) {
			return;
		}

		ManaPool pool = getManaPool(world.method_8503(), stack);
		if (!(pool instanceof DummyPool)) {
			if (pool == null) {
				setMana(stack, 0);
			} else {
				pool.receiveMana(getManaBacklog(stack));
				setManaBacklog(stack, 0);
				setMana(stack, pool.getCurrentMana());
				setMaxMana(stack, pool.getMaxMana());
			}
		}
	}

	@NotNull
	@Override
	public class_1269 method_7884(class_1838 ctx) {
		class_1937 world = ctx.method_8045();
		class_1657 player = ctx.method_8036();

		if (player != null && player.method_21823()) {
			var receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, ctx.method_8037(), null);
			if (receiver instanceof ManaPool pool) {
				if (!world.field_9236) {
					bindPool(ctx.method_8041(), pool);
					world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.ding, class_3419.field_15248, 1F, 1F);
				}
				return class_1269.method_29236(world.method_8608());
			}
		}

		return class_1269.field_5811;
	}

	protected static void setMana(class_1799 stack, int mana) {
		if (mana > 0) {
			ItemNBTHelper.setInt(stack, TAG_MANA, mana);
		} else {
			ItemNBTHelper.removeEntry(stack, TAG_MANA);
		}
	}

	protected static void setMaxMana(class_1799 stack, int maxMana) {
		ItemNBTHelper.setInt(stack, TAG_MAX_MANA, maxMana);
	}

	protected static int getManaBacklog(class_1799 stack) {
		return ItemNBTHelper.getInt(stack, TAG_MANA_BACKLOG, 0);
	}

	protected static void setManaBacklog(class_1799 stack, int backlog) {
		ItemNBTHelper.setInt(stack, TAG_MANA_BACKLOG, backlog);
	}

	public void bindPool(class_1799 stack, ManaPool pool) {
		class_4208 pos = class_4208.method_19443(pool.getManaReceiverLevel().method_27983(), pool.getManaReceiverPos());
		class_2520 ser = class_4208.field_25066.encodeStart(class_2509.field_11560, pos).get().orThrow();
		ItemNBTHelper.set(stack, TAG_POS, ser);
	}

	@Nullable
	private static class_4208 getBoundPos(class_1799 stack) {
		if (!stack.method_7948().method_10545(TAG_POS)) {
			return null;
		}

		return class_4208.field_25066.parse(class_2509.field_11560, ItemNBTHelper.get(stack, TAG_POS))
				.result()
				.filter(pos -> pos.method_19446().method_10264() != Integer.MIN_VALUE)
				.orElse(null);
	}

	@Nullable
	private ManaPool getManaPool(@Nullable MinecraftServer server, class_1799 stack) {
		if (server == null) {
			return fallbackPool;
		}

		class_4208 pos = getBoundPos(stack);
		if (pos == null) {
			return fallbackPool;
		}

		class_5321<class_1937> type = pos.method_19442();
		class_1937 world = server.method_3847(type);
		if (world != null) {
			var receiver = XplatAbstractions.INSTANCE.findManaReceiver(world, pos.method_19446(), null);
			if (receiver instanceof ManaPool pool) {
				return pool;
			}
		}

		return null;
	}

	public static class ManaItemImpl implements ManaItem {
		private final class_1799 stack;

		public ManaItemImpl(class_1799 stack) {
			this.stack = stack;
		}

		@Override
		public int getMana() {
			return ItemNBTHelper.getInt(stack, TAG_MANA, 0);
		}

		@Override
		public int getMaxMana() {
			return ItemNBTHelper.getInt(stack, TAG_MAX_MANA, ManaPoolBlockEntity.MAX_MANA);
		}

		@Override
		public void addMana(int mana) {
			setMana(stack, getMana() + mana);
			setManaBacklog(stack, getManaBacklog(stack) + mana);
		}

		@Override
		public boolean canReceiveManaFromPool(class_2586 pool) {
			return false;
		}

		@Override
		public boolean canReceiveManaFromItem(class_1799 otherStack) {
			return false;
		}

		@Override
		public boolean canExportManaToPool(class_2586 pool) {
			return false;
		}

		@Override
		public boolean canExportManaToItem(class_1799 otherStack) {
			return true;
		}

		@Override
		public boolean isNoExport() {
			return false;
		}
	}

	private static class DummyPool implements ManaPool {

		@Override
		public boolean isFull() {
			return false;
		}

		@Override
		public void receiveMana(int mana) {}

		@Override
		public boolean canReceiveManaFromBursts() {
			return false;
		}

		@Override
		public class_1937 getManaReceiverLevel() {
			return null;
		}

		@Override
		public class_2338 getManaReceiverPos() {
			return ManaBurst.NO_SOURCE;
		}

		@Override
		public int getCurrentMana() {
			return 0;
		}

		@Override
		public int getMaxMana() {
			return 0;
		}

		@Override
		public boolean isOutputtingPower() {
			return false;
		}

		@Override
		public Optional<class_1767> getColor() {
			return Optional.empty();
		}

		@Override
		public void setColor(Optional<class_1767> color) {}

	}

	public static class CoordBoundItemImpl implements CoordBoundItem {
		private final class_1799 stack;

		public CoordBoundItemImpl(class_1799 stack) {
			this.stack = stack;
		}

		@Nullable
		@Override
		public class_2338 getBinding(class_1937 world) {
			class_4208 pos = getBoundPos(stack);
			if (pos == null) {
				return null;
			}

			if (pos.method_19442() == world.method_27983()) {
				return pos.method_19446();
			}

			return null;
		}
	}

	@Override
	public Optional<class_5632> method_32346(class_1799 stack) {
		return Optional.of(ManaBarTooltip.fromManaItem(stack));
	}

}
