/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.helper;

import com.mojang.datafixers.util.Pair;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_2985;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public final class PlayerHelper {

	private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*]|ComputerCraft)$");
	private static Class<? extends class_1657> fakePlayerClass;

	public static void setFakePlayerClass(Class<? extends class_1657> fakePlayerClass) {
		PlayerHelper.fakePlayerClass = fakePlayerClass;
	}

	public static boolean isTruePlayer(@Nullable class_1297 e) {
		if (!(e instanceof class_1657 player)) {
			return false;
		}

		String name = player.method_5477().getString();
		return (fakePlayerClass == null || !fakePlayerClass.isInstance(player)) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
	}

	public static List<class_1657> getRealPlayersIn(class_1937 level, class_238 aabb) {
		return level.method_8390(class_1657.class, aabb, player -> isTruePlayer(player) && !player.method_7325());
	}

	// Checks if either of the player's hands has an item.
	public static boolean hasAnyHeldItem(class_1657 player) {
		return !player.method_6047().method_7960() || !player.method_6079().method_7960();
	}

	// Checks main hand, then off hand for this item.
	public static boolean hasHeldItem(class_1657 player, class_1792 item) {
		return !player.method_6047().method_7960() && player.method_6047().method_31574(item)
				|| !player.method_6079().method_7960() && player.method_6079().method_31574(item);
	}

	// Checks main hand, then off hand for this item class.
	public static boolean hasHeldItemClass(class_1657 player, Class<?> template) {
		return !player.method_6047().method_7960() && template.isAssignableFrom(player.method_6047().method_7909().getClass())
				|| !player.method_6079().method_7960() && template.isAssignableFrom(player.method_6079().method_7909().getClass());
	}

	public static class_1799 getFirstHeldItem(class_1309 living, class_1792 item) {
		return getFirstHeldItem(living, s -> s.method_31574(item));
	}

	public static class_1799 getFirstHeldItem(class_1309 living, Predicate<class_1799> pred) {
		class_1799 main = living.method_6047();
		class_1799 offhand = living.method_6079();
		if (!main.method_7960() && pred.test(main)) {
			return main;
		} else if (!offhand.method_7960() && pred.test(offhand)) {
			return offhand;
		} else {
			return class_1799.field_8037;
		}
	}

	public static class_1799 getFirstHeldItemClass(class_1309 living, Class<?> template) {
		return getFirstHeldItem(living, s -> template.isAssignableFrom(s.method_7909().getClass()));
	}

	public static class_1799 getAmmo(class_1657 player, Predicate<class_1799> ammoFunc) {
		// Mainly from ItemBow.findAmmo
		if (ammoFunc.test(player.method_5998(class_1268.field_5810))) {
			return player.method_5998(class_1268.field_5810);
		} else if (ammoFunc.test(player.method_5998(class_1268.field_5808))) {
			return player.method_5998(class_1268.field_5808);
		} else {
			for (int i = 0; i < player.method_31548().method_5439(); ++i) {
				class_1799 itemstack = player.method_31548().method_5438(i);

				if (ammoFunc.test(itemstack)) {
					return itemstack;
				}
			}

			return class_1799.field_8037;
		}
	}

	public static boolean hasAmmo(class_1657 player, Predicate<class_1799> ammoFunc) {
		return !getAmmo(player, ammoFunc).method_7960();
	}

	public static void consumeAmmo(class_1657 player, Predicate<class_1799> ammoFunc) {
		class_1799 ammo = getAmmo(player, ammoFunc);
		if (!ammo.method_7960()) {
			ammo.method_7934(1);
		}
	}

	public static class_1799 getItemFromInventory(class_1657 player, Predicate<class_1799> itemPred) {
		for (int i = 0; i < player.method_31548().method_5439(); i++) {
			class_1799 item = player.method_31548().method_5438(i);
			if (itemPred.test(item)) {
				return item;
			}
		}
		return class_1799.field_8037;
	}

	public static class_1799 getItemClassFromInventory(class_1657 player, Class<?> template) {
		return getItemFromInventory(player, s -> template.isAssignableFrom(s.method_7909().getClass()));
	}

	public static boolean hasAdvancement(class_3222 player, class_2960 advancementId) {
		class_2985 advancements = player.method_14236();
		class_2989 manager = player.method_37908().method_8503().method_3851();
		class_161 advancement = manager.method_12896(advancementId);
		return advancement != null && advancements.method_12882(advancement).method_740();
	}

	public static void grantCriterion(class_3222 player, class_2960 advancementId, String criterion) {
		class_2985 advancements = player.method_14236();
		class_2989 manager = player.method_37908().method_8503().method_3851();
		class_161 advancement = manager.method_12896(advancementId);
		if (advancement != null && !advancements.method_12882(advancement).method_740()) {
			advancements.method_12878(advancement, criterion);
		}
	}

	public static class_1269 substituteUse(class_1838 ctx, class_1799 toUse) {
		return substituteUseTrackPos(ctx, toUse).getFirst();
	}

	/**
	 * Temporarily swap <code>toUse</code> into the hand of the player, use it, then swap it back out.
	 * This is to ensure that any code in mods' onItemUse that relies on player.getHeldItem(ctx.hand) == ctx.stack
	 * will work as intended.
	 * Properly handles null players, as long as the Item's onItemUse also handles them.
	 * 
	 * @return The usage result, as well as a properly offset block position pointing at where the block was placed
	 *         (if the item was a BlockItem)
	 */
	public static Pair<class_1269, class_2338> substituteUseTrackPos(class_1838 ctx, class_1799 toUse) {
		class_1799 save = class_1799.field_8037;
		class_3965 hit = new class_3965(ctx.method_17698(), ctx.method_8038(), ctx.method_8037(), ctx.method_17699());
		class_1838 newCtx;

		if (ctx.method_8036() != null) {
			save = ctx.method_8036().method_5998(ctx.method_20287());
			ctx.method_8036().method_6122(ctx.method_20287(), toUse);
			// Need to construct a new one still to refresh the itemstack
			newCtx = new class_1838(ctx.method_8036(), ctx.method_20287(), hit);
		} else {
			newCtx = new ItemUseContextWithNullPlayer(ctx.method_8045(), ctx.method_20287(), toUse, hit);
		}

		class_2338 finalPos = new class_1750(newCtx).method_8037();

		class_1269 result = toUse.method_7981(newCtx);

		if (ctx.method_8036() != null) {
			ctx.method_8036().method_6122(ctx.method_20287(), save);
		}

		return Pair.of(result, finalPos);
	}

	// To expose protected ctor
	private static class ItemUseContextWithNullPlayer extends class_1838 {
		public ItemUseContextWithNullPlayer(class_1937 world, class_1268 hand, class_1799 stack, class_3965 rayTraceResult) {
			super(world, null, hand, stack, rayTraceResult);
		}
	}

	private PlayerHelper() {}
}
