/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import vazkii.botania.api.recipe.*;
import vazkii.botania.common.crafting.recipe.HeadRecipe;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.crafting.recipe.StateCopyingPureDaisyRecipe;
import vazkii.botania.mixin.RecipeManagerAccessor;

import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_1263;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_7923;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class BotaniaRecipeTypes {
	public static final class_3956<vazkii.botania.api.recipe.ManaInfusionRecipe> MANA_INFUSION_TYPE = new ModRecipeType<>();
	public static final class_1865<ManaInfusionRecipe> MANA_INFUSION_SERIALIZER = new ManaInfusionRecipe.Serializer();

	public static final class_3956<vazkii.botania.api.recipe.ElvenTradeRecipe> ELVEN_TRADE_TYPE = new ModRecipeType<>();
	public static final class_1865<ElvenTradeRecipe> ELVEN_TRADE_SERIALIZER = new ElvenTradeRecipe.Serializer();
	public static final class_1865<LexiconElvenTradeRecipe> LEXICON_ELVEN_TRADE_SERIALIZER = new NoOpRecipeSerializer<>(LexiconElvenTradeRecipe::new);

	public static final class_3956<vazkii.botania.api.recipe.PureDaisyRecipe> PURE_DAISY_TYPE = new ModRecipeType<>();
	public static final class_1865<PureDaisyRecipe> PURE_DAISY_SERIALIZER = new PureDaisyRecipe.Serializer();
	public static final class_1865<StateCopyingPureDaisyRecipe> COPYING_PURE_DAISY_SERIALIZER = new StateCopyingPureDaisyRecipe.Serializer();

	public static final class_3956<vazkii.botania.api.recipe.BotanicalBreweryRecipe> BREW_TYPE = new ModRecipeType<>();
	public static final class_1865<BotanicalBreweryRecipe> BREW_SERIALIZER = new BotanicalBreweryRecipe.Serializer();

	public static final class_3956<PetalApothecaryRecipe> PETAL_TYPE = new ModRecipeType<>();
	public static final class_1865<PetalsRecipe> PETAL_SERIALIZER = new PetalsRecipe.Serializer();

	public static final class_3956<vazkii.botania.api.recipe.RunicAltarRecipe> RUNE_TYPE = new ModRecipeType<>();
	public static final class_1865<RunicAltarRecipe> RUNE_SERIALIZER = new RunicAltarRecipe.Serializer();
	public static final class_1865<HeadRecipe> RUNE_HEAD_SERIALIZER = new HeadRecipe.Serializer();

	public static final class_3956<TerrestrialAgglomerationRecipe> TERRA_PLATE_TYPE = new ModRecipeType<>();
	public static final class_1865<RecipeTerraPlate> TERRA_PLATE_SERIALIZER = new RecipeTerraPlate.Serializer();

	public static final class_3956<OrechidRecipe> ORECHID_TYPE = new ModRecipeType<>();
	public static final class_1865<OrechidRecipe> ORECHID_SERIALIZER = new OrechidRecipe.Serializer();

	public static final class_3956<OrechidIgnemRecipe> ORECHID_IGNEM_TYPE = new ModRecipeType<>();
	public static final class_1865<OrechidIgnemRecipe> ORECHID_IGNEM_SERIALIZER = new OrechidIgnemRecipe.Serializer();

	public static final class_3956<MarimorphosisRecipe> MARIMORPHOSIS_TYPE = new ModRecipeType<>();
	public static final class_1865<MarimorphosisRecipe> MARIMORPHOSIS_SERIALIZER = new MarimorphosisRecipe.Serializer();

	public static void submitRecipeTypes(BiConsumer<class_3956<?>, class_2960> r) {
		r.accept(ELVEN_TRADE_TYPE, vazkii.botania.api.recipe.ElvenTradeRecipe.TYPE_ID);
		r.accept(MANA_INFUSION_TYPE, vazkii.botania.api.recipe.ManaInfusionRecipe.TYPE_ID);
		r.accept(PURE_DAISY_TYPE, vazkii.botania.api.recipe.PureDaisyRecipe.TYPE_ID);
		r.accept(BREW_TYPE, vazkii.botania.api.recipe.BotanicalBreweryRecipe.TYPE_ID);
		r.accept(PETAL_TYPE, PetalApothecaryRecipe.TYPE_ID);
		r.accept(RUNE_TYPE, vazkii.botania.api.recipe.RunicAltarRecipe.TYPE_ID);
		r.accept(TERRA_PLATE_TYPE, TerrestrialAgglomerationRecipe.TYPE_ID);
		r.accept(ORECHID_TYPE, vazkii.botania.api.recipe.OrechidRecipe.TYPE_ID);
		r.accept(ORECHID_IGNEM_TYPE, vazkii.botania.api.recipe.OrechidRecipe.IGNEM_TYPE_ID);
		r.accept(MARIMORPHOSIS_TYPE, vazkii.botania.api.recipe.OrechidRecipe.MARIMORPHOSIS_TYPE_ID);
	}

	public static void submitRecipeSerializers(BiConsumer<class_1865<?>, class_2960> r) {
		r.accept(ELVEN_TRADE_SERIALIZER, vazkii.botania.api.recipe.ElvenTradeRecipe.TYPE_ID);
		r.accept(LEXICON_ELVEN_TRADE_SERIALIZER, prefix("elven_trade_lexicon"));
		r.accept(MANA_INFUSION_SERIALIZER, vazkii.botania.api.recipe.ManaInfusionRecipe.TYPE_ID);
		r.accept(PURE_DAISY_SERIALIZER, vazkii.botania.api.recipe.PureDaisyRecipe.TYPE_ID);
		r.accept(COPYING_PURE_DAISY_SERIALIZER, prefix("state_copying_pure_daisy"));
		r.accept(BREW_SERIALIZER, vazkii.botania.api.recipe.BotanicalBreweryRecipe.TYPE_ID);
		r.accept(PETAL_SERIALIZER, PetalApothecaryRecipe.TYPE_ID);
		r.accept(RUNE_SERIALIZER, vazkii.botania.api.recipe.RunicAltarRecipe.TYPE_ID);
		r.accept(RUNE_HEAD_SERIALIZER, prefix("runic_altar_head"));
		r.accept(TERRA_PLATE_SERIALIZER, TerrestrialAgglomerationRecipe.TYPE_ID);
		r.accept(ORECHID_SERIALIZER, vazkii.botania.api.recipe.OrechidRecipe.TYPE_ID);
		r.accept(ORECHID_IGNEM_SERIALIZER, vazkii.botania.api.recipe.OrechidRecipe.IGNEM_TYPE_ID);
		r.accept(MARIMORPHOSIS_SERIALIZER, vazkii.botania.api.recipe.OrechidRecipe.MARIMORPHOSIS_TYPE_ID);
	}

	private static class ModRecipeType<T extends class_1860<?>> implements class_3956<T> {
		@Override
		public String toString() {
			return class_7923.field_41188.method_10221(this).toString();
		}
	}

	public static <C extends class_1263, T extends class_1860<C>> Map<class_2960, T> getRecipes(class_1937 world, class_3956<T> type) {
		return ((RecipeManagerAccessor) world.method_8433()).botania_getAll(type);
	}
}
