/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import vazkii.botania.api.block.Bound;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class SpectranthemumBlockEntity extends FunctionalFlowerBlockEntity {
	private static final String TAG_BIND_X = "bindX";
	private static final String TAG_BIND_Y = "bindY";
	private static final String TAG_BIND_Z = "bindZ";

	private static final int BASE_COST = 2;
	private static final int RANGE = 2;

	private class_2338 bindPos = Bound.UNBOUND_POS;

	public SpectranthemumBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.SPECTRANTHEMUM, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236 && redstoneSignal == 0 && method_10997().method_22340(bindPos)) {
			class_2338 pos = getEffectivePos();

			boolean did = false;

			List<class_1542> items = method_10997().method_18467(class_1542.class, new class_238(pos.method_10069(-RANGE, -RANGE, -RANGE), pos.method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));

			for (class_1542 item : items) {
				if (!DelayHelper.canInteractWith(this, item)) {
					continue;
				}

				class_1799 stack = item.method_6983();
				if (XplatAbstractions.INSTANCE.findManaItem(stack) != null) {
					continue;
				}

				// TODO: maybe teleport fewer items if the cost is too much?
				double cost = BASE_COST * stack.method_7947() * Math.sqrt(bindPos.method_19770(item.method_19538()));
				if (getMana() >= cost) {
					spawnExplosionParticles(item, 10);
					item.method_5814(bindPos.method_10263() + 0.5, bindPos.method_10264() + 1.5, bindPos.method_10260() + 0.5);
					item.method_18799(class_243.field_1353);
					spawnExplosionParticles(item, 10);
					addMana(-(int) cost);
					did = true;
				}
			}

			if (did) {
				sync();
			}
		}
	}

	static void spawnExplosionParticles(class_1297 item, int p) {
		XplatAbstractions.INSTANCE.sendToTracking(item, new BotaniaEffectPacket(EffectType.ITEM_SMOKE, item.method_23317(), item.method_23318(), item.method_23321(), item.method_5628(), p));
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_BIND_X, bindPos.method_10263());
		cmp.method_10569(TAG_BIND_Y, bindPos.method_10264());
		cmp.method_10569(TAG_BIND_Z, bindPos.method_10260());
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		bindPos = new class_2338(
				cmp.method_10550(TAG_BIND_X),
				cmp.method_10550(TAG_BIND_Y),
				cmp.method_10550(TAG_BIND_Z)
		);
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public int getColor() {
		return 0x98BCFF;
	}

	@Override
	public int getMaxMana() {
		return 5000;
	}

	@Override
	public boolean bindTo(class_1657 player, class_1799 wand, class_2338 pos, class_2350 side) {
		boolean bound = super.bindTo(player, wand, pos, side);

		if (!bound && !pos.equals(bindPos) && !pos.equals(getEffectivePos())) {
			bindPos = pos;
			sync();

			return true;
		}

		return bound;
	}

	@Override
	public class_2338 getBinding() {
		return Proxy.INSTANCE.getClientPlayer().method_5715() && bindPos.method_10264() != Integer.MIN_VALUE ? bindPos : super.getBinding();
	}

}
