/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;

public class FallenKanadeBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int RANGE = 2;
	private static final int COST = 120;

	public FallenKanadeBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.FALLEN_KANADE, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!method_10997().field_9236) {
			boolean did = false;
			List<class_1309> entities = method_10997().method_8390(class_1309.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)), FallenKanadeBlockEntity::canHeal);
			for (class_1309 toHeal : entities) {
				if (toHeal.method_6112(class_1294.field_5924) == null && getMana() >= COST) {
					toHeal.method_6092(new class_1293(class_1294.field_5924, 59, 2, true, true));
					addMana(-COST);
					did = true;
				}
			}
			if (did) {
				sync();
			}
		}
	}

	private static boolean canHeal(class_1309 e) {
		// Don't try to heal anything dead
		if (!e.method_5805()) {
			return false;
		}
		// heal pets and non-spectating players
		return e instanceof class_1657 player && !player.method_7325() || e instanceof class_1321 animal && animal.method_6181() || e instanceof class_1496 horse && horse.method_6727();
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public int getColor() {
		return 0xFFFF00;
	}

	@Override
	public int getMaxMana() {
		return 900;
	}

}
