/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.item;

import org.jetbrains.annotations.Nullable;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;

/**
 * An item that implements this will allow for various wireframes to be drawn
 * around the player. This will be called while the item is in the inventory,
 * armor slot or bauble slots.
 */
public interface WireframeCoordinateListProvider {

	/**
	 * Returns a list of BlockPos for the wireframes to draw.
	 * Will not be null.
	 */
	List<class_2338> getWireframesToDraw(class_1657 player, class_1799 stack);

	/**
	 * Gets a wireframe to draw thicker than the rest.
	 * This is useful to indicate the precedence of some position over the others.
	 * 
	 * @return The position of a single wireframe to draw thicker than all the others.
	 */
	@Nullable
	default class_2338 getSourceWireframe(class_1657 player, class_1799 stack) {
		return null;
	}

}
