/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.client.lib.ResourcesLib;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2248;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class FloatingFlowerModelProvider implements class_2405 {
	private final class_7784 packOutput;

	public FloatingFlowerModelProvider(class_7784 packOutput) {
		this.packOutput = packOutput;
	}

	@Override
	public CompletableFuture<?> method_10319(class_7403 cache) {
		List<class_3545<String, JsonElement>> jsons = new ArrayList<>();
		for (class_2248 b : class_7923.field_41175) {
			class_2960 id = class_7923.field_41175.method_10221(b);
			if (LibMisc.MOD_ID.equals(id.method_12836()) && b instanceof FloatingFlowerBlock) {
				String name = id.method_12832();
				String nonFloat;
				if (name.endsWith("_floating_flower")) {
					nonFloat = name.replace("_floating_flower", "_mystical_flower");
				} else {
					nonFloat = name.replace("floating_", "");
				}

				JsonObject obj = new JsonObject();
				obj.addProperty("parent", "minecraft:block/block");
				obj.addProperty("loader", ClientXplatAbstractions.FLOATING_FLOWER_MODEL_LOADER_ID.toString());
				JsonObject flower = new JsonObject();
				flower.addProperty("parent", ResourcesLib.PREFIX_MOD + "block/" + nonFloat);
				obj.add("flower", flower);
				jsons.add(new class_3545<>(name, obj));
			}
		}
		List<CompletableFuture<?>> output = new ArrayList<>();
		class_7784.class_7489 blocks = packOutput.method_45973(class_7784.class_7490.field_39368, "models/block");
		class_7784.class_7489 items = packOutput.method_45973(class_7784.class_7490.field_39368, "models/item");
		for (class_3545<String, JsonElement> pair : jsons) {
			output.add(class_2405.method_10320(cache, pair.method_15441(), blocks.method_44107(prefix(pair.method_15442()))));
			output.add(class_2405.method_10320(cache, pair.method_15441(), items.method_44107(prefix(pair.method_15442()))));
		}

		return CompletableFuture.allOf(output.toArray(CompletableFuture[]::new));
	}

	@NotNull
	@Override
	public String method_10321() {
		return "Botania floating flower models";
	}
}
