/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.world;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3215;
import net.minecraft.class_3233;
import net.minecraft.class_3754;
import net.minecraft.class_4543;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5868;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import net.minecraft.core.*;
import net.minecraft.world.level.*;
import net.minecraft.world.level.biome.*;
import net.minecraft.world.level.chunk.*;
import net.minecraft.world.level.levelgen.*;
import org.jetbrains.annotations.NotNull;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class SkyblockChunkGenerator extends class_3754 {
	// [VanillaCopy] NoiseBasedChunkGenerator's codec, but calls our constructor
	public static final Codec<SkyblockChunkGenerator> field_24773 = RecordCodecBuilder.create(
			(instance) -> instance.group(
					class_1966.field_24713.fieldOf("biome_source").forGetter((gen) -> gen.field_12761),
					class_5284.field_24781.fieldOf("settings").forGetter(class_3754::method_41541))
					.apply(instance, instance.stable(SkyblockChunkGenerator::new)));

	public static void submitRegistration(BiConsumer<Codec<? extends class_2794>, class_2960> consumer) {
		consumer.accept(SkyblockChunkGenerator.field_24773, prefix("skyblock"));
	}

	public static boolean isWorldSkyblock(class_1937 world) {
		return world.method_8398() instanceof class_3215 chunkCache && chunkCache.method_12129() instanceof SkyblockChunkGenerator;
	}

	private SkyblockChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings) {
		super(biomeSource, settings);
	}

	@NotNull
	@Override
	protected Codec<? extends class_2794> method_28506() {
		return field_24773;
	}

	@Override
	public void method_41538(@NotNull class_2791 chunkAccess, @NotNull class_5868 context,
			@NotNull class_7138 randomState, @NotNull class_5138 structureManager,
			@NotNull class_4543 biomeManager, @NotNull class_2378<class_1959> biomes, @NotNull class_6748 blender) {}

	@Override
	public void method_12108(@NotNull class_3233 worldGenRegion, long seed, @NotNull class_7138 randomState,
			@NotNull class_4543 biomeManager, @NotNull class_5138 structureManager,
			@NotNull class_2791 chunkAccess, class_2893.@NotNull class_2894 carving) {}

	@Override
	public @NotNull CompletableFuture<class_2791> method_12088(@NotNull Executor executor, @NotNull class_6748 blender,
			@NotNull class_7138 randomState, @NotNull class_5138 structureManager, @NotNull class_2791 chunk) {
		return CompletableFuture.completedFuture(chunk);
	}

	@Override
	public void method_12107(@NotNull class_3233 region) {}

	@Override
	public void method_12102(@NotNull class_5281 level, @NotNull class_2791 chunkAccess,
			@NotNull class_5138 structureManager) {}

	/**
	 * Calculates the height at a particular location as it would be in a world with the same seed that isn't empty.
	 * (Based on code from CarpetSkyAdditions.)
	 */
	public int getBaseHeightInEquivalentNoiseWorld(int x, int z, class_2902.class_2903 heightmap, class_5281 level) {
		class_7138 randomState = class_7138.method_41556(
				method_41541().comp_349(),
				level.method_30349().method_30530(class_7924.field_41244).method_46771(),
				level.method_8412());
		return super.method_16397(x, z, heightmap, level, randomState);
	}
}
