/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;

import java.util.List;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class LabelliaBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int PICKUP_RANGE = 0;
	private static final int RENAME_RANGE = 2;
	private static final int COST = 500;

	public LabelliaBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.LABELLIA, pos, state);
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public int getColor() {
		return 0xFFEE83;
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (!field_11863.field_9236 && redstoneSignal == 0 && getMana() >= COST) {
			class_2338 effPos = getEffectivePos();
			class_2338 realPos = method_11016();
			int x = effPos.method_10263();
			int y = effPos.method_10264();
			int z = effPos.method_10260();

			for (class_1542 nameTagEnt : field_11863.method_8390(class_1542.class,
					new class_238(realPos.method_10069(-PICKUP_RANGE, 0, -PICKUP_RANGE),
							realPos.method_10069(PICKUP_RANGE + 1, 1, PICKUP_RANGE + 1)),
					class_1301.field_6154)) {
				if (!DelayHelper.canInteractWith(this, nameTagEnt)) {
					continue;
				}

				class_1799 nameTag = nameTagEnt.method_6983();
				if (nameTag.method_31574(class_1802.field_8448) && nameTag.method_7938()) {
					class_238 renameArea = new class_238(x - RENAME_RANGE, y, z - RENAME_RANGE, x + RENAME_RANGE + 1, y + 1, z + RENAME_RANGE + 1);
					class_2561 name = nameTag.method_7964();
					List<class_1309> nameableEntities = field_11863.method_8390(class_1309.class, renameArea,
							class_1301.field_6154.and(e -> !name.equals(e.method_5797()) && !(e instanceof class_1657)));

					List<class_1542> nameableItems = field_11863.method_8390(class_1542.class, renameArea,
							i -> DelayHelper.canInteractWith(this, i)
									&& i != nameTagEnt
									&& !name.equals(i.method_6983().method_7964()));

					if (!nameableItems.isEmpty() || !nameableEntities.isEmpty()) {
						for (class_1309 e : nameableEntities) {
							// [VanillaCopy] from NameTagItem
							e.method_5665(name);
							if (e instanceof class_1308 mob) {
								mob.method_5971();
							}
						}
						for (class_1542 i : nameableItems) {
							i.method_6983().method_7977(name);
							EntityHelper.syncItem(i);
							((class_3218) field_11863).method_14199(class_2398.field_11213,
									i.method_23317(), i.method_23318(), i.method_23321(),
									3, 0, 0, 0, 0);

						}
						addMana(-COST);
						EntityHelper.shrinkItem(nameTagEnt);
						field_11863.method_43128(null, x + 0.5, y + 0.5, z + 0.5, BotaniaSounds.labellia, class_3419.field_15245, 1F, 1F);
						break;
					}
				}
			}
		}
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RENAME_RANGE);
	}

	@Override
	public RadiusDescriptor getSecondaryRadius() {
		return RadiusDescriptor.Rectangle.square(method_11016(), PICKUP_RANGE);
	}

	@Override
	public int getMaxMana() {
		return 6000;
	}
}
