/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1264;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.block_entity.CacophoniumBlockEntity;

public class CacophoniumBlock extends BotaniaBlock implements class_2343 {
	protected CacophoniumBlock(class_2251 builder) {
		super(builder);
		method_9590(method_9564().method_11657(class_2741.field_12484, false));
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(class_2741.field_12484);
	}

	@Override
	public void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, class_2338 fromPos, boolean isMoving) {
		boolean power = world.method_49804(pos) > 0;
		boolean powered = state.method_11654(class_2741.field_12484);

		if (power && !powered) {
			class_2586 tile = world.method_8321(pos);
			if (tile instanceof CacophoniumBlockEntity cacophonium) {
				cacophonium.annoyDirewolf();
			}
			world.method_8652(pos, state.method_11657(class_2741.field_12484, true), class_2248.field_31029);
		} else if (!power && powered) {
			world.method_8652(pos, state.method_11657(class_2741.field_12484, false), class_2248.field_31029);
		}
	}

	@Override
	public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving) {
		if (!state.method_27852(newState.method_26204())) {
			class_2586 te = world.method_8321(pos);
			if (te instanceof CacophoniumBlockEntity cacophonium) {
				class_1264.method_5449(world, pos.method_10263(), pos.method_10264(), pos.method_10260(), cacophonium.stack);
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new CacophoniumBlockEntity(pos, state);
	}

}
