/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.client.core.handler;

import org.joml.Matrix4f;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.common.lib.LibMisc;
import vazkii.botania.xplat.BotaniaConfig;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4730;
import net.minecraft.class_557;
import net.minecraft.class_5602;
import net.minecraft.class_811;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

// Hacky way to render 3D lexicon, will be reevaluated in the future.
public class RenderLexicon {
	private static class_557 model = null;
	private static final boolean SHOULD_MISSPELL = Math.random() < 0.004;
	public static final class_4730 TEXTURE = new class_4730(class_1723.field_21668, prefix("item/lexicon_3d"));
	public static final class_4730 ELVEN_TEXTURE = new class_4730(class_1723.field_21668, prefix("item/lexicon_elven_3d"));

	private static final String[] QUOTES = new String[] {
			"\"Neat!\" - Direwolf20",
			"\"It's pretty ledge.\" - Haighyorkie",
			"\"I don't really like it.\" - CrustyMustard",
			"\"It's a very thinky mod.\" - AdamG3691",
			"\"You must craft the tiny potato.\" - TheFractangle",
			"\"Vazkii did a thing.\" - cpw"
	};

	private static final String[] MISSPELLINGS = {
			"Bonito", "Bonita", "Bonitia", "Botnaia", "Bontonio",
			"Botnia", "Bonitaaaaaaaaaa", "Botonio", "Botonia", "Botnetia",
			"Banana", "Brotania", "Botanica", "Boat", "Batania", "Bosnia"
	};

	private static int quote = -1;
	private static int misspelling = -1;

	private static class_557 getModel() {
		if (model == null) {
			model = new class_557(class_310.method_1551().method_31974().method_32072(class_5602.field_27685));
		}
		return model;
	}

	public static boolean renderHand(class_1799 stack, class_811 type,
			boolean leftHanded, class_4587 ms, class_4597 buffers, int light) {
		if (!BotaniaConfig.client().lexicon3dModel()
				|| !type.method_29998()
				|| stack.method_7960()
				|| !stack.method_31574(BotaniaItems.lexicon)) {
			return false;
		}
		try {
			doRender(stack, leftHanded, ms, buffers, light, ClientTickHandler.partialTicks);
			return true;
		} catch (Throwable throwable) {
			BotaniaAPI.LOGGER.warn("Failed to render lexicon", throwable);
			return false;
		}
	}

	private static void doRender(class_1799 stack, boolean leftHanded, class_4587 ms, class_4597 buffers, int light, float partialTicks) {
		class_310 mc = class_310.method_1551();

		ms.method_22903();

		float ticks = ClientTickHandler.ticksWithLexicaOpen;
		if (ticks > 0 && ticks < 10) {
			if (LexicaBotaniaItem.isOpen()) {
				ticks += partialTicks;
			} else {
				ticks -= partialTicks;
			}
		}

		if (!leftHanded) {
			ms.method_46416(0.3F + 0.02F * ticks, 0.125F + 0.01F * ticks, -0.2F - 0.035F * ticks);
			ms.method_22907(VecHelper.rotateY(180F + ticks * 6));
		} else {
			ms.method_46416(0.1F - 0.02F * ticks, 0.125F + 0.01F * ticks, -0.2F - 0.035F * ticks);
			ms.method_22907(VecHelper.rotateY(200F + ticks * 10));
		}
		ms.method_22907(VecHelper.rotateZ(-0.3F + ticks * 2.85F));
		float opening = class_3532.method_15363(ticks / 12F, 0, 1);

		float pageFlipTicks = ClientTickHandler.pageFlipTicks;
		if (pageFlipTicks > 0) {
			pageFlipTicks -= ClientTickHandler.partialTicks;
		}

		float pageFlip = pageFlipTicks / 5F;

		float leftPageAngle = class_3532.method_22450(pageFlip + 0.25F) * 1.6F - 0.3F;
		float rightPageAngle = class_3532.method_22450(pageFlip + 0.75F) * 1.6F - 0.3F;
		var model = getModel();
		model.method_17073(ClientTickHandler.total(), class_3532.method_15363(leftPageAngle, 0.0F, 1.0F), class_3532.method_15363(rightPageAngle, 0.0F, 1.0F), opening);

		class_4730 mat = LexicaBotaniaItem.isElven(stack) ? ELVEN_TEXTURE : TEXTURE;
		class_4588 buffer = mat.method_24145(buffers, class_1921::method_23572);
		model.method_2828(ms, buffer, light, class_4608.field_21444, 1, 1, 1, 1);

		if (ticks < 3) {
			class_327 font = class_310.method_1551().field_1772;
			ms.method_22907(VecHelper.rotateZ(180F));
			ms.method_46416(-0.30F, -0.24F, -0.07F);
			ms.method_22905(0.0030F, 0.0030F, -0.0030F);

			if (misspelling == -1 && mc.field_1687 != null) {
				misspelling = mc.field_1687.field_9229.method_43048(MISSPELLINGS.length);
			}

			String title = LexicaBotaniaItem.getTitle(stack).getString();
			if (SHOULD_MISSPELL) {
				title = title.replaceAll(LibMisc.MOD_NAME, MISSPELLINGS[misspelling]);
			}
			font.method_27521(font.method_27523(title, 80), 0, 0, 0xD69700, false, ms.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, light);

			ms.method_46416(0F, 10F, 0F);
			ms.method_22905(0.6F, 0.6F, 0.6F);
			class_2561 edition = LexicaBotaniaItem.getEdition().method_27661().method_27695(class_124.field_1056, class_124.field_1067);
			font.method_30882(edition, 0, 0, 0xA07100, false, ms.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, light);

			if (quote == -1 && mc.field_1687 != null) {
				quote = mc.field_1687.field_9229.method_43048(QUOTES.length);
			}

			String quoteStr = QUOTES[quote];

			ms.method_46416(-5F, 15F, 0F);
			renderText(0, 0, 140, 0, 0x79ff92, quoteStr, ms.method_23760().method_23761(), buffers, light);

			ms.method_46416(8F, 110F, 0F);
			String blurb = class_1074.method_4662("botaniamisc.lexiconcover0");
			font.method_27521(blurb, 0, 0, 0x79ff92, false, ms.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, light);

			ms.method_46416(0F, 10F, 0F);
			String blurb2 = class_124.field_1073 + "" + class_124.field_1056 + class_1074.method_4662("botaniamisc.lexiconcover1");
			font.method_27521(blurb2, 0, 0, 0x79ff92, false, ms.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, light);

			ms.method_46416(0F, -30F, 0F);

			String authorTitle = class_1074.method_4662("botaniamisc.lexiconcover2");
			int len = font.method_1727(authorTitle);
			font.method_27521(authorTitle, 58 - len / 2F, -8, 0xD69700, false, ms.method_23760().method_23761(), buffers, class_327.class_6415.field_33993, 0, light);
		}

		ms.method_22909();
	}

	@SuppressWarnings("SameParameterValue")
	private static void renderText(int x, int y, int width, int paragraphSize, int color, String unlocalizedText, Matrix4f matrix, class_4597 buffers, int light) {
		x += 2;
		y += 10;
		width -= 4;

		class_327 font = class_310.method_1551().field_1772;
		String text = class_1074.method_4662(unlocalizedText).replaceAll("&", "\u00a7");
		String[] textEntries = text.split("<br>");

		List<List<String>> lines = new ArrayList<>();

		String controlCodes;
		for (String s : textEntries) {
			List<String> words = new ArrayList<>();
			String lineStr = "";
			String[] tokens = s.split(" ");
			for (String token : tokens) {
				String prev = lineStr;
				String spaced = token + " ";
				lineStr += spaced;

				controlCodes = toControlCodes(getControlCodes(prev));
				if (font.method_1727(lineStr) > width) {
					lines.add(words);
					lineStr = controlCodes + spaced;
					words = new ArrayList<>();
				}

				words.add(controlCodes + token);
			}

			if (!lineStr.isEmpty()) {
				lines.add(words);
			}
			lines.add(new ArrayList<>());
		}

		for (List<String> words : lines) {
			int xi = x;
			int spacing = 4;

			for (String s : words) {
				int extra = 0;
				font.method_27521(s, xi, y, color, false, matrix, buffers, class_327.class_6415.field_33993, 0, light);
				xi += font.method_1727(s) + spacing + extra;
			}

			y += words.isEmpty() ? paragraphSize : 10;
		}
	}

	private static String getControlCodes(String s) {
		String controls = s.replaceAll("(?<!\u00a7)(.)", "");
		return controls.replaceAll(".*r", "r");
	}

	private static String toControlCodes(String s) {
		return s.replaceAll(".", "\u00a7$0");
	}
}
