/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.test.block;

import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import net.minecraft.gametest.framework.*;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.test.TestingUtil;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class BindingTest {
	//Empty 33x33x33 structure
	private static final String TEMPLATE = "botania:block/flower_binding_arena";

	@class_6302(method_35936 = TEMPLATE)
	public void functionalFlowerAutoBindTest(class_4516 helper) {
		autobindTest(helper, BotaniaBlocks.creativePool, BotaniaFlowerBlocks.clayconiaFloating, 10);
	}

	@class_6302(method_35936 = TEMPLATE)
	public void generatingFlowerAutoBindTest(class_4516 helper) {
		autobindTest(helper, BotaniaBlocks.manaSpreader, BotaniaFlowerBlocks.endoflameFloating, 6);
	}

	private void autobindTest(class_4516 helper, class_2248 bindTargetBlock, class_2248 flower, int maxDistance) {
		class_2338 middle = new class_2338(16, 16, 16);
		helper.method_35984(middle, bindTargetBlock);
		class_2338 absoluteBindTarget = TestingUtil.assertAnyBlockEntity(helper, middle).method_11016();

		List<class_2338> justCloseEnough = placeAxialFlowers(helper, middle, flower, maxDistance);
		List<class_2338> tooFarAway = placeAxialFlowers(helper, middle, flower, maxDistance + 1);

		helper.method_36003(1L, () -> {
			justCloseEnough.forEach(pos -> assertFlowerBoundTo(helper, pos, absoluteBindTarget));
			tooFarAway.forEach(pos -> assertFlowerBoundTo(helper, pos, null));
			helper.method_36036();
		});
	}

	@class_6302(method_35936 = TEMPLATE)
	public void functionalFlowerManualBindTest(class_4516 helper) {
		manualBindTest(helper, BotaniaBlocks.creativePool, BotaniaFlowerBlocks.clayconiaFloating, 10);
	}

	@class_6302(method_35936 = TEMPLATE)
	public void generatingFlowerManualBindTest(class_4516 helper) {
		manualBindTest(helper, BotaniaBlocks.manaSpreader, BotaniaFlowerBlocks.endoflameFloating, 6);
	}

	private void manualBindTest(class_4516 helper, class_2248 bindTargetBlock, class_2248 flower, int maxDistance) {
		class_2338 middle = new class_2338(16, 16, 16);

		//Place flowers first so they can't automatically bind
		List<class_2338> justCloseEnough = placeAxialFlowers(helper, middle, flower, maxDistance);
		List<class_2338> tooFarAway = placeAxialFlowers(helper, middle, flower, maxDistance + 1);

		helper.method_35984(middle, bindTargetBlock);
		class_2338 absoluteBindTarget = TestingUtil.assertAnyBlockEntity(helper, middle).method_11016();

		//Bind each flower with the Wand of the Forest. (before doing any assertions, so you can examine the result in-game)
		justCloseEnough.forEach(pos -> TestingUtil.bindWithWandOfTheForest(helper, pos, middle));
		tooFarAway.forEach(pos -> TestingUtil.bindWithWandOfTheForest(helper, pos, middle));

		//Close-enough ones should bind, far away ones should not.
		justCloseEnough.forEach(pos -> assertFlowerBoundTo(helper, pos, absoluteBindTarget));
		tooFarAway.forEach(pos -> assertFlowerBoundTo(helper, pos, null));

		helper.method_36036();
	}

	@class_6302(method_35936 = TEMPLATE)
	public void functionalFlowerObedienceStick(class_4516 helper) {
		obedienceStickTest(helper, BotaniaBlocks.creativePool, BotaniaFlowerBlocks.clayconiaFloating, 10);
	}

	@class_6302(method_35936 = TEMPLATE)
	public void generatingFlowerObedienceStick(class_4516 helper) {
		obedienceStickTest(helper, BotaniaBlocks.manaSpreader, BotaniaFlowerBlocks.endoflameFloating, 6);
	}

	private void obedienceStickTest(class_4516 helper, class_2248 bindTargetBlock, class_2248 flower, int maxDistance) {
		class_2338 middle = new class_2338(16, 16, 16);

		//Place flowers first so they can't automatically bind
		List<class_2338> justCloseEnough = placeAxialFlowers(helper, middle, flower, maxDistance);
		List<class_2338> tooFarAway = placeAxialFlowers(helper, middle, flower, maxDistance + 1);

		helper.method_35984(middle, bindTargetBlock);
		class_2338 absoluteBindTarget = TestingUtil.assertAnyBlockEntity(helper, middle).method_11016();

		//Use a Floral Obedience Stick on the pool
		class_1657 player = helper.method_36021();
		player.method_5673(class_1304.field_6173, new class_1799(BotaniaItems.obedienceStick));
		TestingUtil.useItemOn(helper, player, class_1268.field_5808, middle);

		//All close-enough flowers should bind, all far-away ones should not
		justCloseEnough.forEach(pos -> assertFlowerBoundTo(helper, pos, absoluteBindTarget));
		tooFarAway.forEach(pos -> assertFlowerBoundTo(helper, pos, null));

		helper.method_36036();
	}

	private static List<class_2338> placeAxialFlowers(class_4516 helper, class_2338 center, class_2248 flower, int distance) {
		return Arrays.stream(class_2350.values())
				.map(dir -> center.method_10079(dir, distance))
				.peek(pos -> helper.method_35984(pos, flower))
				.collect(Collectors.toList());
	}

	private static void assertFlowerBoundTo(class_4516 helper, class_2338 relativePos, @Nullable class_2338 absoluteBindTarget) {
		String message = absoluteBindTarget == null ? "Flower should not have bound" : "Flower should have bound to " + absoluteBindTarget;

		class_2586 be = TestingUtil.assertAnyBlockEntity(helper, relativePos);
		if (be instanceof GeneratingFlowerBlockEntity tege) {
			TestingUtil.assertEqualsAt(helper, relativePos, tege.getBinding(), absoluteBindTarget, () -> message);
		} else if (be instanceof FunctionalFlowerBlockEntity tefe) {
			TestingUtil.assertEqualsAt(helper, relativePos, tefe.getBinding(), absoluteBindTarget, () -> message);
		} else {
			TestingUtil.throwPositionedAssertion(helper, relativePos, () -> "Expected a flower here");
		}
	}
}
