/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.fabric.mixin;

import net.minecraft.class_1718;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4538;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import vazkii.botania.common.block.PylonBlock;

@Mixin(class_1718.class)
public class EnchantmentMenuFabricMixin {
	@SuppressWarnings("target")
	@ModifyVariable(
		method = "method_17411(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V",
		at = @At(value = "STORE", ordinal = 0),
		ordinal = 0
	)
	private int botaniaPylonEnchanting(int obj, class_1799 stack, class_1937 level, class_2338 pos) {
		for (int x = -1; x <= 1; ++x) {
			for (int z = -1; z <= 1; ++z) {
				if ((x != 0 || z != 0) && level.method_22347(pos.method_10069(x, 0, z)) && level.method_22347(pos.method_10069(x, 1, z))) {
					obj += getPylonValue(level.method_8320(pos.method_10069(x * 2, 0, z * 2)), level, pos);
					obj += getPylonValue(level.method_8320(pos.method_10069(x * 2, 1, z * 2)), level, pos);
					if (x != 0 && z != 0) {
						obj += getPylonValue(level.method_8320(pos.method_10069(x * 2, 0, z)), level, pos);
						obj += getPylonValue(level.method_8320(pos.method_10069(x * 2, 1, z)), level, pos);
						obj += getPylonValue(level.method_8320(pos.method_10069(x, 0, z * 2)), level, pos);
						obj += getPylonValue(level.method_8320(pos.method_10069(x, 1, z * 2)), level, pos);
					}
				}
			}
		}
		return obj;
	}

	@Unique
	private float getPylonValue(class_2680 state, class_4538 world, class_2338 pos) {
		if (state.method_26204() instanceof PylonBlock pylon) {
			return pylon.getEnchantPowerBonus(state, world, pos);
		}
		return 0;
	}
}
