package vazkii.botania.fabric.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3665;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_809;
import net.minecraft.client.resources.model.*;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.client.model.ManaBlasterBakedModel;
import vazkii.botania.xplat.ClientXplatAbstractions;

import java.util.*;
import java.util.function.Function;

/*
 * NB: We extend BlockModel only as an artifact of where we inject our mixin.
 * Pretty much all of the data of the superclass is ignored.
 */
public class FabricManaBlasterModel extends class_793 {
	private final class_2960 gunNoClip, gunClip;

	public FabricManaBlasterModel(class_2960 gunNoClip, class_2960 gunClip) {
		super(null, Collections.emptyList(), Collections.emptyMap(), false, class_4751.field_21859, class_809.field_4301, Collections.emptyList());
		this.gunNoClip = gunNoClip;
		this.gunClip = gunClip;
	}

	@Override
	public Collection<class_2960> method_4755() {
		return List.of(this.gunNoClip, this.gunClip);
	}

	@Override
	public void method_45785(Function<class_2960, class_1100> modelGetter) {
		modelGetter.apply(this.gunNoClip).method_45785(modelGetter);
		modelGetter.apply(this.gunClip).method_45785(modelGetter);
	}

	@Nullable
	@Override
	public class_1087 method_4753(class_7775 baker, Function<class_4730, class_1058> spriteGetter,
			class_3665 state, class_2960 location) {

		return ManaBlasterBakedModel.create(
				baker,
				this.gunNoClip, this.gunClip,
				state);
	}

	@Nullable
	public static FabricManaBlasterModel hookModelLoad(JsonElement jsonElement) {
		JsonObject json = jsonElement.getAsJsonObject();
		JsonElement loader = json.get("loader");
		if (loader != null && loader.isJsonPrimitive()
				&& loader.getAsString().equals(ClientXplatAbstractions.MANA_GUN_MODEL_LOADER_ID.toString())) {
			return new FabricManaBlasterModel(
					new class_2960(class_3518.method_15265(json, "gun_noclip")),
					new class_2960(class_3518.method_15265(json, "gun_clip"))
			);
		}
		return null;
	}
}
