/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data.recipes;

import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_184;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2066;
import net.minecraft.class_2073;
import net.minecraft.class_2119;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2444;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2456;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3955;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7784;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.data.recipes.*;
import net.minecraft.world.item.*;
import org.apache.commons.lang3.mutable.MutableObject;

import vazkii.botania.api.state.enums.CraftyCratePattern;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.recipe.*;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.common.lib.LibItemNames;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.mixin.RecipeProviderAccessor;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CraftingRecipeProvider extends BotaniaRecipeProvider {
	public CraftingRecipeProvider(class_7784 packOutput) {
		super(packOutput);
	}

	@Override
	public void buildRecipes(Consumer<class_2444> consumer) {
		specialRecipe(consumer, AncientWillRecipe.SERIALIZER);
		specialRecipe(consumer, BlackHoleTalismanExtractRecipe.SERIALIZER);
		specialRecipe(consumer, CompositeLensRecipe.SERIALIZER);
		specialRecipe(consumer, CosmeticAttachRecipe.SERIALIZER);
		specialRecipe(consumer, CosmeticRemoveRecipe.SERIALIZER);
		specialRecipe(consumer, ResoluteIvyRecipe.SERIALIZER);
		specialRecipe(consumer, LaputaShardUpgradeRecipe.SERIALIZER);
		specialRecipe(consumer, LensDyeingRecipe.SERIALIZER);
		specialRecipe(consumer, ManaBlasterClipRecipe.SERIALIZER);
		specialRecipe(consumer, ManaBlasterLensRecipe.SERIALIZER);
		specialRecipe(consumer, ManaBlasterRemoveLensRecipe.SERIALIZER);
		specialRecipe(consumer, MergeVialRecipe.SERIALIZER);
		specialRecipe(consumer, PhantomInkRecipe.SERIALIZER);
		specialRecipe(consumer, SpellbindingClothRecipe.SERIALIZER);
		specialRecipe(consumer, SplitLensRecipe.SERIALIZER);
		specialRecipe(consumer, TerraShattererTippingRecipe.SERIALIZER);

		registerMain(consumer);
		registerMisc(consumer);
		registerTools(consumer);
		registerTrinkets(consumer);
		registerLenses(consumer);
		registerCorporeaAndRedString(consumer);
		registerFloatingFlowers(consumer);
		registerConversions(consumer);
		registerDecor(consumer);
	}

	public static class_2066.class_2068 conditionsFromItem(class_1935 item) {
		return RecipeProviderAccessor.botania_condition(class_2073.class_2074.method_8973().method_8977(item).method_8976());
	}

	private static class_2066.class_2068 conditionsFromItems(class_1935... items) {
		class_2073[] preds = new class_2073[items.length];
		for (int i = 0; i < items.length; i++) {
			preds[i] = class_2073.class_2074.method_8973().method_8977(items[i]).method_8976();
		}

		return RecipeProviderAccessor.botania_condition(preds);
	}

	public static class_2066.class_2068 conditionsFromTag(class_6862<class_1792> tag) {
		return RecipeProviderAccessor.botania_condition(class_2073.class_2074.method_8973().method_8975(tag).method_8976());
	}

	/** Addons: override this to return your modid */
	protected class_2960 prefix(String path) {
		return ResourceLocationHelper.prefix(path);
	}

	private void registerMain(Consumer<class_2444> consumer) {
		MutableObject<class_2444> base = new MutableObject<>();
		MutableObject<class_2444> gog = new MutableObject<>();
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.manaSpreader)
				.method_10433('P', BotaniaTags.Items.PETALS)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10434('C', class_1802.field_27022)
				.method_10439("WWW")
				.method_10439("CP ")
				.method_10439("WWW")
				.method_10435("botania:spreader")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS))
				.method_10431(base::setValue);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.manaSpreader)
				.method_10433('P', BotaniaTags.Items.PETALS)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10439("WWW")
				.method_10439("WP ")
				.method_10439("WWW")
				.method_10435("botania:spreader")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS))
				.method_10431(gog::setValue);
		consumer.accept(new GogAlternationResult(gog.getValue(), base.getValue()));
		class_2450.method_10447(class_7800.field_40636, BotaniaBlocks.redstoneSpreader)
				.method_10454(BotaniaBlocks.manaSpreader)
				.method_10454(class_1802.field_8725)
				.method_10452("botania:spreader")
				.method_10442("has_item", conditionsFromItem(BotaniaBlocks.manaSpreader))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.elvenSpreader)
				.method_10433('P', BotaniaTags.Items.PETALS)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10433('W', BotaniaTags.Items.DREAMWOOD_LOGS)
				.method_10439("WWW")
				.method_10439("EP ")
				.method_10439("WWW")
				.method_10435("botania:spreader")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10429("has_alt_item", conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40636, BotaniaBlocks.gaiaSpreader)
				.method_10454(BotaniaBlocks.elvenSpreader)
				.method_10446(BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10454(BotaniaItems.lifeEssence)
				.method_10452("botania:spreader")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.manaPool)
				.method_10434('R', BotaniaBlocks.livingrock)
				.method_10439("R R")
				.method_10439("RRR")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.livingrock))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.dilutedPool)
				.method_10434('R', BotaniaBlocks.livingrockSlab)
				.method_10439("R R")
				.method_10439("RRR")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.livingrock))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.fabulousPool)
				.method_10434('R', BotaniaBlocks.shimmerrock)
				.method_10439("R R")
				.method_10439("RRR")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.shimmerrock))
				.method_10429("has_alt_item", conditionsFromItem(BotaniaItems.rainbowRod))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.fabulousPool)
				.method_10434('P', BotaniaBlocks.manaPool)
				.method_10434('B', BotaniaBlocks.bifrostPerm)
				.method_10439("BPB")
				.method_10439("BBB")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.bifrostPerm))
				.method_10429("has_alt_item", conditionsFromItem(BotaniaItems.rainbowRod))
				.method_17972(consumer, prefix(class_7923.field_41178.method_10221(BotaniaBlocks.fabulousPool.method_8389()).method_12832() + "_upgrade"));
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.runeAltar)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10439("SSS")
				.method_10439("SPS")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.runeAltar)
				.method_10433('P', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10439("SSS")
				.method_10439("SPS")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND))
				.method_17972(consumer, prefix("runic_altar_alt"));
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.manaPylon)
				.method_10433('D', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('G', class_1802.field_8695)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439(" G ")
				.method_10439("MDM")
				.method_10439(" G ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.naturaPylon)
				.method_10434('P', BotaniaBlocks.manaPylon)
				.method_10433('T', BotaniaTags.Items.NUGGETS_TERRASTEEL)
				.method_10434('E', class_1802.field_8449)
				.method_10439(" T ")
				.method_10439("TPT")
				.method_10439(" E ")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.manaPylon))
				.method_10429("has_alt_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.gaiaPylon)
				.method_10434('P', BotaniaBlocks.manaPylon)
				.method_10434('D', BotaniaItems.pixieDust)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439(" D ")
				.method_10439("EPE")
				.method_10439(" D ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10429("has_alt_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.distributor)
				.method_10434('R', BotaniaBlocks.livingrock)
				.method_10433('S', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("RRR")
				.method_10439("S S")
				.method_10439("RRR")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.manaVoid)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10434('O', class_1802.field_8281)
				.method_10439("SSS")
				.method_10439("O O")
				.method_10439("SSS")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.livingrock))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.manaDetector)
				.method_10434('R', class_1802.field_8725)
				.method_10434('T', class_2246.field_22422)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10439("RSR")
				.method_10439("STS")
				.method_10439("RSR")
				.method_10429("has_item", conditionsFromItem(class_2246.field_22422))
				.method_10429("has_alt_item", conditionsFromItem(BotaniaBlocks.livingrock))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.turntable)
				.method_10434('P', class_1802.field_8105)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10439("WWW")
				.method_10439("WPW")
				.method_10439("WWW")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS))
				.method_10429("has_alt_item", conditionsFromItem(class_1802.field_8105))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.tinyPlanet)
				.method_10434('P', BotaniaItems.tinyPlanet)
				.method_10434('S', class_1802.field_20391)
				.method_10439("SSS")
				.method_10439("SPS")
				.method_10439("SSS")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.tinyPlanet))
				.method_10429("has_alt_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.alchemyCatalyst)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('B', class_1802.field_8740)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10434('G', class_1802.field_8695)
				.method_10439("SGS")
				.method_10439("BPB")
				.method_10439("SGS")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10429("has_alt_item", conditionsFromItem(class_1802.field_8740))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.openCrate)
				.method_10434('W', BotaniaBlocks.livingwoodPlanks)
				.method_10439("WWW")
				.method_10439("W W")
				.method_10439("W W")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.livingwoodPlanks))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.craftCrate)
				.method_10434('C', class_1802.field_8465)
				.method_10434('W', BotaniaBlocks.dreamwoodPlanks)
				.method_10439("WCW")
				.method_10439("W W")
				.method_10439("W W")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.dreamwoodPlanks))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.forestEye)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10434('E', class_1802.field_8449)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("MSM")
				.method_10439("SES")
				.method_10439("MSM")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.wildDrum)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10434('H', BotaniaItems.grassHorn)
				.method_10434('L', class_1802.field_8745)
				.method_10439("WLW")
				.method_10439("WHW")
				.method_10439("WLW")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.grassHorn))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.gatheringDrum)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10433('W', BotaniaTags.Items.DREAMWOOD_LOGS)
				.method_10434('L', class_1802.field_8745)
				.method_10439("WLW")
				.method_10439("WEW")
				.method_10439("WLW")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10429("has_alt_item", conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.canopyDrum)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10434('H', BotaniaItems.leavesHorn)
				.method_10434('L', class_1802.field_8745)
				.method_10439("WLW")
				.method_10439("WHW")
				.method_10439("WLW")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.leavesHorn))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40635, BotaniaBlocks.abstrusePlatform, 2)
				.method_10433('0', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('3', BotaniaBlocks.livingwoodFramed)
				.method_10434('4', BotaniaBlocks.livingwoodPatternFramed)
				.method_10439("343")
				.method_10439("0P0")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40635, BotaniaBlocks.spectralPlatform, 2)
				.method_10433('0', BotaniaTags.Items.DREAMWOOD_LOGS)
				.method_10434('3', BotaniaBlocks.dreamwoodFramed)
				.method_10434('4', BotaniaBlocks.dreamwoodPatternFramed)
				.method_10434('D', BotaniaItems.pixieDust)
				.method_10439("343")
				.method_10439("0D0")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.alfPortal)
				.method_10433('T', BotaniaTags.Items.NUGGETS_TERRASTEEL)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10439("WTW")
				.method_10439("WTW")
				.method_10439("WTW")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.conjurationCatalyst)
				.method_10434('P', BotaniaBlocks.alchemyCatalyst)
				.method_10434('B', BotaniaItems.pixieDust)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10433('G', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("SBS")
				.method_10439("GPG")
				.method_10439("SGS")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10429("has_alt_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.spawnerClaw)
				.method_10434('P', class_1802.field_20405)
				.method_10434('B', class_1802.field_8894)
				.method_10433('S', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('E', BotaniaItems.enderAirBottle)
				.method_10433('M', BotaniaTags.Items.BLOCKS_MANASTEEL)
				.method_10439("BSB")
				.method_10439("PMP")
				.method_10439("PEP")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.enderAirBottle))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.enderEye)
				.method_10434('R', class_1802.field_8725)
				.method_10434('E', class_1802.field_8449)
				.method_10434('O', class_1802.field_8281)
				.method_10439("RER")
				.method_10439("EOE")
				.method_10439("RER")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8449))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.starfield)
				.method_10434('P', BotaniaItems.pixieDust)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('O', class_1802.field_8281)
				.method_10439("EPE")
				.method_10439("EOE")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10429("has_alt_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.rfGenerator)
				.method_10434('R', class_1802.field_8793)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("SRS")
				.method_10439("RMR")
				.method_10439("SRS")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8793))
				.method_10429("has_alt_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.brewery)
				.method_10434('A', BotaniaItems.runeMana)
				.method_10434('R', BotaniaBlocks.livingrock)
				.method_10434('S', class_1802.field_8740)
				.method_10433('M', BotaniaTags.Items.BLOCKS_MANASTEEL)
				.method_10439("RSR")
				.method_10439("RAR")
				.method_10439("RMR")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeMana))
				.method_10429("has_alt_item", conditionsFromItem(class_1802.field_8740))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.terraPlate)
				.method_10434('0', BotaniaItems.runeWater)
				.method_10434('1', BotaniaItems.runeFire)
				.method_10434('2', BotaniaItems.runeEarth)
				.method_10434('3', BotaniaItems.runeAir)
				.method_10434('8', BotaniaItems.runeMana)
				.method_10434('L', class_2246.field_10441)
				.method_10433('M', BotaniaTags.Items.BLOCKS_MANASTEEL)
				.method_10439("LLL")
				.method_10439("0M1")
				.method_10439("283")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.RUNES))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.pump)
				.method_10434('B', class_1802.field_8550)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10433('I', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("SSS")
				.method_10439("IBI")
				.method_10439("SSS")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.incensePlate)
				.method_10434('S', BotaniaBlocks.livingwoodSlab)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10439("SSW")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.hourglass)
				.method_10434('R', class_1802.field_8725)
				.method_10433('S', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10434('G', class_1802.field_8695)
				.method_10434('M', BotaniaBlocks.manaGlass)
				.method_10439("GMG")
				.method_10439("RSR")
				.method_10439("GMG")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.manaGlass))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40637, BotaniaBlocks.ghostRail)
				.method_10454(class_1802.field_8129)
				.method_10454(BotaniaBlocks.spectralPlatform)
				.method_10442("has_item", conditionsFromItem(class_1802.field_8129))
				.method_10442("has_alt_item", conditionsFromItem(BotaniaBlocks.spectralPlatform))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.sparkChanger)
				.method_10434('R', class_1802.field_8725)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("ESE")
				.method_10439("SRS")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.felPumpkin)
				.method_10434('P', class_1802.field_17518)
				.method_10434('B', class_1802.field_8606)
				.method_10434('S', class_1802.field_8276)
				.method_10434('F', class_1802.field_8511)
				.method_10434('G', class_1802.field_8054)
				.method_10439(" S ")
				.method_10439("BPF")
				.method_10439(" G ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_17518))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaBlocks.cocoon)
				.method_10434('S', class_1802.field_8276)
				.method_10434('C', BotaniaItems.manaweaveCloth)
				.method_10434('P', BotaniaBlocks.felPumpkin)
				.method_10434('D', BotaniaItems.pixieDust)
				.method_10439("SSS")
				.method_10439("CPC")
				.method_10439("SDS")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.felPumpkin))
				.method_10431(base::setValue);
		class_2447.method_10437(class_7800.field_40642, BotaniaBlocks.cocoon)
				.method_10434('S', class_1802.field_8276)
				.method_10434('P', BotaniaBlocks.felPumpkin)
				.method_10433('I', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("SSS")
				.method_10439("SPS")
				.method_10439("SIS")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.felPumpkin))
				.method_10431(gog::setValue);
		consumer.accept(new GogAlternationResult(gog.getValue(), base.getValue()));
		class_2450.method_10447(class_7800.field_40637, BotaniaBlocks.lightRelayDefault)
				.method_10454(BotaniaItems.redString)
				.method_10446(BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10454(class_1802.field_8601)
				.method_10454(class_1802.field_8601)
				.method_10442("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40637, BotaniaBlocks.lightRelayDetector)
				.method_10454(BotaniaBlocks.lightRelayDefault)
				.method_10454(class_1802.field_8725)
				.method_10442("has_item", conditionsFromItem(BotaniaBlocks.lightRelayDefault))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40637, BotaniaBlocks.lightRelayFork)
				.method_10454(BotaniaBlocks.lightRelayDefault)
				.method_10454(class_1802.field_8530)
				.method_10442("has_item", conditionsFromItem(BotaniaBlocks.lightRelayDefault))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40637, BotaniaBlocks.lightRelayToggle)
				.method_10454(BotaniaBlocks.lightRelayDefault)
				.method_10454(class_1802.field_8865)
				.method_10442("has_item", conditionsFromItem(BotaniaBlocks.lightRelayDefault))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.lightLauncher)
				.method_10433('D', BotaniaTags.Items.DREAMWOOD_LOGS)
				.method_10434('L', BotaniaBlocks.lightRelayDefault)
				.method_10439("DDD")
				.method_10439("DLD")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.lightRelayDefault))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaBlocks.manaBomb)
				.method_10434('T', class_1802.field_8626)
				.method_10434('G', BotaniaItems.lifeEssence)
				.method_10433('L', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10439("LTL")
				.method_10439("TGT")
				.method_10439("LTL")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.bellows)
				.method_10434('R', BotaniaItems.runeAir)
				.method_10434('S', BotaniaBlocks.livingwoodSlab)
				.method_10434('L', class_1802.field_8745)
				.method_10439("SSS")
				.method_10439("RL ")
				.method_10439("SSS")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeAir))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, BotaniaBlocks.bifrostPerm)
				.method_10454(BotaniaItems.rainbowRod)
				.method_10454(BotaniaBlocks.elfGlass)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.rainbowRod))
				.method_10431(consumer);
		class_2450.method_10448(class_7800.field_40635, BotaniaBlocks.cellBlock, 3)
				.method_10449(class_1802.field_17520, 3)
				.method_10454(class_1802.field_8186)
				.method_10454(class_1802.field_8179)
				.method_10454(class_1802.field_8567)
				.method_10442("has_item", conditionsFromItem(BotaniaFlowerBlocks.dandelifeon))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.teruTeruBozu)
				.method_10434('C', BotaniaItems.manaweaveCloth)
				.method_10434('S', class_1802.field_17525)
				.method_10439("C")
				.method_10439("C")
				.method_10439("S")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaweaveCloth))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.avatar)
				.method_10433('D', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10439(" W ")
				.method_10439("WDW")
				.method_10439("W W")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.animatedTorch)
				.method_10433('D', BotaniaTags.Items.DUSTS_MANA)
				.method_10434('T', class_1802.field_8530)
				.method_10439("D")
				.method_10439("T")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8530))
				.method_10429("has_alt_item", conditionsFromTag(BotaniaTags.Items.DUSTS_MANA))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.livingwoodTwig)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10439(" W")
				.method_10439("W ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.redstoneRoot)
				.method_10454(class_1802.field_8725)
				.method_10451(class_1856.method_8091(class_1802.field_8471, class_1802.field_8602))
				.method_10442("has_item", conditionsFromItem(class_1802.field_8725))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.dreamwoodTwig)
				.method_10433('W', BotaniaTags.Items.DREAMWOOD_LOGS)
				.method_10439(" W")
				.method_10439("W ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.gaiaIngot)
				.method_10434('S', BotaniaItems.lifeEssence)
				.method_10433('I', BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10439(" S ")
				.method_10439("SIS")
				.method_10439(" S ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.manaweaveCloth)
				.method_10434('S', BotaniaItems.manaString)
				.method_10439("SS")
				.method_10439("SS")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaString))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.drySeeds)
				.method_10454(BotaniaItems.grassSeeds)
				.method_10454(class_1802.field_8689)
				.method_10452("botania:seeds")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.grassSeeds))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.goldenSeeds)
				.method_10454(BotaniaItems.grassSeeds)
				.method_10454(class_1802.field_8861)
				.method_10452("botania:seeds")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.grassSeeds))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.vividSeeds)
				.method_10454(BotaniaItems.grassSeeds)
				.method_10454(class_1802.field_8408)
				.method_10452("botania:seeds")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.grassSeeds))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.scorchedSeeds)
				.method_10454(BotaniaItems.grassSeeds)
				.method_10454(class_1802.field_8183)
				.method_10452("botania:seeds")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.grassSeeds))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.infusedSeeds)
				.method_10454(BotaniaItems.grassSeeds)
				.method_10454(class_1802.field_8662)
				.method_10452("botania:seeds")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.grassSeeds))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.mutatedSeeds)
				.method_10454(BotaniaItems.grassSeeds)
				.method_10454(class_1802.field_8680)
				.method_10452("botania:seeds")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.grassSeeds))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40642, BotaniaItems.darkQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10428('C', class_1856.method_8091(class_1802.field_8713, class_1802.field_8665))
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40642, BotaniaItems.blazeQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10434('C', class_1802.field_8183)
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40642, BotaniaItems.lavenderQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10428('C', class_1856.method_8091(class_1802.field_17500, class_1802.field_17511, class_1802.field_17526, class_1802.field_17529))
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40642, BotaniaItems.redQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10434('C', class_1802.field_8725)
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40642, BotaniaItems.sunnyQuartz, 8)
				.method_10434('Q', class_1802.field_8155)
				.method_10434('C', class_1802.field_17525)
				.method_10439("QQQ")
				.method_10439("QCQ")
				.method_10439("QQQ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8155))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.vineBall)
				.method_10434('V', class_1802.field_17523)
				.method_10439("VVV")
				.method_10439("VVV")
				.method_10439("VVV")
				.method_10429("has_item", conditionsFromItem(class_1802.field_17523))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.necroVirus)
				.method_10454(BotaniaItems.pixieDust)
				.method_10454(BotaniaItems.vineBall)
				.method_10454(class_1802.field_8135)
				.method_10454(class_1802.field_8711)
				.method_10454(class_1802.field_8449)
				.method_10454(class_1802.field_8470)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10442("has_alt_item", conditionsFromItem(class_1802.field_8470))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.nullVirus)
				.method_10454(BotaniaItems.pixieDust)
				.method_10454(BotaniaItems.vineBall)
				.method_10454(class_1802.field_8135)
				.method_10454(class_1802.field_8711)
				.method_10454(class_1802.field_8449)
				.method_10454(class_1802.field_8398)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10442("has_alt_item", conditionsFromItem(class_1802.field_8398))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40635, BotaniaItems.spark)
				.method_10433('P', BotaniaTags.Items.PETALS)
				.method_10434('B', class_1802.field_8183)
				.method_10434('N', class_1802.field_8397)
				.method_10439(" P ")
				.method_10439("BNB")
				.method_10439(" P ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8183))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40635, BotaniaItems.sparkUpgradeDispersive)
				.method_10454(BotaniaItems.pixieDust)
				.method_10446(BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10454(BotaniaItems.runeWater)
				.method_10452("botania:spark_upgrade")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10442("has_alt_item", conditionsFromItem(BotaniaItems.spark))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.sparkUpgradeDominant)
				.method_10454(BotaniaItems.pixieDust)
				.method_10446(BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10454(BotaniaItems.runeFire)
				.method_10452("botania:spark_upgrade")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10442("has_alt_item", conditionsFromItem(BotaniaItems.spark))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.sparkUpgradeRecessive)
				.method_10454(BotaniaItems.pixieDust)
				.method_10446(BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10454(BotaniaItems.runeEarth)
				.method_10452("botania:spark_upgrade")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10442("has_alt_item", conditionsFromItem(BotaniaItems.spark))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.sparkUpgradeIsolated)
				.method_10454(BotaniaItems.pixieDust)
				.method_10446(BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10454(BotaniaItems.runeAir)
				.method_10452("botania:spark_upgrade")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10442("has_alt_item", conditionsFromItem(BotaniaItems.spark))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40642, BotaniaItems.vial, 3)
				.method_10434('G', BotaniaBlocks.manaGlass)
				.method_10439("G G")
				.method_10439(" G ")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.manaGlass))
				.method_10429("has_alt_item", conditionsFromItem(BotaniaBlocks.brewery))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40642, BotaniaItems.flask, 3)
				.method_10434('G', BotaniaBlocks.elfGlass)
				.method_10439("G G")
				.method_10439(" G ")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.elfGlass))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40638, BotaniaItems.worldSeed, 4)
				.method_10434('S', class_1802.field_8317)
				.method_10433('D', BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10434('G', class_1802.field_8270)
				.method_10439("G")
				.method_10439("S")
				.method_10439("D")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40639, BotaniaItems.thornChakram, 2)
				.method_10433('T', BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10434('V', class_1802.field_17523)
				.method_10439("VVV")
				.method_10439("VTV")
				.method_10439("VVV")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40639, BotaniaItems.flareChakram, 2)
				.method_10434('P', BotaniaItems.pixieDust)
				.method_10434('B', class_1802.field_8183)
				.method_10434('C', BotaniaItems.thornChakram)
				.method_10439("BBB")
				.method_10439("CPC")
				.method_10439("BBB")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.thornChakram))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.keepIvy)
				.method_10454(BotaniaItems.pixieDust)
				.method_10454(class_1802.field_17523)
				.method_10454(BotaniaItems.enderAirBottle)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.enderAirBottle))
				.method_10431(consumer);

	}

	private void registerMisc(Consumer<class_2444> consumer) {
		class_1856 mushrooms = class_1856.method_8091(BotaniaBlocks.whiteMushroom, BotaniaBlocks.orangeMushroom,
				BotaniaBlocks.magentaMushroom, BotaniaBlocks.lightBlueMushroom, BotaniaBlocks.yellowMushroom,
				BotaniaBlocks.limeMushroom, BotaniaBlocks.pinkMushroom, BotaniaBlocks.grayMushroom, BotaniaBlocks.lightGrayMushroom,
				BotaniaBlocks.cyanMushroom, BotaniaBlocks.purpleMushroom, BotaniaBlocks.blueMushroom, BotaniaBlocks.brownMushroom,
				BotaniaBlocks.greenMushroom, BotaniaBlocks.redMushroom, BotaniaBlocks.blackMushroom);
		class_2450.method_10447(class_7800.field_40640, class_1802.field_8208)
				.method_10453(mushrooms, 2)
				.method_10454(class_1802.field_8428)
				.method_10442("has_item", conditionsFromItem(class_1802.field_8428))
				.method_10442("has_orig_recipe", class_2119.method_27847(new class_2960("mushroom_stew")))
				.method_36443(consumer, "botania:mushroom_stew");

		class_2447.method_10437(class_7800.field_40635, class_1802.field_8786)
				.method_10434('S', class_1802.field_8276)
				.method_10434('M', BotaniaItems.manaString)
				.method_10439("S S")
				.method_10439(" M ")
				.method_10439("S S")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaString))
				.method_17972(consumer, prefix("cobweb"));

		petalApothecary(class_1802.field_20412, BotaniaBlocks.defaultAltar)
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.PETALS))
				.method_10431(consumer);
		petalApothecary(class_1802.field_20392, BotaniaBlocks.mossyAltar)
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.PETALS))
				.method_10431(consumer);
		petalApothecary(BotaniaBlocks.livingrock, BotaniaBlocks.livingrockAltar)
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.livingrock))
				.method_10431(consumer);
		petalApothecary(class_1802.field_29025, BotaniaBlocks.deepslateAltar)
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.PETALS))
				.method_10431(consumer);
		for (String metamorphicVariant : LibBlockNames.METAMORPHIC_VARIANTS) {
			class_2248 apothecary = getBlockOrThrow(prefix("apothecary_" + metamorphicVariant));
			class_2248 cobble = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + metamorphicVariant + "_cobblestone"));
			petalApothecary(cobble, apothecary)
					.method_10435("botania:metamorphic_apothecary")
					.method_10429("has_item", conditionsFromItem(cobble))
					.method_10429("has_flower_item", conditionsFromItem(BotaniaFlowerBlocks.marimorphosis))
					.method_10431(consumer);
		}
		ColorHelper.supportedColors().forEach(color -> {
			class_2450.method_10447(class_7800.field_40635, BotaniaBlocks.getShinyFlower(color))
					.method_10454(class_1802.field_8601)
					.method_10454(class_1802.field_8601)
					.method_10454(BotaniaBlocks.getFlower(color))
					.method_10452("botania:shiny_flower")
					.method_10442("has_item", conditionsFromItem(BotaniaBlocks.getFlower(color)))
					.method_10431(consumer);
			class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.getFloatingFlower(color))
					.method_10434('S', BotaniaItems.grassSeeds)
					.method_10434('D', class_1802.field_8831)
					.method_10434('F', BotaniaBlocks.getShinyFlower(color))
					.method_10439("F")
					.method_10439("S")
					.method_10439("D")
					.method_10435("botania:floating_flowers")
					.method_10429("has_item", conditionsFromItem(BotaniaBlocks.getShinyFlower(color)))
					.method_10431(consumer);
			class_2447.method_10437(class_7800.field_40635, BotaniaBlocks.getPetalBlock(color))
					.method_10434('P', BotaniaItems.getPetal(color))
					.method_10439("PPP")
					.method_10439("PPP")
					.method_10439("PPP")
					.method_10435("botania:petal_block")
					.method_10429("has_item", conditionsFromItem(BotaniaItems.getPetal(color)))
					.method_10431(consumer);
			class_2450.method_10447(class_7800.field_40635, BotaniaBlocks.getMushroom(color))
					.method_10451(class_1856.method_8091(class_1802.field_17517, class_1802.field_17516))
					.method_10454(class_1769.method_7803(color))
					.method_10452("botania:mushroom")
					.method_10442("has_item", conditionsFromItem(class_1802.field_17517))
					.method_10442("has_alt_item", conditionsFromItem(class_1802.field_17516))
					.method_36443(consumer, "botania:mushroom_" + color.ordinal());
			class_2450.method_10448(class_7800.field_40642, BotaniaItems.getPetal(color), 4)
					.method_10454(BotaniaBlocks.getDoubleFlower(color))
					.method_10452("botania:petal_double")
					.method_10442("has_item", conditionsFromItem(BotaniaBlocks.getDoubleFlower(color)))
					.method_10442("has_alt_item", conditionsFromItem(BotaniaItems.getPetal(color)))
					.method_36443(consumer, "botania:petal_" + color.method_7792() + "_double");
			class_2450.method_10448(class_7800.field_40642, BotaniaItems.getPetal(color), 2)
					.method_10454(BotaniaBlocks.getFlower(color))
					.method_10452("botania:petal")
					.method_10442("has_item", conditionsFromItem(BotaniaBlocks.getFlower(color)))
					.method_10442("has_alt_item", conditionsFromItem(BotaniaItems.getPetal(color)))
					.method_36443(consumer, "botania:petal_" + color.method_7792());
			class_2450.method_10447(class_7800.field_40642, class_1769.method_7803(color))
					.method_10451(class_1856.method_8106(BotaniaTags.Items.getPetalTag(color)))
					.method_10452("botania:dye")
					.method_10442("has_item", conditionsFromItem(BotaniaItems.getPetal(color)))
					.method_36443(consumer, "botania:dye_" + color.method_7792());
		});
	}

	private void registerTools(Consumer<class_2444> consumer) {
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.lexicon)
				.method_10446(class_3489.field_15528)
				.method_10454(class_1802.field_8529)
				.method_10442("has_item", conditionsFromTag(class_3489.field_15528))
				.method_10442("has_alt_item", conditionsFromItem(class_1802.field_8529))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.twigWand)
				.method_10433('P', BotaniaTags.Items.PETALS)
				.method_10434('S', BotaniaItems.livingwoodTwig)
				.method_10439(" PS")
				.method_10439(" SP")
				.method_10439("S  ")
				.method_10435("botania:twig_wand")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.PETALS))
				.method_10431(WrapperResult.ofType(WandOfTheForestRecipe.SERIALIZER, consumer));
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.dreamwoodWand)
				.method_10433('P', BotaniaTags.Items.PETALS)
				.method_10434('S', BotaniaItems.dreamwoodTwig)
				.method_10439(" PS")
				.method_10439(" SP")
				.method_10439("S  ")
				.method_10435("botania:twig_wand")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.PETALS))
				.method_10431(WrapperResult.ofType(WandOfTheForestRecipe.SERIALIZER, consumer));
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.manaTablet)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10439("SSS")
				.method_10439("SPS")
				.method_10439("SSS")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.manaTablet)
				.method_10433('P', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('S', BotaniaBlocks.livingrock)
				.method_10439("SSS")
				.method_10439("SPS")
				.method_10439("SSS")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND))
				.method_17972(consumer, prefix("mana_tablet_alt"));

		class_2447.method_10437(class_7800.field_40638, BotaniaItems.cacophonium)
				.method_10434('N', class_1802.field_8643)
				.method_10434('G', class_1802.field_27022)
				.method_10439(" G ")
				.method_10439("GNG")
				.method_10439("GG ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8643))
				.method_10431(consumer);

		class_2447.method_10437(class_7800.field_40638, BotaniaItems.grassHorn)
				.method_10434('S', BotaniaItems.grassSeeds)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10439(" W ")
				.method_10439("WSW")
				.method_10439("WW ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.LIVINGWOOD_LOGS))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.leavesHorn)
				.method_10454(BotaniaItems.grassHorn)
				.method_10446(class_3489.field_15558)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.grassHorn))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.snowHorn)
				.method_10454(BotaniaItems.grassHorn)
				.method_10454(class_1802.field_8543)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.grassHorn))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.manaMirror)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('R', BotaniaBlocks.livingrock)
				.method_10434('S', BotaniaItems.livingwoodTwig)
				.method_10434('T', BotaniaItems.manaTablet)
				.method_10433('I', BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10439(" PR")
				.method_10439(" SI")
				.method_10439("T  ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaTablet))
				.method_10429("has_alt_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.openBucket)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("E E")
				.method_10439(" E ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.spawnerMover)
				.method_10434('A', BotaniaItems.enderAirBottle)
				.method_10433('D', BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10434('E', BotaniaItems.lifeEssence)
				.method_10433('I', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("EIE")
				.method_10439("ADA")
				.method_10439("EIE")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.slingshot)
				.method_10434('A', BotaniaItems.runeAir)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10439(" TA")
				.method_10439(" TT")
				.method_10439("T  ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeAir))
				.method_10431(consumer);

		registerSimpleArmorSet(consumer, class_1856.method_8106(BotaniaTags.Items.INGOTS_MANASTEEL), "manasteel", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL));
		registerSimpleArmorSet(consumer, class_1856.method_8106(BotaniaTags.Items.INGOTS_ELEMENTIUM), "elementium", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM));
		registerSimpleArmorSet(consumer, class_1856.method_8091(BotaniaItems.manaweaveCloth), "manaweave", conditionsFromItem(BotaniaItems.manaweaveCloth));

		registerTerrasteelUpgradeRecipe(consumer, BotaniaItems.terrasteelHelm, BotaniaItems.manasteelHelm, BotaniaItems.runeSpring);
		registerTerrasteelUpgradeRecipe(consumer, BotaniaItems.terrasteelChest, BotaniaItems.manasteelChest, BotaniaItems.runeSummer);
		registerTerrasteelUpgradeRecipe(consumer, BotaniaItems.terrasteelLegs, BotaniaItems.manasteelLegs, BotaniaItems.runeAutumn);
		registerTerrasteelUpgradeRecipe(consumer, BotaniaItems.terrasteelBoots, BotaniaItems.manasteelBoots, BotaniaItems.runeWinter);

		registerToolSetRecipes(consumer, class_1856.method_8106(BotaniaTags.Items.INGOTS_MANASTEEL), class_1856.method_8091(BotaniaItems.livingwoodTwig),
				conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL), BotaniaItems.manasteelSword, BotaniaItems.manasteelPick, BotaniaItems.manasteelAxe,
				BotaniaItems.manasteelHoe, BotaniaItems.manasteelShovel, BotaniaItems.manasteelShears);
		registerToolSetRecipes(consumer, class_1856.method_8106(BotaniaTags.Items.INGOTS_ELEMENTIUM), class_1856.method_8091(BotaniaItems.dreamwoodTwig),
				conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM), BotaniaItems.elementiumSword, BotaniaItems.elementiumPick, BotaniaItems.elementiumAxe,
				BotaniaItems.elementiumHoe, BotaniaItems.elementiumShovel, BotaniaItems.elementiumShears);

		class_2447.method_10437(class_7800.field_40639, BotaniaItems.terraSword)
				.method_10434('S', BotaniaItems.livingwoodTwig)
				.method_10433('I', BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10439("I")
				.method_10439("I")
				.method_10439("S")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.terraPick)
				.method_10434('T', BotaniaItems.manaTablet)
				.method_10433('I', BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10434('L', BotaniaItems.livingwoodTwig)
				.method_10439("ITI")
				.method_10439("ILI")
				.method_10439(" L ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(WrapperResult.ofType(ManaUpgradeRecipe.SERIALIZER, consumer));
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.terraAxe)
				.method_10434('S', BotaniaItems.livingwoodTwig)
				.method_10433('T', BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10434('G', class_1802.field_8801)
				.method_10439("TTG")
				.method_10439("TST")
				.method_10439(" S ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, BotaniaItems.starSword)
				.method_10434('A', BotaniaItems.enderAirBottle)
				.method_10433('D', BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10434('T', BotaniaItems.terraSword)
				.method_10433('I', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("  I")
				.method_10439("AD ")
				.method_10439("TA ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.terraAxe))
				.method_10429("has_terrasteel", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, BotaniaItems.thunderSword)
				.method_10434('A', BotaniaItems.enderAirBottle)
				.method_10433('D', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('T', BotaniaItems.terraSword)
				.method_10433('I', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("  I")
				.method_10439("AD ")
				.method_10439("TA ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.terraAxe))
				.method_10429("has_terrasteel", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, BotaniaItems.livingwoodBow)
				.method_10434('S', BotaniaItems.manaString)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10439(" TS")
				.method_10439("T S")
				.method_10439(" TS")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaString))
				.method_10429("has_twig", conditionsFromItem(BotaniaItems.livingwoodTwig))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, BotaniaItems.crystalBow)
				.method_10434('S', BotaniaItems.manaString)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10433('D', BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10439(" DS")
				.method_10439("T S")
				.method_10439(" DS")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE))
				.method_10431(consumer);

		class_2447.method_10437(class_7800.field_40639, BotaniaItems.enderDagger)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10433('S', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10439("P")
				.method_10439("S")
				.method_10439("T")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.enderHand)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('E', class_1802.field_8466)
				.method_10434('L', class_1802.field_8745)
				.method_10434('O', class_1802.field_8281)
				.method_10439("PLO")
				.method_10439("LEL")
				.method_10439("OL ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8466))
				.method_10429("has_alt_item", conditionsFromItem(class_1802.field_8449))
				.method_10431(consumer);

		class_2450.method_10448(class_7800.field_40642, BotaniaItems.placeholder, 32)
				.method_10454(class_1802.field_8465)
				.method_10454(BotaniaBlocks.livingrock)
				.method_10442("has_dreamwood", conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS))
				.method_10442("has_crafty_crate", conditionsFromItem(BotaniaBlocks.craftCrate))
				.method_10431(consumer);

		for (CraftyCratePattern pattern : CraftyCratePattern.values()) {
			if (pattern == CraftyCratePattern.NONE) {
				continue;
			}
			class_1792 item = getItemOrThrow(prefix(LibItemNames.CRAFT_PATTERN_PREFIX + pattern.method_15434().split("_", 2)[1]));
			String s = pattern.openSlots.stream().map(bool -> bool ? "R" : "P").collect(Collectors.joining());
			class_2447.method_10437(class_7800.field_40638, item)
					.method_10434('P', BotaniaItems.placeholder)
					.method_10434('R', class_1802.field_8725)
					.method_10439(s.substring(0, 3))
					.method_10439(s.substring(3, 6))
					.method_10439(s.substring(6, 9))
					.method_10435("botania:craft_pattern")
					.method_10429("has_item", conditionsFromItem(BotaniaItems.placeholder))
					.method_10429("has_crafty_crate", conditionsFromItem(BotaniaBlocks.craftCrate))
					.method_10431(consumer);
		}

		class_2447.method_10437(class_7800.field_40638, BotaniaItems.manaGun)
				.method_10434('S', BotaniaBlocks.redstoneSpreader)
				.method_10433('D', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('T', class_1802.field_8626)
				.method_10433('W', BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10434('M', BotaniaItems.runeMana)
				.method_10439("SMD")
				.method_10439(" WT")
				.method_10439("  W")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);

		class_2447.method_10437(class_7800.field_40638, BotaniaItems.dirtRod)
				.method_10434('D', class_1802.field_8831)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10434('E', BotaniaItems.runeEarth)
				.method_10439("  D")
				.method_10439(" T ")
				.method_10439("E  ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeEarth))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.terraformRod)
				.method_10434('A', BotaniaItems.runeAutumn)
				.method_10434('R', BotaniaItems.dirtRod)
				.method_10434('S', BotaniaItems.runeSpring)
				.method_10433('T', BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10434('G', BotaniaItems.grassSeeds)
				.method_10434('W', BotaniaItems.runeWinter)
				.method_10434('M', BotaniaItems.runeSummer)
				.method_10439(" WT")
				.method_10439("ARS")
				.method_10439("GM ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);

		class_2447.method_10437(class_7800.field_40638, BotaniaItems.waterRod)
				.method_10428('B', class_1856.method_8101(class_1844.method_8061(new class_1799(class_1802.field_8574), class_1847.field_8991)))
				.method_10434('R', BotaniaItems.runeWater)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10439("  B")
				.method_10439(" T ")
				.method_10439("R  ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeWater))
				.method_10431(WrapperResult.ofType(WaterBottleMatchingRecipe.SERIALIZER, consumer));

		class_2447.method_10437(class_7800.field_40638, BotaniaItems.rainbowRod)
				.method_10434('P', BotaniaItems.pixieDust)
				.method_10433('D', BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439(" PD")
				.method_10439(" EP")
				.method_10439("E  ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.tornadoRod)
				.method_10434('R', BotaniaItems.runeAir)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10434('F', class_1802.field_8153)
				.method_10439("  F")
				.method_10439(" T ")
				.method_10439("R  ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeAir))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, BotaniaItems.fireRod)
				.method_10434('R', BotaniaItems.runeFire)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10434('F', class_1802.field_8183)
				.method_10439("  F")
				.method_10439(" T ")
				.method_10439("R  ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeFire))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.skyDirtRod)
				.method_10454(BotaniaItems.dirtRod)
				.method_10454(BotaniaItems.pixieDust)
				.method_10454(BotaniaItems.runeAir)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10431(consumer);

		class_2447.method_10437(class_7800.field_40638, BotaniaItems.diviningRod)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10433('D', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10439(" TD")
				.method_10439(" TT")
				.method_10439("T  ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.gravityRod)
				.method_10434('T', BotaniaItems.dreamwoodTwig)
				.method_10433('D', BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10434('W', class_1802.field_8861)
				.method_10439(" TD")
				.method_10439(" WT")
				.method_10439("T  ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_DRAGONSTONE))
				.method_10431(consumer);

		class_2447.method_10437(class_7800.field_40639, BotaniaItems.missileRod)
				.method_10433('D', BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10434('T', BotaniaItems.dreamwoodTwig)
				.method_10434('G', BotaniaItems.lifeEssence)
				.method_10439("GDD")
				.method_10439(" TD")
				.method_10439("T G")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.cobbleRod)
				.method_10434('C', class_1802.field_20412)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10434('F', BotaniaItems.runeFire)
				.method_10434('W', BotaniaItems.runeWater)
				.method_10439(" FC")
				.method_10439(" TW")
				.method_10439("T  ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeFire))
				.method_10429("has_alt_item", conditionsFromItem(BotaniaItems.runeWater))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.smeltRod)
				.method_10434('B', class_1802.field_8894)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10434('F', BotaniaItems.runeFire)
				.method_10439(" BF")
				.method_10439(" TB")
				.method_10439("T  ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeFire))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.exchangeRod)
				.method_10434('R', BotaniaItems.runeSloth)
				.method_10434('S', class_1802.field_20391)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10439(" SR")
				.method_10439(" TS")
				.method_10439("T  ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeSloth))
				.method_10431(consumer);

		class_2447.method_10437(class_7800.field_40638, BotaniaItems.laputaShard)
				.method_10434('P', class_1802.field_8434)
				.method_10434('A', BotaniaItems.runeAir)
				.method_10434('S', BotaniaItems.lifeEssence)
				.method_10433('D', BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10434('E', BotaniaItems.runeEarth)
				.method_10433('F', BotaniaTags.Items.MUNDANE_FLOATING_FLOWERS)
				.method_10439("SFS")
				.method_10439("PDP")
				.method_10439("ASE")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);

		class_2447.method_10437(class_7800.field_40638, BotaniaItems.craftingHalo)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('C', class_1802.field_8465)
				.method_10433('I', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439(" P ")
				.method_10439("ICI")
				.method_10439(" I ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.clip)
				.method_10433('D', BotaniaTags.Items.DREAMWOOD_LOGS)
				.method_10439(" D ")
				.method_10439("D D")
				.method_10439("DD ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.DREAMWOOD_LOGS))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.spellCloth)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('C', BotaniaItems.manaweaveCloth)
				.method_10439(" C ")
				.method_10439("CPC")
				.method_10439(" C ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaweaveCloth))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.flowerBag)
				.method_10433('P', BotaniaTags.Items.PETALS)
				.method_10433('W', class_3489.field_15544)
				.method_10439("WPW")
				.method_10439("W W")
				.method_10439(" W ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.MYSTICAL_FLOWERS))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40637, BotaniaItems.poolMinecart)
				.method_10454(class_1802.field_8045)
				.method_10454(BotaniaBlocks.manaPool)
				.method_10442("has_item", conditionsFromItem(class_1802.field_8045))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.blackHoleTalisman)
				.method_10434('A', BotaniaItems.enderAirBottle)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('G', BotaniaItems.lifeEssence)
				.method_10439(" G ")
				.method_10439("EAE")
				.method_10439(" E ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.temperanceStone)
				.method_10434('R', BotaniaItems.runeEarth)
				.method_10434('S', class_1802.field_20391)
				.method_10439(" S ")
				.method_10439("SRS")
				.method_10439(" S ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeEarth))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.incenseStick)
				.method_10434('B', class_1802.field_8183)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10434('G', class_1802.field_8070)
				.method_10439("  G")
				.method_10439(" B ")
				.method_10439("T  ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8070))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.obedienceStick)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("  M")
				.method_10439(" T ")
				.method_10439("T  ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.slimeBottle)
				.method_10434('S', class_1802.field_8777)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('G', BotaniaBlocks.elfGlass)
				.method_10439("EGE")
				.method_10439("ESE")
				.method_10439(" E ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.autocraftingHalo)
				.method_10454(BotaniaItems.craftingHalo)
				.method_10446(BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10442("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.sextant)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10433('I', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439(" TI")
				.method_10439(" TT")
				.method_10439("III")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.astrolabe)
				.method_10433('D', BotaniaTags.Items.DREAMWOOD_LOGS)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('G', BotaniaItems.lifeEssence)
				.method_10439(" EG")
				.method_10439("EEE")
				.method_10439("GED")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);

	}

	private void registerTrinkets(Consumer<class_2444> consumer) {
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.tinyPlanet)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('S', class_1802.field_20391)
				.method_10434('L', BotaniaBlocks.livingrock)
				.method_10439("LSL")
				.method_10439("SPS")
				.method_10439("LSL")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.manaRing)
				.method_10434('T', BotaniaItems.manaTablet)
				.method_10434('I', BotaniaItems.manaSteel)
				.method_10439("TI ")
				.method_10439("I I")
				.method_10439(" I ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaTablet))
				.method_10431(WrapperResult.ofType(ManaUpgradeRecipe.SERIALIZER, consumer));
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.auraRing)
				.method_10434('R', BotaniaItems.runeMana)
				.method_10433('I', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("RI ")
				.method_10439("I I")
				.method_10439(" I ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.runeMana))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.manaRingGreater)
				.method_10446(BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10454(BotaniaItems.manaRing)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.terrasteel))
				.method_10431(WrapperResult.ofType(ShapelessManaUpgradeRecipe.SERIALIZER, consumer));
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.auraRingGreater)
				.method_10446(BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10454(BotaniaItems.auraRing)
				.method_10442("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.travelBelt)
				.method_10434('A', BotaniaItems.runeAir)
				.method_10433('S', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10434('E', BotaniaItems.runeEarth)
				.method_10434('L', class_1802.field_8745)
				.method_10439("EL ")
				.method_10439("L L")
				.method_10439("SLA")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.knockbackBelt)
				.method_10434('A', BotaniaItems.runeFire)
				.method_10433('S', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10434('E', BotaniaItems.runeEarth)
				.method_10434('L', class_1802.field_8745)
				.method_10439("AL ")
				.method_10439("L L")
				.method_10439("SLE")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.icePendant)
				.method_10434('R', BotaniaItems.runeWater)
				.method_10434('S', BotaniaItems.manaString)
				.method_10434('W', BotaniaItems.runeWinter)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("WS ")
				.method_10439("S S")
				.method_10439("MSR")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.lavaPendant)
				.method_10434('S', BotaniaItems.manaString)
				.method_10433('D', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10434('F', BotaniaItems.runeFire)
				.method_10434('M', BotaniaItems.runeSummer)
				.method_10439("MS ")
				.method_10439("S S")
				.method_10439("DSF")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.magnetRing)
				.method_10434('L', BotaniaItems.lensMagnet)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("LM ")
				.method_10439("M M")
				.method_10439(" M ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.waterRing)
				.method_10434('P', class_1802.field_8323)
				.method_10434('C', class_1802.field_8429)
				.method_10434('H', class_1802.field_8207)
				.method_10434('W', BotaniaItems.runeWater)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("WMP")
				.method_10439("MHM")
				.method_10439("CM ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8207))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.miningRing)
				.method_10434('P', class_1802.field_8335)
				.method_10434('E', BotaniaItems.runeEarth)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("EMP")
				.method_10439("M M")
				.method_10439(" M ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.divaCharm)
				.method_10434('P', BotaniaItems.tinyPlanet)
				.method_10434('G', class_1802.field_8695)
				.method_10434('H', BotaniaItems.runePride)
				.method_10434('L', BotaniaItems.lifeEssence)
				.method_10439("LGP")
				.method_10439(" HG")
				.method_10439(" GL")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.flightTiara)
				.method_10434('E', BotaniaItems.enderAirBottle)
				.method_10434('F', class_1802.field_8153)
				.method_10433('I', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('L', BotaniaItems.lifeEssence)
				.method_10439("LLL")
				.method_10439("ILI")
				.method_10439("FEF")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_36443(consumer, "botania:flighttiara_0");

		// Normal quartz and not Tags.Items.QUARTZ because the recipes conflict.
		class_1792[] items = { class_1802.field_8155, BotaniaItems.darkQuartz, BotaniaItems.manaQuartz, BotaniaItems.blazeQuartz,
				BotaniaItems.lavenderQuartz, BotaniaItems.redQuartz, BotaniaItems.elfQuartz, BotaniaItems.sunnyQuartz };
		for (int i = 0; i < items.length; i++) {
			int tiaraType = i + 1;
			class_2450.method_10447(class_7800.field_40638, BotaniaItems.flightTiara)
					.method_10454(BotaniaItems.flightTiara)
					.method_10454(items[i])
					.method_10452("botania:flight_tiara_wings")
					.method_10442("has_item", conditionsFromItem(BotaniaItems.flightTiara))
					.method_36443(NbtOutputResult.with(consumer, tag -> tag.method_10569("variant", tiaraType)),
							"botania:flighttiara_" + tiaraType);
		}
		class_2447.method_10437(class_7800.field_40639, BotaniaItems.pixieRing)
				.method_10434('D', BotaniaItems.pixieDust)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("DE ")
				.method_10439("E E")
				.method_10439(" E ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.superTravelBelt)
				.method_10434('S', BotaniaItems.travelBelt)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('L', BotaniaItems.lifeEssence)
				.method_10439("E  ")
				.method_10439(" S ")
				.method_10439("L E")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.reachRing)
				.method_10434('R', BotaniaItems.runePride)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10439("RE ")
				.method_10439("E E")
				.method_10439(" E ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.itemFinder)
				.method_10434('E', class_1802.field_8687)
				.method_10434('I', class_1802.field_8620)
				.method_10434('Y', class_1802.field_8449)
				.method_10439(" I ")
				.method_10439("IYI")
				.method_10439("IEI")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8449))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.superLavaPendant)
				.method_10434('P', BotaniaItems.lavaPendant)
				.method_10434('B', class_1802.field_8894)
				.method_10434('G', BotaniaItems.lifeEssence)
				.method_10434('N', class_1802.field_8729)
				.method_10439("BBB")
				.method_10439("BPB")
				.method_10439("NGN")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.bloodPendant)
				.method_10434('P', class_1802.field_8434)
				.method_10433('D', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('G', class_1802.field_8070)
				.method_10439(" P ")
				.method_10439("PGP")
				.method_10439("DP ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8070))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, BotaniaItems.holyCloak)
				.method_10434('S', BotaniaItems.lifeEssence)
				.method_10434('W', class_1802.field_19044)
				.method_10434('G', class_1802.field_8601)
				.method_10439("WWW")
				.method_10439("GWG")
				.method_10439("GSG")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, BotaniaItems.unholyCloak)
				.method_10434('R', class_1802.field_8725)
				.method_10434('S', BotaniaItems.lifeEssence)
				.method_10434('W', class_1802.field_19059)
				.method_10439("WWW")
				.method_10439("RWR")
				.method_10439("RSR")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, BotaniaItems.balanceCloak)
				.method_10434('R', class_1802.field_8687)
				.method_10434('S', BotaniaItems.lifeEssence)
				.method_10434('W', class_1802.field_19052)
				.method_10439("WWW")
				.method_10439("RWR")
				.method_10439("RSR")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.monocle)
				.method_10434('G', BotaniaBlocks.manaGlass)
				.method_10433('I', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10434('N', class_1802.field_8397)
				.method_10439("GN")
				.method_10439("IN")
				.method_10439(" N")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.swapRing)
				.method_10434('C', class_1802.field_19060)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("CM ")
				.method_10439("M M")
				.method_10439(" M ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40638, BotaniaItems.magnetRingGreater)
				.method_10446(BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10454(BotaniaItems.magnetRing)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.magnetRing))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.speedUpBelt)
				.method_10434('P', BotaniaItems.grassSeeds)
				.method_10434('B', BotaniaItems.travelBelt)
				.method_10434('S', class_1802.field_8479)
				.method_10434('M', class_1802.field_8895)
				.method_10439(" M ")
				.method_10439("PBP")
				.method_10439(" S ")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8895))
				.method_10429("has_alt_item", conditionsFromItem(BotaniaItems.travelBelt))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.dodgeRing)
				.method_10434('R', BotaniaItems.runeAir)
				.method_10434('E', class_1802.field_8687)
				.method_10433('M', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10439("EM ")
				.method_10439("M M")
				.method_10439(" MR")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_MANASTEEL))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.invisibilityCloak)
				.method_10434('P', BotaniaItems.manaPearl)
				.method_10434('C', class_1802.field_8434)
				.method_10434('W', class_1802.field_19044)
				.method_10434('G', BotaniaBlocks.manaGlass)
				.method_10439("CWC")
				.method_10439("GWG")
				.method_10439("GPG")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaPearl))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.cloudPendant)
				.method_10434('S', BotaniaItems.manaString)
				.method_10433('D', BotaniaTags.Items.INGOTS_MANASTEEL)
				.method_10434('F', BotaniaItems.runeAir)
				.method_10434('M', BotaniaItems.runeAutumn)
				.method_10439("MS ")
				.method_10439("S S")
				.method_10439("DSF")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaString))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.superCloudPendant)
				.method_10434('P', BotaniaItems.cloudPendant)
				.method_10434('B', class_1802.field_8070)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10434('G', BotaniaItems.lifeEssence)
				.method_10434('N', class_1802.field_19044)
				.method_10439("BEB")
				.method_10439("BPB")
				.method_10439("NGN")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.cloudPendant))
				.method_10429("has_alt_item", conditionsFromItem(BotaniaItems.lifeEssence))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.thirdEye)
				.method_10434('Q', class_1802.field_20402)
				.method_10434('R', class_1802.field_8071)
				.method_10434('S', BotaniaItems.runeEarth)
				.method_10433('D', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10434('E', class_1802.field_8449)
				.method_10439("RSR")
				.method_10439("QEQ")
				.method_10439("RDR")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, BotaniaItems.goddessCharm)
				.method_10433('P', BotaniaTags.Items.PETALS_PINK)
				.method_10434('A', BotaniaItems.runeWater)
				.method_10434('S', BotaniaItems.runeSpring)
				.method_10433('D', BotaniaTags.Items.GEMS_MANA_DIAMOND)
				.method_10439(" P ")
				.method_10439(" P ")
				.method_10439("ADS")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.GEMS_MANA_DIAMOND))
				.method_10431(consumer);

	}

	private void registerCorporeaAndRedString(Consumer<class_2444> consumer) {
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.redString)
				.method_10454(class_1802.field_8276)
				.method_10454(class_1802.field_8793)
				.method_10454(BotaniaItems.pixieDust)
				.method_10454(BotaniaItems.enderAirBottle)
				.method_10452("botania:red_string")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.enderAirBottle))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.redString)
				.method_10454(class_1802.field_8276)
				.method_10454(class_1802.field_8793)
				.method_10454(BotaniaItems.pixieDust)
				.method_10454(BotaniaItems.enderAirBottle)
				.method_10454(class_1802.field_17518)
				.method_10452("botania:red_string")
				.method_10442("has_item", conditionsFromItem(BotaniaItems.enderAirBottle))
				.method_36443(consumer, "botania:red_string_alt");
		registerRedStringBlock(consumer, BotaniaBlocks.redStringDispenser, class_1856.method_8091(class_1802.field_8357), conditionsFromItem(class_1802.field_8357));
		registerRedStringBlock(consumer, BotaniaBlocks.redStringFertilizer, class_1856.method_8091(BotaniaItems.fertilizer), conditionsFromItem(BotaniaItems.fertilizer));
		registerRedStringBlock(consumer, BotaniaBlocks.redStringComparator, class_1856.method_8091(class_1802.field_8857), conditionsFromItem(class_1802.field_8857));
		registerRedStringBlock(consumer, BotaniaBlocks.redStringRelay, class_1856.method_8091(BotaniaBlocks.manaSpreader), conditionsFromItem(BotaniaBlocks.manaSpreader));
		registerRedStringBlock(consumer, BotaniaBlocks.redStringInterceptor, class_1856.method_8091(class_1802.field_8781), conditionsFromItem(class_1802.field_8781));
		class_2450.method_10448(class_7800.field_40636, BotaniaItems.corporeaSpark, 4)
				.method_10454(BotaniaItems.spark)
				.method_10454(BotaniaItems.pixieDust)
				.method_10454(BotaniaItems.enderAirBottle)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.enderAirBottle))
				.method_10442("has_alt_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40636, BotaniaItems.corporeaSparkMaster)
				.method_10454(BotaniaItems.corporeaSpark)
				.method_10446(BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.corporeaSpark))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.corporeaIndex)
				.method_10434('A', BotaniaItems.enderAirBottle)
				.method_10434('S', BotaniaItems.corporeaSpark)
				.method_10433('D', BotaniaTags.Items.GEMS_DRAGONSTONE)
				.method_10434('O', class_1802.field_8281)
				.method_10439("AOA")
				.method_10439("OSO")
				.method_10439("DOD")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.corporeaSpark))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40636, BotaniaBlocks.corporeaFunnel)
				.method_10454(class_1802.field_8878)
				.method_10454(BotaniaItems.corporeaSpark)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.corporeaSpark))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40636, BotaniaBlocks.corporeaInterceptor)
				.method_10454(class_1802.field_8793)
				.method_10454(BotaniaItems.corporeaSpark)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.corporeaSpark))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40636, BotaniaBlocks.corporeaCrystalCube)
				.method_10434('C', BotaniaItems.corporeaSpark)
				.method_10434('G', BotaniaBlocks.elfGlass)
				.method_10433('W', BotaniaTags.Items.DREAMWOOD_LOGS)
				.method_10439("C")
				.method_10439("G")
				.method_10439("W")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.corporeaSpark))
				.method_10431(consumer);
		class_2450.method_10448(class_7800.field_40634, BotaniaBlocks.corporeaBlock, 8)
				.method_10454(BotaniaBlocks.livingrockPolished)
				.method_10454(BotaniaItems.corporeaSpark)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.corporeaSpark))
				.method_10431(consumer);
		slabShape(BotaniaBlocks.corporeaSlab, BotaniaBlocks.corporeaBlock).method_10431(consumer);
		stairs(BotaniaBlocks.corporeaStairs, BotaniaBlocks.corporeaBlock).method_10431(consumer);
		class_2447.method_10436(class_7800.field_40634, BotaniaBlocks.corporeaBrick, 4)
				.method_10434('R', BotaniaBlocks.corporeaBlock)
				.method_10439("RR")
				.method_10439("RR")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.corporeaBlock))
				.method_10431(consumer);
		slabShape(BotaniaBlocks.corporeaBrickSlab, BotaniaBlocks.corporeaBrick).method_10431(consumer);
		stairs(BotaniaBlocks.corporeaBrickStairs, BotaniaBlocks.corporeaBrick).method_10431(consumer);
		wallShape(BotaniaBlocks.corporeaBrickWall, BotaniaBlocks.corporeaBrick, 6).method_10431(consumer);
	}

	private void registerLenses(Consumer<class_2444> consumer) {
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensSpeed)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaItems.runeAir)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensPower)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaItems.runeFire)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensTime)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaItems.runeEarth)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensEfficiency)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaItems.runeWater)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensBounce)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaItems.runeSummer)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensGravity)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaItems.runeWinter)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.lensMine)
				.method_10434('P', class_1802.field_8249)
				.method_10434('A', class_1802.field_8759)
				.method_10434('R', class_1802.field_8725)
				.method_10434('L', BotaniaItems.lensNormal)
				.method_10439(" P ")
				.method_10439("ALA")
				.method_10439(" R ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensDamage)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaItems.runeWrath)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensPhantom)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaBlocks.abstrusePlatform)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensMagnet)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(class_1802.field_8620)
				.method_10454(class_1802.field_8695)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensExplosive)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaItems.runeEnvy)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.lensInfluence)
				.method_10434('P', class_1802.field_8434)
				.method_10434('R', BotaniaItems.runeAir)
				.method_10434('L', BotaniaItems.lensNormal)
				.method_10439("PRP")
				.method_10439("PLP")
				.method_10439("PPP")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.lensWeight)
				.method_10434('P', class_1802.field_8434)
				.method_10434('R', BotaniaItems.runeWater)
				.method_10434('L', BotaniaItems.lensNormal)
				.method_10439("PPP")
				.method_10439("PLP")
				.method_10439("PRP")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.lensPaint)
				.method_10433('E', BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10433('W', class_3489.field_15544)
				.method_10434('L', BotaniaItems.lensNormal)
				.method_10439(" E ")
				.method_10439("WLW")
				.method_10439(" E ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensFire)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(class_1802.field_8814)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensPiston)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaBlocks.pistonRelay)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.lensLight)
				.method_10434('F', class_1802.field_8814)
				.method_10434('G', class_1802.field_8801)
				.method_10434('L', BotaniaItems.lensNormal)
				.method_10439("GFG")
				.method_10439("FLF")
				.method_10439("GFG")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.lensLight)
				.method_10434('F', class_1802.field_8814)
				.method_10434('G', class_1802.field_8801)
				.method_10434('L', BotaniaItems.lensNormal)
				.method_10439("FGF")
				.method_10439("GLG")
				.method_10439("FGF")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_36443(consumer, "botania:lens_light_alt");
		class_2447.method_10437(class_7800.field_40642, BotaniaItems.lensMessenger)
				.method_10434('P', class_1802.field_8407)
				.method_10434('L', BotaniaItems.lensNormal)
				.method_10439(" P ")
				.method_10439("PLP")
				.method_10439(" P ")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.lensNormal))
				.method_10431(consumer);

		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensWarp)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaItems.pixieDust)
				.method_10442("has_item", conditionsFromItem(BotaniaItems.pixieDust))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensRedirect)
				.method_10454(BotaniaItems.lensNormal)
				.method_10446(BotaniaTags.Items.LIVINGWOOD_LOGS)
				.method_10446(BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10442("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensFirework)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(class_1802.field_8639)
				.method_10446(BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10442("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensFlare)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(BotaniaBlocks.elfGlass)
				.method_10446(BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10442("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40642, BotaniaItems.lensTripwire)
				.method_10454(BotaniaItems.lensNormal)
				.method_10454(class_1802.field_8366)
				.method_10446(BotaniaTags.Items.INGOTS_ELEMENTIUM)
				.method_10442("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_ELEMENTIUM))
				.method_10431(consumer);
	}

	private void registerFloatingFlowers(Consumer<class_2444> consumer) {
		for (class_2248 block : new class_2248[] {
				BotaniaFlowerBlocks.pureDaisy, BotaniaFlowerBlocks.manastar, BotaniaFlowerBlocks.hydroangeas, BotaniaFlowerBlocks.endoflame,
				BotaniaFlowerBlocks.thermalily, BotaniaFlowerBlocks.rosaArcana, BotaniaFlowerBlocks.munchdew, BotaniaFlowerBlocks.entropinnyum,
				BotaniaFlowerBlocks.kekimurus, BotaniaFlowerBlocks.gourmaryllis, BotaniaFlowerBlocks.narslimmus, BotaniaFlowerBlocks.spectrolus,
				BotaniaFlowerBlocks.dandelifeon, BotaniaFlowerBlocks.rafflowsia, BotaniaFlowerBlocks.shulkMeNot, BotaniaFlowerBlocks.bellethorn,
				BotaniaFlowerBlocks.bellethornChibi, BotaniaFlowerBlocks.bergamute, BotaniaFlowerBlocks.dreadthorn, BotaniaFlowerBlocks.heiseiDream,
				BotaniaFlowerBlocks.tigerseye, BotaniaFlowerBlocks.jadedAmaranthus, BotaniaFlowerBlocks.orechid, BotaniaFlowerBlocks.fallenKanade,
				BotaniaFlowerBlocks.exoflame, BotaniaFlowerBlocks.agricarnation, BotaniaFlowerBlocks.agricarnationChibi, BotaniaFlowerBlocks.hopperhock,
				BotaniaFlowerBlocks.hopperhockChibi, BotaniaFlowerBlocks.tangleberrie, BotaniaFlowerBlocks.tangleberrieChibi,
				BotaniaFlowerBlocks.jiyuulia, BotaniaFlowerBlocks.jiyuuliaChibi, BotaniaFlowerBlocks.rannuncarpus, BotaniaFlowerBlocks.rannuncarpusChibi,
				BotaniaFlowerBlocks.hyacidus, BotaniaFlowerBlocks.pollidisiac, BotaniaFlowerBlocks.clayconia,
				BotaniaFlowerBlocks.clayconiaChibi, BotaniaFlowerBlocks.loonium, BotaniaFlowerBlocks.daffomill, BotaniaFlowerBlocks.vinculotus,
				BotaniaFlowerBlocks.spectranthemum, BotaniaFlowerBlocks.medumone, BotaniaFlowerBlocks.marimorphosis, BotaniaFlowerBlocks.marimorphosisChibi,
				BotaniaFlowerBlocks.bubbell, BotaniaFlowerBlocks.bubbellChibi, BotaniaFlowerBlocks.solegnolia, BotaniaFlowerBlocks.solegnoliaChibi,
				BotaniaFlowerBlocks.orechidIgnem, BotaniaFlowerBlocks.labellia }) {
			createFloatingFlowerRecipe(consumer, block);
		}
	}

	private void registerConversions(Consumer<class_2444> consumer) {
		compression(BotaniaItems.manaSteel, BotaniaTags.Items.NUGGETS_MANASTEEL)
				.method_17972(consumer, prefix("conversions/manasteel_from_nuggets"));
		compression(BotaniaItems.elementium, BotaniaTags.Items.NUGGETS_ELEMENTIUM)
				.method_17972(consumer, prefix("conversions/elementium_from_nuggets"));
		compression(BotaniaItems.terrasteel, BotaniaTags.Items.NUGGETS_TERRASTEEL)
				.method_17972(consumer, prefix("conversions/terrasteel_from_nugget"));
		compression(BotaniaBlocks.manasteelBlock, BotaniaTags.Items.INGOTS_MANASTEEL).method_10431(consumer);
		compression(BotaniaBlocks.terrasteelBlock, BotaniaTags.Items.INGOTS_TERRASTEEL).method_10431(consumer);
		compression(BotaniaBlocks.elementiumBlock, BotaniaTags.Items.INGOTS_ELEMENTIUM).method_10431(consumer);
		compression(BotaniaBlocks.manaDiamondBlock, BotaniaTags.Items.GEMS_MANA_DIAMOND).method_10431(consumer);
		compression(BotaniaBlocks.dragonstoneBlock, BotaniaTags.Items.GEMS_DRAGONSTONE).method_10431(consumer);

		MutableObject<class_2444> base = new MutableObject<>();
		MutableObject<class_2444> gog = new MutableObject<>();
		compression(BotaniaBlocks.blazeBlock, class_1802.field_8894).method_10431(base::setValue);
		class_2447.method_10437(class_7800.field_40634, BotaniaBlocks.blazeBlock)
				.method_10434('I', class_1802.field_8183)
				.method_10439("III")
				.method_10439("III")
				.method_10439("III")
				.method_10429("has_item", conditionsFromItem(class_1802.field_8183))
				.method_10431(gog::setValue);
		consumer.accept(new GogAlternationResult(gog.getValue(), base.getValue()));

		deconstructPetalBlock(consumer, BotaniaItems.whitePetal, BotaniaBlocks.petalBlockWhite);
		deconstructPetalBlock(consumer, BotaniaItems.orangePetal, BotaniaBlocks.petalBlockOrange);
		deconstructPetalBlock(consumer, BotaniaItems.magentaPetal, BotaniaBlocks.petalBlockMagenta);
		deconstructPetalBlock(consumer, BotaniaItems.lightBluePetal, BotaniaBlocks.petalBlockLightBlue);
		deconstructPetalBlock(consumer, BotaniaItems.yellowPetal, BotaniaBlocks.petalBlockYellow);
		deconstructPetalBlock(consumer, BotaniaItems.limePetal, BotaniaBlocks.petalBlockLime);
		deconstructPetalBlock(consumer, BotaniaItems.pinkPetal, BotaniaBlocks.petalBlockPink);
		deconstructPetalBlock(consumer, BotaniaItems.grayPetal, BotaniaBlocks.petalBlockGray);
		deconstructPetalBlock(consumer, BotaniaItems.lightGrayPetal, BotaniaBlocks.petalBlockSilver);
		deconstructPetalBlock(consumer, BotaniaItems.cyanPetal, BotaniaBlocks.petalBlockCyan);
		deconstructPetalBlock(consumer, BotaniaItems.purplePetal, BotaniaBlocks.petalBlockPurple);
		deconstructPetalBlock(consumer, BotaniaItems.bluePetal, BotaniaBlocks.petalBlockBlue);
		deconstructPetalBlock(consumer, BotaniaItems.brownPetal, BotaniaBlocks.petalBlockBrown);
		deconstructPetalBlock(consumer, BotaniaItems.greenPetal, BotaniaBlocks.petalBlockGreen);
		deconstructPetalBlock(consumer, BotaniaItems.redPetal, BotaniaBlocks.petalBlockRed);
		deconstructPetalBlock(consumer, BotaniaItems.blackPetal, BotaniaBlocks.petalBlockBlack);

		deconstruct(base::setValue, class_1802.field_8894, BotaniaBlocks.blazeBlock, "blazeblock_deconstruct");
		deconstruct(gog::setValue, class_1802.field_8183, BotaniaBlocks.blazeBlock, "blazeblock_deconstruct");
		consumer.accept(new GogAlternationResult(gog.getValue(), base.getValue()));
		deconstruct(consumer, BotaniaItems.manaSteel, BotaniaTags.Items.BLOCKS_MANASTEEL, "manasteel_block_deconstruct");
		deconstruct(consumer, BotaniaItems.manaDiamond, BotaniaBlocks.manaDiamondBlock, "manadiamond_block_deconstruct");
		deconstruct(consumer, BotaniaItems.terrasteel, BotaniaTags.Items.BLOCKS_TERRASTEEL, "terrasteel_block_deconstruct");
		deconstruct(consumer, BotaniaItems.elementium, BotaniaTags.Items.BLOCKS_ELEMENTIUM, "elementium_block_deconstruct");
		deconstruct(consumer, BotaniaItems.dragonstone, BotaniaBlocks.dragonstoneBlock, "dragonstone_block_deconstruct");
		deconstruct(consumer, BotaniaItems.manasteelNugget, BotaniaTags.Items.INGOTS_MANASTEEL, "manasteel_to_nuggets");
		deconstruct(consumer, BotaniaItems.terrasteelNugget, BotaniaTags.Items.INGOTS_TERRASTEEL, "terrasteel_to_nugget");
		deconstruct(consumer, BotaniaItems.elementiumNugget, BotaniaTags.Items.INGOTS_ELEMENTIUM, "elementium_to_nuggets");

		recombineSlab(consumer, BotaniaBlocks.livingrock, BotaniaBlocks.livingrockSlab);
		recombineSlab(consumer, BotaniaBlocks.livingrockPolished, BotaniaBlocks.livingrockPolishedSlab);
		recombineSlab(consumer, BotaniaBlocks.livingrockBrick, BotaniaBlocks.livingrockBrickSlab);
		recombineSlab(consumer, BotaniaBlocks.livingwood, BotaniaBlocks.livingwoodSlab);
		recombineSlab(consumer, BotaniaBlocks.livingwoodPlanks, BotaniaBlocks.livingwoodPlankSlab);
		recombineSlab(consumer, BotaniaBlocks.dreamwood, BotaniaBlocks.dreamwoodSlab);
		recombineSlab(consumer, BotaniaBlocks.dreamwoodPlanks, BotaniaBlocks.dreamwoodPlankSlab);
		recombineSlab(consumer, BotaniaBlocks.shimmerrock, BotaniaBlocks.shimmerrockSlab);
		recombineSlab(consumer, BotaniaBlocks.shimmerwoodPlanks, BotaniaBlocks.shimmerwoodPlankSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeStoneForest, BotaniaBlocks.biomeStoneForestSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeBrickForest, BotaniaBlocks.biomeBrickForestSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeCobblestoneForest, BotaniaBlocks.biomeCobblestoneForestSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeStonePlains, BotaniaBlocks.biomeStonePlainsSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeBrickPlains, BotaniaBlocks.biomeBrickPlainsSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeCobblestonePlains, BotaniaBlocks.biomeCobblestonePlainsSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeStoneMountain, BotaniaBlocks.biomeStoneMountainSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeBrickMountain, BotaniaBlocks.biomeBrickMountainSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeCobblestoneMountain, BotaniaBlocks.biomeCobblestoneMountainSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeStoneFungal, BotaniaBlocks.biomeStoneFungalSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeBrickFungal, BotaniaBlocks.biomeBrickFungalSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeCobblestoneFungal, BotaniaBlocks.biomeCobblestoneFungalSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeStoneSwamp, BotaniaBlocks.biomeStoneSwampSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeBrickSwamp, BotaniaBlocks.biomeBrickSwampSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeCobblestoneSwamp, BotaniaBlocks.biomeCobblestoneSwampSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeStoneDesert, BotaniaBlocks.biomeStoneDesertSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeBrickDesert, BotaniaBlocks.biomeBrickDesertSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeCobblestoneDesert, BotaniaBlocks.biomeCobblestoneDesertSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeStoneTaiga, BotaniaBlocks.biomeStoneTaigaSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeBrickTaiga, BotaniaBlocks.biomeBrickTaigaSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeCobblestoneTaiga, BotaniaBlocks.biomeCobblestoneTaigaSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeStoneMesa, BotaniaBlocks.biomeStoneMesaSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeBrickMesa, BotaniaBlocks.biomeBrickMesaSlab);
		recombineSlab(consumer, BotaniaBlocks.biomeCobblestoneMesa, BotaniaBlocks.biomeCobblestoneMesaSlab);
		recombineSlab(consumer, BotaniaBlocks.whitePavement, BotaniaBlocks.whitePavementSlab);
		recombineSlab(consumer, BotaniaBlocks.blackPavement, BotaniaBlocks.blackPavementSlab);
		recombineSlab(consumer, BotaniaBlocks.bluePavement, BotaniaBlocks.bluePavementSlab);
		recombineSlab(consumer, BotaniaBlocks.yellowPavement, BotaniaBlocks.yellowPavementSlab);
		recombineSlab(consumer, BotaniaBlocks.redPavement, BotaniaBlocks.redPavementSlab);
		recombineSlab(consumer, BotaniaBlocks.greenPavement, BotaniaBlocks.greenPavementSlab);
		recombineSlab(consumer, BotaniaBlocks.darkQuartz, BotaniaBlocks.darkQuartzSlab);
		recombineSlab(consumer, BotaniaBlocks.manaQuartz, BotaniaBlocks.manaQuartzSlab);
		recombineSlab(consumer, BotaniaBlocks.blazeQuartz, BotaniaBlocks.blazeQuartzSlab);
		recombineSlab(consumer, BotaniaBlocks.lavenderQuartz, BotaniaBlocks.lavenderQuartzSlab);
		recombineSlab(consumer, BotaniaBlocks.redQuartz, BotaniaBlocks.redQuartzSlab);
		recombineSlab(consumer, BotaniaBlocks.elfQuartz, BotaniaBlocks.elfQuartzSlab);
		recombineSlab(consumer, BotaniaBlocks.sunnyQuartz, BotaniaBlocks.sunnyQuartzSlab);
		recombineSlab(consumer, BotaniaBlocks.corporeaBlock, BotaniaBlocks.corporeaSlab);
		recombineSlab(consumer, BotaniaBlocks.corporeaBrick, BotaniaBlocks.corporeaBrickSlab);
	}

	private void registerDecor(Consumer<class_2444> consumer) {
		class_2447.method_10436(class_7800.field_40634, BotaniaBlocks.livingrockPolished, 4)
				.method_10434('R', BotaniaBlocks.livingrock)
				.method_10439("RR")
				.method_10439("RR")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.livingrock))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40634, BotaniaBlocks.livingrockSlate)
				.method_10434('R', BotaniaBlocks.livingrockSlab)
				.method_10439("R")
				.method_10439("R")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.livingrock))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40634, BotaniaBlocks.livingrockBrick, 4)
				.method_10434('R', BotaniaBlocks.livingrockPolished)
				.method_10439("RR")
				.method_10439("RR")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.livingrockPolished))
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40634, BotaniaBlocks.livingrockBrickChiseled)
				.method_10434('R', BotaniaBlocks.livingrockBrickSlab)
				.method_10439("R")
				.method_10439("R")
				.method_10429("has_item", conditionsFromItem(BotaniaBlocks.livingrockBrick))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, BotaniaBlocks.livingrockBrickMossy)
				.method_10454(BotaniaBlocks.livingrockBrick)
				.method_10454(class_1802.field_28654)
				.method_10442("has_item", conditionsFromItem(BotaniaBlocks.livingrockBrick))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, BotaniaBlocks.livingrockBrickMossy)
				.method_10454(BotaniaBlocks.livingrockBrick)
				.method_10454(class_1802.field_17523)
				.method_10442("has_item", conditionsFromItem(BotaniaBlocks.livingrockBrick))
				.method_36443(consumer, "botania:mossy_livingrock_bricks_vine");
		class_2450.method_10447(class_7800.field_40634, BotaniaBlocks.shimmerrock)
				.method_10454(BotaniaBlocks.livingrock)
				.method_10454(BotaniaBlocks.bifrostPerm)
				.method_10442("has_item", conditionsFromItem(BotaniaBlocks.bifrostPerm))
				.method_10442("has_alt_item", conditionsFromItem(BotaniaItems.rainbowRod))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, BotaniaBlocks.shimmerwoodPlanks)
				.method_10454(BotaniaBlocks.dreamwoodPlanks)
				.method_10454(BotaniaBlocks.bifrostPerm)
				.method_10442("has_item", conditionsFromItem(BotaniaBlocks.bifrostPerm))
				.method_10442("has_alt_item", conditionsFromItem(BotaniaItems.rainbowRod))
				.method_10431(consumer);

		registerForQuartz(consumer, LibBlockNames.QUARTZ_DARK, BotaniaItems.darkQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_MANA, BotaniaItems.manaQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_BLAZE, BotaniaItems.blazeQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_LAVENDER, BotaniaItems.lavenderQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_RED, BotaniaItems.redQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_ELF, BotaniaItems.elfQuartz);
		registerForQuartz(consumer, LibBlockNames.QUARTZ_SUNNY, BotaniaItems.sunnyQuartz);

		registerForWood(consumer, LibBlockNames.LIVING_WOOD);
		registerForWood(consumer, LibBlockNames.DREAM_WOOD);

		stairs(BotaniaBlocks.livingrockStairs, BotaniaBlocks.livingrock).method_10431(consumer);
		slabShape(BotaniaBlocks.livingrockSlab, BotaniaBlocks.livingrock).method_10431(consumer);
		wallShape(BotaniaBlocks.livingrockWall, BotaniaBlocks.livingrock, 6).method_10431(consumer);

		stairs(BotaniaBlocks.livingrockPolishedStairs, BotaniaBlocks.livingrockPolished).method_10431(consumer);
		slabShape(BotaniaBlocks.livingrockPolishedSlab, BotaniaBlocks.livingrockPolished).method_10431(consumer);
		wallShape(BotaniaBlocks.livingrockPolishedWall, BotaniaBlocks.livingrockPolished, 6).method_10431(consumer);

		stairs(BotaniaBlocks.livingrockBrickStairs, BotaniaBlocks.livingrockBrick).method_10431(consumer);
		slabShape(BotaniaBlocks.livingrockBrickSlab, BotaniaBlocks.livingrockBrick).method_10431(consumer);
		wallShape(BotaniaBlocks.livingrockBrickWall, BotaniaBlocks.livingrockBrick, 6).method_10431(consumer);

		stairs(BotaniaBlocks.livingrockBrickMossyStairs, BotaniaBlocks.livingrockBrickMossy).method_10431(consumer);
		slabShape(BotaniaBlocks.livingrockBrickMossySlab, BotaniaBlocks.livingrockBrickMossy).method_10431(consumer);
		wallShape(BotaniaBlocks.livingrockBrickMossyWall, BotaniaBlocks.livingrockBrickMossy, 6).method_10431(consumer);

		stairs(BotaniaBlocks.shimmerrockStairs, BotaniaBlocks.shimmerrock).method_10431(consumer);
		slabShape(BotaniaBlocks.shimmerrockSlab, BotaniaBlocks.shimmerrock).method_10431(consumer);
		stairs(BotaniaBlocks.shimmerwoodPlankStairs, BotaniaBlocks.shimmerwoodPlanks).method_10431(consumer);
		slabShape(BotaniaBlocks.shimmerwoodPlankSlab, BotaniaBlocks.shimmerwoodPlanks).method_10431(consumer);

		for (String variant : LibBlockNames.METAMORPHIC_VARIANTS) {
			registerForMetamorphic(consumer, variant);
		}

		class_1792[] pavementIngredients = { class_1802.field_8162, class_1802.field_8713, class_1802.field_8759, class_1802.field_8725, class_1802.field_8861, class_1802.field_8777 };
		for (int i = 0; i < pavementIngredients.length; i++) {
			registerForPavement(consumer, LibBlockNames.PAVEMENT_VARIANTS[i], pavementIngredients[i]);
		}

		wallShape(BotaniaBlocks.managlassPane, BotaniaBlocks.manaGlass, 16).method_10431(consumer);
		wallShape(BotaniaBlocks.alfglassPane, BotaniaBlocks.elfGlass, 16).method_10431(consumer);
		wallShape(BotaniaBlocks.bifrostPane, BotaniaBlocks.bifrostPerm, 16).method_10431(consumer);

		// azulejo0 recipe in loader-specific datagen

		List<class_1792> allAzulejos = IntStream.range(0, 16).mapToObj(i -> "azulejo_" + i)
				.map(ResourceLocationHelper::prefix)
				.map(class_7923.field_41178::method_10223)
				.toList();
		for (int i = 0; i < allAzulejos.size(); i++) {
			int resultIndex = (i + 1) % allAzulejos.size();
			String recipeName = "azulejo_" + resultIndex;
			if (resultIndex == 0) {
				recipeName += "_alt";
			}
			class_2450.method_10447(class_7800.field_40634, allAzulejos.get(resultIndex))
					.method_10454(allAzulejos.get(i))
					.method_10442("has_azulejo", conditionsFromItem(BotaniaBlocks.azulejo0))
					.method_10452("botania:azulejo_cycling")
					.method_17972(consumer, prefix(recipeName));
		}

		cosmeticBauble(consumer, BotaniaItems.blackBowtie, BotaniaItems.whitePetal);
		cosmeticBauble(consumer, BotaniaItems.blackTie, BotaniaItems.orangePetal);
		cosmeticBauble(consumer, BotaniaItems.redGlasses, BotaniaItems.magentaPetal);
		cosmeticBauble(consumer, BotaniaItems.puffyScarf, BotaniaItems.lightBluePetal);
		cosmeticBauble(consumer, BotaniaItems.engineerGoggles, BotaniaItems.yellowPetal);
		cosmeticBauble(consumer, BotaniaItems.eyepatch, BotaniaItems.limePetal);
		cosmeticBauble(consumer, BotaniaItems.wickedEyepatch, BotaniaItems.pinkPetal);
		cosmeticBauble(consumer, BotaniaItems.redRibbons, BotaniaItems.grayPetal);
		cosmeticBauble(consumer, BotaniaItems.pinkFlowerBud, BotaniaItems.lightGrayPetal);
		cosmeticBauble(consumer, BotaniaItems.polkaDottedBows, BotaniaItems.cyanPetal);
		cosmeticBauble(consumer, BotaniaItems.blueButterfly, BotaniaItems.purplePetal);
		cosmeticBauble(consumer, BotaniaItems.catEars, BotaniaItems.bluePetal);
		cosmeticBauble(consumer, BotaniaItems.witchPin, BotaniaItems.brownPetal);
		cosmeticBauble(consumer, BotaniaItems.devilTail, BotaniaItems.greenPetal);
		cosmeticBauble(consumer, BotaniaItems.kamuiEye, BotaniaItems.redPetal);
		cosmeticBauble(consumer, BotaniaItems.googlyEyes, BotaniaItems.blackPetal);
		cosmeticBauble(consumer, BotaniaItems.fourLeafClover, class_1802.field_8446);
		cosmeticBauble(consumer, BotaniaItems.clockEye, class_1802.field_8492);
		cosmeticBauble(consumer, BotaniaItems.unicornHorn, class_1802.field_8669);
		cosmeticBauble(consumer, BotaniaItems.devilHorns, class_1802.field_8273);
		cosmeticBauble(consumer, BotaniaItems.hyperPlus, class_1802.field_8192);
		cosmeticBauble(consumer, BotaniaItems.botanistEmblem, class_1802.field_8131);
		cosmeticBauble(consumer, BotaniaItems.ancientMask, class_1802.field_8330);
		cosmeticBauble(consumer, BotaniaItems.eerieMask, class_1802.field_8298);
		cosmeticBauble(consumer, BotaniaItems.alienAntenna, class_1802.field_8851);
		cosmeticBauble(consumer, BotaniaItems.anaglyphGlasses, class_1802.field_8632);
		cosmeticBauble(consumer, BotaniaItems.orangeShades, class_1802.field_8296);
		cosmeticBauble(consumer, BotaniaItems.grouchoGlasses, class_1802.field_8345);
		cosmeticBauble(consumer, BotaniaItems.thickEyebrows, class_1802.field_8099);
		cosmeticBauble(consumer, BotaniaItems.lusitanicShield, class_1802.field_8408);
		cosmeticBauble(consumer, BotaniaItems.tinyPotatoMask, class_1802.field_8264);
		cosmeticBauble(consumer, BotaniaItems.questgiverMark, class_1802.field_8226);
		cosmeticBauble(consumer, BotaniaItems.thinkingHand, BotaniaBlocks.tinyPotato);
	}

	protected void registerSimpleArmorSet(Consumer<class_2444> consumer, class_1856 item, String variant,
			class_184 criterion) {
		class_1792 helmet = getItemOrThrow(prefix(variant + "_helmet"));
		class_1792 chestplate = getItemOrThrow(prefix(variant + "_chestplate"));
		class_1792 leggings = getItemOrThrow(prefix(variant + "_leggings"));
		class_1792 boots = getItemOrThrow(prefix(variant + "_boots"));
		class_2447.method_10437(class_7800.field_40639, helmet)
				.method_10428('S', item)
				.method_10439("SSS")
				.method_10439("S S")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, chestplate)
				.method_10428('S', item)
				.method_10439("S S")
				.method_10439("SSS")
				.method_10439("SSS")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, leggings)
				.method_10428('S', item)
				.method_10439("SSS")
				.method_10439("S S")
				.method_10439("S S")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, boots)
				.method_10428('S', item)
				.method_10439("S S")
				.method_10439("S S")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
	}

	protected void registerToolSetRecipes(Consumer<class_2444> consumer, class_1856 item, class_1856 stick,
			class_184 criterion, class_1935 sword, class_1935 pickaxe,
			class_1935 axe, class_1935 hoe, class_1935 shovel, class_1935 shears) {
		class_2447.method_10437(class_7800.field_40638, pickaxe)
				.method_10428('S', item)
				.method_10428('T', stick)
				.method_10439("SSS")
				.method_10439(" T ")
				.method_10439(" T ")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, shovel)
				.method_10428('S', item)
				.method_10428('T', stick)
				.method_10439("S")
				.method_10439("T")
				.method_10439("T")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, axe)
				.method_10428('S', item)
				.method_10428('T', stick)
				.method_10439("SS")
				.method_10439("ST")
				.method_10439(" T")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, hoe)
				.method_10428('S', item)
				.method_10428('T', stick)
				.method_10439("SS")
				.method_10439(" T")
				.method_10439(" T")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40639, sword)
				.method_10428('S', item)
				.method_10428('T', stick)
				.method_10439("S")
				.method_10439("S")
				.method_10439("T")
				.method_10429("has_item", criterion)
				.method_10431(consumer);
		class_2447.method_10437(class_7800.field_40638, shears)
				.method_10428('S', item)
				.method_10439(" S")
				.method_10439("S ")
				.method_10429("has_item", criterion)
				.method_10431(consumer);

	}

	protected void registerTerrasteelUpgradeRecipe(Consumer<class_2444> consumer, class_1935 output,
			class_1935 upgradedInput, class_1935 runeInput) {
		class_2447.method_10437(class_7800.field_40639, output)
				.method_10434('T', BotaniaItems.livingwoodTwig)
				.method_10433('S', BotaniaTags.Items.INGOTS_TERRASTEEL)
				.method_10434('R', runeInput)
				.method_10434('A', upgradedInput)
				.method_10439("TRT")
				.method_10439("SAS")
				.method_10439(" S ")
				.method_10429("has_item", conditionsFromTag(BotaniaTags.Items.INGOTS_TERRASTEEL))
				.method_10429("has_prev_tier", conditionsFromItem(upgradedInput))
				.method_10431(WrapperResult.ofType(ArmorUpgradeRecipe.SERIALIZER, consumer));
	}

	public static void registerRedStringBlock(Consumer<class_2444> consumer, class_1935 output, class_1856 input, class_184 criterion) {
		class_2447.method_10437(class_7800.field_40636, output)
				.method_10434('R', BotaniaBlocks.livingrock)
				.method_10434('S', BotaniaItems.redString)
				.method_10428('M', input)
				.method_10439("RRR")
				.method_10439("RMS")
				.method_10439("RRR")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.redString))
				.method_10429("has_base_block", criterion)
				.method_10431(consumer);
	}

	protected void createFloatingFlowerRecipe(Consumer<class_2444> consumer, class_1935 input) {
		class_2960 inputName = class_7923.field_41178.method_10221(input.method_8389());
		class_1792 output = getItemOrThrow(new class_2960(inputName.method_12836(), "floating_" + inputName.method_12832()));
		class_2450.method_10447(class_7800.field_40635, output)
				.method_10446(BotaniaTags.Items.FLOATING_FLOWERS)
				.method_10454(input)
				.method_10452("botania:floating_flower")
				.method_10442("has_item", conditionsFromItem(input))
				.method_10431(consumer);
	}

	protected void deconstruct(Consumer<class_2444> consumer, class_1935 output, class_1935 input, String name) {
		class_2450.method_10448(class_7800.field_40642, output, 9)
				.method_10442("has_item", conditionsFromItem(output))
				.method_10454(input)
				.method_17972(consumer, prefix("conversions/" + name));
	}

	protected void deconstruct(Consumer<class_2444> consumer, class_1935 output, class_6862<class_1792> input, String name) {
		class_2450.method_10448(class_7800.field_40642, output, 9)
				.method_10442("has_item", conditionsFromItem(output))
				.method_10446(input)
				.method_17972(consumer, prefix("conversions/" + name));
	}

	protected void deconstructPetalBlock(Consumer<class_2444> consumer, class_1935 output, class_1935 input) {
		class_2450.method_10448(class_7800.field_40642, output, 9)
				.method_10442("has_item", conditionsFromItem(output))
				.method_10454(input).method_10452("botania:petal_block_deconstruct")
				.method_17972(consumer, prefix("conversions/" + class_7923.field_41178.method_10221(input.method_8389()).method_12832() + "_deconstruct"));
	}

	protected void recombineSlab(Consumer<class_2444> consumer, class_1935 fullBlock, class_1935 slab) {
		class_2447.method_10437(class_7800.field_40634, fullBlock)
				.method_10434('Q', slab)
				.method_10439("QQ")
				.method_10429("has_item", conditionsFromItem(slab))
				.method_17972(consumer, prefix("slab_recombine/" + class_7923.field_41178.method_10221(fullBlock.method_8389()).method_12832()));
	}

	protected class_2447 petalApothecary(class_1935 block, class_1935 apothecary) {
		return class_2447.method_10437(class_7800.field_40635, apothecary)
				.method_10433('P', BotaniaTags.Items.PETALS)
				.method_10434('C', block)
				.method_10439("CPC")
				.method_10439(" C ")
				.method_10439("CCC");
	}

	protected void registerForQuartz(Consumer<class_2444> consumer, String variant, class_1935 baseItem) {
		class_2248 base = getBlockOrThrow(prefix(variant));
		class_2248 slab = getBlockOrThrow(prefix(variant + LibBlockNames.SLAB_SUFFIX));
		class_2248 stairs = getBlockOrThrow(prefix(variant + LibBlockNames.STAIR_SUFFIX));
		class_2248 chiseled = getBlockOrThrow(prefix("chiseled_" + variant));
		class_2248 pillar = getBlockOrThrow(prefix(variant + "_pillar"));

		class_2447.method_10437(class_7800.field_40634, base)
				.method_10434('Q', baseItem)
				.method_10439("QQ")
				.method_10439("QQ")
				.method_10435("botania:quartz_block")
				.method_10429("has_item", conditionsFromItem(baseItem))
				.method_10431(consumer);
		stairs(stairs, base).method_10435("botania:quartz_stairs").method_10431(consumer);
		slabShape(slab, base).method_10435("botania:quartz_slab").method_10431(consumer);
		pillar(pillar, base).method_10435("botania:quartz_pillar").method_10431(consumer);
		chiseled(chiseled, slab).method_10435("botania:quartz_chiseled")
				.method_10429("has_base_item", conditionsFromItem(base)).method_10431(consumer);
	}

	protected void registerForWood(Consumer<class_2444> consumer, String variant) {

		class_6862<class_1792> tag = variant.contains("livingwood") ? BotaniaTags.Items.LIVINGWOOD_LOGS : BotaniaTags.Items.DREAMWOOD_LOGS;
		class_2248 log = getBlockOrThrow(prefix(variant + "_log"));
		class_2248 wood = getBlockOrThrow(prefix(variant));
		class_2248 strippedLog = getBlockOrThrow(prefix("stripped_" + variant + "_log"));
		class_2248 strippedWood = getBlockOrThrow(prefix("stripped_" + variant));
		class_2248 glimmeringLog = getBlockOrThrow(prefix("glimmering_" + variant + "_log"));
		class_2248 glimmeringWood = getBlockOrThrow(prefix("glimmering_" + variant));
		class_2248 glimmeringStrippedLog = getBlockOrThrow(prefix("glimmering_stripped_" + variant + "_log"));
		class_2248 glimmeringStrippedWood = getBlockOrThrow(prefix("glimmering_stripped_" + variant));
		class_2248 stairs = getBlockOrThrow(prefix(variant + "_stairs"));
		class_2248 slab = getBlockOrThrow(prefix(variant + "_slab"));
		class_2248 wall = getBlockOrThrow(prefix(variant + "_wall"));
		class_2248 strippedStairs = getBlockOrThrow(prefix("stripped_" + variant + "_stairs"));
		class_2248 strippedSlab = getBlockOrThrow(prefix("stripped_" + variant + "_slab"));
		class_2248 strippedWall = getBlockOrThrow(prefix("stripped_" + variant + "_wall"));

		class_2248 planks = getBlockOrThrow(prefix(variant + "_planks"));
		class_2248 planksStairs = getBlockOrThrow(prefix(variant + "_planks_stairs"));
		class_2248 planksSlab = getBlockOrThrow(prefix(variant + "_planks_slab"));
		class_2248 mossyPlanks = getBlockOrThrow(prefix("mossy_" + variant + "_planks"));
		class_2248 framed = getBlockOrThrow(prefix("framed_" + variant));
		class_2248 patternFramed = getBlockOrThrow(prefix("pattern_framed_" + variant));
		class_2248 fence = getBlockOrThrow(prefix(variant + "_fence"));
		class_2248 fenceGate = getBlockOrThrow(prefix(variant + "_fence_gate"));

		class_2450.method_10448(class_7800.field_40634, planks, 4).method_10446(tag).method_10452("planks")
				.method_10442("has_item", conditionsFromTag(tag)).method_10431(consumer);
		class_2447.method_10436(class_7800.field_40634, wood, 3).method_10435("wood").method_10429("has_log", conditionsFromItem(log))
				.method_10434('#', log)
				.method_10439("##")
				.method_10439("##")
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40634, strippedWood, 3).method_10435("wood").method_10429("has_log", conditionsFromItem(strippedLog))
				.method_10434('#', strippedLog)
				.method_10439("##")
				.method_10439("##")
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, glimmeringLog).method_10452("botania:glimmering_" + variant)
				.method_10454(log)
				.method_10454(class_1802.field_8601)
				.method_10442("has_item", conditionsFromItem(log))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, glimmeringWood).method_10452("botania:glimmering_" + variant)
				.method_10454(wood)
				.method_10454(class_1802.field_8601)
				.method_10442("has_item", conditionsFromItem(wood))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, glimmeringStrippedLog).method_10452("botania:glimmering_" + variant)
				.method_10454(strippedLog)
				.method_10454(class_1802.field_8601)
				.method_10442("has_item", conditionsFromItem(strippedLog))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, glimmeringStrippedWood).method_10452("botania:glimmering_" + variant)
				.method_10454(strippedWood)
				.method_10454(class_1802.field_8601)
				.method_10442("has_item", conditionsFromItem(strippedWood))
				.method_10431(consumer);
		class_2447.method_10436(class_7800.field_40634, glimmeringWood, 3).method_10435("botania:glimmering_" + variant)
				.method_10429("has_log", conditionsFromItem(glimmeringLog))
				.method_10434('#', glimmeringLog)
				.method_10439("##")
				.method_10439("##")
				.method_17972(consumer, prefix("glimmering_" + variant + "_from_log"));
		class_2447.method_10436(class_7800.field_40634, glimmeringStrippedWood, 3).method_10435("botania:glimmering_" + variant)
				.method_10429("has_log", conditionsFromItem(glimmeringStrippedLog))
				.method_10434('#', glimmeringStrippedLog)
				.method_10439("##")
				.method_10439("##")
				.method_17972(consumer, prefix("glimmering_stripped_" + variant + "_from_log"));

		stairs(stairs, wood).method_10431(consumer);
		slabShape(slab, wood).method_10431(consumer);
		wallShape(wall, wood, 6).method_10431(consumer);
		fence(fence, planks).method_10431(consumer);
		fenceGate(fenceGate, planks).method_10431(consumer);

		stairs(strippedStairs, strippedWood).method_10431(consumer);
		slabShape(strippedSlab, strippedWood).method_10431(consumer);
		wallShape(strippedWall, strippedWood, 6).method_10431(consumer);

		stairs(planksStairs, planks).method_10431(consumer);
		slabShape(planksSlab, planks).method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, mossyPlanks)
				.method_10454(planks)
				.method_10454(class_1802.field_28654)
				.method_10442("has_item", conditionsFromItem(planks))
				.method_10431(consumer);
		class_2450.method_10447(class_7800.field_40634, mossyPlanks)
				.method_10454(planks)
				.method_10454(class_1802.field_17523)
				.method_10442("has_item", conditionsFromItem(planks))
				.method_17972(consumer, prefix("mossy_" + variant + "_planks_vine"));
		class_2447.method_10436(class_7800.field_40634, framed, 4)
				.method_10434('W', planks)
				.method_10439("W W")
				.method_10439("W W")
				.method_10429("has_item", conditionsFromItem(planks))
				.method_10431(consumer);
		ringShape(patternFramed, planks).method_10431(consumer);
	}

	private void registerForPavement(Consumer<class_2444> consumer, String color, class_1792 mainInput) {
		String baseName = color + LibBlockNames.PAVEMENT_SUFFIX;
		class_2248 base = getBlockOrThrow(prefix(baseName));
		class_2248 stair = getBlockOrThrow(prefix(baseName + LibBlockNames.STAIR_SUFFIX));
		class_2248 slab = getBlockOrThrow(prefix(baseName + LibBlockNames.SLAB_SUFFIX));

		class_2450 builder = class_2450.method_10448(class_7800.field_40634, base, 3)
				.method_10454(BotaniaBlocks.livingrock)
				.method_10454(class_1802.field_20412)
				.method_10454(class_1802.field_8110)
				.method_10452("botania:pavement")
				.method_10442("has_item", conditionsFromItem(BotaniaBlocks.livingrock));
		if (mainInput != class_1802.field_8162) {
			builder.method_10454(mainInput);
		}
		builder.method_10431(consumer);

		slabShape(slab, base).method_10435("botania:pavement_slab").method_10431(consumer);
		stairs(stair, base).method_10435("botania:pavement_stairs").method_10431(consumer);
	}

	private void registerForMetamorphic(Consumer<class_2444> consumer, String variant) {
		class_2248 base = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_stone"));
		class_2248 slab = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_stone" + LibBlockNames.SLAB_SUFFIX));
		class_2248 stair = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_stone" + LibBlockNames.STAIR_SUFFIX));
		class_2248 wall = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_stone" + LibBlockNames.WALL_SUFFIX));
		class_2248 brick = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks"));
		class_2248 brickSlab = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks" + LibBlockNames.SLAB_SUFFIX));
		class_2248 brickStair = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks" + LibBlockNames.STAIR_SUFFIX));
		class_2248 brickWall = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks" + LibBlockNames.WALL_SUFFIX));
		class_2248 chiseledBrick = getBlockOrThrow(prefix("chiseled_" + LibBlockNames.METAMORPHIC_PREFIX + variant + "_bricks"));
		class_2248 cobble = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_cobblestone"));
		class_2248 cobbleSlab = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_cobblestone" + LibBlockNames.SLAB_SUFFIX));
		class_2248 cobbleStair = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_cobblestone" + LibBlockNames.STAIR_SUFFIX));
		class_2248 cobbleWall = getBlockOrThrow(prefix(LibBlockNames.METAMORPHIC_PREFIX + variant + "_cobblestone" + LibBlockNames.WALL_SUFFIX));

		class_2066.class_2068 marimorphosis = conditionsFromItem(BotaniaFlowerBlocks.marimorphosis);
		slabShape(slab, base).method_10435("botania:metamorphic_stone_slab")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		stairs(stair, base).method_10435("botania:metamorphic_stone_stairs")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		wallShape(wall, base, 6).method_10435("botania:metamorphic_stone_wall")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);

		brick(brick, base).method_10435("botania:metamorphic_brick")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		slabShape(brickSlab, brick).method_10435("botania:metamorphic_brick_slab")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		stairs(brickStair, brick).method_10435("botania:metamorphic_brick_stairs")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		wallShape(brickWall, brick, 6).method_10435("botania:metamorphic_brick_wall")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		chiseled(chiseledBrick, brickSlab).method_10429("has_base_item", conditionsFromItem(brick))
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);

		slabShape(cobbleSlab, cobble).method_10435("botania:metamorphic_cobble_slab")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		stairs(cobbleStair, cobble).method_10435("botania:metamorphic_cobble_stairs")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
		wallShape(cobbleWall, cobble, 6).method_10435("botania:metamorphic_cobble_wall")
				.method_10429("has_flower_item", marimorphosis).method_10431(consumer);
	}

	private class_2447 compression(class_1935 output, class_6862<class_1792> input) {
		return class_2447.method_10437(output instanceof class_2248 ? class_7800.field_40634 : class_7800.field_40642, output)
				.method_10433('I', input)
				.method_10439("III")
				.method_10439("III")
				.method_10439("III")
				.method_10429("has_item", conditionsFromTag(input));
	}

	protected class_2447 compression(class_1935 output, class_1935 input) {
		return class_2447.method_10437(output instanceof class_2248 ? class_7800.field_40634 : class_7800.field_40642, output)
				.method_10434('I', input)
				.method_10439("III")
				.method_10439("III")
				.method_10439("III")
				.method_10429("has_item", conditionsFromItem(input));
	}

	protected class_2447 brick(class_1935 output, class_1935 input) {
		return class_2447.method_10436(class_7800.field_40634, output, 4)
				.method_10429("has_item", conditionsFromItem(input))
				.method_10434('Q', input)
				.method_10439("QQ")
				.method_10439("QQ");
	}

	protected class_2447 stairs(class_1935 output, class_1935 input) {
		return class_2447.method_10436(class_7800.field_40634, output, 4)
				.method_10429("has_item", conditionsFromItem(input))
				.method_10434('Q', input)
				.method_10439("Q  ")
				.method_10439("QQ ")
				.method_10439("QQQ");
	}

	protected class_2447 slabShape(class_1935 output, class_1935 input) {
		return class_2447.method_10436(class_7800.field_40634, output, 6)
				.method_10429("has_item", conditionsFromItem(input))
				.method_10434('Q', input)
				.method_10439("QQQ");
	}

	protected class_2447 pillar(class_1935 output, class_1935 input) {
		return class_2447.method_10436(class_7800.field_40634, output, 2)
				.method_10429("has_item", conditionsFromItem(input))
				.method_10434('Q', input)
				.method_10439("Q")
				.method_10439("Q");
	}

	protected class_2447 chiseled(class_1935 output, class_1935 input) {
		return class_2447.method_10437(class_7800.field_40634, output)
				.method_10429("has_item", conditionsFromItem(input))
				.method_10434('Q', input)
				.method_10439("Q")
				.method_10439("Q");
	}

	protected class_2447 wallShape(class_1935 output, class_1935 input, int amount) {
		return class_2447.method_10436(class_7800.field_40642, output, amount)
				.method_10429("has_item", conditionsFromItem(input))
				.method_10434('B', input)
				.method_10439("BBB")
				.method_10439("BBB");
	}

	protected class_2447 fence(class_1935 output, class_1935 input) {
		return class_2447.method_10436(class_7800.field_40642, output, 3)
				.method_10429("has_item", conditionsFromItem(input))
				.method_10435("wooden_fence")
				.method_10434('B', input)
				.method_10434('S', class_1802.field_8600)
				.method_10439("BSB")
				.method_10439("BSB");
	}

	protected class_2447 fenceGate(class_1935 output, class_1935 input) {
		return class_2447.method_10436(class_7800.field_40636, output, 1)
				.method_10429("has_item", conditionsFromItem(input))
				.method_10435("wooden_fence_gate")
				.method_10434('B', input)
				.method_10434('S', class_1802.field_8600)
				.method_10439("SBS")
				.method_10439("SBS");
	}

	protected class_2447 ringShape(class_1935 output, class_1935 input) {
		return class_2447.method_10436(class_7800.field_40634, output, 4)
				.method_10434('W', input)
				.method_10439(" W ")
				.method_10439("W W")
				.method_10439(" W ")
				.method_10429("has_item", conditionsFromItem(input));
	}

	protected void cosmeticBauble(Consumer<class_2444> consumer, class_1935 output, class_1935 input) {
		class_2447.method_10437(class_7800.field_40642, output)
				.method_10434('P', input)
				.method_10434('S', BotaniaItems.manaString)
				.method_10439("PPP")
				.method_10439("PSP")
				.method_10439("PPP")
				.method_10435("botania:cosmetic_bauble")
				.method_10429("has_item", conditionsFromItem(BotaniaItems.manaString))
				.method_10431(consumer);
	}

	protected void specialRecipe(Consumer<class_2444> consumer, NoOpRecipeSerializer<? extends class_3955> serializer) {
		class_2960 name = class_7923.field_41189.method_10221(serializer);
		class_2456.method_10476(serializer).method_10475(consumer, prefix("dynamic/" + name.method_12832()).toString());
	}

	protected class_2248 getBlockOrThrow(class_2960 location) {
		return class_7923.field_41175.method_31140(class_5321.method_29179(class_7924.field_41254, location));
	}

	protected class_1792 getItemOrThrow(class_2960 location) {
		return class_7923.field_41178.method_31140(class_5321.method_29179(class_7924.field_41197, location));
	}

	@Override
	public String method_10321() {
		return "Botania crafting recipes";
	}
}
