/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.helper.PlayerHelper;

import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_169;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class RealPlayerCondition implements class_5341 {
	public static final RealPlayerCondition INSTANCE = new RealPlayerCondition();

	private RealPlayerCondition() {}

	@Override
	public boolean test(class_47 lootContext) {
		class_1657 player = lootContext.method_296(class_181.field_1233);
		return PlayerHelper.isTruePlayer(player);
	}

	@NotNull
	@Override
	public Set<class_169<?>> method_293() {
		return ImmutableSet.of(class_181.field_1233);
	}

	@NotNull
	@Override
	public class_5342 method_29325() {
		return BotaniaLootModifiers.KILLED_BY_REAL_PLAYER;
	}

	public static class Serializer implements net.minecraft.class_5335<RealPlayerCondition> {
		@Override
		public void serialize(@NotNull JsonObject json, @NotNull RealPlayerCondition value, @NotNull JsonSerializationContext context) {}

		@NotNull
		@Override
		public RealPlayerCondition method_517(@NotNull JsonObject json, @NotNull JsonDeserializationContext context) {
			return INSTANCE;
		}
	}
}
