/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.loot;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.item.equipment.tool.elementium.ElementiumAxeItem;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.function.Consumer;
import net.minecraft.class_2246;
import net.minecraft.class_2960;
import net.minecraft.class_55;
import net.minecraft.class_5662;
import net.minecraft.class_79;
import net.minecraft.class_83;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class LootHandler {
	public static final class_2960 GOG_SEEDS_TABLE = new class_2960(BotaniaAPI.GOG_MODID, "extra_seeds");

	public static void lootLoad(class_2960 id, Consumer<class_55.class_56> addPool) {
		String prefix = "minecraft:chests/";
		String name = id.toString();

		if (name.startsWith(prefix)) {
			String file = name.substring(name.indexOf(prefix) + prefix.length());
			switch (file) {
				case "abandoned_mineshaft":
				case "desert_pyramid":
				case "jungle_temple":
				case "simple_dungeon":
				case "spawn_bonus_chest":
				case "stronghold_corridor":
					addPool.accept(getInjectPool(file));
					break;
				case "village/village_temple":
				case "village/village_toolsmith":
				case "village/village_weaponsmith":
					addPool.accept(getInjectPool("village_chest"));
					break;
				default:
					break;
			}
		} else if (id.method_12832().startsWith("entities/")) {
			// not great, as it's inserted into absolutely every single entity loot table (this evaluates twice for sheep, for example)
			addPool.accept(class_55.method_347().method_351(class_83.method_428(ElementiumAxeItem.BEHEADING_LOOT_TABLE)));
		} else if (XplatAbstractions.INSTANCE.gogLoaded()
				&& (class_2246.field_10479.method_26162().equals(id) || class_2246.field_10214.method_26162().equals(id))) {
			addPool.accept(class_55.method_347().method_351(class_83.method_428(GOG_SEEDS_TABLE)));
		}
	}

	private static class_55.class_56 getInjectPool(String entryName) {
		return class_55.method_347()
				.method_351(getInjectEntry(entryName, 1))
				.method_35509(class_5662.method_32462(0, 1));
	}

	private static class_79.class_80<?> getInjectEntry(String name, int weight) {
		class_2960 table = prefix("inject/" + name);
		return class_83.method_428(table)
				.method_437(weight);
	}

}
