/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import net.minecraft.class_120;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_47;
import net.minecraft.class_5339;
import net.minecraft.class_5341;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.item.Relic;
import vazkii.botania.xplat.XplatAbstractions;

public class BindUuid extends class_120 {

	protected BindUuid(class_5341[] conditionsIn) {
		super(conditionsIn);
	}

	@NotNull
	@Override
	public class_1799 method_522(@NotNull class_1799 stack, @NotNull class_47 context) {
		if (context.method_296(class_181.field_1230) instanceof class_1657 player) {
			var relic = XplatAbstractions.INSTANCE.findRelic(stack);
			if (relic != null) {
				relic.bindToUUID(player.method_5667());
			}
		}

		return stack;
	}

	@Override
	public class_5339 method_29321() {
		return BotaniaLootModifiers.BIND_UUID;
	}

	public static class Serializer extends class_120.class_123<BindUuid> {
		@NotNull
		@Override
		public BindUuid method_530(@NotNull JsonObject object, @NotNull JsonDeserializationContext deserializationContext, @NotNull class_5341[] conditionsIn) {
			return new BindUuid(conditionsIn);
		}
	}

}
