/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.lens;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.item.SparkEntity;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.*;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7923;

public class PaintslingerLens extends Lens {

	@Override
	public boolean collideBurst(ManaBurst burst, class_239 pos, boolean isManaBlock, boolean shouldKill, class_1799 stack) {
		class_1297 entity = burst.entity();
		int storedColor = LensItem.getStoredColor(stack);
		if (!entity.method_37908().field_9236 && !burst.isFake() && storedColor > -1 && storedColor < 17) {
			if (pos.method_17783() == class_239.class_240.field_1331) {
				class_1297 collidedWith = ((class_3966) pos).method_17782();
				if (collidedWith instanceof class_1472 sheep) {
					int r = 20;
					class_1767 sheepColor = sheep.method_6633();
					List<class_1472> sheepList = entity.method_37908().method_18467(class_1472.class,
							new class_238(sheep.method_23317() - r, sheep.method_23318() - r, sheep.method_23321() - r,
									sheep.method_23317() + r, sheep.method_23318() + r, sheep.method_23321() + r));
					for (class_1472 other : sheepList) {
						if (other.method_6633() == sheepColor) {
							other.method_6631(class_1767.method_7791(storedColor == 16 ? other.method_37908().field_9229.method_43048(16) : storedColor));
						}
					}
					shouldKill = true;
				} else if (collidedWith instanceof SparkEntity spark) {
					spark.setNetwork(class_1767.method_7791(storedColor == 16 ? collidedWith.method_37908().field_9229.method_43048(16) : storedColor));
				}
			} else if (pos.method_17783() == class_239.class_240.field_1332) {
				class_2338 hitPos = ((class_3965) pos).method_17777();
				class_2248 hitBlock = entity.method_37908().method_8320(hitPos).method_26204();
				class_2960 blockId = class_7923.field_41175.method_10221(hitBlock);

				if (BotaniaAPI.instance().getPaintableBlocks().containsKey(blockId)) {
					List<class_2338> coordsToPaint = new ArrayList<>();
					Queue<class_2338> coordsToCheck = new ArrayDeque<>();
					Set<class_2338> checkedCoords = new HashSet<>();
					coordsToCheck.add(hitPos);
					checkedCoords.add(hitPos);

					while (!coordsToCheck.isEmpty() && coordsToPaint.size() < 1000) {
						class_2338 coords = coordsToCheck.remove();
						coordsToPaint.add(coords);

						for (class_2350 dir : class_2350.values()) {
							class_2338 candidatePos = coords.method_10093(dir);
							if (checkedCoords.add(candidatePos) && entity.method_37908().method_8320(candidatePos).method_27852(hitBlock)) {
								coordsToCheck.add(candidatePos);
							}
						}
					}
					for (class_2338 coords : coordsToPaint) {
						class_1767 placeColor = class_1767.method_7791(storedColor == 16 ? entity.method_37908().field_9229.method_43048(16) : storedColor);
						class_2680 stateThere = entity.method_37908().method_8320(coords);

						Function<class_1767, class_2248> f = BotaniaAPI.instance().getPaintableBlocks().get(blockId);
						class_2248 newBlock = f.apply(placeColor);
						if (newBlock != stateThere.method_26204()) {
							entity.method_37908().method_8501(coords, newBlock.method_34725(stateThere));
							XplatAbstractions.INSTANCE.sendToNear(entity.method_37908(), coords, new BotaniaEffectPacket(EffectType.PAINT_LENS, coords.method_10263(), coords.method_10264(), coords.method_10260(), placeColor.method_7789()));
						}
					}
				}
			}
		}

		return shouldKill;
	}

}
