/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.equipment.tool;

import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.common.entity.FallingStarEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.manasteel.ManasteelSwordItem;

public class StarcallerItem extends ManasteelSwordItem {

	private static final int MANA_PER_DAMAGE = 120;
	private static final String TAG_LAST_TRIGGER = "lastTriggerTime";
	/* Number of ticks between two stars */
	private static final int INTERVAL = 12;

	public StarcallerItem(class_1793 props) {
		super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
	}

	@Override
	public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
		super.method_7888(stack, world, entity, slot, selected);
		if (!(entity instanceof class_1657 player)) {
			return;
		}

		// Initialize timer for new items
		if (!ItemNBTHelper.verifyExistance(stack, TAG_LAST_TRIGGER)) {
			ItemNBTHelper.setLong(stack, TAG_LAST_TRIGGER, world.method_8510());
		}

		class_1293 haste = player.method_6112(class_1294.field_5917);
		float check = haste == null ? 0.16666667F : haste.method_5578() == 1 ? 0.5F : 0.4F;

		long timeSinceLast = world.method_8510() - ItemNBTHelper.getLong(stack, TAG_LAST_TRIGGER, world.method_8510());
		if (timeSinceLast > INTERVAL && player.method_6047() == stack && player.field_6251 == check && !world.field_9236) {
			ItemNBTHelper.setLong(stack, TAG_LAST_TRIGGER, world.method_8510());
			summonFallingStar(stack, world, player);
		}
	}

	private void summonFallingStar(class_1799 stack, class_1937 world, class_1657 player) {
		class_3965 pos = ToolCommons.raytraceFromEntity(player, 48, false);
		if (pos.method_17783() == class_239.class_240.field_1332) {
			class_243 posVec = class_243.method_24954(pos.method_17777());
			class_243 motVec = new class_243((0.5 * Math.random() - 0.25) * 18, 24, (0.5 * Math.random() - 0.25) * 18);
			posVec = posVec.method_1019(motVec);
			motVec = motVec.method_1029().method_22882().method_1021(1.5);

			FallingStarEntity star = new FallingStarEntity(player, world);
			star.method_5814(posVec.field_1352, posVec.field_1351, posVec.field_1350);
			star.method_18799(motVec);
			world.method_8649(star);

			if (!world.method_8419()
					&& Math.abs(world.method_8532() - 18000) < 1800
					&& Math.random() < 0.125) {
				FallingStarEntity bonusStar = new FallingStarEntity(player, world);
				bonusStar.method_5814(posVec.field_1352, posVec.field_1351, posVec.field_1350);
				bonusStar.method_18800(motVec.field_1352 + Math.random() - 0.5,
						motVec.field_1351 + Math.random() - 0.5, motVec.field_1350 + Math.random() - 0.5);
				world.method_8649(bonusStar);
			}

			stack.method_7956(1, player, p -> p.method_20236(class_1268.field_5808));
			world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.starcaller, class_3419.field_15248, 1F, 1F);
		}
	}

	@Override
	public int getManaPerDamage() {
		return MANA_PER_DAMAGE;
	}
}
