/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2158;
import net.minecraft.class_2158.class_2159;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3518;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.api.recipe.StateIngredient;

public class PureDaisyRecipe implements vazkii.botania.api.recipe.PureDaisyRecipe {

	public static final int DEFAULT_TIME = 150;

	private final class_2960 id;
	protected final StateIngredient input;
	protected final class_2680 outputState;
	private final int time;
	private final class_2158.class_2159 function;

	/**
	 * @param id       The ID for this recipe.
	 * @param input    The input for the recipe. Can be a Block, BlockState, or Tag&lt;Block&gt;.
	 * @param state    The blockstate to be placed upon recipe completion.
	 * @param time     The amount of time in ticks to complete this recipe. Note that this is ticks on your block, not
	 *                 total time.
	 *                 The Pure Daisy only ticks one block at a time in a round robin fashion.
	 * @param function An mcfunction to run at the converted block after finish. If you don't want one, pass
	 *                 CommandFunction.CacheableFunction.NONE
	 */
	public PureDaisyRecipe(class_2960 id, StateIngredient input, class_2680 state, int time, class_2158.class_2159 function) {
		Preconditions.checkArgument(time >= 0, "Time must be nonnegative");
		this.id = id;
		this.input = input;
		this.outputState = state;
		this.time = time;
		this.function = function;
	}

	@Override
	public boolean matches(class_1937 world, class_2338 pos, SpecialFlowerBlockEntity pureDaisy, class_2680 state) {
		return input.test(state) && outputState != state;
	}

	@Override
	public boolean set(class_1937 world, class_2338 pos, SpecialFlowerBlockEntity pureDaisy) {
		if (!world.field_9236) {
			boolean success = world.method_8501(pos, outputState);
			if (success) {
				var serverLevel = (class_3218) world;
				var server = serverLevel.method_8503();
				this.function.method_9196(server.method_3740()).ifPresent(command -> {
					var context = server.method_3740().method_12899()
							.method_9227((class_3218) world)
							.method_9208(class_243.method_24955(pos));
					server.method_3740().method_12904(command, context);
				});
			}
			return success;
		}
		return true;
	}

	@Override
	public StateIngredient getInput() {
		return input;
	}

	@Override
	public class_2680 getOutputState() {
		return outputState;
	}

	@Override
	public class_2158.class_2159 getSuccessFunction() {
		return this.function;
	}

	@Override
	public int getTime() {
		return time;
	}

	@Override
	public class_2960 method_8114() {
		return id;
	}

	@Override
	public class_1865<?> method_8119() {
		return BotaniaRecipeTypes.PURE_DAISY_SERIALIZER;
	}

	public static class Serializer implements class_1865<PureDaisyRecipe> {
		@NotNull
		@Override
		public PureDaisyRecipe method_8121(@NotNull class_2960 id, JsonObject object) {
			StateIngredient input = StateIngredientHelper.deserialize(class_3518.method_15296(object, "input"));
			class_2680 output = StateIngredientHelper.readBlockState(class_3518.method_15296(object, "output"));
			int time = class_3518.method_15282(object, "time", DEFAULT_TIME);
			var functionIdString = class_3518.method_15253(object, "success_function", null);
			var functionId = functionIdString == null ? null : new class_2960(functionIdString);
			var function = functionId == null ? class_2158.class_2159.field_9809 : new class_2158.class_2159(functionId);
			return new PureDaisyRecipe(id, input, output, time, function);
		}

		@Override
		public void toNetwork(@NotNull class_2540 buf, PureDaisyRecipe recipe) {
			recipe.input.write(buf);
			buf.method_10804(class_2248.method_9507(recipe.outputState));
			buf.method_10804(recipe.time);
		}

		@NotNull
		@Override
		public PureDaisyRecipe method_8122(@NotNull class_2960 id, @NotNull class_2540 buf) {
			StateIngredient input = StateIngredientHelper.read(buf);
			class_2680 output = class_2248.method_9531(buf.method_10816());
			int time = buf.method_10816();
			return new PureDaisyRecipe(id, input, output, time, class_2158.class_2159.field_9809);
		}
	}
}
