/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.mana;

import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_247;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.RunicAltarBlockEntity;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.helper.InventoryHelper;

public class RunicAltarBlock extends BotaniaWaterloggedBlock implements class_2343 {

	private static final class_265 TOP = class_2248.method_9541(0, 6, 0, 16, 12, 16);
	private static final class_265 BOTTOM = class_2248.method_9541(2, 0, 2, 14, 6, 14);
	private static final class_265 SHAPE = class_259.method_1072(TOP, BOTTOM, class_247.field_1366);

	public RunicAltarBlock(class_2251 builder) {
		super(builder);
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		if (!(world.method_8321(pos) instanceof RunicAltarBlockEntity altar)) {
			return class_1269.field_5811;
		}
		class_1799 stack = player.method_5998(hand);
		boolean mainHandEmpty = player.method_6047().method_7960();

		if (altar.canAddLastRecipe() && mainHandEmpty) {
			return altar.trySetLastRecipe(player);
		} else if (!altar.isEmpty() && altar.manaToGet == 0 && mainHandEmpty) {
			InventoryHelper.withdrawFromInventory(altar, player);
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
			return class_1269.method_29236(world.method_8608());
		} else if (!stack.method_7960()) {
			boolean result = altar.addItem(player, stack, hand);
			VanillaPacketDispatcher.dispatchTEToNearbyPlayers(altar);
			if (result) {
				return class_1269.method_29236(world.method_8608());
			}
		}

		return class_1269.field_5811;
	}

	@Override
	public void method_9536(@NotNull class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
		if (!state.method_27852(newState.method_26204())) {
			class_2586 be = world.method_8321(pos);
			if (be instanceof SimpleInventoryBlockEntity inventory) {
				class_1264.method_5451(world, pos, inventory.getItemHandler());
			}
			super.method_9536(state, world, pos, newState, isMoving);
		}
	}

	@NotNull
	@Override
	public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new RunicAltarBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
		if (level.field_9236) {
			return createTickerHelper(type, BotaniaBlockEntities.RUNE_ALTAR, RunicAltarBlockEntity::clientTick);
		} else {
			return createTickerHelper(type, BotaniaBlockEntities.RUNE_ALTAR, RunicAltarBlockEntity::serverTick);
		}
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		RunicAltarBlockEntity altar = (RunicAltarBlockEntity) world.method_8321(pos);
		return altar.signal;
	}

}
