/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.mixin.*;
import vazkii.botania.xplat.XplatAbstractions;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1338;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4135;

public class TigerseyeBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int RANGE = 10;
	private static final int RANGE_Y = 4;
	private static final int COST = 70;
	private static final int SUCCESS_EVENT = 0;

	public TigerseyeBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.TIGERSEYE, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		for (class_1548 entity : method_10997().method_18467(class_1548.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE_Y, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE_Y + 1, RANGE + 1)))) {
			((CreeperAccessor) entity).setCurrentFuseTime(2);
			entity.method_5980(null);

			if (getMana() >= COST) {
				if (pacifyCreeper(entity)) {
					XplatAbstractions.INSTANCE.tigersEyeComponent(entity).setPacified();
					entity.method_5783(BotaniaSounds.tigerseyePacify, 1.0F, (field_11863.field_9229.method_43057() - field_11863.field_9229.method_43057()) * 0.2F + 1.0F);
					field_11863.method_8427(method_11016(), method_11010().method_26204(), SUCCESS_EVENT, entity.method_5628());
					addMana(-COST);
					sync();
				}
			}
		}
	}

	public static void pacifyAfterLoad(class_1297 entity, class_3218 level) {
		if (entity instanceof class_1548 creeper && XplatAbstractions.INSTANCE.tigersEyeComponent(creeper).isPacified()) {
			pacifyCreeper(creeper);
		}
	}

	private static boolean pacifyCreeper(class_1548 creeper) {
		boolean did = false;
		class_1355 goalSelector = ((MobAccessor) creeper).getGoalSelector();
		Set<class_4135> goals = goalSelector.method_35115();
		for (var goal : goals) {
			class_1352 wrapped = goal.method_19058();
			if (wrapped instanceof CreeperAvoidPlayerGoal playerGoal && !playerGoal.enabled) {
				playerGoal.enable();
				did = true;
				break;
			}
		}

		class_1355 targetSelector = ((MobAccessor) creeper).getTargetSelector();
		for (var iterator = targetSelector.method_35115().iterator(); iterator.hasNext();) {
			class_4135 pg = iterator.next();
			if (pg.method_19058() instanceof NearestAttackableTargetGoalAccessor targetGoal
					&& targetGoal.getTargetClass() == class_1657.class) {
				iterator.remove();
				did = true;
			}
		}
		return did;
	}

	@Override
	public boolean method_11004(int id, int payload) {
		if (id == SUCCESS_EVENT) {
			if (field_11863.field_9236) {
				class_1297 e = field_11863.method_8469(payload);
				if (e != null) {
					float r = (getColor() >> 16 & 0xFF) / 255F;
					float g = (getColor() >> 8 & 0xFF) / 255F;
					float b = (getColor() & 0xFF) / 255F;
					SparkleParticleData data = SparkleParticleData.sparkle(field_11863.field_9229.method_43057(), r, g, b, 10);

					for (int i = 0; i < 50; i++) {
						double x = e.method_23317() + field_11863.field_9229.method_43058() - 0.5;
						double y = e.method_23318() + e.method_17682() * field_11863.field_9229.method_43058();
						double z = e.method_23321() + field_11863.field_9229.method_43058() - 0.5;
						field_11863.method_8406(data, x, y, z, 0, 0, 0);
					}
				}
			}
			return true;
		}
		return super.method_11004(id, payload);
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

	@Override
	public int getColor() {
		return 0xB1A618;
	}

	@Override
	public int getMaxMana() {
		return 1000;
	}

	public static class CreeperAvoidPlayerGoal extends class_1338<class_1657> {
		private boolean enabled = false;

		public CreeperAvoidPlayerGoal(class_1548 mob) {
			this(mob, 6.0F, 1.0, 1.2);
		}

		private CreeperAvoidPlayerGoal(class_1548 mob, float maxDist, double walkSpeedModifier, double sprintSpeedModifier) {
			super(mob, class_1657.class, maxDist, walkSpeedModifier, sprintSpeedModifier);
		}

		public void enable() {
			enabled = true;
		}

		@Override
		public boolean method_6264() {
			return enabled && super.method_6264();
		}
	}

}
