/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.recipe.OrechidRecipe;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3956;
import net.minecraft.class_5712;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.class_6088;
import net.minecraft.server.MinecraftServer;

public class OrechidBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int COST = 17500;
	private static final int COST_GOG = 700;
	private static final int DELAY = 100;
	private static final int DELAY_GOG = 2;
	private static final int RANGE = 5;
	private static final int RANGE_Y = 3;

	protected OrechidBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	public OrechidBlockEntity(class_2338 pos, class_2680 state) {
		this(BotaniaFlowerBlocks.ORECHID, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236 || redstoneSignal > 0 || !canOperate()) {
			return;
		}

		if (getMana() >= getCost() && ticksExisted % getDelay() == 0) {
			class_2338 coords = getCoordsToPut();
			if (coords != null) {
				trySetRecipe(coords, findMatchingRecipe(coords));
			}
		}
	}

	protected void playSound(class_2338 coords) {
		method_10997().method_8396(null, coords, BotaniaSounds.orechid, class_3419.field_15245, 1F, 1F);
	}

	@Nullable
	private OrechidRecipe findMatchingRecipe(class_2338 coords) {
		class_2680 input = field_11863.method_8320(coords);
		List<class_6008.class_6010<OrechidRecipe>> values = new ArrayList<>();
		for (OrechidRecipe recipe : OrechidManager.getMatchingRecipes(method_10997().method_8433(), getRecipeType(), input)) {
			values.add(class_6008.method_34980(recipe, recipe.getWeight(method_10997(), coords)));
		}
		return class_6011.method_34986(method_10997().field_9229, values)
				.map(class_6008.class_6010::method_34983)
				.orElse(null);
	}

	private void trySetRecipe(class_2338 coords, @Nullable OrechidRecipe recipe) {
		if (recipe == null) {
			return;
		}

		class_2680 state = recipe.getOutput(field_11863, coords).pick(field_11863.field_9229);
		if (method_10997().method_8501(coords, state)) {
			if (BotaniaConfig.common().blockBreakParticles()) {
				method_10997().method_20290(class_6088.field_31144, coords, class_2248.method_9507(state));
			}
			playSound(coords);
			addMana(-getCost());
			method_10997().method_33596(null, class_5712.field_28733, coords);

			var serverLevel = (class_3218) this.field_11863;
			var server = serverLevel.method_8503();
			recipe.getSuccessFunction().method_9196(server.method_3740()).ifPresent(command -> {
				var context = server.method_3740().method_12899()
						.method_9227(serverLevel)
						.method_9208(class_243.method_24955(coords));
				server.method_3740().method_12904(command, context);
			});

			sync();
		}
	}

	private class_2338 getCoordsToPut() {
		List<class_2338> possibleCoords = new ArrayList<>();
		var matcher = getReplaceMatcher();
		for (class_2338 pos : class_2338.method_10097(getEffectivePos().method_10069(-getRange(), -getRangeY(), -getRange()),
				getEffectivePos().method_10069(getRange(), getRangeY(), getRange()))) {
			class_2680 state = method_10997().method_8320(pos);
			if (matcher.test(state)) {
				possibleCoords.add(pos.method_10062());
			}
		}

		if (possibleCoords.isEmpty()) {
			return null;
		}
		return possibleCoords.get(method_10997().field_9229.method_43048(possibleCoords.size()));
	}

	public boolean canOperate() {
		return true;
	}

	public class_3956<? extends OrechidRecipe> getRecipeType() {
		return BotaniaRecipeTypes.ORECHID_TYPE;
	}

	public Predicate<class_2680> getReplaceMatcher() {
		return state -> !OrechidManager.getMatchingRecipes(
				this.method_10997().method_8433(),
				this.getRecipeType(),
				state
		).isEmpty();
	}

	public int getCost() {
		return XplatAbstractions.INSTANCE.gogLoaded() ? COST_GOG : COST;
	}

	public int getDelay() {
		return XplatAbstractions.INSTANCE.gogLoaded() ? DELAY_GOG : DELAY;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), getRange());
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	public int getRange() {
		return RANGE;
	}

	public int getRangeY() {
		return RANGE_Y;
	}

	@Override
	public int getColor() {
		return 0x818181;
	}

	@Override
	public int getMaxMana() {
		return getCost();
	}

}
