/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.FakeAirBlockEntity;

public class BubbellBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int RANGE = 12;
	private static final int RANGE_MINI = 6;
	private static final int COST_PER_TICK = 4;
	private static final String TAG_RANGE = "range";

	int range = 2;

	protected BubbellBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	public BubbellBlockEntity(class_2338 pos, class_2680 state) {
		this(BotaniaFlowerBlocks.BUBBELL, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236) {
			return;
		}

		if (ticksExisted % 200 == 0) {
			sync();
		}

		if (getMana() > COST_PER_TICK) {
			addMana(-COST_PER_TICK);

			if (ticksExisted % 10 == 0 && range < getRange()) {
				range++;
			}

			for (class_2338 pos : class_2338.method_10097(getEffectivePos().method_10069(-range, -range, -range), getEffectivePos().method_10069(range, range, range))) {
				if (getEffectivePos().method_10262(pos) < range * range) {
					class_2680 state = method_10997().method_8320(pos);
					if (state.method_27852(class_2246.field_10382)) {
						method_10997().method_8652(pos, BotaniaBlocks.fakeAir.method_9564(), class_2248.field_31028);
						FakeAirBlockEntity air = (FakeAirBlockEntity) method_10997().method_8321(pos);
						air.setFlower(this);
					}
				}
			}
		}
	}

	public static boolean isValidBubbell(class_1937 world, class_2338 pos) {
		class_2586 tile = world.method_8321(pos);
		if (tile instanceof BubbellBlockEntity bubbell) {
			return bubbell.getMana() > COST_PER_TICK;
		}

		return false;
	}

	@Override
	public void writeToPacketNBT(class_2487 cmp) {
		super.writeToPacketNBT(cmp);
		cmp.method_10569(TAG_RANGE, range);
	}

	@Override
	public void readFromPacketNBT(class_2487 cmp) {
		super.readFromPacketNBT(cmp);
		range = cmp.method_10550(TAG_RANGE);
	}

	@Override
	public int getMaxMana() {
		return 2000;
	}

	@Override
	public int getColor() {
		return 0x0DCF89;
	}

	public int getRange() {
		return RANGE;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return new RadiusDescriptor.Circle(getEffectivePos(), range);
	}

	public static class Mini extends BubbellBlockEntity {
		public Mini(class_2338 pos, class_2680 state) {
			super(BotaniaFlowerBlocks.BUBBELL_CHIBI, pos, state);
		}

		@Override
		public int getRange() {
			return RANGE_MINI;
		}
	}

}
