/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.decor;

import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2420;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import net.minecraft.class_6808;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.recipe.CustomApothecaryColor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.xplat.BotaniaConfig;

public class BotaniaMushroomBlock extends class_2420 implements CustomApothecaryColor {

	private static final class_265 SHAPE = method_9541(4.8, 0, 4.8, 12.8, 16, 12.8);
	public final class_1767 color;

	public BotaniaMushroomBlock(class_1767 color, class_2251 builder) {
		super(builder, class_6808.field_35903 /* Doesn't matter, we override the grow method */);
		this.color = color;
	}

	@Override
	public boolean method_10349(class_3218 level, class_2338 pos, class_2680 state, class_5819 rand) {
		return false;
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return field_11304;
	}

	// [VanillaCopy] super, without light level requirement
	@Override
	public boolean method_9558(class_2680 state, class_4538 worldIn, class_2338 pos) {
		class_2338 blockpos = pos.method_10074();
		class_2680 blockstate = worldIn.method_8320(blockpos);
		if (!blockstate.method_26164(class_3481.field_25739)) {
			return this.method_9695(blockstate, worldIn, blockpos);
		} else {
			return true;
		}
	}

	@Override
	public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 rand) {
		int hex = MysticalPetalItem.getPetalLikeColor(color);
		int r = (hex & 0xFF0000) >> 16;
		int g = (hex & 0xFF00) >> 8;
		int b = hex & 0xFF;

		if (rand.method_43058() < BotaniaConfig.client().flowerParticleFrequency() * 0.25F) {
			SparkleParticleData data = SparkleParticleData.sparkle(rand.method_43057(), r / 255F, g / 255F, b / 255F, 5);
			world.method_8406(data, pos.method_10263() + 0.3 + rand.method_43057() * 0.5, pos.method_10264() + 0.5 + rand.method_43057() * 0.5, pos.method_10260() + 0.3 + rand.method_43057() * 0.5, 0, 0, 0);
		}
	}

	@Override
	public int getParticleColor(class_1799 stack) {
		return MysticalPetalItem.getPetalLikeColor(color);
	}
}
