/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.corporea;

import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import vazkii.botania.common.block.BotaniaWaterloggedBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.corporea.BaseCorporeaBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaCrystalCubeBlockEntity;
import vazkii.botania.common.item.WandOfTheForestItem;

public class CorporeaCrystalCubeBlock extends BotaniaWaterloggedBlock implements class_2343 {

	private static final class_265 SHAPE = method_9541(3.0, 0, 3.0, 13.0, 16, 13.0);

	public CorporeaCrystalCubeBlock(class_4970.class_2251 builder) {
		super(builder);
	}

	@Override
	public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
		if (!world.field_9236) {
			CorporeaCrystalCubeBlockEntity cube = (CorporeaCrystalCubeBlockEntity) world.method_8321(pos);
			cube.doRequest(player);
		}
	}

	@NotNull
	@Override
	public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 ctx) {
		return SHAPE;
	}

	@Override
	public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		class_1799 stack = player.method_5998(hand);
		if (!stack.method_7960()) {
			if (stack.method_7909() instanceof WandOfTheForestItem && player.method_21823()) {
				return class_1269.field_5811;
			}
			CorporeaCrystalCubeBlockEntity cube = (CorporeaCrystalCubeBlockEntity) world.method_8321(pos);
			if (cube.locked) {
				if (!world.field_9236) {
					player.method_7353(class_2561.method_43471("botaniamisc.crystalCubeLocked"), false);
				}
			} else {
				cube.setRequestTarget(stack);
			}
			return class_1269.method_29236(world.method_8608());
		}
		return class_1269.field_5811;
	}

	@NotNull
	@Override
	public BaseCorporeaBlockEntity method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
		return new CorporeaCrystalCubeBlockEntity(pos, state);
	}

	@Nullable
	@Override
	public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
		if (!level.field_9236) {
			return createTickerHelper(type, BotaniaBlockEntities.CORPOREA_CRYSTAL_CUBE, CorporeaCrystalCubeBlockEntity::serverTick);
		}
		return null;
	}

	@Override
	public boolean method_9498(class_2680 state) {
		return true;
	}

	@Override
	public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
		return ((CorporeaCrystalCubeBlockEntity) world.method_8321(pos)).getComparatorValue();
	}
}
