/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.block_entity.red_string;

import org.jetbrains.annotations.Nullable;

import vazkii.botania.api.block.Bound;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;

import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;

public abstract class RedStringBlockEntity extends BotaniaBlockEntity implements Bound {

	private class_2338 binding;

	protected RedStringBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
		super(type, pos, state);
	}

	public static void commonTick(class_1937 level, class_2338 pos_, class_2680 state, RedStringBlockEntity self) {
		class_2350 dir = self.getOrientation();
		int range = self.getRange();
		class_2338 currBinding = self.getBinding();
		self.setBinding(null);

		for (int i = 0; i < range; i++) {
			pos_ = pos_.method_10093(dir);
			if (level.method_22347(pos_)) {
				continue;
			}

			class_2586 tile = level.method_8321(pos_);
			if (tile instanceof RedStringBlockEntity) {
				continue;
			}

			if (self.acceptBlock(pos_)) {
				self.setBinding(pos_);
				if (!Objects.equals(currBinding, pos_)) {
					self.onBound(pos_);
				}
				return;
			}
		}
		if (!level.field_9236 && !Objects.equals(currBinding, self.binding)) {
			self.onBound(self.binding);
		}
	}

	public int getRange() {
		return 8;
	}

	public abstract boolean acceptBlock(class_2338 pos);

	public void onBound(@Nullable class_2338 pos) {}

	@Nullable
	@Override
	public class_2338 getBinding() {
		return binding;
	}

	public void setBinding(class_2338 binding) {
		this.binding = binding;
	}

	public class_2350 getOrientation() {
		return method_11010().method_11654(class_2741.field_12525);
	}

	public class_2586 getTileAtBinding() {
		class_2338 binding = getBinding();
		return binding == null || field_11863 == null ? null : field_11863.method_8321(binding);
	}

	public class_2680 getStateAtBinding() {
		class_2338 binding = getBinding();
		return binding == null ? class_2246.field_10124.method_9564() : field_11863.method_8320(binding);
	}

	public class_2248 getBlockAtBinding() {
		return getStateAtBinding().method_26204();
	}
}
