/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block;

import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1738;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1827;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2342;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2357;
import net.minecraft.class_2362;
import net.minecraft.class_2374;
import net.minecraft.class_2465;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2741;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_2965;
import net.minecraft.class_2969;
import net.minecraft.class_3619;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5168;
import net.minecraft.class_7923;
import net.minecraft.core.*;
import net.minecraft.world.level.block.*;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block.PetalApothecary;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.api.state.enums.AlfheimPortalState;
import vazkii.botania.api.state.enums.LuminizerVariant;
import vazkii.botania.common.block.corporea.*;
import vazkii.botania.common.block.decor.*;
import vazkii.botania.common.block.decor.panes.BotaniaPaneBlock;
import vazkii.botania.common.block.decor.stairs.BotaniaStairBlock;
import vazkii.botania.common.block.dispenser.*;
import vazkii.botania.common.block.mana.*;
import vazkii.botania.common.block.red_string.*;
import vazkii.botania.common.entity.EnderAirBottleEntity;
import vazkii.botania.common.entity.VineBallEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.block.BlockItemWithSpecialRenderer;
import vazkii.botania.common.item.block.TinyPotatoBlockItem;
import vazkii.botania.common.lib.LibBlockNames;
import vazkii.botania.mixin.DispenserBlockAccessor;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;

import static vazkii.botania.common.lib.LibBlockNames.*;
import static vazkii.botania.common.lib.LibBlockNames.SLAB_SUFFIX;
import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public final class BotaniaBlocks {
	private static final class_4970.class_4972<class_1299<?>> NO_SPAWN = (state, world, pos, et) -> false;
	private static final class_4970.class_4973 NO_SUFFOCATION = (state, world, pos) -> false;

	public static final class_2248 whiteFlower = new BotaniaFlowerBlock(class_1767.field_7952, class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9634().method_9618().method_49229(class_4970.class_2250.field_10657).method_50012(class_3619.field_15971).method_9632(0).method_9626(class_2498.field_11535));
	public static final class_2248 orangeFlower = new BotaniaFlowerBlock(class_1767.field_7946, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 magentaFlower = new BotaniaFlowerBlock(class_1767.field_7958, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 lightBlueFlower = new BotaniaFlowerBlock(class_1767.field_7951, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 yellowFlower = new BotaniaFlowerBlock(class_1767.field_7947, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 limeFlower = new BotaniaFlowerBlock(class_1767.field_7961, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 pinkFlower = new BotaniaFlowerBlock(class_1767.field_7954, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 grayFlower = new BotaniaFlowerBlock(class_1767.field_7944, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 lightGrayFlower = new BotaniaFlowerBlock(class_1767.field_7967, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 cyanFlower = new BotaniaFlowerBlock(class_1767.field_7955, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 purpleFlower = new BotaniaFlowerBlock(class_1767.field_7945, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 blueFlower = new BotaniaFlowerBlock(class_1767.field_7966, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 brownFlower = new BotaniaFlowerBlock(class_1767.field_7957, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 greenFlower = new BotaniaFlowerBlock(class_1767.field_7942, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 redFlower = new BotaniaFlowerBlock(class_1767.field_7964, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 blackFlower = new BotaniaFlowerBlock(class_1767.field_7963, class_4970.class_2251.method_9630(whiteFlower));

	public static final class_2248 whiteShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower).method_9631(s -> 15));
	public static final class_2248 orangeShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7946, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 magentaShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7958, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 lightBlueShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7951, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 yellowShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7947, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 limeShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7961, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 pinkShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7954, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 grayShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7944, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 lightGrayShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7967, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 cyanShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7955, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 purpleShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7945, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 blueShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7966, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 brownShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7957, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 greenShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7942, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 redShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7964, class_4970.class_2251.method_9630(whiteShinyFlower));
	public static final class_2248 blackShinyFlower = new GlimmeringFlowerBlock(class_1767.field_7963, class_4970.class_2251.method_9630(whiteShinyFlower));

	public static final class_2248 whiteBuriedPetals = new BuriedPetalBlock(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower).method_9626(class_2498.field_28697).method_9631(s -> 4));
	public static final class_2248 orangeBuriedPetals = new BuriedPetalBlock(class_1767.field_7946, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 magentaBuriedPetals = new BuriedPetalBlock(class_1767.field_7958, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 lightBlueBuriedPetals = new BuriedPetalBlock(class_1767.field_7951, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 yellowBuriedPetals = new BuriedPetalBlock(class_1767.field_7947, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 limeBuriedPetals = new BuriedPetalBlock(class_1767.field_7961, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 pinkBuriedPetals = new BuriedPetalBlock(class_1767.field_7954, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 grayBuriedPetals = new BuriedPetalBlock(class_1767.field_7944, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 lightGrayBuriedPetals = new BuriedPetalBlock(class_1767.field_7967, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 cyanBuriedPetals = new BuriedPetalBlock(class_1767.field_7955, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 purpleBuriedPetals = new BuriedPetalBlock(class_1767.field_7945, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 blueBuriedPetals = new BuriedPetalBlock(class_1767.field_7966, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 brownBuriedPetals = new BuriedPetalBlock(class_1767.field_7957, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 greenBuriedPetals = new BuriedPetalBlock(class_1767.field_7942, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 redBuriedPetals = new BuriedPetalBlock(class_1767.field_7964, class_4970.class_2251.method_9630(whiteBuriedPetals));
	public static final class_2248 blackBuriedPetals = new BuriedPetalBlock(class_1767.field_7963, class_4970.class_2251.method_9630(whiteBuriedPetals));

	public static final class_4970.class_2251 FLOATING_PROPS = class_4970.class_2251.method_9637().method_31710(class_3620.field_16004).method_9632(0.5F).method_9626(class_2498.field_11529).method_9631(s -> 15);
	public static final class_2248 whiteFloatingFlower = new FloatingFlowerBlock(class_1767.field_7952, FLOATING_PROPS);
	public static final class_2248 orangeFloatingFlower = new FloatingFlowerBlock(class_1767.field_7946, FLOATING_PROPS);
	public static final class_2248 magentaFloatingFlower = new FloatingFlowerBlock(class_1767.field_7958, FLOATING_PROPS);
	public static final class_2248 lightBlueFloatingFlower = new FloatingFlowerBlock(class_1767.field_7951, FLOATING_PROPS);
	public static final class_2248 yellowFloatingFlower = new FloatingFlowerBlock(class_1767.field_7947, FLOATING_PROPS);
	public static final class_2248 limeFloatingFlower = new FloatingFlowerBlock(class_1767.field_7961, FLOATING_PROPS);
	public static final class_2248 pinkFloatingFlower = new FloatingFlowerBlock(class_1767.field_7954, FLOATING_PROPS);
	public static final class_2248 grayFloatingFlower = new FloatingFlowerBlock(class_1767.field_7944, FLOATING_PROPS);
	public static final class_2248 lightGrayFloatingFlower = new FloatingFlowerBlock(class_1767.field_7967, FLOATING_PROPS);
	public static final class_2248 cyanFloatingFlower = new FloatingFlowerBlock(class_1767.field_7955, FLOATING_PROPS);
	public static final class_2248 purpleFloatingFlower = new FloatingFlowerBlock(class_1767.field_7945, FLOATING_PROPS);
	public static final class_2248 blueFloatingFlower = new FloatingFlowerBlock(class_1767.field_7966, FLOATING_PROPS);
	public static final class_2248 brownFloatingFlower = new FloatingFlowerBlock(class_1767.field_7957, FLOATING_PROPS);
	public static final class_2248 greenFloatingFlower = new FloatingFlowerBlock(class_1767.field_7942, FLOATING_PROPS);
	public static final class_2248 redFloatingFlower = new FloatingFlowerBlock(class_1767.field_7964, FLOATING_PROPS);
	public static final class_2248 blackFloatingFlower = new FloatingFlowerBlock(class_1767.field_7963, FLOATING_PROPS);

	public static final class_2248 petalBlockWhite = new PetalBlock(class_1767.field_7952, class_4970.class_2251.method_9637().method_51517(class_1767.field_7952).method_9632(0.4F).method_9626(class_2498.field_28697));
	public static final class_2248 petalBlockOrange = new PetalBlock(class_1767.field_7946, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7946));
	public static final class_2248 petalBlockMagenta = new PetalBlock(class_1767.field_7958, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7958));
	public static final class_2248 petalBlockLightBlue = new PetalBlock(class_1767.field_7951, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7951));
	public static final class_2248 petalBlockYellow = new PetalBlock(class_1767.field_7947, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7947));
	public static final class_2248 petalBlockLime = new PetalBlock(class_1767.field_7961, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7961));
	public static final class_2248 petalBlockPink = new PetalBlock(class_1767.field_7954, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7954));
	public static final class_2248 petalBlockGray = new PetalBlock(class_1767.field_7944, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7944));
	public static final class_2248 petalBlockSilver = new PetalBlock(class_1767.field_7967, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7967));
	public static final class_2248 petalBlockCyan = new PetalBlock(class_1767.field_7955, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7955));
	public static final class_2248 petalBlockPurple = new PetalBlock(class_1767.field_7945, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7945));
	public static final class_2248 petalBlockBlue = new PetalBlock(class_1767.field_7966, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7966));
	public static final class_2248 petalBlockBrown = new PetalBlock(class_1767.field_7957, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7957));
	public static final class_2248 petalBlockGreen = new PetalBlock(class_1767.field_7942, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7942));
	public static final class_2248 petalBlockRed = new PetalBlock(class_1767.field_7964, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7964));
	public static final class_2248 petalBlockBlack = new PetalBlock(class_1767.field_7963, class_4970.class_2251.method_9630(petalBlockWhite).method_51517(class_1767.field_7963));

	public static final class_2248 whiteMushroom = new BotaniaMushroomBlock(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower).method_9631(s -> 3).method_49229(class_4970.class_2250.field_10656));
	public static final class_2248 orangeMushroom = new BotaniaMushroomBlock(class_1767.field_7946, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 magentaMushroom = new BotaniaMushroomBlock(class_1767.field_7958, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 lightBlueMushroom = new BotaniaMushroomBlock(class_1767.field_7951, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 yellowMushroom = new BotaniaMushroomBlock(class_1767.field_7947, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 limeMushroom = new BotaniaMushroomBlock(class_1767.field_7961, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 pinkMushroom = new BotaniaMushroomBlock(class_1767.field_7954, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 grayMushroom = new BotaniaMushroomBlock(class_1767.field_7944, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 lightGrayMushroom = new BotaniaMushroomBlock(class_1767.field_7967, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 cyanMushroom = new BotaniaMushroomBlock(class_1767.field_7955, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 purpleMushroom = new BotaniaMushroomBlock(class_1767.field_7945, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 blueMushroom = new BotaniaMushroomBlock(class_1767.field_7966, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 brownMushroom = new BotaniaMushroomBlock(class_1767.field_7957, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 greenMushroom = new BotaniaMushroomBlock(class_1767.field_7942, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 redMushroom = new BotaniaMushroomBlock(class_1767.field_7964, class_4970.class_2251.method_9630(whiteMushroom));
	public static final class_2248 blackMushroom = new BotaniaMushroomBlock(class_1767.field_7963, class_4970.class_2251.method_9630(whiteMushroom));

	public static final class_2248 doubleFlowerWhite = new BotaniaDoubleFlowerBlock(class_1767.field_7952, class_4970.class_2251.method_9630(whiteFlower));
	public static final class_2248 doubleFlowerOrange = new BotaniaDoubleFlowerBlock(class_1767.field_7946, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerMagenta = new BotaniaDoubleFlowerBlock(class_1767.field_7958, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerLightBlue = new BotaniaDoubleFlowerBlock(class_1767.field_7951, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerYellow = new BotaniaDoubleFlowerBlock(class_1767.field_7947, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerLime = new BotaniaDoubleFlowerBlock(class_1767.field_7961, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerPink = new BotaniaDoubleFlowerBlock(class_1767.field_7954, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerGray = new BotaniaDoubleFlowerBlock(class_1767.field_7944, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerLightGray = new BotaniaDoubleFlowerBlock(class_1767.field_7967, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerCyan = new BotaniaDoubleFlowerBlock(class_1767.field_7955, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerPurple = new BotaniaDoubleFlowerBlock(class_1767.field_7945, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerBlue = new BotaniaDoubleFlowerBlock(class_1767.field_7966, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerBrown = new BotaniaDoubleFlowerBlock(class_1767.field_7957, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerGreen = new BotaniaDoubleFlowerBlock(class_1767.field_7942, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerRed = new BotaniaDoubleFlowerBlock(class_1767.field_7964, class_4970.class_2251.method_9630(doubleFlowerWhite));
	public static final class_2248 doubleFlowerBlack = new BotaniaDoubleFlowerBlock(class_1767.field_7963, class_4970.class_2251.method_9630(doubleFlowerWhite));

	public static final class_2248 pottedWhiteFlower = flowerPot(whiteFlower, 0);
	public static final class_2248 pottedOrangeFlower = flowerPot(orangeFlower, 0);
	public static final class_2248 pottedMagentaFlower = flowerPot(magentaFlower, 0);
	public static final class_2248 pottedLightBlueFlower = flowerPot(lightBlueFlower, 0);
	public static final class_2248 pottedYellowFlower = flowerPot(yellowFlower, 0);
	public static final class_2248 pottedLimeFlower = flowerPot(limeFlower, 0);
	public static final class_2248 pottedPinkFlower = flowerPot(pinkFlower, 0);
	public static final class_2248 pottedGrayFlower = flowerPot(grayFlower, 0);
	public static final class_2248 pottedLightGrayFlower = flowerPot(lightGrayFlower, 0);
	public static final class_2248 pottedCyanFlower = flowerPot(cyanFlower, 0);
	public static final class_2248 pottedPurpleFlower = flowerPot(purpleFlower, 0);
	public static final class_2248 pottedBlueFlower = flowerPot(blueFlower, 0);
	public static final class_2248 pottedBrownFlower = flowerPot(brownFlower, 0);
	public static final class_2248 pottedGreenFlower = flowerPot(greenFlower, 0);
	public static final class_2248 pottedRedFlower = flowerPot(redFlower, 0);
	public static final class_2248 pottedBlackFlower = flowerPot(blackFlower, 0);

	public static final class_2248 pottedWhiteShinyFlower = flowerPot(whiteShinyFlower, 15);
	public static final class_2248 pottedOrangeShinyFlower = flowerPot(orangeShinyFlower, 15);
	public static final class_2248 pottedMagentaShinyFlower = flowerPot(magentaShinyFlower, 15);
	public static final class_2248 pottedLightBlueShinyFlower = flowerPot(lightBlueShinyFlower, 15);
	public static final class_2248 pottedYellowShinyFlower = flowerPot(yellowShinyFlower, 15);
	public static final class_2248 pottedLimeShinyFlower = flowerPot(limeShinyFlower, 15);
	public static final class_2248 pottedPinkShinyFlower = flowerPot(pinkShinyFlower, 15);
	public static final class_2248 pottedGrayShinyFlower = flowerPot(grayShinyFlower, 15);
	public static final class_2248 pottedLightGrayShinyFlower = flowerPot(lightGrayShinyFlower, 15);
	public static final class_2248 pottedCyanShinyFlower = flowerPot(cyanShinyFlower, 15);
	public static final class_2248 pottedPurpleShinyFlower = flowerPot(purpleShinyFlower, 15);
	public static final class_2248 pottedBlueShinyFlower = flowerPot(blueShinyFlower, 15);
	public static final class_2248 pottedBrownShinyFlower = flowerPot(brownShinyFlower, 15);
	public static final class_2248 pottedGreenShinyFlower = flowerPot(greenShinyFlower, 15);
	public static final class_2248 pottedRedShinyFlower = flowerPot(redShinyFlower, 15);
	public static final class_2248 pottedBlackShinyFlower = flowerPot(blackShinyFlower, 15);

	public static final class_2248 pottedWhiteMushroom = flowerPot(whiteMushroom, 3);
	public static final class_2248 pottedOrangeMushroom = flowerPot(orangeMushroom, 3);
	public static final class_2248 pottedMagentaMushroom = flowerPot(magentaMushroom, 3);
	public static final class_2248 pottedLightBlueMushroom = flowerPot(lightBlueMushroom, 3);
	public static final class_2248 pottedYellowMushroom = flowerPot(yellowMushroom, 3);
	public static final class_2248 pottedLimeMushroom = flowerPot(limeMushroom, 3);
	public static final class_2248 pottedPinkMushroom = flowerPot(pinkMushroom, 3);
	public static final class_2248 pottedGrayMushroom = flowerPot(grayMushroom, 3);
	public static final class_2248 pottedLightGrayMushroom = flowerPot(lightGrayMushroom, 3);
	public static final class_2248 pottedCyanMushroom = flowerPot(cyanMushroom, 3);
	public static final class_2248 pottedPurpleMushroom = flowerPot(purpleMushroom, 3);
	public static final class_2248 pottedBlueMushroom = flowerPot(blueMushroom, 3);
	public static final class_2248 pottedBrownMushroom = flowerPot(brownMushroom, 3);
	public static final class_2248 pottedGreenMushroom = flowerPot(greenMushroom, 3);
	public static final class_2248 pottedRedMushroom = flowerPot(redMushroom, 3);
	public static final class_2248 pottedBlackMushroom = flowerPot(blackMushroom, 3);

	public static final class_2248 defaultAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.DEFAULT, class_4970.class_2251.method_9637()
			.method_9632(3.5F).method_9626(class_2498.field_11544).method_51368(class_2766.field_12653).method_29292().method_31710(class_3620.field_16023)
			.method_9631(s -> s.method_11654(PetalApothecaryBlock.FLUID) == PetalApothecary.State.LAVA ? 15 : 0));
	public static final class_2248 deepslateAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.DEEPSLATE, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29033).method_31710(class_3620.field_33532));
	public static final class_2248 livingrockAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.LIVINGROCK, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_11544).method_31710(class_3620.field_16003));
	public static final class_2248 mossyAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.MOSSY, class_4970.class_2251.method_9630(defaultAltar));
	public static final class_2248 forestAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.FOREST, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_27202).method_31710(class_3620.field_16004));
	public static final class_2248 plainsAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.PLAINS, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_27203).method_51517(class_1767.field_7952));
	public static final class_2248 mountainAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.MOUNTAIN, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29035).method_51517(class_1767.field_7967));
	public static final class_2248 fungalAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.FUNGAL, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29034).method_31710(class_3620.field_25703));
	public static final class_2248 swampAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.SWAMP, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29035).method_31710(class_3620.field_15992));
	public static final class_2248 desertAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.DESERT, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29033).method_31710(class_3620.field_15981));
	public static final class_2248 taigaAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.TAIGA, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_29033).method_51517(class_1767.field_7966));
	public static final class_2248 mesaAltar = new PetalApothecaryBlock(PetalApothecaryBlock.Variant.MESA, class_4970.class_2251.method_9630(defaultAltar).method_9626(class_2498.field_27203).method_31710(class_3620.field_16003));
	public static final class_2248[] ALL_APOTHECARIES = new class_2248[] { defaultAltar, deepslateAltar, livingrockAltar, mossyAltar, forestAltar, plainsAltar, mountainAltar, fungalAltar, swampAltar, desertAltar, taigaAltar, mesaAltar };

	public static final class_2248 livingrock = new BotaniaBlock(class_4970.class_2251.method_9637().method_9629(2, 10).method_9626(class_2498.field_11544)
			.method_51368(class_2766.field_12653).method_31710(class_3620.field_16003).method_29292());
	public static final class_2248 livingrockPolished = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockSlate = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrick = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickCracked = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockBrickMossy = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));

	public static final class_2248 livingwoodLog = new class_2465(class_4970.class_2251.method_9637().method_9632(2)
			.method_9626(class_2498.field_11547).method_51368(class_2766.field_12651).method_51520(state -> state.method_11654(class_2741.field_12496) == class_2350.class_2351.field_11052 ? class_3620.field_15982 : class_3620.field_15992));
	public static final class_2248 livingwoodLogStripped = new class_2465(class_4970.class_2251.method_9630(livingwoodLog).method_31710(class_3620.field_15982));
	public static final class_2248 livingwoodLogGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLog).method_9631(b -> 12));
	public static final class_2248 livingwoodLogStrippedGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogStripped).method_9631(b -> 8));
	public static final class_2248 livingwood = new class_2465(class_4970.class_2251.method_9630(livingwoodLog).method_31710(class_3620.field_15992));
	public static final class_2248 livingwoodStripped = new class_2465(class_4970.class_2251.method_9630(livingwoodLogStripped));
	public static final class_2248 livingwoodGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogGlimmering).method_31710(class_3620.field_15992));
	public static final class_2248 livingwoodStrippedGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogStrippedGlimmering).method_31710(class_3620.field_15992));
	public static final class_2248 livingwoodPlanks = new BotaniaBlock(class_4970.class_2251.method_9630(livingwoodLog).method_31710(class_3620.field_15982));
	public static final class_2248 livingwoodPlanksMossy = new BotaniaBlock(class_4970.class_2251.method_9630(livingwoodPlanks));
	public static final class_2248 livingwoodFramed = new class_2465(class_4970.class_2251.method_9630(livingwoodPlanks));
	public static final class_2248 livingwoodPatternFramed = new BotaniaBlock(class_4970.class_2251.method_9630(livingwoodPlanks));

	public static final class_2248 dreamwoodLog = new class_2465(class_4970.class_2251.method_9630(livingwoodLog).method_31710(class_3620.field_16025));
	public static final class_2248 dreamwoodLogStripped = new class_2465(class_4970.class_2251.method_9630(dreamwoodLog));
	public static final class_2248 dreamwoodLogGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogGlimmering).method_31710(class_3620.field_16025));
	public static final class_2248 dreamwoodLogStrippedGlimmering = new class_2465(class_4970.class_2251.method_9630(livingwoodLogStrippedGlimmering).method_31710(class_3620.field_16025));
	public static final class_2248 dreamwood = new class_2465(class_4970.class_2251.method_9630(dreamwoodLog));
	public static final class_2248 dreamwoodStripped = new class_2465(class_4970.class_2251.method_9630(dreamwoodLog));
	public static final class_2248 dreamwoodGlimmering = new class_2465(class_4970.class_2251.method_9630(dreamwoodLogGlimmering));
	public static final class_2248 dreamwoodStrippedGlimmering = new class_2465(class_4970.class_2251.method_9630(dreamwoodLogStrippedGlimmering));
	public static final class_2248 dreamwoodPlanks = new BotaniaBlock(class_4970.class_2251.method_9630(dreamwoodLog));
	public static final class_2248 dreamwoodPlanksMossy = new BotaniaBlock(class_4970.class_2251.method_9630(dreamwoodPlanks));
	public static final class_2248 dreamwoodFramed = new class_2465(class_4970.class_2251.method_9630(dreamwoodPlanks));
	public static final class_2248 dreamwoodPatternFramed = new BotaniaBlock(class_4970.class_2251.method_9630(dreamwoodPlanks));

	public static final class_2248 manaSpreader = new ManaSpreaderBlock(ManaSpreaderBlock.Variant.MANA, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));
	public static final class_2248 redstoneSpreader = new ManaSpreaderBlock(ManaSpreaderBlock.Variant.REDSTONE, class_4970.class_2251.method_9630(livingwood).method_26235(NO_SPAWN));
	public static final class_2248 elvenSpreader = new ManaSpreaderBlock(ManaSpreaderBlock.Variant.ELVEN, class_4970.class_2251.method_9630(dreamwood).method_26235(NO_SPAWN));
	public static final class_2248 gaiaSpreader = new ManaSpreaderBlock(ManaSpreaderBlock.Variant.GAIA, class_4970.class_2251.method_9630(dreamwood).method_26235(NO_SPAWN));

	public static final class_2248 manaPool = new ManaPoolBlock(ManaPoolBlock.Variant.DEFAULT, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 creativePool = new ManaPoolBlock(ManaPoolBlock.Variant.CREATIVE, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 dilutedPool = new ManaPoolBlock(ManaPoolBlock.Variant.DILUTED, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 fabulousPool = new ManaPoolBlock(ManaPoolBlock.Variant.FABULOUS, class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 alchemyCatalyst = new AlchemyCatalystBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 conjurationCatalyst = new ConjurationCatalystBlock(class_4970.class_2251.method_9630(livingrock));

	public static final class_2248 manasteelBlock = new BotaniaBlock(class_4970.class_2251.method_9637().method_9629(3, 10).method_31710(class_3620.field_15980)
			.method_9626(class_2498.field_11533).method_51368(class_2766.field_18284).method_29292());
	public static final class_2248 terrasteelBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock).method_31710(class_3620.field_16001));
	public static final class_2248 elementiumBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock).method_31710(class_3620.field_16030));
	public static final class_2248 manaDiamondBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock).method_31710(class_3620.field_15983));
	public static final class_2248 dragonstoneBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock).method_51368(class_2766.field_12648).method_31710(class_3620.field_16030));

	public static final class_2248 manaGlass = new BotaniaGlassBlock(class_4970.class_2251.method_9630(class_2246.field_10033).method_9631(s -> 15).method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));
	public static final class_2248 elfGlass = new BotaniaGlassBlock(class_4970.class_2251.method_9630(manaGlass).method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));
	public static final class_2248 bifrost = new BifrostBlock(class_4970.class_2251.method_9637().method_9629(-1, 0.3F)
			.method_9631(s -> 15).method_9626(class_2498.field_11537).method_51368(class_2766.field_12645).method_22488()
			.method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));
	public static final class_2248 bifrostPerm = new PermanentBifrostBlock(class_4970.class_2251.method_9637().method_9632(0.3F)
			.method_9631(s -> 15).method_9626(class_2498.field_11537).method_51368(class_2766.field_12645).method_22488()
			.method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION).method_26235(NO_SPAWN));

	public static final class_2248 runeAltar = new RunicAltarBlock(class_4970.class_2251.method_9630(livingrock).method_29292());
	public static final class_2248 enchanter = new ManaEnchanterBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_15980).method_9629(3, 5).method_9631(s -> 15).method_9626(class_2498.field_11544));
	public static final class_2248 brewery = new BotanicalBreweryBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 terraPlate = new TerrestrialAgglomerationPlateBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_15980).method_9629(3, 10).method_9626(class_2498.field_11533).method_29292());
	public static final class_2248 alfPortal = new AlfheimPortalBlock(class_4970.class_2251.method_9630(livingwood).method_9632(10).method_9626(class_2498.field_11547)
			.method_9631(s -> s.method_11654(BotaniaStateProperties.ALFPORTAL_STATE) != AlfheimPortalState.OFF ? 15 : 0));

	public static final class_2248 manaPylon = new PylonBlock(PylonBlock.Variant.MANA, class_4970.class_2251.method_9637().method_51517(class_1767.field_7951).method_9632(5.5F).method_9626(class_2498.field_11533).method_9631(s -> 7).method_29292());
	public static final class_2248 naturaPylon = new PylonBlock(PylonBlock.Variant.NATURA, class_4970.class_2251.method_9630(manaPylon).method_31710(class_3620.field_16001));
	public static final class_2248 gaiaPylon = new PylonBlock(PylonBlock.Variant.GAIA, class_4970.class_2251.method_9630(manaPylon).method_51517(class_1767.field_7954));

	public static final class_2248 distributor = new ManaSplitterBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 manaVoid = new ManaVoidBlock(class_4970.class_2251.method_9630(livingrock).method_9629(2, 2000));
	public static final class_2248 manaDetector = new ManaDetectorBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 pistonRelay = new ForceRelayBlock(class_4970.class_2251.method_9637().method_9629(2, 10).method_9626(class_2498.field_11533).method_31710(class_3620.field_16014).method_26235(NO_SPAWN));
	public static final class_2248 turntable = new SpreaderTurntableBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 tinyPlanet = new TinyPlanetBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_33532).method_9629(20, 100)
			.method_9626(class_2498.field_29033).method_51368(class_2766.field_12653).method_29292());
	public static final class_2248 wildDrum = new DrumBlock(DrumBlock.Variant.WILD, class_4970.class_2251.method_9630(livingwood).method_51368(class_2766.field_12653));
	public static final class_2248 gatheringDrum = new DrumBlock(DrumBlock.Variant.GATHERING, class_4970.class_2251.method_9630(wildDrum));
	public static final class_2248 canopyDrum = new DrumBlock(DrumBlock.Variant.CANOPY, class_4970.class_2251.method_9630(wildDrum));
	public static final class_2248 spawnerClaw = new LifeImbuerBlock(class_4970.class_2251.method_9637().method_9626(class_2498.field_11533).method_9632(3).method_29292());
	public static final class_2248 rfGenerator = new PowerGeneratorBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 prism = new ManaPrismBlock(class_4970.class_2251.method_9630(elfGlass).method_9634());
	public static final class_2248 pump = new ManaPumpBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 sparkChanger = new SparkTinkererBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 manaBomb = new ManastormChargeBlock(class_4970.class_2251.method_9630(livingwood).method_9632(12));
	public static final class_2248 bellows = new BellowsBlock(class_4970.class_2251.method_9630(livingwood));

	public static final class_2248 openCrate = new OpenCrateBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 craftCrate = new CraftyCrateBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 forestEye = new EyeOfTheAncientsBlock(class_4970.class_2251.method_9637().method_9629(5, 10).method_9626(class_2498.field_11533).method_29292());
	public static final class_2248 solidVines = new SolidVineBlock(class_4970.class_2251.method_9630(class_2246.field_10597));
	public static final class_2248 abstrusePlatform = new PlatformBlock(PlatformBlock.Variant.ABSTRUSE, class_4970.class_2251.method_9630(livingwood).method_9629(2, 5).method_26235(NO_SPAWN).method_22488().method_26245(NO_SUFFOCATION).method_26243(NO_SUFFOCATION));
	public static final class_2248 spectralPlatform = new PlatformBlock(PlatformBlock.Variant.SPECTRAL, class_4970.class_2251.method_9630(abstrusePlatform));
	public static final class_2248 infrangiblePlatform = new PlatformBlock(PlatformBlock.Variant.INFRANGIBLE, class_4970.class_2251.method_9630(abstrusePlatform).method_9629(-1, Float.MAX_VALUE).method_26235(NO_SPAWN).method_22488());
	public static final class_2248 tinyPotato = new TinyPotatoBlock(class_4970.class_2251.method_9637().method_9632(0.25F).method_51517(class_1767.field_7954));
	public static final class_2248 enderEye = new EnderOverseerBlock(class_4970.class_2251.method_9630(manasteelBlock));
	public static final class_2248 redStringContainer = new RedStringContainerBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringDispenser = new RedStringDispenserBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringFertilizer = new RedStringNutrifierBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringComparator = new RedStringComparatorBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringRelay = new RedStringSpooferBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 redStringInterceptor = new RedStringInterceptorBlock(class_4970.class_2251.method_9630(livingrock));

	public static final class_2248 corporeaFunnel = new CorporeaFunnelBlock(class_4970.class_2251.method_9637().method_9632(5.5F)
			.method_51517(class_1767.field_7945).method_9626(class_2498.field_11533).method_51368(class_2766.field_12653).method_29292());
	public static final class_2248 corporeaInterceptor = new CorporeaInterceptorBlock(class_4970.class_2251.method_9630(corporeaFunnel));
	public static final class_2248 corporeaIndex = new CorporeaIndexBlock(class_4970.class_2251.method_9630(corporeaFunnel).method_22488());
	public static final class_2248 corporeaCrystalCube = new CorporeaCrystalCubeBlock(class_4970.class_2251.method_9630(corporeaFunnel));
	public static final class_2248 corporeaRetainer = new CorporeaRetainerBlock(class_4970.class_2251.method_9630(corporeaFunnel));

	public static final class_2248 corporeaBlock = new BotaniaBlock(class_4970.class_2251.method_9630(corporeaFunnel));
	public static final class_2248 corporeaBrick = new BotaniaBlock(class_4970.class_2251.method_9630(corporeaBlock));
	public static final class_2482 corporeaSlab = new class_2482(class_4970.class_2251.method_9630(corporeaBlock));
	public static final class_2510 corporeaStairs = new BotaniaStairBlock(corporeaBlock.method_9564(), class_4970.class_2251.method_9630(corporeaBlock));
	public static final class_2482 corporeaBrickSlab = new class_2482(class_4970.class_2251.method_9630(corporeaBrick));
	public static final class_2510 corporeaBrickStairs = new BotaniaStairBlock(corporeaBrick.method_9564(), class_4970.class_2251.method_9630(corporeaBrick));
	public static final class_2248 corporeaBrickWall = new class_2544(class_4970.class_2251.method_9630(corporeaBrick));

	public static final class_2248 incensePlate = new IncensePlateBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 hourglass = new HoveringHourglassBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_15994).method_9632(2).method_9626(class_2498.field_11533));
	public static final class_2248 ghostRail = new SpectralRailBlock(class_4970.class_2251.method_9630(class_2246.field_10167));
	public static final class_2248 lightRelayDefault = new LuminizerBlock(LuminizerVariant.DEFAULT, class_4970.class_2251.method_9637().method_9634());
	public static final class_2248 lightRelayDetector = new LuminizerBlock(LuminizerVariant.DETECTOR, class_4970.class_2251.method_9630(lightRelayDefault));
	public static final class_2248 lightRelayFork = new LuminizerBlock(LuminizerVariant.FORK, class_4970.class_2251.method_9630(lightRelayDefault));
	public static final class_2248 lightRelayToggle = new LuminizerBlock(LuminizerVariant.TOGGLE, class_4970.class_2251.method_9630(lightRelayDefault));
	public static final class_2248 lightLauncher = new LuminizerLauncherBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 cacophonium = new CacophoniumBlock(class_4970.class_2251.method_9630(class_2246.field_10179).method_9632(0.8F));
	public static final class_2248 cellBlock = new CellularBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9626(class_2498.field_11543));
	public static final class_2248 teruTeruBozu = new TeruTeruBozuBlock(class_4970.class_2251.method_9637().method_9626(class_2498.field_11543).method_51368(class_2766.field_12654).method_51517(class_1767.field_7952));
	public static final class_2248 avatar = new AvatarBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 fakeAir = new FakeAirBlock(class_4970.class_2251.method_9637().method_51371().method_9634().method_42327().method_26250().method_9640());
	public static final class_2248 root = new LivingRootBlock(class_4970.class_2251.method_9637().method_9632(1.2F).method_9626(class_2498.field_11547));
	public static final class_2248 felPumpkin = new FelPumpkinBlock(class_4970.class_2251.method_9630(class_2246.field_10147));
	public static final class_2248 cocoon = new CocoonBlock(class_4970.class_2251.method_9637().method_9629(3, 60).method_9626(class_2498.field_11543));
	public static final class_2248 enchantedSoil = new EnchantedSoilBlock(class_4970.class_2251.method_9637().method_9632(0.6F).method_9626(class_2498.field_11535).method_31710(class_3620.field_15999));
	public static final class_2248 animatedTorch = new AnimatedTorchBlock(class_4970.class_2251.method_9637().method_9631(s -> 7).method_22488());
	public static final class_2248 starfield = new StarfieldCreatorBlock(class_4970.class_2251.method_9637().method_51517(class_1767.field_7954).method_9629(5, 2000).method_9626(class_2498.field_11533));

	public static final class_2248 azulejo0 = new BotaniaBlock(class_4970.class_2251.method_9637().method_31710(class_3620.field_15980).method_9629(2, 5)
			.method_9626(class_2498.field_11544).method_51368(class_2766.field_12653).method_29292());
	public static final class_2248 azulejo1 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo2 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo3 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo4 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo5 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo6 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo7 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo8 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo9 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo10 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo11 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo12 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo13 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo14 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 azulejo15 = new BotaniaBlock(class_4970.class_2251.method_9630(azulejo0));
	public static final class_2248 manaFlame = new ManaFlameBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9626(class_2498.field_11543).method_9631(s -> 15).method_9634());
	public static final class_2248 blazeBlock = new BotaniaBlock(class_4970.class_2251.method_9630(manasteelBlock).method_51368(class_2766.field_18289).method_9631(s -> 15).method_31710(class_3620.field_15994));
	public static final class_2248 gaiaHead = new GaiaHeadBlock(class_4970.class_2251.method_9637().method_50012(class_3619.field_15971).method_9632(1));
	public static final class_2248 gaiaHeadWall = new WallGaiaHeadBlock(class_4970.class_2251.method_9630(gaiaHead));
	public static final class_2248 shimmerrock = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 shimmerwoodPlanks = new BotaniaBlock(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 dryGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.DRY, class_4970.class_2251.method_9637().method_9632(0.6F).method_9640().method_9626(class_2498.field_11535).method_31710(class_3620.field_16018));
	public static final class_2248 goldenGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.GOLDEN, class_4970.class_2251.method_9630(dryGrass).method_31710(class_3620.field_15994));
	public static final class_2248 vividGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.VIVID, class_4970.class_2251.method_9630(dryGrass).method_31710(class_3620.field_16004));
	public static final class_2248 scorchedGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.SCORCHED, class_4970.class_2251.method_9630(dryGrass).method_31710(class_3620.field_16012));
	public static final class_2248 infusedGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.INFUSED, class_4970.class_2251.method_9630(dryGrass).method_31710(class_3620.field_16026));
	public static final class_2248 mutatedGrass = new BotaniaGrassBlock(BotaniaGrassBlock.Variant.MUTATED, class_4970.class_2251.method_9630(dryGrass).method_31710(class_3620.field_25707));

	public static final class_2248 motifDaybloom = new FlowerMotifBlock(class_1294.field_5919, 15, class_4970.class_2251.method_9630(class_2246.field_10449), true);
	public static final class_2248 motifNightshade = new FlowerMotifBlock(class_1294.field_5899, 20, class_4970.class_2251.method_9630(class_2246.field_10449), true);
	public static final class_2248 motifHydroangeas = new FlowerMotifBlock(class_1294.field_5908, 10, class_4970.class_2251.method_9630(class_2246.field_10449), false);

	public static final class_2248 pottedMotifDaybloom = flowerPot(motifDaybloom, 0);
	public static final class_2248 pottedMotifNightshade = flowerPot(motifNightshade, 0);
	public static final class_2248 pottedMotifHydroangeas = flowerPot(motifHydroangeas, 0);

	public static final class_2248 livingwoodStairs = new BotaniaStairBlock(livingwood.method_9564(), class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodSlab = new class_2482(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodWall = new class_2544(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodFence = new class_2354(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodFenceGate = new class_2349(class_4970.class_2251.method_9630(livingwood), BotaniaBlockSetTypes.LIVINGWOOD);
	public static final class_2248 livingwoodStrippedStairs = new BotaniaStairBlock(livingwoodStripped.method_9564(), class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodStrippedSlab = new class_2482(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodStrippedWall = new class_2544(class_4970.class_2251.method_9630(livingwood));
	public static final class_2248 livingwoodPlankStairs = new BotaniaStairBlock(livingwoodPlanks.method_9564(), class_4970.class_2251.method_9630(livingwoodPlanks));
	public static final class_2248 livingwoodPlankSlab = new class_2482(class_4970.class_2251.method_9630(livingwoodPlanks));

	public static final class_2248 livingrockStairs = new BotaniaStairBlock(livingrock.method_9564(), class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockSlab = new class_2482(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockWall = new class_2544(class_4970.class_2251.method_9630(livingrock));
	public static final class_2248 livingrockPolishedStairs = new BotaniaStairBlock(livingrock.method_9564(), class_4970.class_2251.method_9630(livingrockPolished));
	public static final class_2248 livingrockPolishedSlab = new class_2482(class_4970.class_2251.method_9630(livingrockPolished));
	public static final class_2248 livingrockPolishedWall = new class_2544(class_4970.class_2251.method_9630(livingrockPolished));
	public static final class_2248 livingrockBrickStairs = new BotaniaStairBlock(livingrockBrick.method_9564(), class_4970.class_2251.method_9630(livingrockBrick));
	public static final class_2248 livingrockBrickSlab = new class_2482(class_4970.class_2251.method_9630(livingrockBrick));
	public static final class_2248 livingrockBrickWall = new class_2544(class_4970.class_2251.method_9630(livingrockBrick));
	public static final class_2248 livingrockBrickMossyStairs = new BotaniaStairBlock(livingrockBrickMossy.method_9564(), class_4970.class_2251.method_9630(livingrockBrickMossy));
	public static final class_2248 livingrockBrickMossySlab = new class_2482(class_4970.class_2251.method_9630(livingrockBrickMossy));
	public static final class_2248 livingrockBrickMossyWall = new class_2544(class_4970.class_2251.method_9630(livingrockBrickMossy));

	public static final class_2248 dreamwoodStairs = new BotaniaStairBlock(dreamwood.method_9564(), class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodSlab = new class_2482(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodWall = new class_2544(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodFence = new class_2354(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodFenceGate = new class_2349(class_4970.class_2251.method_9630(dreamwood), BotaniaBlockSetTypes.DREAMWOOD);
	public static final class_2248 dreamwoodStrippedStairs = new BotaniaStairBlock(dreamwoodStripped.method_9564(), class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodStrippedSlab = new class_2482(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodStrippedWall = new class_2544(class_4970.class_2251.method_9630(dreamwood));
	public static final class_2248 dreamwoodPlankStairs = new BotaniaStairBlock(dreamwoodPlanks.method_9564(), class_4970.class_2251.method_9630(dreamwoodPlanks));
	public static final class_2248 dreamwoodPlankSlab = new class_2482(class_4970.class_2251.method_9630(dreamwoodPlanks));

	public static final class_2248 darkQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(class_2246.field_10153).method_31710(class_3620.field_16009));
	public static final class_2248 darkQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 darkQuartzPillar = new class_2465(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 darkQuartzSlab = new class_2482(class_4970.class_2251.method_9630(darkQuartz));
	public static final class_2248 darkQuartzStairs = new BotaniaStairBlock(darkQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 manaQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz).method_31710(class_3620.field_15983));
	public static final class_2248 manaQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(manaQuartz));
	public static final class_2248 manaQuartzPillar = new class_2465(class_4970.class_2251.method_9630(manaQuartz));
	public static final class_2248 manaQuartzSlab = new class_2482(class_4970.class_2251.method_9630(manaQuartz));
	public static final class_2248 manaQuartzStairs = new BotaniaStairBlock(manaQuartz.method_9564(), class_4970.class_2251.method_9630(darkQuartz));

	public static final class_2248 blazeQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz).method_31710(class_3620.field_15986));
	public static final class_2248 blazeQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(blazeQuartz));
	public static final class_2248 blazeQuartzPillar = new class_2465(class_4970.class_2251.method_9630(blazeQuartz));
	public static final class_2248 blazeQuartzSlab = new class_2482(class_4970.class_2251.method_9630(blazeQuartz));
	public static final class_2248 blazeQuartzStairs = new BotaniaStairBlock(blazeQuartz.method_9564(), class_4970.class_2251.method_9630(blazeQuartz));

	public static final class_2248 lavenderQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz).method_31710(class_3620.field_16030));
	public static final class_2248 lavenderQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(lavenderQuartz));
	public static final class_2248 lavenderQuartzPillar = new class_2465(class_4970.class_2251.method_9630(lavenderQuartz));
	public static final class_2248 lavenderQuartzSlab = new class_2482(class_4970.class_2251.method_9630(lavenderQuartz));
	public static final class_2248 lavenderQuartzStairs = new BotaniaStairBlock(lavenderQuartz.method_9564(), class_4970.class_2251.method_9630(lavenderQuartz));

	public static final class_2248 redQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz).method_31710(class_3620.field_16003));
	public static final class_2248 redQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(redQuartz));
	public static final class_2248 redQuartzPillar = new class_2465(class_4970.class_2251.method_9630(redQuartz));
	public static final class_2248 redQuartzSlab = new class_2482(class_4970.class_2251.method_9630(redQuartz));
	public static final class_2248 redQuartzStairs = new BotaniaStairBlock(redQuartz.method_9564(), class_4970.class_2251.method_9630(redQuartz));

	public static final class_2248 elfQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz).method_31710(class_3620.field_15997));
	public static final class_2248 elfQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(elfQuartz));
	public static final class_2248 elfQuartzPillar = new class_2465(class_4970.class_2251.method_9630(elfQuartz));
	public static final class_2248 elfQuartzSlab = new class_2482(class_4970.class_2251.method_9630(elfQuartz));
	public static final class_2248 elfQuartzStairs = new BotaniaStairBlock(elfQuartz.method_9564(), class_4970.class_2251.method_9630(elfQuartz));

	public static final class_2248 sunnyQuartz = new BotaniaBlock(class_4970.class_2251.method_9630(darkQuartz).method_31710(class_3620.field_16010));
	public static final class_2248 sunnyQuartzChiseled = new BotaniaBlock(class_4970.class_2251.method_9630(sunnyQuartz));
	public static final class_2248 sunnyQuartzPillar = new class_2465(class_4970.class_2251.method_9630(sunnyQuartz));
	public static final class_2248 sunnyQuartzSlab = new class_2482(class_4970.class_2251.method_9630(sunnyQuartz));
	public static final class_2248 sunnyQuartzStairs = new BotaniaStairBlock(sunnyQuartz.method_9564(), class_4970.class_2251.method_9630(sunnyQuartz));

	public static final class_2248 whitePavement = new BotaniaBlock(class_4970.class_2251.method_9630(livingrock).method_31710(class_3620.field_16003));
	public static final class_2248 whitePavementStair = new BotaniaStairBlock(whitePavement.method_9564(), class_4970.class_2251.method_9630(whitePavement));
	public static final class_2248 whitePavementSlab = new class_2482(class_4970.class_2251.method_9630(whitePavement));

	public static final class_2248 blackPavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement).method_31710(class_3620.field_15978));
	public static final class_2248 blackPavementStair = new BotaniaStairBlock(blackPavement.method_9564(), class_4970.class_2251.method_9630(blackPavement));
	public static final class_2248 blackPavementSlab = new class_2482(class_4970.class_2251.method_9630(blackPavement));

	public static final class_2248 bluePavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement).method_31710(class_3620.field_15984));
	public static final class_2248 bluePavementStair = new BotaniaStairBlock(bluePavement.method_9564(), class_4970.class_2251.method_9630(bluePavement));
	public static final class_2248 bluePavementSlab = new class_2482(class_4970.class_2251.method_9630(bluePavement));

	public static final class_2248 yellowPavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement).method_31710(class_3620.field_16013));
	public static final class_2248 yellowPavementStair = new BotaniaStairBlock(yellowPavement.method_9564(), class_4970.class_2251.method_9630(yellowPavement));
	public static final class_2248 yellowPavementSlab = new class_2482(class_4970.class_2251.method_9630(yellowPavement));

	public static final class_2248 redPavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement).method_31710(class_3620.field_15982));
	public static final class_2248 redPavementStair = new BotaniaStairBlock(redPavement.method_9564(), class_4970.class_2251.method_9630(redPavement));
	public static final class_2248 redPavementSlab = new class_2482(class_4970.class_2251.method_9630(redPavement));

	public static final class_2248 greenPavement = new BotaniaBlock(class_4970.class_2251.method_9630(whitePavement).method_31710(class_3620.field_16028));
	public static final class_2248 greenPavementStair = new BotaniaStairBlock(greenPavement.method_9564(), class_4970.class_2251.method_9630(greenPavement));
	public static final class_2248 greenPavementSlab = new class_2482(class_4970.class_2251.method_9630(greenPavement));

	public static final class_2248 biomeStoneForest = new BotaniaBlock(class_4970.class_2251.method_9637().method_9629(1.5F, 10)
			.method_9626(class_2498.field_27202).method_51368(class_2766.field_12653).method_29292().method_31710(class_3620.field_25705));
	public static final class_2248 biomeStoneForestSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneForestStairs = new BotaniaStairBlock(biomeStoneForest.method_9564(), class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeStoneForestWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForest = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForestSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForestStairs = new BotaniaStairBlock(biomeStoneForest.method_9564(), class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeCobblestoneForestWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForest = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForestSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForestStairs = new BotaniaStairBlock(biomeStoneForest.method_9564(), class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeBrickForestWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneForest));
	public static final class_2248 biomeChiseledBrickForest = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest));

	public static final class_2248 biomeStonePlains = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest)
			.method_9626(class_2498.field_27203).method_31710(class_3620.field_16025));
	public static final class_2248 biomeStonePlainsSlab = new class_2482(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeStonePlainsStairs = new BotaniaStairBlock(biomeStonePlains.method_9564(), class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeStonePlainsWall = new class_2544(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlains = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlainsSlab = new class_2482(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlainsStairs = new BotaniaStairBlock(biomeStonePlains.method_9564(), class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeCobblestonePlainsWall = new class_2544(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlains = new class_2465(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlainsSlab = new class_2482(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlainsStairs = new BotaniaStairBlock(biomeStonePlains.method_9564(), class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeBrickPlainsWall = new class_2544(class_4970.class_2251.method_9630(biomeStonePlains));
	public static final class_2248 biomeChiseledBrickPlains = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStonePlains));

	public static final class_2248 biomeStoneMountain = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest)
			.method_9626(class_2498.field_29035).method_31710(class_3620.field_33617));
	public static final class_2248 biomeStoneMountainSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeStoneMountainStairs = new BotaniaStairBlock(biomeStoneMountain.method_9564(), class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeStoneMountainWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountain = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountainSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountainStairs = new BotaniaStairBlock(biomeStoneMountain.method_9564(), class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeCobblestoneMountainWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountain = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountainSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountainStairs = new BotaniaStairBlock(biomeStoneMountain.method_9564(), class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeBrickMountainWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMountain));
	public static final class_2248 biomeChiseledBrickMountain = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMountain));

	public static final class_2248 biomeStoneFungal = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest)
			.method_9626(class_2498.field_29034).method_31710(class_3620.field_16029));
	public static final class_2248 biomeStoneFungalSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeStoneFungalStairs = new BotaniaStairBlock(biomeStoneFungal.method_9564(), class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeStoneFungalWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungal = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungalSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungalStairs = new BotaniaStairBlock(biomeStoneFungal.method_9564(), class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeCobblestoneFungalWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungal = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungalSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungalStairs = new BotaniaStairBlock(biomeStoneFungal.method_9564(), class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeBrickFungalWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneFungal));
	public static final class_2248 biomeChiseledBrickFungal = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneFungal));

	public static final class_2248 biomeStoneSwamp = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest)
			.method_9626(class_2498.field_29035).method_31710(class_3620.field_15988));
	public static final class_2248 biomeStoneSwampSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeStoneSwampStairs = new BotaniaStairBlock(biomeStoneSwamp.method_9564(), class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeStoneSwampWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwamp = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwampSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwampStairs = new BotaniaStairBlock(biomeStoneSwamp.method_9564(), class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeCobblestoneSwampWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwamp = new BotaniaDirectionalBlock(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwampSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwampStairs = new BotaniaStairBlock(biomeStoneSwamp.method_9564(), class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeBrickSwampWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneSwamp));
	public static final class_2248 biomeChiseledBrickSwamp = new BotaniaDirectionalBlock(class_4970.class_2251.method_9630(biomeStoneSwamp));

	public static final class_2248 biomeStoneDesert = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest)
			.method_9626(class_2498.field_29033).method_31710(class_3620.field_16000));
	public static final class_2248 biomeStoneDesertSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeStoneDesertStairs = new BotaniaStairBlock(biomeStoneDesert.method_9564(), class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeStoneDesertWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesert = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesertSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesertStairs = new BotaniaStairBlock(biomeStoneDesert.method_9564(), class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeCobblestoneDesertWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesert = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesertSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesertStairs = new BotaniaStairBlock(biomeStoneDesert.method_9564(), class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeBrickDesertWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneDesert));
	public static final class_2248 biomeChiseledBrickDesert = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneDesert));

	public static final class_2248 biomeStoneTaiga = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest)
			.method_9626(class_2498.field_29033).method_31710(class_3620.field_16015));
	public static final class_2248 biomeStoneTaigaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeStoneTaigaStairs = new BotaniaStairBlock(biomeStoneTaiga.method_9564(), class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeStoneTaigaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaiga = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaigaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaigaStairs = new BotaniaStairBlock(biomeStoneTaiga.method_9564(), class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeCobblestoneTaigaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaiga = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaigaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaigaStairs = new BotaniaStairBlock(biomeStoneTaiga.method_9564(), class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeBrickTaigaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneTaiga));
	public static final class_2248 biomeChiseledBrickTaiga = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneTaiga));

	public static final class_2248 biomeStoneMesa = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneForest)
			.method_9626(class_2498.field_27203).method_31710(class_3620.field_16003));
	public static final class_2248 biomeStoneMesaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeStoneMesaStairs = new BotaniaStairBlock(biomeStoneMesa.method_9564(), class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeStoneMesaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesa = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesaStairs = new BotaniaStairBlock(biomeStoneMesa.method_9564(), class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeCobblestoneMesaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesa = new BotaniaBlock(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesaSlab = new class_2482(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesaStairs = new BotaniaStairBlock(biomeStoneMesa.method_9564(), class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeBrickMesaWall = new class_2544(class_4970.class_2251.method_9630(biomeStoneMesa));
	public static final class_2248 biomeChiseledBrickMesa = new class_2465(class_4970.class_2251.method_9630(biomeStoneMesa));

	public static final class_2248 shimmerrockSlab = new class_2482(class_4970.class_2251.method_9630(shimmerrock));
	public static final class_2248 shimmerrockStairs = new BotaniaStairBlock(shimmerrock.method_9564(), class_4970.class_2251.method_9630(shimmerrock));

	public static final class_2248 shimmerwoodPlankSlab = new class_2482(class_4970.class_2251.method_9630(shimmerwoodPlanks));
	public static final class_2248 shimmerwoodPlankStairs = new BotaniaStairBlock(shimmerwoodPlanks.method_9564(), class_4970.class_2251.method_9630(shimmerwoodPlanks));

	public static final class_2248 managlassPane = new BotaniaPaneBlock(class_4970.class_2251.method_9630(manaGlass));
	public static final class_2248 alfglassPane = new BotaniaPaneBlock(class_4970.class_2251.method_9630(elfGlass));
	public static final class_2248 bifrostPane = new BotaniaPaneBlock(class_4970.class_2251.method_9630(bifrostPerm));

	static class_2362 flowerPot(class_2248 block, int lightLevel) {
		class_4970.class_2251 properties = class_4970.class_2251.method_9637().method_9618().method_22488().method_50012(class_3619.field_15971);
		return new class_2362(block, lightLevel > 0 ? properties.method_9631(blockState -> lightLevel) : properties);
	}

	public static void registerBlocks(BiConsumer<class_2248, class_2960> r) {
		// triples of: block getter from dye color, block ID prefix, block ID suffix
		Stream.<Triple<Function<class_1767, class_2248>, String, String>>of(
				Triple.of(BotaniaBlocks::getFlower, "", LibBlockNames.MYSTICAL_FLOWER_SUFFIX),
				Triple.of(BotaniaBlocks::getShinyFlower, "", LibBlockNames.SHINY_FLOWER_SUFFIX),
				Triple.of(BotaniaBlocks::getBuriedPetal, "", LibBlockNames.BURIED_PETALS_SUFFIX),
				Triple.of(BotaniaBlocks::getFloatingFlower, "", LibBlockNames.FLOATING_FLOWER_SUFFIX),
				Triple.of(BotaniaBlocks::getPetalBlock, "", LibBlockNames.PETAL_BLOCK_SUFFIX),
				Triple.of(BotaniaBlocks::getMushroom, "", LibBlockNames.MUSHROOM_SUFFIX),
				Triple.of(BotaniaBlocks::getDoubleFlower, "", LibBlockNames.DOUBLE_FLOWER_SUFFIX),
				Triple.of(BotaniaBlocks::getPottedFlower, LibBlockNames.POTTED_PREFIX, LibBlockNames.MYSTICAL_FLOWER_SUFFIX),
				Triple.of(BotaniaBlocks::getPottedShinyFlower, LibBlockNames.POTTED_PREFIX, LibBlockNames.SHINY_FLOWER_SUFFIX),
				Triple.of(BotaniaBlocks::getPottedMushroom, LibBlockNames.POTTED_PREFIX, LibBlockNames.MUSHROOM_SUFFIX)
		).forEach(coloredBlockRegistration -> {
			ColorHelper.supportedColors().forEach(dyeColor -> {
				r.accept(coloredBlockRegistration.getLeft().apply(dyeColor),
						prefix(coloredBlockRegistration.getMiddle() + dyeColor.method_7792() + coloredBlockRegistration.getRight()));
			});
		});

		r.accept(defaultAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.DEFAULT.name().toLowerCase(Locale.ROOT)));
		r.accept(forestAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.FOREST.name().toLowerCase(Locale.ROOT)));
		r.accept(plainsAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.PLAINS.name().toLowerCase(Locale.ROOT)));
		r.accept(mountainAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.MOUNTAIN.name().toLowerCase(Locale.ROOT)));
		r.accept(fungalAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.FUNGAL.name().toLowerCase(Locale.ROOT)));
		r.accept(swampAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.SWAMP.name().toLowerCase(Locale.ROOT)));
		r.accept(desertAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.DESERT.name().toLowerCase(Locale.ROOT)));
		r.accept(taigaAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.TAIGA.name().toLowerCase(Locale.ROOT)));
		r.accept(mesaAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.MESA.name().toLowerCase(Locale.ROOT)));
		r.accept(mossyAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.MOSSY.name().toLowerCase(Locale.ROOT)));
		r.accept(livingrockAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.LIVINGROCK.name().toLowerCase(Locale.ROOT)));
		r.accept(deepslateAltar, prefix(LibBlockNames.APOTHECARY_PREFIX + PetalApothecaryBlock.Variant.DEEPSLATE.name().toLowerCase(Locale.ROOT)));

		r.accept(livingrock, prefix(LibBlockNames.LIVING_ROCK));
		r.accept(livingrockStairs, prefix(LibBlockNames.LIVING_ROCK + STAIR_SUFFIX));
		r.accept(livingrockSlab, prefix(LibBlockNames.LIVING_ROCK + SLAB_SUFFIX));
		r.accept(livingrockWall, prefix(LibBlockNames.LIVING_ROCK + WALL_SUFFIX));
		r.accept(livingrockPolished, prefix(LibBlockNames.LIVING_ROCK_POLISHED));
		r.accept(livingrockPolishedStairs, prefix(LibBlockNames.LIVING_ROCK_POLISHED + STAIR_SUFFIX));
		r.accept(livingrockPolishedSlab, prefix(LibBlockNames.LIVING_ROCK_POLISHED + SLAB_SUFFIX));
		r.accept(livingrockPolishedWall, prefix(LibBlockNames.LIVING_ROCK_POLISHED + WALL_SUFFIX));
		r.accept(livingrockSlate, prefix(LibBlockNames.LIVING_ROCK_SLATE));
		r.accept(livingrockBrick, prefix(LibBlockNames.LIVING_ROCK_BRICK));
		r.accept(livingrockBrickStairs, prefix(LibBlockNames.LIVING_ROCK_BRICK + STAIR_SUFFIX));
		r.accept(livingrockBrickSlab, prefix(LibBlockNames.LIVING_ROCK_BRICK + SLAB_SUFFIX));
		r.accept(livingrockBrickWall, prefix(LibBlockNames.LIVING_ROCK_BRICK + WALL_SUFFIX));
		r.accept(livingrockBrickMossy, prefix(LibBlockNames.LIVING_ROCK_BRICK_MOSSY));
		r.accept(livingrockBrickMossyStairs, prefix(LibBlockNames.LIVING_ROCK_BRICK_MOSSY + STAIR_SUFFIX));
		r.accept(livingrockBrickMossySlab, prefix(LibBlockNames.LIVING_ROCK_BRICK_MOSSY + SLAB_SUFFIX));
		r.accept(livingrockBrickMossyWall, prefix(LibBlockNames.LIVING_ROCK_BRICK_MOSSY + WALL_SUFFIX));
		r.accept(livingrockBrickChiseled, prefix(LibBlockNames.LIVING_ROCK_BRICK_CHISELED));
		r.accept(livingrockBrickCracked, prefix(LibBlockNames.LIVING_ROCK_BRICK_CRACKED));

		r.accept(livingwoodLog, prefix(LibBlockNames.LIVING_WOOD_LOG));
		r.accept(livingwood, prefix(LibBlockNames.LIVING_WOOD));
		r.accept(livingwoodStairs, prefix(LibBlockNames.LIVING_WOOD + STAIR_SUFFIX));
		r.accept(livingwoodSlab, prefix(LibBlockNames.LIVING_WOOD + SLAB_SUFFIX));
		r.accept(livingwoodWall, prefix(LibBlockNames.LIVING_WOOD + WALL_SUFFIX));
		r.accept(livingwoodLogStripped, prefix(LibBlockNames.LIVING_WOOD_LOG_STRIPPED));
		r.accept(livingwoodStripped, prefix(LibBlockNames.LIVING_WOOD_STRIPPED));
		r.accept(livingwoodStrippedStairs, prefix(LibBlockNames.LIVING_WOOD_STRIPPED + STAIR_SUFFIX));
		r.accept(livingwoodStrippedSlab, prefix(LibBlockNames.LIVING_WOOD_STRIPPED + SLAB_SUFFIX));
		r.accept(livingwoodStrippedWall, prefix(LibBlockNames.LIVING_WOOD_STRIPPED + WALL_SUFFIX));
		r.accept(livingwoodLogGlimmering, prefix(LibBlockNames.LIVING_WOOD_LOG_GLIMMERING));
		r.accept(livingwoodGlimmering, prefix(LibBlockNames.LIVING_WOOD_GLIMMERING));
		r.accept(livingwoodLogStrippedGlimmering, prefix(LibBlockNames.LIVING_WOOD_LOG_GLIMMERING_STRIPPED));
		r.accept(livingwoodStrippedGlimmering, prefix(LibBlockNames.LIVING_WOOD_GLIMMERING_STRIPPED));
		r.accept(livingwoodPlanks, prefix(LibBlockNames.LIVING_WOOD_PLANKS));
		r.accept(livingwoodPlankStairs, prefix(LibBlockNames.LIVING_WOOD_PLANKS + STAIR_SUFFIX));
		r.accept(livingwoodPlankSlab, prefix(LibBlockNames.LIVING_WOOD_PLANKS + SLAB_SUFFIX));
		r.accept(livingwoodFence, prefix(LibBlockNames.LIVING_WOOD + FENCE_SUFFIX));
		r.accept(livingwoodFenceGate, prefix(LibBlockNames.LIVING_WOOD + FENCE_GATE_SUFFIX));
		r.accept(livingwoodPlanksMossy, prefix(LibBlockNames.LIVING_WOOD_PLANKS_MOSSY));
		r.accept(livingwoodFramed, prefix(LibBlockNames.LIVING_WOOD_FRAMED));
		r.accept(livingwoodPatternFramed, prefix(LibBlockNames.LIVING_WOOD_PATTERN_FRAMED));

		r.accept(dreamwoodLog, prefix(LibBlockNames.DREAM_WOOD_LOG));
		r.accept(dreamwood, prefix(LibBlockNames.DREAM_WOOD));
		r.accept(dreamwoodStairs, prefix(LibBlockNames.DREAM_WOOD + STAIR_SUFFIX));
		r.accept(dreamwoodSlab, prefix(LibBlockNames.DREAM_WOOD + SLAB_SUFFIX));
		r.accept(dreamwoodWall, prefix(LibBlockNames.DREAM_WOOD + WALL_SUFFIX));
		r.accept(dreamwoodLogStripped, prefix(LibBlockNames.DREAM_WOOD_LOG_STRIPPED));
		r.accept(dreamwoodStripped, prefix(LibBlockNames.DREAM_WOOD_STRIPPED));
		r.accept(dreamwoodStrippedStairs, prefix(LibBlockNames.DREAM_WOOD_STRIPPED + STAIR_SUFFIX));
		r.accept(dreamwoodStrippedSlab, prefix(LibBlockNames.DREAM_WOOD_STRIPPED + SLAB_SUFFIX));
		r.accept(dreamwoodStrippedWall, prefix(LibBlockNames.DREAM_WOOD_STRIPPED + WALL_SUFFIX));
		r.accept(dreamwoodLogGlimmering, prefix(LibBlockNames.DREAM_WOOD_LOG_GLIMMERING));
		r.accept(dreamwoodGlimmering, prefix(LibBlockNames.DREAM_WOOD_GLIMMERING));
		r.accept(dreamwoodLogStrippedGlimmering, prefix(LibBlockNames.DREAM_WOOD_LOG_GLIMMERING_STRIPPED));
		r.accept(dreamwoodStrippedGlimmering, prefix(LibBlockNames.DREAM_WOOD_GLIMMERING_STRIPPED));
		r.accept(dreamwoodPlanks, prefix(LibBlockNames.DREAM_WOOD_PLANKS));
		r.accept(dreamwoodPlankStairs, prefix(LibBlockNames.DREAM_WOOD_PLANKS + STAIR_SUFFIX));
		r.accept(dreamwoodPlankSlab, prefix(LibBlockNames.DREAM_WOOD_PLANKS + SLAB_SUFFIX));
		r.accept(dreamwoodFence, prefix(LibBlockNames.DREAM_WOOD + FENCE_SUFFIX));
		r.accept(dreamwoodFenceGate, prefix(LibBlockNames.DREAM_WOOD + FENCE_GATE_SUFFIX));
		r.accept(dreamwoodPlanksMossy, prefix(LibBlockNames.DREAM_WOOD_PLANKS_MOSSY));
		r.accept(dreamwoodFramed, prefix(LibBlockNames.DREAM_WOOD_FRAMED));
		r.accept(dreamwoodPatternFramed, prefix(LibBlockNames.DREAM_WOOD_PATTERN_FRAMED));

		r.accept(manaSpreader, prefix(LibBlockNames.SPREADER));
		r.accept(redstoneSpreader, prefix(LibBlockNames.SPREADER_REDSTONE));
		r.accept(elvenSpreader, prefix(LibBlockNames.SPREADER_ELVEN));
		r.accept(gaiaSpreader, prefix(LibBlockNames.SPREADER_GAIA));
		r.accept(manaPool, prefix(LibBlockNames.POOL));
		r.accept(creativePool, prefix(LibBlockNames.POOL_CREATIVE));
		r.accept(dilutedPool, prefix(LibBlockNames.POOL_DILUTED));
		r.accept(fabulousPool, prefix(LibBlockNames.POOL_FABULOUS));
		r.accept(alchemyCatalyst, prefix(LibBlockNames.ALCHEMY_CATALYST));
		r.accept(conjurationCatalyst, prefix(LibBlockNames.CONJURATION_CATALYST));
		r.accept(manasteelBlock, prefix(LibBlockNames.MANASTEEL_BLOCK));
		r.accept(terrasteelBlock, prefix(LibBlockNames.TERRASTEEL_BLOCK));
		r.accept(elementiumBlock, prefix(LibBlockNames.ELEMENTIUM_BLOCK));
		r.accept(manaDiamondBlock, prefix(LibBlockNames.MANA_DIAMOND_BLOCK));
		r.accept(dragonstoneBlock, prefix(LibBlockNames.DRAGONSTONE_BLOCK));
		r.accept(manaGlass, prefix(LibBlockNames.MANA_GLASS));
		r.accept(elfGlass, prefix(LibBlockNames.ELF_GLASS));
		r.accept(bifrost, prefix(LibBlockNames.BIFROST));
		r.accept(bifrostPerm, prefix(LibBlockNames.BIFROST_PERM));
		r.accept(runeAltar, prefix(LibBlockNames.RUNE_ALTAR));
		r.accept(enchanter, prefix(LibBlockNames.ENCHANTER));
		r.accept(brewery, prefix(LibBlockNames.BREWERY));
		r.accept(terraPlate, prefix(LibBlockNames.TERRA_PLATE));
		r.accept(alfPortal, prefix(LibBlockNames.ALF_PORTAL));
		r.accept(manaPylon, prefix(LibBlockNames.PYLON));
		r.accept(naturaPylon, prefix(LibBlockNames.PYLON_NATURA));
		r.accept(gaiaPylon, prefix(LibBlockNames.PYLON_GAIA));
		r.accept(distributor, prefix(LibBlockNames.DISTRIBUTOR));
		r.accept(manaVoid, prefix(LibBlockNames.MANA_VOID));
		r.accept(manaDetector, prefix(LibBlockNames.MANA_DETECTOR));
		r.accept(pistonRelay, prefix(LibBlockNames.PISTON_RELAY));
		r.accept(turntable, prefix(LibBlockNames.TURNTABLE));
		r.accept(tinyPlanet, prefix(LibBlockNames.TINY_PLANET));
		r.accept(wildDrum, prefix(LibBlockNames.DRUM_WILD));
		r.accept(gatheringDrum, prefix(LibBlockNames.DRUM_GATHERING));
		r.accept(canopyDrum, prefix(LibBlockNames.DRUM_CANOPY));
		r.accept(spawnerClaw, prefix(LibBlockNames.SPAWNER_CLAW));
		r.accept(rfGenerator, prefix(LibBlockNames.FLUXFIELD));
		r.accept(prism, prefix(LibBlockNames.PRISM));
		r.accept(pump, prefix(LibBlockNames.PUMP));
		r.accept(sparkChanger, prefix(LibBlockNames.SPARK_CHANGER));
		r.accept(manaBomb, prefix(LibBlockNames.MANA_BOMB));
		r.accept(bellows, prefix(LibBlockNames.BELLOWS));
		r.accept(openCrate, prefix(LibBlockNames.OPEN_CRATE));
		r.accept(craftCrate, prefix(LibBlockNames.CRAFT_CRATE));
		r.accept(forestEye, prefix(LibBlockNames.FOREST_EYE));
		r.accept(solidVines, prefix(LibBlockNames.SOLID_VINE));
		r.accept(abstrusePlatform, prefix(LibBlockNames.PLATFORM_ABSTRUSE));
		r.accept(spectralPlatform, prefix(LibBlockNames.PLATFORM_SPECTRAL));
		r.accept(infrangiblePlatform, prefix(LibBlockNames.PLATFORM_INFRANGIBLE));
		r.accept(tinyPotato, prefix(LibBlockNames.TINY_POTATO));
		r.accept(enderEye, prefix(LibBlockNames.ENDER_EYE_BLOCK));
		r.accept(redStringContainer, prefix(LibBlockNames.RED_STRING_CONTAINER));
		r.accept(redStringDispenser, prefix(LibBlockNames.RED_STRING_DISPENSER));
		r.accept(redStringFertilizer, prefix(LibBlockNames.RED_STRING_FERTILIZER));
		r.accept(redStringComparator, prefix(LibBlockNames.RED_STRING_COMPARATOR));
		r.accept(redStringRelay, prefix(LibBlockNames.RED_STRING_RELAY));
		r.accept(redStringInterceptor, prefix(LibBlockNames.RED_STRING_INTERCEPTOR));
		r.accept(corporeaIndex, prefix(LibBlockNames.CORPOREA_INDEX));
		r.accept(corporeaFunnel, prefix(LibBlockNames.CORPOREA_FUNNEL));
		r.accept(corporeaInterceptor, prefix(LibBlockNames.CORPOREA_INTERCEPTOR));
		r.accept(corporeaCrystalCube, prefix(LibBlockNames.CORPOREA_CRYSTAL_CUBE));
		r.accept(corporeaRetainer, prefix(LibBlockNames.CORPOREA_RETAINER));
		r.accept(corporeaBlock, prefix(LibBlockNames.CORPOREA_BLOCK));
		r.accept(corporeaSlab, prefix(LibBlockNames.CORPOREA_SLAB));
		r.accept(corporeaStairs, prefix(LibBlockNames.CORPOREA_STAIRS));
		r.accept(corporeaBrick, prefix(LibBlockNames.CORPOREA_BRICK));
		r.accept(corporeaBrickSlab, prefix(LibBlockNames.CORPOREA_BRICK + LibBlockNames.SLAB_SUFFIX));
		r.accept(corporeaBrickStairs, prefix(LibBlockNames.CORPOREA_BRICK + LibBlockNames.STAIR_SUFFIX));
		r.accept(corporeaBrickWall, prefix(LibBlockNames.CORPOREA_BRICK + LibBlockNames.WALL_SUFFIX));
		r.accept(incensePlate, prefix(LibBlockNames.INCENSE_PLATE));
		r.accept(hourglass, prefix(LibBlockNames.HOURGLASS));
		r.accept(ghostRail, prefix(LibBlockNames.GHOST_RAIL));
		r.accept(lightRelayDefault, prefix(LibBlockNames.LIGHT_RELAY));
		r.accept(lightRelayDetector, prefix("detector" + LibBlockNames.LIGHT_RELAY_SUFFIX));
		r.accept(lightRelayFork, prefix("fork" + LibBlockNames.LIGHT_RELAY_SUFFIX));
		r.accept(lightRelayToggle, prefix("toggle" + LibBlockNames.LIGHT_RELAY_SUFFIX));
		r.accept(lightLauncher, prefix(LibBlockNames.LIGHT_LAUNCHER));
		r.accept(cacophonium, prefix(LibBlockNames.CACOPHONIUM));
		r.accept(cellBlock, prefix(LibBlockNames.CELL_BLOCK));
		r.accept(teruTeruBozu, prefix(LibBlockNames.TERU_TERU_BOZU));
		r.accept(avatar, prefix(LibBlockNames.AVATAR));
		r.accept(fakeAir, prefix(LibBlockNames.FAKE_AIR));
		r.accept(root, prefix(LibBlockNames.ROOT));
		r.accept(felPumpkin, prefix(LibBlockNames.FEL_PUMPKIN));
		r.accept(cocoon, prefix(LibBlockNames.COCOON));
		r.accept(enchantedSoil, prefix(LibBlockNames.ENCHANTED_SOIL));
		r.accept(animatedTorch, prefix(LibBlockNames.ANIMATED_TORCH));
		r.accept(starfield, prefix(LibBlockNames.STARFIELD));
		r.accept(azulejo0, prefix(LibBlockNames.AZULEJO_PREFIX + 0));
		r.accept(azulejo1, prefix(LibBlockNames.AZULEJO_PREFIX + 1));
		r.accept(azulejo2, prefix(LibBlockNames.AZULEJO_PREFIX + 2));
		r.accept(azulejo3, prefix(LibBlockNames.AZULEJO_PREFIX + 3));
		r.accept(azulejo4, prefix(LibBlockNames.AZULEJO_PREFIX + 4));
		r.accept(azulejo5, prefix(LibBlockNames.AZULEJO_PREFIX + 5));
		r.accept(azulejo6, prefix(LibBlockNames.AZULEJO_PREFIX + 6));
		r.accept(azulejo7, prefix(LibBlockNames.AZULEJO_PREFIX + 7));
		r.accept(azulejo8, prefix(LibBlockNames.AZULEJO_PREFIX + 8));
		r.accept(azulejo9, prefix(LibBlockNames.AZULEJO_PREFIX + 9));
		r.accept(azulejo10, prefix(LibBlockNames.AZULEJO_PREFIX + 10));
		r.accept(azulejo11, prefix(LibBlockNames.AZULEJO_PREFIX + 11));
		r.accept(azulejo12, prefix(LibBlockNames.AZULEJO_PREFIX + 12));
		r.accept(azulejo13, prefix(LibBlockNames.AZULEJO_PREFIX + 13));
		r.accept(azulejo14, prefix(LibBlockNames.AZULEJO_PREFIX + 14));
		r.accept(azulejo15, prefix(LibBlockNames.AZULEJO_PREFIX + 15));
		r.accept(manaFlame, prefix(LibBlockNames.MANA_FLAME));
		r.accept(blazeBlock, prefix(LibBlockNames.BLAZE_BLOCK));
		r.accept(gaiaHeadWall, prefix(LibBlockNames.GAIA_WALL_HEAD));
		r.accept(gaiaHead, prefix(LibBlockNames.GAIA_HEAD));
		r.accept(shimmerrock, prefix(LibBlockNames.SHIMMERROCK));
		r.accept(shimmerrockSlab, prefix(LibBlockNames.SHIMMERROCK + SLAB_SUFFIX));
		r.accept(shimmerrockStairs, prefix(LibBlockNames.SHIMMERROCK + STAIR_SUFFIX));
		r.accept(shimmerwoodPlanks, prefix(LibBlockNames.SHIMMERWOOD_PLANKS));
		r.accept(shimmerwoodPlankSlab, prefix(LibBlockNames.SHIMMERWOOD_PLANKS + SLAB_SUFFIX));
		r.accept(shimmerwoodPlankStairs, prefix(LibBlockNames.SHIMMERWOOD_PLANKS + STAIR_SUFFIX));
		r.accept(dryGrass, prefix(BotaniaGrassBlock.Variant.DRY.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(goldenGrass, prefix(BotaniaGrassBlock.Variant.GOLDEN.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(vividGrass, prefix(BotaniaGrassBlock.Variant.VIVID.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(scorchedGrass, prefix(BotaniaGrassBlock.Variant.SCORCHED.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(infusedGrass, prefix(BotaniaGrassBlock.Variant.INFUSED.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(mutatedGrass, prefix(BotaniaGrassBlock.Variant.MUTATED.name().toLowerCase(Locale.ROOT) + LibBlockNames.ALT_GRASS_SUFFIX));
		r.accept(motifDaybloom, prefix(LibBlockNames.MOTIF_DAYBLOOM));
		r.accept(motifNightshade, prefix(LibBlockNames.MOTIF_NIGHTSHADE));
		r.accept(motifHydroangeas, prefix(LibBlockNames.MOTIF_HYDROANGEAS));
		r.accept(pottedMotifDaybloom, prefix(LibBlockNames.POTTED_PREFIX + LibBlockNames.MOTIF_DAYBLOOM));
		r.accept(pottedMotifNightshade, prefix(LibBlockNames.POTTED_PREFIX + LibBlockNames.MOTIF_NIGHTSHADE));
		r.accept(pottedMotifHydroangeas, prefix(LibBlockNames.POTTED_PREFIX + LibBlockNames.MOTIF_HYDROANGEAS));

		r.accept(darkQuartz, prefix(QUARTZ_DARK));
		r.accept(darkQuartzChiseled, prefix("chiseled_" + QUARTZ_DARK));
		r.accept(darkQuartzPillar, prefix(QUARTZ_DARK + "_pillar"));
		r.accept(darkQuartzSlab, prefix(QUARTZ_DARK + SLAB_SUFFIX));
		r.accept(darkQuartzStairs, prefix(QUARTZ_DARK + STAIR_SUFFIX));

		r.accept(manaQuartz, prefix(QUARTZ_MANA));
		r.accept(manaQuartzChiseled, prefix("chiseled_" + QUARTZ_MANA));
		r.accept(manaQuartzPillar, prefix(QUARTZ_MANA + "_pillar"));
		r.accept(manaQuartzSlab, prefix(QUARTZ_MANA + SLAB_SUFFIX));
		r.accept(manaQuartzStairs, prefix(QUARTZ_MANA + STAIR_SUFFIX));

		r.accept(blazeQuartz, prefix(QUARTZ_BLAZE));
		r.accept(blazeQuartzChiseled, prefix("chiseled_" + QUARTZ_BLAZE));
		r.accept(blazeQuartzPillar, prefix(QUARTZ_BLAZE + "_pillar"));
		r.accept(blazeQuartzSlab, prefix(QUARTZ_BLAZE + SLAB_SUFFIX));
		r.accept(blazeQuartzStairs, prefix(QUARTZ_BLAZE + STAIR_SUFFIX));

		r.accept(lavenderQuartz, prefix(QUARTZ_LAVENDER));
		r.accept(lavenderQuartzChiseled, prefix("chiseled_" + QUARTZ_LAVENDER));
		r.accept(lavenderQuartzPillar, prefix(QUARTZ_LAVENDER + "_pillar"));
		r.accept(lavenderQuartzSlab, prefix(QUARTZ_LAVENDER + SLAB_SUFFIX));
		r.accept(lavenderQuartzStairs, prefix(QUARTZ_LAVENDER + STAIR_SUFFIX));

		r.accept(redQuartz, prefix(QUARTZ_RED));
		r.accept(redQuartzChiseled, prefix("chiseled_" + QUARTZ_RED));
		r.accept(redQuartzPillar, prefix(QUARTZ_RED + "_pillar"));
		r.accept(redQuartzSlab, prefix(QUARTZ_RED + SLAB_SUFFIX));
		r.accept(redQuartzStairs, prefix(QUARTZ_RED + STAIR_SUFFIX));

		r.accept(elfQuartz, prefix(QUARTZ_ELF));
		r.accept(elfQuartzChiseled, prefix("chiseled_" + QUARTZ_ELF));
		r.accept(elfQuartzPillar, prefix(QUARTZ_ELF + "_pillar"));
		r.accept(elfQuartzSlab, prefix(QUARTZ_ELF + SLAB_SUFFIX));
		r.accept(elfQuartzStairs, prefix(QUARTZ_ELF + STAIR_SUFFIX));

		r.accept(sunnyQuartz, prefix(QUARTZ_SUNNY));
		r.accept(sunnyQuartzChiseled, prefix("chiseled_" + QUARTZ_SUNNY));
		r.accept(sunnyQuartzPillar, prefix(QUARTZ_SUNNY + "_pillar"));
		r.accept(sunnyQuartzSlab, prefix(QUARTZ_SUNNY + SLAB_SUFFIX));
		r.accept(sunnyQuartzStairs, prefix(QUARTZ_SUNNY + STAIR_SUFFIX));

		r.accept(whitePavement, prefix("white" + PAVEMENT_SUFFIX));
		r.accept(whitePavementStair, prefix("white" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(whitePavementSlab, prefix("white" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(blackPavement, prefix("black" + PAVEMENT_SUFFIX));
		r.accept(blackPavementStair, prefix("black" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(blackPavementSlab, prefix("black" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(bluePavement, prefix("blue" + PAVEMENT_SUFFIX));
		r.accept(bluePavementStair, prefix("blue" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(bluePavementSlab, prefix("blue" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(yellowPavement, prefix("yellow" + PAVEMENT_SUFFIX));
		r.accept(yellowPavementStair, prefix("yellow" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(yellowPavementSlab, prefix("yellow" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(redPavement, prefix("red" + PAVEMENT_SUFFIX));
		r.accept(redPavementStair, prefix("red" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(redPavementSlab, prefix("red" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(greenPavement, prefix("green" + PAVEMENT_SUFFIX));
		r.accept(greenPavementStair, prefix("green" + PAVEMENT_SUFFIX + STAIR_SUFFIX));
		r.accept(greenPavementSlab, prefix("green" + PAVEMENT_SUFFIX + SLAB_SUFFIX));

		r.accept(biomeStoneForest, prefix(METAMORPHIC_PREFIX + "forest_stone"));
		r.accept(biomeStoneForestSlab, prefix(METAMORPHIC_PREFIX + "forest_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneForestStairs, prefix(METAMORPHIC_PREFIX + "forest_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneForestWall, prefix(METAMORPHIC_PREFIX + "forest_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneForest, prefix(METAMORPHIC_PREFIX + "forest_cobblestone"));
		r.accept(biomeCobblestoneForestSlab, prefix(METAMORPHIC_PREFIX + "forest_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneForestStairs, prefix(METAMORPHIC_PREFIX + "forest_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneForestWall, prefix(METAMORPHIC_PREFIX + "forest_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickForest, prefix(METAMORPHIC_PREFIX + "forest_bricks"));
		r.accept(biomeBrickForestSlab, prefix(METAMORPHIC_PREFIX + "forest_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickForestStairs, prefix(METAMORPHIC_PREFIX + "forest_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickForestWall, prefix(METAMORPHIC_PREFIX + "forest_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickForest, prefix("chiseled_" + METAMORPHIC_PREFIX + "forest_bricks"));

		r.accept(biomeStonePlains, prefix(METAMORPHIC_PREFIX + "plains_stone"));
		r.accept(biomeStonePlainsSlab, prefix(METAMORPHIC_PREFIX + "plains_stone" + SLAB_SUFFIX));
		r.accept(biomeStonePlainsStairs, prefix(METAMORPHIC_PREFIX + "plains_stone" + STAIR_SUFFIX));
		r.accept(biomeStonePlainsWall, prefix(METAMORPHIC_PREFIX + "plains_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestonePlains, prefix(METAMORPHIC_PREFIX + "plains_cobblestone"));
		r.accept(biomeCobblestonePlainsSlab, prefix(METAMORPHIC_PREFIX + "plains_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestonePlainsStairs, prefix(METAMORPHIC_PREFIX + "plains_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestonePlainsWall, prefix(METAMORPHIC_PREFIX + "plains_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickPlains, prefix(METAMORPHIC_PREFIX + "plains_bricks"));
		r.accept(biomeBrickPlainsSlab, prefix(METAMORPHIC_PREFIX + "plains_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickPlainsStairs, prefix(METAMORPHIC_PREFIX + "plains_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickPlainsWall, prefix(METAMORPHIC_PREFIX + "plains_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickPlains, prefix("chiseled_" + METAMORPHIC_PREFIX + "plains_bricks"));

		r.accept(biomeStoneMountain, prefix(METAMORPHIC_PREFIX + "mountain_stone"));
		r.accept(biomeStoneMountainSlab, prefix(METAMORPHIC_PREFIX + "mountain_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneMountainStairs, prefix(METAMORPHIC_PREFIX + "mountain_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneMountainWall, prefix(METAMORPHIC_PREFIX + "mountain_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneMountain, prefix(METAMORPHIC_PREFIX + "mountain_cobblestone"));
		r.accept(biomeCobblestoneMountainSlab, prefix(METAMORPHIC_PREFIX + "mountain_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneMountainStairs, prefix(METAMORPHIC_PREFIX + "mountain_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneMountainWall, prefix(METAMORPHIC_PREFIX + "mountain_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickMountain, prefix(METAMORPHIC_PREFIX + "mountain_bricks"));
		r.accept(biomeBrickMountainSlab, prefix(METAMORPHIC_PREFIX + "mountain_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickMountainStairs, prefix(METAMORPHIC_PREFIX + "mountain_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickMountainWall, prefix(METAMORPHIC_PREFIX + "mountain_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickMountain, prefix("chiseled_" + METAMORPHIC_PREFIX + "mountain_bricks"));

		r.accept(biomeStoneFungal, prefix(METAMORPHIC_PREFIX + "fungal_stone"));
		r.accept(biomeStoneFungalSlab, prefix(METAMORPHIC_PREFIX + "fungal_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneFungalStairs, prefix(METAMORPHIC_PREFIX + "fungal_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneFungalWall, prefix(METAMORPHIC_PREFIX + "fungal_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneFungal, prefix(METAMORPHIC_PREFIX + "fungal_cobblestone"));
		r.accept(biomeCobblestoneFungalSlab, prefix(METAMORPHIC_PREFIX + "fungal_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneFungalStairs, prefix(METAMORPHIC_PREFIX + "fungal_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneFungalWall, prefix(METAMORPHIC_PREFIX + "fungal_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickFungal, prefix(METAMORPHIC_PREFIX + "fungal_bricks"));
		r.accept(biomeBrickFungalSlab, prefix(METAMORPHIC_PREFIX + "fungal_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickFungalStairs, prefix(METAMORPHIC_PREFIX + "fungal_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickFungalWall, prefix(METAMORPHIC_PREFIX + "fungal_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickFungal, prefix("chiseled_" + METAMORPHIC_PREFIX + "fungal_bricks"));

		r.accept(biomeStoneSwamp, prefix(METAMORPHIC_PREFIX + "swamp_stone"));
		r.accept(biomeStoneSwampSlab, prefix(METAMORPHIC_PREFIX + "swamp_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneSwampStairs, prefix(METAMORPHIC_PREFIX + "swamp_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneSwampWall, prefix(METAMORPHIC_PREFIX + "swamp_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneSwamp, prefix(METAMORPHIC_PREFIX + "swamp_cobblestone"));
		r.accept(biomeCobblestoneSwampSlab, prefix(METAMORPHIC_PREFIX + "swamp_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneSwampStairs, prefix(METAMORPHIC_PREFIX + "swamp_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneSwampWall, prefix(METAMORPHIC_PREFIX + "swamp_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickSwamp, prefix(METAMORPHIC_PREFIX + "swamp_bricks"));
		r.accept(biomeBrickSwampSlab, prefix(METAMORPHIC_PREFIX + "swamp_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickSwampStairs, prefix(METAMORPHIC_PREFIX + "swamp_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickSwampWall, prefix(METAMORPHIC_PREFIX + "swamp_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickSwamp, prefix("chiseled_" + METAMORPHIC_PREFIX + "swamp_bricks"));

		r.accept(biomeStoneDesert, prefix(METAMORPHIC_PREFIX + "desert_stone"));
		r.accept(biomeStoneDesertSlab, prefix(METAMORPHIC_PREFIX + "desert_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneDesertStairs, prefix(METAMORPHIC_PREFIX + "desert_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneDesertWall, prefix(METAMORPHIC_PREFIX + "desert_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneDesert, prefix(METAMORPHIC_PREFIX + "desert_cobblestone"));
		r.accept(biomeCobblestoneDesertSlab, prefix(METAMORPHIC_PREFIX + "desert_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneDesertStairs, prefix(METAMORPHIC_PREFIX + "desert_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneDesertWall, prefix(METAMORPHIC_PREFIX + "desert_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickDesert, prefix(METAMORPHIC_PREFIX + "desert_bricks"));
		r.accept(biomeBrickDesertSlab, prefix(METAMORPHIC_PREFIX + "desert_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickDesertStairs, prefix(METAMORPHIC_PREFIX + "desert_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickDesertWall, prefix(METAMORPHIC_PREFIX + "desert_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickDesert, prefix("chiseled_" + METAMORPHIC_PREFIX + "desert_bricks"));

		r.accept(biomeStoneTaiga, prefix(METAMORPHIC_PREFIX + "taiga_stone"));
		r.accept(biomeStoneTaigaSlab, prefix(METAMORPHIC_PREFIX + "taiga_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneTaigaStairs, prefix(METAMORPHIC_PREFIX + "taiga_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneTaigaWall, prefix(METAMORPHIC_PREFIX + "taiga_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneTaiga, prefix(METAMORPHIC_PREFIX + "taiga_cobblestone"));
		r.accept(biomeCobblestoneTaigaSlab, prefix(METAMORPHIC_PREFIX + "taiga_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneTaigaStairs, prefix(METAMORPHIC_PREFIX + "taiga_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneTaigaWall, prefix(METAMORPHIC_PREFIX + "taiga_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickTaiga, prefix(METAMORPHIC_PREFIX + "taiga_bricks"));
		r.accept(biomeBrickTaigaSlab, prefix(METAMORPHIC_PREFIX + "taiga_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickTaigaStairs, prefix(METAMORPHIC_PREFIX + "taiga_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickTaigaWall, prefix(METAMORPHIC_PREFIX + "taiga_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickTaiga, prefix("chiseled_" + METAMORPHIC_PREFIX + "taiga_bricks"));

		r.accept(biomeStoneMesa, prefix(METAMORPHIC_PREFIX + "mesa_stone"));
		r.accept(biomeStoneMesaSlab, prefix(METAMORPHIC_PREFIX + "mesa_stone" + SLAB_SUFFIX));
		r.accept(biomeStoneMesaStairs, prefix(METAMORPHIC_PREFIX + "mesa_stone" + STAIR_SUFFIX));
		r.accept(biomeStoneMesaWall, prefix(METAMORPHIC_PREFIX + "mesa_stone" + WALL_SUFFIX));
		r.accept(biomeCobblestoneMesa, prefix(METAMORPHIC_PREFIX + "mesa_cobblestone"));
		r.accept(biomeCobblestoneMesaSlab, prefix(METAMORPHIC_PREFIX + "mesa_cobblestone" + SLAB_SUFFIX));
		r.accept(biomeCobblestoneMesaStairs, prefix(METAMORPHIC_PREFIX + "mesa_cobblestone" + STAIR_SUFFIX));
		r.accept(biomeCobblestoneMesaWall, prefix(METAMORPHIC_PREFIX + "mesa_cobblestone" + WALL_SUFFIX));
		r.accept(biomeBrickMesa, prefix(METAMORPHIC_PREFIX + "mesa_bricks"));
		r.accept(biomeBrickMesaSlab, prefix(METAMORPHIC_PREFIX + "mesa_bricks" + SLAB_SUFFIX));
		r.accept(biomeBrickMesaStairs, prefix(METAMORPHIC_PREFIX + "mesa_bricks" + STAIR_SUFFIX));
		r.accept(biomeBrickMesaWall, prefix(METAMORPHIC_PREFIX + "mesa_bricks" + WALL_SUFFIX));
		r.accept(biomeChiseledBrickMesa, prefix("chiseled_" + METAMORPHIC_PREFIX + "mesa_bricks"));

		r.accept(managlassPane, prefix(LibBlockNames.MANA_GLASS + "_pane"));
		r.accept(alfglassPane, prefix(LibBlockNames.ELF_GLASS + "_pane"));
		r.accept(bifrostPane, prefix(LibBlockNames.BIFROST + "_pane"));
	}

	public static void registerItemBlocks(BiConsumer<class_1792, class_2960> r) {
		class_1792.class_1793 props = BotaniaItems.defaultBuilder();
		Stream.<Function<class_1767, class_2248>>of(
				BotaniaBlocks::getFlower,
				BotaniaBlocks::getShinyFlower,
				BotaniaBlocks::getFloatingFlower,
				BotaniaBlocks::getPetalBlock,
				BotaniaBlocks::getMushroom,
				BotaniaBlocks::getDoubleFlower
		).forEach(
				blockGetter -> ColorHelper.supportedColors().map(blockGetter).forEach(
						block -> r.accept(new class_1747(block, props), class_7923.field_41175.method_10221(block))
				)
		);
		r.accept(new class_1747(defaultAltar, props), class_7923.field_41175.method_10221(defaultAltar));
		r.accept(new class_1747(forestAltar, props), class_7923.field_41175.method_10221(forestAltar));
		r.accept(new class_1747(plainsAltar, props), class_7923.field_41175.method_10221(plainsAltar));
		r.accept(new class_1747(mountainAltar, props), class_7923.field_41175.method_10221(mountainAltar));
		r.accept(new class_1747(fungalAltar, props), class_7923.field_41175.method_10221(fungalAltar));
		r.accept(new class_1747(swampAltar, props), class_7923.field_41175.method_10221(swampAltar));
		r.accept(new class_1747(desertAltar, props), class_7923.field_41175.method_10221(desertAltar));
		r.accept(new class_1747(taigaAltar, props), class_7923.field_41175.method_10221(taigaAltar));
		r.accept(new class_1747(mesaAltar, props), class_7923.field_41175.method_10221(mesaAltar));
		r.accept(new class_1747(mossyAltar, props), class_7923.field_41175.method_10221(mossyAltar));
		r.accept(new class_1747(livingrockAltar, props), class_7923.field_41175.method_10221(livingrockAltar));
		r.accept(new class_1747(deepslateAltar, props), class_7923.field_41175.method_10221(deepslateAltar));

		r.accept(new class_1747(livingrock, props), class_7923.field_41175.method_10221(livingrock));
		r.accept(new class_1747(livingrockStairs, props), class_7923.field_41175.method_10221(livingrockStairs));
		r.accept(new class_1747(livingrockSlab, props), class_7923.field_41175.method_10221(livingrockSlab));
		r.accept(new class_1747(livingrockWall, props), class_7923.field_41175.method_10221(livingrockWall));
		r.accept(new class_1747(livingrockPolished, props), class_7923.field_41175.method_10221(livingrockPolished));
		r.accept(new class_1747(livingrockPolishedStairs, props), class_7923.field_41175.method_10221(livingrockPolishedStairs));
		r.accept(new class_1747(livingrockPolishedSlab, props), class_7923.field_41175.method_10221(livingrockPolishedSlab));
		r.accept(new class_1747(livingrockPolishedWall, props), class_7923.field_41175.method_10221(livingrockPolishedWall));
		r.accept(new class_1747(livingrockSlate, props), class_7923.field_41175.method_10221(livingrockSlate));
		r.accept(new class_1747(livingrockBrick, props), class_7923.field_41175.method_10221(livingrockBrick));
		r.accept(new class_1747(livingrockBrickStairs, props), class_7923.field_41175.method_10221(livingrockBrickStairs));
		r.accept(new class_1747(livingrockBrickSlab, props), class_7923.field_41175.method_10221(livingrockBrickSlab));
		r.accept(new class_1747(livingrockBrickWall, props), class_7923.field_41175.method_10221(livingrockBrickWall));
		r.accept(new class_1747(livingrockBrickMossy, props), class_7923.field_41175.method_10221(livingrockBrickMossy));
		r.accept(new class_1747(livingrockBrickMossyStairs, props), class_7923.field_41175.method_10221(livingrockBrickMossyStairs));
		r.accept(new class_1747(livingrockBrickMossySlab, props), class_7923.field_41175.method_10221(livingrockBrickMossySlab));
		r.accept(new class_1747(livingrockBrickMossyWall, props), class_7923.field_41175.method_10221(livingrockBrickMossyWall));
		r.accept(new class_1747(livingrockBrickChiseled, props), class_7923.field_41175.method_10221(livingrockBrickChiseled));
		r.accept(new class_1747(livingrockBrickCracked, props), class_7923.field_41175.method_10221(livingrockBrickCracked));

		r.accept(new class_1747(livingwoodLog, props), class_7923.field_41175.method_10221(livingwoodLog));
		r.accept(new class_1747(livingwood, props), class_7923.field_41175.method_10221(livingwood));
		r.accept(new class_1747(livingwoodStairs, props), class_7923.field_41175.method_10221(livingwoodStairs));
		r.accept(new class_1747(livingwoodSlab, props), class_7923.field_41175.method_10221(livingwoodSlab));
		r.accept(new class_1747(livingwoodWall, props), class_7923.field_41175.method_10221(livingwoodWall));
		r.accept(new class_1747(livingwoodLogStripped, props), class_7923.field_41175.method_10221(livingwoodLogStripped));
		r.accept(new class_1747(livingwoodStripped, props), class_7923.field_41175.method_10221(livingwoodStripped));
		r.accept(new class_1747(livingwoodStrippedStairs, props), class_7923.field_41175.method_10221(livingwoodStrippedStairs));
		r.accept(new class_1747(livingwoodStrippedSlab, props), class_7923.field_41175.method_10221(livingwoodStrippedSlab));
		r.accept(new class_1747(livingwoodStrippedWall, props), class_7923.field_41175.method_10221(livingwoodStrippedWall));
		r.accept(new class_1747(livingwoodLogGlimmering, props), class_7923.field_41175.method_10221(livingwoodLogGlimmering));
		r.accept(new class_1747(livingwoodGlimmering, props), class_7923.field_41175.method_10221(livingwoodGlimmering));
		r.accept(new class_1747(livingwoodLogStrippedGlimmering, props), class_7923.field_41175.method_10221(livingwoodLogStrippedGlimmering));
		r.accept(new class_1747(livingwoodStrippedGlimmering, props), class_7923.field_41175.method_10221(livingwoodStrippedGlimmering));
		r.accept(new class_1747(livingwoodPlanks, props), class_7923.field_41175.method_10221(livingwoodPlanks));
		r.accept(new class_1747(livingwoodPlankStairs, props), class_7923.field_41175.method_10221(livingwoodPlankStairs));
		r.accept(new class_1747(livingwoodPlankSlab, props), class_7923.field_41175.method_10221(livingwoodPlankSlab));
		r.accept(new class_1747(livingwoodFence, props), class_7923.field_41175.method_10221(livingwoodFence));
		r.accept(new class_1747(livingwoodFenceGate, props), class_7923.field_41175.method_10221(livingwoodFenceGate));
		r.accept(new class_1747(livingwoodPlanksMossy, props), class_7923.field_41175.method_10221(livingwoodPlanksMossy));
		r.accept(new class_1747(livingwoodFramed, props), class_7923.field_41175.method_10221(livingwoodFramed));
		r.accept(new class_1747(livingwoodPatternFramed, props), class_7923.field_41175.method_10221(livingwoodPatternFramed));

		r.accept(new class_1747(dreamwoodLog, props), class_7923.field_41175.method_10221(dreamwoodLog));
		r.accept(new class_1747(dreamwood, props), class_7923.field_41175.method_10221(dreamwood));
		r.accept(new class_1747(dreamwoodStairs, props), class_7923.field_41175.method_10221(dreamwoodStairs));
		r.accept(new class_1747(dreamwoodSlab, props), class_7923.field_41175.method_10221(dreamwoodSlab));
		r.accept(new class_1747(dreamwoodWall, props), class_7923.field_41175.method_10221(dreamwoodWall));
		r.accept(new class_1747(dreamwoodLogStripped, props), class_7923.field_41175.method_10221(dreamwoodLogStripped));
		r.accept(new class_1747(dreamwoodStripped, props), class_7923.field_41175.method_10221(dreamwoodStripped));
		r.accept(new class_1747(dreamwoodStrippedStairs, props), class_7923.field_41175.method_10221(dreamwoodStrippedStairs));
		r.accept(new class_1747(dreamwoodStrippedSlab, props), class_7923.field_41175.method_10221(dreamwoodStrippedSlab));
		r.accept(new class_1747(dreamwoodStrippedWall, props), class_7923.field_41175.method_10221(dreamwoodStrippedWall));
		r.accept(new class_1747(dreamwoodLogGlimmering, props), class_7923.field_41175.method_10221(dreamwoodLogGlimmering));
		r.accept(new class_1747(dreamwoodGlimmering, props), class_7923.field_41175.method_10221(dreamwoodGlimmering));
		r.accept(new class_1747(dreamwoodLogStrippedGlimmering, props), class_7923.field_41175.method_10221(dreamwoodLogStrippedGlimmering));
		r.accept(new class_1747(dreamwoodStrippedGlimmering, props), class_7923.field_41175.method_10221(dreamwoodStrippedGlimmering));
		r.accept(new class_1747(dreamwoodPlanks, props), class_7923.field_41175.method_10221(dreamwoodPlanks));
		r.accept(new class_1747(dreamwoodPlankStairs, props), class_7923.field_41175.method_10221(dreamwoodPlankStairs));
		r.accept(new class_1747(dreamwoodPlankSlab, props), class_7923.field_41175.method_10221(dreamwoodPlankSlab));
		r.accept(new class_1747(dreamwoodFence, props), class_7923.field_41175.method_10221(dreamwoodFence));
		r.accept(new class_1747(dreamwoodFenceGate, props), class_7923.field_41175.method_10221(dreamwoodFenceGate));
		r.accept(new class_1747(dreamwoodPlanksMossy, props), class_7923.field_41175.method_10221(dreamwoodPlanksMossy));
		r.accept(new class_1747(dreamwoodFramed, props), class_7923.field_41175.method_10221(dreamwoodFramed));
		r.accept(new class_1747(dreamwoodPatternFramed, props), class_7923.field_41175.method_10221(dreamwoodPatternFramed));

		r.accept(new class_1747(manaSpreader, props), class_7923.field_41175.method_10221(manaSpreader));
		r.accept(new class_1747(redstoneSpreader, props), class_7923.field_41175.method_10221(redstoneSpreader));
		r.accept(new class_1747(elvenSpreader, props), class_7923.field_41175.method_10221(elvenSpreader));
		r.accept(new class_1747(gaiaSpreader, props), class_7923.field_41175.method_10221(gaiaSpreader));
		r.accept(new class_1747(manaPool, props), class_7923.field_41175.method_10221(manaPool));
		r.accept(new class_1747(creativePool, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8904)), class_7923.field_41175.method_10221(creativePool));
		r.accept(new class_1747(dilutedPool, props), class_7923.field_41175.method_10221(dilutedPool));
		r.accept(new class_1747(fabulousPool, props), class_7923.field_41175.method_10221(fabulousPool));
		r.accept(new class_1747(alchemyCatalyst, props), class_7923.field_41175.method_10221(alchemyCatalyst));
		r.accept(new class_1747(conjurationCatalyst, props), class_7923.field_41175.method_10221(conjurationCatalyst));
		r.accept(new class_1747(manasteelBlock, props), class_7923.field_41175.method_10221(manasteelBlock));
		r.accept(new class_1747(terrasteelBlock, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8907)), class_7923.field_41175.method_10221(terrasteelBlock));
		r.accept(new class_1747(elementiumBlock, props), class_7923.field_41175.method_10221(elementiumBlock));
		r.accept(new class_1747(manaDiamondBlock, props), class_7923.field_41175.method_10221(manaDiamondBlock));
		r.accept(new class_1747(dragonstoneBlock, props), class_7923.field_41175.method_10221(dragonstoneBlock));
		r.accept(new class_1747(manaGlass, props), class_7923.field_41175.method_10221(manaGlass));
		r.accept(new class_1747(elfGlass, props), class_7923.field_41175.method_10221(elfGlass));
		r.accept(new class_1747(bifrostPerm, props), class_7923.field_41175.method_10221(bifrostPerm));
		r.accept(new class_1747(runeAltar, props), class_7923.field_41175.method_10221(runeAltar));
		r.accept(new class_1747(enchanter, props), class_7923.field_41175.method_10221(enchanter));
		r.accept(new BlockItemWithSpecialRenderer(brewery, props), class_7923.field_41175.method_10221(brewery));
		r.accept(new class_1747(terraPlate, props), class_7923.field_41175.method_10221(terraPlate));
		r.accept(new class_1747(alfPortal, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8907)), class_7923.field_41175.method_10221(alfPortal));

		r.accept(new BlockItemWithSpecialRenderer(manaPylon, props), class_7923.field_41175.method_10221(manaPylon));
		r.accept(new BlockItemWithSpecialRenderer(naturaPylon, props), class_7923.field_41175.method_10221(naturaPylon));
		r.accept(new BlockItemWithSpecialRenderer(gaiaPylon, props), class_7923.field_41175.method_10221(gaiaPylon));
		r.accept(new class_1747(distributor, props), class_7923.field_41175.method_10221(distributor));
		r.accept(new class_1747(manaVoid, props), class_7923.field_41175.method_10221(manaVoid));
		r.accept(new class_1747(manaDetector, props), class_7923.field_41175.method_10221(manaDetector));
		r.accept(new class_1747(pistonRelay, props), class_7923.field_41175.method_10221(pistonRelay));
		r.accept(new class_1747(turntable, props), class_7923.field_41175.method_10221(turntable));
		r.accept(new class_1747(tinyPlanet, props), class_7923.field_41175.method_10221(tinyPlanet));
		r.accept(new class_1747(wildDrum, props), class_7923.field_41175.method_10221(wildDrum));
		r.accept(new class_1747(gatheringDrum, props), class_7923.field_41175.method_10221(gatheringDrum));
		r.accept(new class_1747(canopyDrum, props), class_7923.field_41175.method_10221(canopyDrum));
		r.accept(new class_1747(spawnerClaw, props), class_7923.field_41175.method_10221(spawnerClaw));
		r.accept(new class_1747(rfGenerator, props), class_7923.field_41175.method_10221(rfGenerator));
		r.accept(new class_1747(prism, props), class_7923.field_41175.method_10221(prism));
		r.accept(new class_1747(pump, props), class_7923.field_41175.method_10221(pump));
		r.accept(new class_1747(sparkChanger, props), class_7923.field_41175.method_10221(sparkChanger));
		r.accept(new class_1747(manaBomb, props), class_7923.field_41175.method_10221(manaBomb));
		r.accept(new BlockItemWithSpecialRenderer(bellows, props), class_7923.field_41175.method_10221(bellows));
		r.accept(new class_1747(openCrate, props), class_7923.field_41175.method_10221(openCrate));
		r.accept(new class_1747(craftCrate, props), class_7923.field_41175.method_10221(craftCrate));
		r.accept(new class_1747(forestEye, props), class_7923.field_41175.method_10221(forestEye));
		r.accept(new class_1747(abstrusePlatform, props), class_7923.field_41175.method_10221(abstrusePlatform));
		r.accept(new class_1747(spectralPlatform, props), class_7923.field_41175.method_10221(spectralPlatform));
		r.accept(new class_1747(infrangiblePlatform, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8904)), class_7923.field_41175.method_10221(infrangiblePlatform));
		r.accept(new TinyPotatoBlockItem(tinyPotato, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8907)), class_7923.field_41175.method_10221(tinyPotato));
		r.accept(new class_1747(enderEye, props), class_7923.field_41175.method_10221(enderEye));
		r.accept(new class_1747(redStringContainer, props), class_7923.field_41175.method_10221(redStringContainer));
		r.accept(new class_1747(redStringDispenser, props), class_7923.field_41175.method_10221(redStringDispenser));
		r.accept(new class_1747(redStringFertilizer, props), class_7923.field_41175.method_10221(redStringFertilizer));
		r.accept(new class_1747(redStringComparator, props), class_7923.field_41175.method_10221(redStringComparator));
		r.accept(new class_1747(redStringRelay, props), class_7923.field_41175.method_10221(redStringRelay));
		r.accept(new class_1747(redStringInterceptor, props), class_7923.field_41175.method_10221(redStringInterceptor));
		r.accept(new BlockItemWithSpecialRenderer(corporeaIndex, props), class_7923.field_41175.method_10221(corporeaIndex));
		r.accept(new class_1747(corporeaFunnel, props), class_7923.field_41175.method_10221(corporeaFunnel));
		r.accept(new class_1747(corporeaInterceptor, props), class_7923.field_41175.method_10221(corporeaInterceptor));
		r.accept(new class_1747(corporeaCrystalCube, props), class_7923.field_41175.method_10221(corporeaCrystalCube));
		r.accept(new class_1747(corporeaRetainer, props), class_7923.field_41175.method_10221(corporeaRetainer));
		r.accept(new class_1747(corporeaBlock, props), class_7923.field_41175.method_10221(corporeaBlock));
		r.accept(new class_1747(corporeaSlab, props), class_7923.field_41175.method_10221(corporeaSlab));
		r.accept(new class_1747(corporeaStairs, props), class_7923.field_41175.method_10221(corporeaStairs));
		r.accept(new class_1747(corporeaBrick, props), class_7923.field_41175.method_10221(corporeaBrick));
		r.accept(new class_1747(corporeaBrickSlab, props), class_7923.field_41175.method_10221(corporeaBrickSlab));
		r.accept(new class_1747(corporeaBrickStairs, props), class_7923.field_41175.method_10221(corporeaBrickStairs));
		r.accept(new class_1747(corporeaBrickWall, props), class_7923.field_41175.method_10221(corporeaBrickWall));
		r.accept(new class_1747(incensePlate, props), class_7923.field_41175.method_10221(incensePlate));
		r.accept(new BlockItemWithSpecialRenderer(hourglass, props), class_7923.field_41175.method_10221(hourglass));
		r.accept(new class_1747(ghostRail, props), class_7923.field_41175.method_10221(ghostRail));
		r.accept(new class_1747(lightRelayDefault, props), class_7923.field_41175.method_10221(lightRelayDefault));
		r.accept(new class_1747(lightRelayDetector, props), class_7923.field_41175.method_10221(lightRelayDetector));
		r.accept(new class_1747(lightRelayFork, props), class_7923.field_41175.method_10221(lightRelayFork));
		r.accept(new class_1747(lightRelayToggle, props), class_7923.field_41175.method_10221(lightRelayToggle));
		r.accept(new class_1747(lightLauncher, props), class_7923.field_41175.method_10221(lightLauncher));
		r.accept(new class_1747(cacophonium, props), class_7923.field_41175.method_10221(cacophonium));
		r.accept(new class_1747(cellBlock, props), class_7923.field_41175.method_10221(cellBlock));
		r.accept(new BlockItemWithSpecialRenderer(teruTeruBozu, props), class_7923.field_41175.method_10221(teruTeruBozu));
		r.accept(new BlockItemWithSpecialRenderer(avatar, props), class_7923.field_41175.method_10221(avatar));
		r.accept(new class_1747(root, props), class_7923.field_41175.method_10221(root));
		r.accept(new class_1747(felPumpkin, props), class_7923.field_41175.method_10221(felPumpkin));
		r.accept(new class_1747(cocoon, props), class_7923.field_41175.method_10221(cocoon));
		r.accept(new class_1747(enchantedSoil, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8903)), class_7923.field_41175.method_10221(enchantedSoil));
		r.accept(new class_1747(animatedTorch, props), class_7923.field_41175.method_10221(animatedTorch));
		r.accept(new class_1747(starfield, props), class_7923.field_41175.method_10221(starfield));
		r.accept(new class_1747(azulejo0, props), class_7923.field_41175.method_10221(azulejo0));
		r.accept(new class_1747(azulejo1, props), class_7923.field_41175.method_10221(azulejo1));
		r.accept(new class_1747(azulejo2, props), class_7923.field_41175.method_10221(azulejo2));
		r.accept(new class_1747(azulejo3, props), class_7923.field_41175.method_10221(azulejo3));
		r.accept(new class_1747(azulejo4, props), class_7923.field_41175.method_10221(azulejo4));
		r.accept(new class_1747(azulejo5, props), class_7923.field_41175.method_10221(azulejo5));
		r.accept(new class_1747(azulejo6, props), class_7923.field_41175.method_10221(azulejo6));
		r.accept(new class_1747(azulejo7, props), class_7923.field_41175.method_10221(azulejo7));
		r.accept(new class_1747(azulejo8, props), class_7923.field_41175.method_10221(azulejo8));
		r.accept(new class_1747(azulejo9, props), class_7923.field_41175.method_10221(azulejo9));
		r.accept(new class_1747(azulejo10, props), class_7923.field_41175.method_10221(azulejo10));
		r.accept(new class_1747(azulejo11, props), class_7923.field_41175.method_10221(azulejo11));
		r.accept(new class_1747(azulejo12, props), class_7923.field_41175.method_10221(azulejo12));
		r.accept(new class_1747(azulejo13, props), class_7923.field_41175.method_10221(azulejo13));
		r.accept(new class_1747(azulejo14, props), class_7923.field_41175.method_10221(azulejo14));
		r.accept(new class_1747(azulejo15, props), class_7923.field_41175.method_10221(azulejo15));
		r.accept(new BlazeItemBlock(blazeBlock, props), class_7923.field_41175.method_10221(blazeBlock));
		r.accept(new class_1827(gaiaHead, gaiaHeadWall, BotaniaItems.defaultBuilder().method_7894(class_1814.field_8907), class_2350.field_11033), class_7923.field_41175.method_10221(gaiaHead));
		r.accept(new class_1747(shimmerrock, props), class_7923.field_41175.method_10221(shimmerrock));
		r.accept(new class_1747(shimmerrockSlab, props), class_7923.field_41175.method_10221(shimmerrockSlab));
		r.accept(new class_1747(shimmerrockStairs, props), class_7923.field_41175.method_10221(shimmerrockStairs));
		r.accept(new class_1747(shimmerwoodPlanks, props), class_7923.field_41175.method_10221(shimmerwoodPlanks));
		r.accept(new class_1747(shimmerwoodPlankSlab, props), class_7923.field_41175.method_10221(shimmerwoodPlankSlab));
		r.accept(new class_1747(shimmerwoodPlankStairs, props), class_7923.field_41175.method_10221(shimmerwoodPlankStairs));
		r.accept(new class_1747(dryGrass, props), class_7923.field_41175.method_10221(dryGrass));
		r.accept(new class_1747(goldenGrass, props), class_7923.field_41175.method_10221(goldenGrass));
		r.accept(new class_1747(vividGrass, props), class_7923.field_41175.method_10221(vividGrass));
		r.accept(new class_1747(scorchedGrass, props), class_7923.field_41175.method_10221(scorchedGrass));
		r.accept(new class_1747(infusedGrass, props), class_7923.field_41175.method_10221(infusedGrass));
		r.accept(new class_1747(mutatedGrass, props), class_7923.field_41175.method_10221(mutatedGrass));
		r.accept(new class_1747(motifDaybloom, props), class_7923.field_41175.method_10221(motifDaybloom));
		r.accept(new class_1747(motifNightshade, props), class_7923.field_41175.method_10221(motifNightshade));
		r.accept(new class_1747(motifHydroangeas, props), class_7923.field_41175.method_10221(motifHydroangeas));

		r.accept(new class_1747(darkQuartz, props), class_7923.field_41175.method_10221(darkQuartz));
		r.accept(new class_1747(darkQuartzPillar, props), class_7923.field_41175.method_10221(darkQuartzPillar));
		r.accept(new class_1747(darkQuartzChiseled, props), class_7923.field_41175.method_10221(darkQuartzChiseled));
		r.accept(new class_1747(darkQuartzSlab, props), class_7923.field_41175.method_10221(darkQuartzSlab));
		r.accept(new class_1747(darkQuartzStairs, props), class_7923.field_41175.method_10221(darkQuartzStairs));

		r.accept(new class_1747(manaQuartz, props), class_7923.field_41175.method_10221(manaQuartz));
		r.accept(new class_1747(manaQuartzPillar, props), class_7923.field_41175.method_10221(manaQuartzPillar));
		r.accept(new class_1747(manaQuartzChiseled, props), class_7923.field_41175.method_10221(manaQuartzChiseled));
		r.accept(new class_1747(manaQuartzSlab, props), class_7923.field_41175.method_10221(manaQuartzSlab));
		r.accept(new class_1747(manaQuartzStairs, props), class_7923.field_41175.method_10221(manaQuartzStairs));

		r.accept(new class_1747(blazeQuartz, props), class_7923.field_41175.method_10221(blazeQuartz));
		r.accept(new class_1747(blazeQuartzPillar, props), class_7923.field_41175.method_10221(blazeQuartzPillar));
		r.accept(new class_1747(blazeQuartzChiseled, props), class_7923.field_41175.method_10221(blazeQuartzChiseled));
		r.accept(new class_1747(blazeQuartzSlab, props), class_7923.field_41175.method_10221(blazeQuartzSlab));
		r.accept(new class_1747(blazeQuartzStairs, props), class_7923.field_41175.method_10221(blazeQuartzStairs));

		r.accept(new class_1747(lavenderQuartz, props), class_7923.field_41175.method_10221(lavenderQuartz));
		r.accept(new class_1747(lavenderQuartzPillar, props), class_7923.field_41175.method_10221(lavenderQuartzPillar));
		r.accept(new class_1747(lavenderQuartzChiseled, props), class_7923.field_41175.method_10221(lavenderQuartzChiseled));
		r.accept(new class_1747(lavenderQuartzSlab, props), class_7923.field_41175.method_10221(lavenderQuartzSlab));
		r.accept(new class_1747(lavenderQuartzStairs, props), class_7923.field_41175.method_10221(lavenderQuartzStairs));

		r.accept(new class_1747(redQuartz, props), class_7923.field_41175.method_10221(redQuartz));
		r.accept(new class_1747(redQuartzPillar, props), class_7923.field_41175.method_10221(redQuartzPillar));
		r.accept(new class_1747(redQuartzChiseled, props), class_7923.field_41175.method_10221(redQuartzChiseled));
		r.accept(new class_1747(redQuartzSlab, props), class_7923.field_41175.method_10221(redQuartzSlab));
		r.accept(new class_1747(redQuartzStairs, props), class_7923.field_41175.method_10221(redQuartzStairs));

		r.accept(new class_1747(elfQuartz, props), class_7923.field_41175.method_10221(elfQuartz));
		r.accept(new class_1747(elfQuartzPillar, props), class_7923.field_41175.method_10221(elfQuartzPillar));
		r.accept(new class_1747(elfQuartzChiseled, props), class_7923.field_41175.method_10221(elfQuartzChiseled));
		r.accept(new class_1747(elfQuartzSlab, props), class_7923.field_41175.method_10221(elfQuartzSlab));
		r.accept(new class_1747(elfQuartzStairs, props), class_7923.field_41175.method_10221(elfQuartzStairs));

		r.accept(new class_1747(sunnyQuartz, props), class_7923.field_41175.method_10221(sunnyQuartz));
		r.accept(new class_1747(sunnyQuartzPillar, props), class_7923.field_41175.method_10221(sunnyQuartzPillar));
		r.accept(new class_1747(sunnyQuartzChiseled, props), class_7923.field_41175.method_10221(sunnyQuartzChiseled));
		r.accept(new class_1747(sunnyQuartzSlab, props), class_7923.field_41175.method_10221(sunnyQuartzSlab));
		r.accept(new class_1747(sunnyQuartzStairs, props), class_7923.field_41175.method_10221(sunnyQuartzStairs));

		r.accept(new class_1747(biomeStoneForest, props), class_7923.field_41175.method_10221(biomeStoneForest));
		r.accept(new class_1747(biomeStoneForestSlab, props), class_7923.field_41175.method_10221(biomeStoneForestSlab));
		r.accept(new class_1747(biomeStoneForestStairs, props), class_7923.field_41175.method_10221(biomeStoneForestStairs));
		r.accept(new class_1747(biomeStoneForestWall, props), class_7923.field_41175.method_10221(biomeStoneForestWall));
		r.accept(new class_1747(biomeBrickForest, props), class_7923.field_41175.method_10221(biomeBrickForest));
		r.accept(new class_1747(biomeBrickForestSlab, props), class_7923.field_41175.method_10221(biomeBrickForestSlab));
		r.accept(new class_1747(biomeBrickForestStairs, props), class_7923.field_41175.method_10221(biomeBrickForestStairs));
		r.accept(new class_1747(biomeBrickForestWall, props), class_7923.field_41175.method_10221(biomeBrickForestWall));
		r.accept(new class_1747(biomeCobblestoneForest, props), class_7923.field_41175.method_10221(biomeCobblestoneForest));
		r.accept(new class_1747(biomeCobblestoneForestSlab, props), class_7923.field_41175.method_10221(biomeCobblestoneForestSlab));
		r.accept(new class_1747(biomeCobblestoneForestStairs, props), class_7923.field_41175.method_10221(biomeCobblestoneForestStairs));
		r.accept(new class_1747(biomeCobblestoneForestWall, props), class_7923.field_41175.method_10221(biomeCobblestoneForestWall));
		r.accept(new class_1747(biomeChiseledBrickForest, props), class_7923.field_41175.method_10221(biomeChiseledBrickForest));

		r.accept(new class_1747(biomeStonePlains, props), class_7923.field_41175.method_10221(biomeStonePlains));
		r.accept(new class_1747(biomeStonePlainsSlab, props), class_7923.field_41175.method_10221(biomeStonePlainsSlab));
		r.accept(new class_1747(biomeStonePlainsStairs, props), class_7923.field_41175.method_10221(biomeStonePlainsStairs));
		r.accept(new class_1747(biomeStonePlainsWall, props), class_7923.field_41175.method_10221(biomeStonePlainsWall));
		r.accept(new class_1747(biomeBrickPlains, props), class_7923.field_41175.method_10221(biomeBrickPlains));
		r.accept(new class_1747(biomeBrickPlainsSlab, props), class_7923.field_41175.method_10221(biomeBrickPlainsSlab));
		r.accept(new class_1747(biomeBrickPlainsStairs, props), class_7923.field_41175.method_10221(biomeBrickPlainsStairs));
		r.accept(new class_1747(biomeBrickPlainsWall, props), class_7923.field_41175.method_10221(biomeBrickPlainsWall));
		r.accept(new class_1747(biomeCobblestonePlains, props), class_7923.field_41175.method_10221(biomeCobblestonePlains));
		r.accept(new class_1747(biomeCobblestonePlainsSlab, props), class_7923.field_41175.method_10221(biomeCobblestonePlainsSlab));
		r.accept(new class_1747(biomeCobblestonePlainsStairs, props), class_7923.field_41175.method_10221(biomeCobblestonePlainsStairs));
		r.accept(new class_1747(biomeCobblestonePlainsWall, props), class_7923.field_41175.method_10221(biomeCobblestonePlainsWall));
		r.accept(new class_1747(biomeChiseledBrickPlains, props), class_7923.field_41175.method_10221(biomeChiseledBrickPlains));

		r.accept(new class_1747(biomeStoneMountain, props), class_7923.field_41175.method_10221(biomeStoneMountain));
		r.accept(new class_1747(biomeStoneMountainSlab, props), class_7923.field_41175.method_10221(biomeStoneMountainSlab));
		r.accept(new class_1747(biomeStoneMountainStairs, props), class_7923.field_41175.method_10221(biomeStoneMountainStairs));
		r.accept(new class_1747(biomeStoneMountainWall, props), class_7923.field_41175.method_10221(biomeStoneMountainWall));
		r.accept(new class_1747(biomeBrickMountain, props), class_7923.field_41175.method_10221(biomeBrickMountain));
		r.accept(new class_1747(biomeBrickMountainSlab, props), class_7923.field_41175.method_10221(biomeBrickMountainSlab));
		r.accept(new class_1747(biomeBrickMountainStairs, props), class_7923.field_41175.method_10221(biomeBrickMountainStairs));
		r.accept(new class_1747(biomeBrickMountainWall, props), class_7923.field_41175.method_10221(biomeBrickMountainWall));
		r.accept(new class_1747(biomeCobblestoneMountain, props), class_7923.field_41175.method_10221(biomeCobblestoneMountain));
		r.accept(new class_1747(biomeCobblestoneMountainSlab, props), class_7923.field_41175.method_10221(biomeCobblestoneMountainSlab));
		r.accept(new class_1747(biomeCobblestoneMountainStairs, props), class_7923.field_41175.method_10221(biomeCobblestoneMountainStairs));
		r.accept(new class_1747(biomeCobblestoneMountainWall, props), class_7923.field_41175.method_10221(biomeCobblestoneMountainWall));
		r.accept(new class_1747(biomeChiseledBrickMountain, props), class_7923.field_41175.method_10221(biomeChiseledBrickMountain));

		r.accept(new class_1747(biomeStoneFungal, props), class_7923.field_41175.method_10221(biomeStoneFungal));
		r.accept(new class_1747(biomeStoneFungalSlab, props), class_7923.field_41175.method_10221(biomeStoneFungalSlab));
		r.accept(new class_1747(biomeStoneFungalStairs, props), class_7923.field_41175.method_10221(biomeStoneFungalStairs));
		r.accept(new class_1747(biomeStoneFungalWall, props), class_7923.field_41175.method_10221(biomeStoneFungalWall));
		r.accept(new class_1747(biomeBrickFungal, props), class_7923.field_41175.method_10221(biomeBrickFungal));
		r.accept(new class_1747(biomeBrickFungalSlab, props), class_7923.field_41175.method_10221(biomeBrickFungalSlab));
		r.accept(new class_1747(biomeBrickFungalStairs, props), class_7923.field_41175.method_10221(biomeBrickFungalStairs));
		r.accept(new class_1747(biomeBrickFungalWall, props), class_7923.field_41175.method_10221(biomeBrickFungalWall));
		r.accept(new class_1747(biomeCobblestoneFungal, props), class_7923.field_41175.method_10221(biomeCobblestoneFungal));
		r.accept(new class_1747(biomeCobblestoneFungalSlab, props), class_7923.field_41175.method_10221(biomeCobblestoneFungalSlab));
		r.accept(new class_1747(biomeCobblestoneFungalStairs, props), class_7923.field_41175.method_10221(biomeCobblestoneFungalStairs));
		r.accept(new class_1747(biomeCobblestoneFungalWall, props), class_7923.field_41175.method_10221(biomeCobblestoneFungalWall));
		r.accept(new class_1747(biomeChiseledBrickFungal, props), class_7923.field_41175.method_10221(biomeChiseledBrickFungal));

		r.accept(new class_1747(biomeStoneSwamp, props), class_7923.field_41175.method_10221(biomeStoneSwamp));
		r.accept(new class_1747(biomeStoneSwampSlab, props), class_7923.field_41175.method_10221(biomeStoneSwampSlab));
		r.accept(new class_1747(biomeStoneSwampStairs, props), class_7923.field_41175.method_10221(biomeStoneSwampStairs));
		r.accept(new class_1747(biomeStoneSwampWall, props), class_7923.field_41175.method_10221(biomeStoneSwampWall));
		r.accept(new class_1747(biomeBrickSwamp, props), class_7923.field_41175.method_10221(biomeBrickSwamp));
		r.accept(new class_1747(biomeBrickSwampSlab, props), class_7923.field_41175.method_10221(biomeBrickSwampSlab));
		r.accept(new class_1747(biomeBrickSwampStairs, props), class_7923.field_41175.method_10221(biomeBrickSwampStairs));
		r.accept(new class_1747(biomeBrickSwampWall, props), class_7923.field_41175.method_10221(biomeBrickSwampWall));
		r.accept(new class_1747(biomeCobblestoneSwamp, props), class_7923.field_41175.method_10221(biomeCobblestoneSwamp));
		r.accept(new class_1747(biomeCobblestoneSwampSlab, props), class_7923.field_41175.method_10221(biomeCobblestoneSwampSlab));
		r.accept(new class_1747(biomeCobblestoneSwampStairs, props), class_7923.field_41175.method_10221(biomeCobblestoneSwampStairs));
		r.accept(new class_1747(biomeCobblestoneSwampWall, props), class_7923.field_41175.method_10221(biomeCobblestoneSwampWall));
		r.accept(new class_1747(biomeChiseledBrickSwamp, props), class_7923.field_41175.method_10221(biomeChiseledBrickSwamp));

		r.accept(new class_1747(biomeStoneDesert, props), class_7923.field_41175.method_10221(biomeStoneDesert));
		r.accept(new class_1747(biomeStoneDesertSlab, props), class_7923.field_41175.method_10221(biomeStoneDesertSlab));
		r.accept(new class_1747(biomeStoneDesertStairs, props), class_7923.field_41175.method_10221(biomeStoneDesertStairs));
		r.accept(new class_1747(biomeStoneDesertWall, props), class_7923.field_41175.method_10221(biomeStoneDesertWall));
		r.accept(new class_1747(biomeBrickDesert, props), class_7923.field_41175.method_10221(biomeBrickDesert));
		r.accept(new class_1747(biomeBrickDesertSlab, props), class_7923.field_41175.method_10221(biomeBrickDesertSlab));
		r.accept(new class_1747(biomeBrickDesertStairs, props), class_7923.field_41175.method_10221(biomeBrickDesertStairs));
		r.accept(new class_1747(biomeBrickDesertWall, props), class_7923.field_41175.method_10221(biomeBrickDesertWall));
		r.accept(new class_1747(biomeCobblestoneDesert, props), class_7923.field_41175.method_10221(biomeCobblestoneDesert));
		r.accept(new class_1747(biomeCobblestoneDesertSlab, props), class_7923.field_41175.method_10221(biomeCobblestoneDesertSlab));
		r.accept(new class_1747(biomeCobblestoneDesertStairs, props), class_7923.field_41175.method_10221(biomeCobblestoneDesertStairs));
		r.accept(new class_1747(biomeCobblestoneDesertWall, props), class_7923.field_41175.method_10221(biomeCobblestoneDesertWall));
		r.accept(new class_1747(biomeChiseledBrickDesert, props), class_7923.field_41175.method_10221(biomeChiseledBrickDesert));

		r.accept(new class_1747(biomeStoneTaiga, props), class_7923.field_41175.method_10221(biomeStoneTaiga));
		r.accept(new class_1747(biomeStoneTaigaSlab, props), class_7923.field_41175.method_10221(biomeStoneTaigaSlab));
		r.accept(new class_1747(biomeStoneTaigaStairs, props), class_7923.field_41175.method_10221(biomeStoneTaigaStairs));
		r.accept(new class_1747(biomeStoneTaigaWall, props), class_7923.field_41175.method_10221(biomeStoneTaigaWall));
		r.accept(new class_1747(biomeBrickTaiga, props), class_7923.field_41175.method_10221(biomeBrickTaiga));
		r.accept(new class_1747(biomeBrickTaigaSlab, props), class_7923.field_41175.method_10221(biomeBrickTaigaSlab));
		r.accept(new class_1747(biomeBrickTaigaStairs, props), class_7923.field_41175.method_10221(biomeBrickTaigaStairs));
		r.accept(new class_1747(biomeBrickTaigaWall, props), class_7923.field_41175.method_10221(biomeBrickTaigaWall));
		r.accept(new class_1747(biomeCobblestoneTaiga, props), class_7923.field_41175.method_10221(biomeCobblestoneTaiga));
		r.accept(new class_1747(biomeCobblestoneTaigaSlab, props), class_7923.field_41175.method_10221(biomeCobblestoneTaigaSlab));
		r.accept(new class_1747(biomeCobblestoneTaigaStairs, props), class_7923.field_41175.method_10221(biomeCobblestoneTaigaStairs));
		r.accept(new class_1747(biomeCobblestoneTaigaWall, props), class_7923.field_41175.method_10221(biomeCobblestoneTaigaWall));
		r.accept(new class_1747(biomeChiseledBrickTaiga, props), class_7923.field_41175.method_10221(biomeChiseledBrickTaiga));

		r.accept(new class_1747(biomeStoneMesa, props), class_7923.field_41175.method_10221(biomeStoneMesa));
		r.accept(new class_1747(biomeStoneMesaSlab, props), class_7923.field_41175.method_10221(biomeStoneMesaSlab));
		r.accept(new class_1747(biomeStoneMesaStairs, props), class_7923.field_41175.method_10221(biomeStoneMesaStairs));
		r.accept(new class_1747(biomeStoneMesaWall, props), class_7923.field_41175.method_10221(biomeStoneMesaWall));
		r.accept(new class_1747(biomeBrickMesa, props), class_7923.field_41175.method_10221(biomeBrickMesa));
		r.accept(new class_1747(biomeBrickMesaSlab, props), class_7923.field_41175.method_10221(biomeBrickMesaSlab));
		r.accept(new class_1747(biomeBrickMesaStairs, props), class_7923.field_41175.method_10221(biomeBrickMesaStairs));
		r.accept(new class_1747(biomeBrickMesaWall, props), class_7923.field_41175.method_10221(biomeBrickMesaWall));
		r.accept(new class_1747(biomeCobblestoneMesa, props), class_7923.field_41175.method_10221(biomeCobblestoneMesa));
		r.accept(new class_1747(biomeCobblestoneMesaSlab, props), class_7923.field_41175.method_10221(biomeCobblestoneMesaSlab));
		r.accept(new class_1747(biomeCobblestoneMesaStairs, props), class_7923.field_41175.method_10221(biomeCobblestoneMesaStairs));
		r.accept(new class_1747(biomeCobblestoneMesaWall, props), class_7923.field_41175.method_10221(biomeCobblestoneMesaWall));
		r.accept(new class_1747(biomeChiseledBrickMesa, props), class_7923.field_41175.method_10221(biomeChiseledBrickMesa));

		r.accept(new class_1747(whitePavement, props), class_7923.field_41175.method_10221(whitePavement));
		r.accept(new class_1747(whitePavementStair, props), class_7923.field_41175.method_10221(whitePavementStair));
		r.accept(new class_1747(whitePavementSlab, props), class_7923.field_41175.method_10221(whitePavementSlab));

		r.accept(new class_1747(blackPavement, props), class_7923.field_41175.method_10221(blackPavement));
		r.accept(new class_1747(blackPavementSlab, props), class_7923.field_41175.method_10221(blackPavementSlab));
		r.accept(new class_1747(blackPavementStair, props), class_7923.field_41175.method_10221(blackPavementStair));

		r.accept(new class_1747(bluePavement, props), class_7923.field_41175.method_10221(bluePavement));
		r.accept(new class_1747(bluePavementStair, props), class_7923.field_41175.method_10221(bluePavementStair));
		r.accept(new class_1747(bluePavementSlab, props), class_7923.field_41175.method_10221(bluePavementSlab));

		r.accept(new class_1747(yellowPavement, props), class_7923.field_41175.method_10221(yellowPavement));
		r.accept(new class_1747(yellowPavementStair, props), class_7923.field_41175.method_10221(yellowPavementStair));
		r.accept(new class_1747(yellowPavementSlab, props), class_7923.field_41175.method_10221(yellowPavementSlab));

		r.accept(new class_1747(redPavement, props), class_7923.field_41175.method_10221(redPavement));
		r.accept(new class_1747(redPavementStair, props), class_7923.field_41175.method_10221(redPavementStair));
		r.accept(new class_1747(redPavementSlab, props), class_7923.field_41175.method_10221(redPavementSlab));

		r.accept(new class_1747(greenPavement, props), class_7923.field_41175.method_10221(greenPavement));
		r.accept(new class_1747(greenPavementStair, props), class_7923.field_41175.method_10221(greenPavementStair));
		r.accept(new class_1747(greenPavementSlab, props), class_7923.field_41175.method_10221(greenPavementSlab));

		r.accept(new class_1747(managlassPane, props), class_7923.field_41175.method_10221(managlassPane));
		r.accept(new class_1747(alfglassPane, props), class_7923.field_41175.method_10221(alfglassPane));
		r.accept(new class_1747(bifrostPane, props), class_7923.field_41175.method_10221(bifrostPane));
	}

	public static void addDispenserBehaviours() {
		class_2315.method_10009(BotaniaItems.twigWand, new WandBehavior());
		class_2315.method_10009(BotaniaItems.phantomInk, new PhantomInkBehavior());
		class_2315.method_10009(BotaniaItems.dreamwoodWand, new WandBehavior());
		class_2315.method_10009(BotaniaItems.obedienceStick, new StickBehavior());
		class_2315.method_10009(BotaniaItems.poolMinecart, new ManaPoolMinecartBehavior());
		class_2315.method_10009(BotaniaBlocks.felPumpkin, new FelPumpkinBehavior());
		class_2315.method_10009(BotaniaItems.spark, new ManaSparkBehavior());
		class_2315.method_10009(BotaniaBlocks.gaiaHead, new class_2969() {
			@NotNull
			@Override
			protected class_1799 method_10135(@NotNull class_2342 source, @NotNull class_1799 stack) {
				method_27955(class_1738.method_7684(source, stack));
				return stack;
			}
		});

		class_2357 behavior = new CorporeaSparkBehavior();
		class_2315.method_10009(BotaniaItems.corporeaSpark, behavior);
		class_2315.method_10009(BotaniaItems.corporeaSparkMaster, behavior);
		class_2315.method_10009(BotaniaItems.corporeaSparkCreative, behavior);
		class_2315.method_10009(BotaniaItems.enderAirBottle, new class_2965() {
			@NotNull
			@Override
			protected class_1676 method_12844(@NotNull class_1937 world, @NotNull class_2374 pos, @NotNull class_1799 stack) {
				return new EnderAirBottleEntity(pos.method_10216(), pos.method_10214(), pos.method_10215(), world);
			}
		});

		behavior = DispenserBlockAccessor.getDispenserRegistry().get(class_1802.field_8469);
		class_2315.method_10009(class_1802.field_8469, new EnderAirBottlingBehavior(behavior));

		behavior = new GrassSeedsBehavior();
		class_1792[] seedItems = {
				BotaniaItems.grassSeeds,
				BotaniaItems.podzolSeeds,
				BotaniaItems.mycelSeeds,
				BotaniaItems.drySeeds,
				BotaniaItems.goldenSeeds,
				BotaniaItems.vividSeeds,
				BotaniaItems.scorchedSeeds,
				BotaniaItems.infusedSeeds,
				BotaniaItems.mutatedSeeds,
		};
		for (class_1792 seed : seedItems) {
			class_2315.method_10009(seed, behavior);
		}

		class_2315.method_10009(BotaniaItems.manasteelShears, new class_5168());
		class_2315.method_10009(BotaniaItems.elementiumShears, new class_5168());
		class_2315.method_10009(BotaniaItems.vineBall, new class_2965() {
			@NotNull
			@Override
			protected class_1676 method_12844(@NotNull class_1937 world, @NotNull class_2374 pos, @NotNull class_1799 stack) {
				return new VineBallEntity(pos.method_10216(), pos.method_10214(), pos.method_10215(), world);
			}
		});

		SeedBehaviors.init();
	}

	public static void addAxeStripping() {
		XplatAbstractions xplat = XplatAbstractions.INSTANCE;
		xplat.addAxeStripping(livingwoodLog, livingwoodLogStripped);
		xplat.addAxeStripping(livingwoodLogGlimmering, livingwoodLogStrippedGlimmering);
		xplat.addAxeStripping(livingwood, livingwoodStripped);
		xplat.addAxeStripping(livingwoodGlimmering, livingwoodStrippedGlimmering);
		xplat.addAxeStripping(dreamwoodLog, dreamwoodLogStripped);
		xplat.addAxeStripping(dreamwoodLogGlimmering, dreamwoodLogStrippedGlimmering);
		xplat.addAxeStripping(dreamwood, dreamwoodStripped);
		xplat.addAxeStripping(dreamwoodGlimmering, dreamwoodStrippedGlimmering);

		xplat.addAxeStripping(BotaniaBlocks.livingwoodStairs, BotaniaBlocks.livingwoodStrippedStairs);
		xplat.addAxeStripping(BotaniaBlocks.livingwoodSlab, BotaniaBlocks.livingwoodStrippedSlab);
		xplat.addAxeStripping(BotaniaBlocks.livingwoodWall, BotaniaBlocks.livingwoodStrippedWall);
		xplat.addAxeStripping(BotaniaBlocks.dreamwoodStairs, BotaniaBlocks.dreamwoodStrippedStairs);
		xplat.addAxeStripping(BotaniaBlocks.dreamwoodSlab, BotaniaBlocks.dreamwoodStrippedSlab);
		xplat.addAxeStripping(BotaniaBlocks.dreamwoodWall, BotaniaBlocks.dreamwoodStrippedWall);
	}

	public static class_2248 getFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteFlower;
			case field_7946 -> orangeFlower;
			case field_7958 -> magentaFlower;
			case field_7951 -> lightBlueFlower;
			case field_7947 -> yellowFlower;
			case field_7961 -> limeFlower;
			case field_7954 -> pinkFlower;
			case field_7944 -> grayFlower;
			case field_7967 -> lightGrayFlower;
			case field_7955 -> cyanFlower;
			case field_7945 -> purpleFlower;
			case field_7966 -> blueFlower;
			case field_7957 -> brownFlower;
			case field_7942 -> greenFlower;
			case field_7964 -> redFlower;
			case field_7963 -> blackFlower;
		};
	}

	public static class_2248 getMushroom(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteMushroom;
			case field_7946 -> orangeMushroom;
			case field_7958 -> magentaMushroom;
			case field_7951 -> lightBlueMushroom;
			case field_7947 -> yellowMushroom;
			case field_7961 -> limeMushroom;
			case field_7954 -> pinkMushroom;
			case field_7944 -> grayMushroom;
			case field_7967 -> lightGrayMushroom;
			case field_7955 -> cyanMushroom;
			case field_7945 -> purpleMushroom;
			case field_7966 -> blueMushroom;
			case field_7957 -> brownMushroom;
			case field_7942 -> greenMushroom;
			case field_7964 -> redMushroom;
			case field_7963 -> blackMushroom;
		};
	}

	public static class_2248 getBuriedPetal(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteBuriedPetals;
			case field_7946 -> orangeBuriedPetals;
			case field_7958 -> magentaBuriedPetals;
			case field_7951 -> lightBlueBuriedPetals;
			case field_7947 -> yellowBuriedPetals;
			case field_7961 -> limeBuriedPetals;
			case field_7954 -> pinkBuriedPetals;
			case field_7944 -> grayBuriedPetals;
			case field_7967 -> lightGrayBuriedPetals;
			case field_7955 -> cyanBuriedPetals;
			case field_7945 -> purpleBuriedPetals;
			case field_7966 -> blueBuriedPetals;
			case field_7957 -> brownBuriedPetals;
			case field_7942 -> greenBuriedPetals;
			case field_7964 -> redBuriedPetals;
			case field_7963 -> blackBuriedPetals;
		};
	}

	public static class_2248 getShinyFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteShinyFlower;
			case field_7946 -> orangeShinyFlower;
			case field_7958 -> magentaShinyFlower;
			case field_7951 -> lightBlueShinyFlower;
			case field_7947 -> yellowShinyFlower;
			case field_7961 -> limeShinyFlower;
			case field_7954 -> pinkShinyFlower;
			case field_7944 -> grayShinyFlower;
			case field_7967 -> lightGrayShinyFlower;
			case field_7955 -> cyanShinyFlower;
			case field_7945 -> purpleShinyFlower;
			case field_7966 -> blueShinyFlower;
			case field_7957 -> brownShinyFlower;
			case field_7942 -> greenShinyFlower;
			case field_7964 -> redShinyFlower;
			case field_7963 -> blackShinyFlower;
		};
	}

	public static class_2248 getFloatingFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> whiteFloatingFlower;
			case field_7946 -> orangeFloatingFlower;
			case field_7958 -> magentaFloatingFlower;
			case field_7951 -> lightBlueFloatingFlower;
			case field_7947 -> yellowFloatingFlower;
			case field_7961 -> limeFloatingFlower;
			case field_7954 -> pinkFloatingFlower;
			case field_7944 -> grayFloatingFlower;
			case field_7967 -> lightGrayFloatingFlower;
			case field_7955 -> cyanFloatingFlower;
			case field_7945 -> purpleFloatingFlower;
			case field_7966 -> blueFloatingFlower;
			case field_7957 -> brownFloatingFlower;
			case field_7942 -> greenFloatingFlower;
			case field_7964 -> redFloatingFlower;
			case field_7963 -> blackFloatingFlower;
		};
	}

	public static class_2248 getDoubleFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> doubleFlowerWhite;
			case field_7946 -> doubleFlowerOrange;
			case field_7958 -> doubleFlowerMagenta;
			case field_7951 -> doubleFlowerLightBlue;
			case field_7947 -> doubleFlowerYellow;
			case field_7961 -> doubleFlowerLime;
			case field_7954 -> doubleFlowerPink;
			case field_7944 -> doubleFlowerGray;
			case field_7967 -> doubleFlowerLightGray;
			case field_7955 -> doubleFlowerCyan;
			case field_7945 -> doubleFlowerPurple;
			case field_7966 -> doubleFlowerBlue;
			case field_7957 -> doubleFlowerBrown;
			case field_7942 -> doubleFlowerGreen;
			case field_7964 -> doubleFlowerRed;
			case field_7963 -> doubleFlowerBlack;
		};
	}

	public static class_2248 getPetalBlock(class_1767 color) {
		return switch (color) {
			case field_7952 -> petalBlockWhite;
			case field_7946 -> petalBlockOrange;
			case field_7958 -> petalBlockMagenta;
			case field_7951 -> petalBlockLightBlue;
			case field_7947 -> petalBlockYellow;
			case field_7961 -> petalBlockLime;
			case field_7954 -> petalBlockPink;
			case field_7944 -> petalBlockGray;
			case field_7967 -> petalBlockSilver;
			case field_7955 -> petalBlockCyan;
			case field_7945 -> petalBlockPurple;
			case field_7966 -> petalBlockBlue;
			case field_7957 -> petalBlockBrown;
			case field_7942 -> petalBlockGreen;
			case field_7964 -> petalBlockRed;
			case field_7963 -> petalBlockBlack;
		};
	}

	public static class_2248 getPottedFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> pottedWhiteFlower;
			case field_7946 -> pottedOrangeFlower;
			case field_7958 -> pottedMagentaFlower;
			case field_7951 -> pottedLightBlueFlower;
			case field_7947 -> pottedYellowFlower;
			case field_7961 -> pottedLimeFlower;
			case field_7954 -> pottedPinkFlower;
			case field_7944 -> pottedGrayFlower;
			case field_7967 -> pottedLightGrayFlower;
			case field_7955 -> pottedCyanFlower;
			case field_7945 -> pottedPurpleFlower;
			case field_7966 -> pottedBlueFlower;
			case field_7957 -> pottedBrownFlower;
			case field_7942 -> pottedGreenFlower;
			case field_7964 -> pottedRedFlower;
			case field_7963 -> pottedBlackFlower;
		};
	}

	public static class_2248 getPottedShinyFlower(class_1767 color) {
		return switch (color) {
			case field_7952 -> pottedWhiteShinyFlower;
			case field_7946 -> pottedOrangeShinyFlower;
			case field_7958 -> pottedMagentaShinyFlower;
			case field_7951 -> pottedLightBlueShinyFlower;
			case field_7947 -> pottedYellowShinyFlower;
			case field_7961 -> pottedLimeShinyFlower;
			case field_7954 -> pottedPinkShinyFlower;
			case field_7944 -> pottedGrayShinyFlower;
			case field_7967 -> pottedLightGrayShinyFlower;
			case field_7955 -> pottedCyanShinyFlower;
			case field_7945 -> pottedPurpleShinyFlower;
			case field_7966 -> pottedBlueShinyFlower;
			case field_7957 -> pottedBrownShinyFlower;
			case field_7942 -> pottedGreenShinyFlower;
			case field_7964 -> pottedRedShinyFlower;
			case field_7963 -> pottedBlackShinyFlower;
		};
	}

	public static class_2248 getPottedMushroom(class_1767 color) {
		return switch (color) {
			case field_7952 -> pottedWhiteMushroom;
			case field_7946 -> pottedOrangeMushroom;
			case field_7958 -> pottedMagentaMushroom;
			case field_7951 -> pottedLightBlueMushroom;
			case field_7947 -> pottedYellowMushroom;
			case field_7961 -> pottedLimeMushroom;
			case field_7954 -> pottedPinkMushroom;
			case field_7944 -> pottedGrayMushroom;
			case field_7967 -> pottedLightGrayMushroom;
			case field_7955 -> pottedCyanMushroom;
			case field_7945 -> pottedPurpleMushroom;
			case field_7966 -> pottedBlueMushroom;
			case field_7957 -> pottedBrownMushroom;
			case field_7942 -> pottedGreenMushroom;
			case field_7964 -> pottedRedMushroom;
			case field_7963 -> pottedBlackMushroom;
		};
	}

	public static void registerFlowerPotPlants(BiConsumer<class_2960, Supplier<? extends class_2248>> consumer) {
		ColorHelper.supportedColors().forEach(dyeColor -> {
			consumer.accept(prefix(dyeColor.method_7792() + MYSTICAL_FLOWER_SUFFIX), () -> getPottedFlower(dyeColor));
			consumer.accept(prefix(dyeColor.method_7792() + SHINY_FLOWER_SUFFIX), () -> getPottedShinyFlower(dyeColor));
			consumer.accept(prefix(dyeColor.method_7792() + MUSHROOM_SUFFIX), () -> getPottedMushroom(dyeColor));
		});
		consumer.accept(prefix(LibBlockNames.MOTIF_DAYBLOOM), () -> pottedMotifDaybloom);
		consumer.accept(prefix(LibBlockNames.MOTIF_NIGHTSHADE), () -> pottedMotifNightshade);
		consumer.accept(prefix(LibBlockNames.MOTIF_HYDROANGEAS), () -> pottedMotifHydroangeas);
	}
}
